% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_by_then_by.R
\name{sort_by_then_by}
\alias{sort_by_then_by}
\title{Sort a table by a list of columns}
\usage{
sort_by_then_by(
  tableX,
  sort_cols = c(1, 2),
  col_type = c("c", "n"),
  decreasing = FALSE,
  return_order = FALSE
)
}
\arguments{
\item{tableX}{a matrix}

\item{sort_cols}{A vector of length two, indicating which
columns in the matrix to sort by, and in which order. To
sort first by column 1 and then by column 2, sort_cols should
be c(1,2).}

\item{col_type}{A vector of length two indicating whether each
column contains character values ("c") or numeric values ("n").
Specified in the same order as sort_cols.}

\item{decreasing}{Whether values should be sorted in decreasing order}

\item{return_order}{Whether to return the sorted table (FALSE) or to 
return the order used to sort the table (TRUE). Defaults to FALSE.}
}
\value{
If return_order is FALSE, this function returns tableX sorted by sort_cols.
If return_order is TRUE, this function returns a two-column matrix indicating the order in which
to put tableX to sort it by sort_cols. To sort a table to match the order, order first by the
first column and then by the second column.
}
\description{
This internal function sorts a table first by one column,
and then by a second column.
Columns can contain numeric values or string values. These
are specified for each column by col_type.
The values of the second column are sorted by successive 
values in the first column.
if return order is TRUE, the function returns the order of
each column instead of the ordered table. To order the original
table, sort first by the order in the first column of the order
matrix and then by the offer in the second colum of the order
matrix.
}
\keyword{internal}
