% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capl.R
\name{get_capl_score}
\alias{get_capl_score}
\title{Compute an overall physical literacy score.}
\usage{
get_capl_score(pc_score = NA, db_score = NA, mc_score = NA, ku_score = NA)
}
\arguments{
\item{pc_score}{A numeric vector (valid values are between 0 and 30).}

\item{db_score}{A numeric (integer) vector (valid values are between 0 and 30).}

\item{mc_score}{A numeric vector (valid values are between 0 and 30).}

\item{ku_score}{A numeric vector (valid values are between 0 and 10).}
}
\value{
Returns a numeric vector with values between 0 and 100 (if valid) or NA (if not valid).
}
\description{
This function computes an overall physical literacy score (\code{capl_score}) based on the physical competence (\code{pc_score}), daily behaviour (\code{db_score}),
motivation and confidence (\code{mc_score}), and knowledge and understanding (\code{ku_score}) domain scores. If one of the scores is missing or invalid, a
weighted score will be computed from the other three scores.
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_number]{validate_number()}}, \code{\link[=validate_integer]{validate_integer()}} and \code{\link[=validate_domain_score]{validate_domain_score()}}.
}
\examples{
get_capl_score(
  pc_score = c(20, 15, 12, 5, 31),
  db_score = c(20, 15, 6, 4.1, 25),
  mc_score = c(20, 20, 19, 15.4, 25),
  ku_score = c(11, 4, 5, 7.8, 10)
)

# [1] 66.66667 54.00000 42.00000 40.28571 85.71429

}
