% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/physical_competence.R
\name{get_pacer_20m_laps}
\alias{get_pacer_20m_laps}
\title{Convert PACER shuttle run laps to their equivalent in 20-metre laps.}
\usage{
get_pacer_20m_laps(lap_distance = NA, laps_run = NA)
}
\arguments{
\item{lap_distance}{A numeric (integer) vector (valid values are 15 or 20).}

\item{laps_run}{A numeric (integer) vector (if \code{lap_distance} = 15, valid values are integers between 1 and 298; if \code{lap_distance} = 20, valid values
are integers between 1 and 229).}
}
\value{
Returns a numeric (integer) vector with values between 1 and 229 (if valid) or NA (if not valid).
}
\description{
This function converts PACER (Progressive Aerobic Cardiovascular Endurance Run) shuttle run laps to their equivalent in 20-metre laps (\code{pacer_laps_20m}).
If laps are already 20-metre laps, they are returned unless outside the valid range (1-229). This variable is used to compute the PACER score
(\code{pacer_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_integer]{validate_integer()}} and \code{\link[=validate_scale]{validate_scale()}}.
}
\examples{
get_pacer_20m_laps(
  lap_distance = c(15, 20, NA, "15", 20.5), 
  laps_run = rep(100, 5)
)

# [1]  77 100  NA  77  NA

}
