% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{validate_scale}
\alias{validate_scale}
\title{Check whether a response to a given questionnaire item or scale is valid.}
\usage{
validate_scale(x, lower_bound = NA, upper_bound = NA)
}
\arguments{
\item{x}{A numeric (integer) vector representing the response to a questionnaire item (valid values are between the values set by the
\code{lower_bound} and \code{upper_bound} argumetns).}

\item{lower_bound}{A numeric (integer) vector representing the value below which x is invalid.}

\item{upper_bound}{A numeric (integer) vector representing the value above which x is invalid.}
}
\value{
Returns a numeric (integer) vector (if valid) or NA (if not valid).
}
\description{
This function checks whether a vector for a given questionnaire item or scale is valid.
}
\examples{
validate_scale(
  x = c(0:10, NA, "7"),
  lower_bound = 1,
  upper_bound = 7
)

# [1] NA  1  2  3  4  5  6  7 NA NA NA NA  7

}
