% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carbon.R
\name{carbon}
\alias{carbon}
\title{Carbon R6 class}
\description{
The Carbon generator creates a new \code{Carbon}-object, which is the class containing
all the app logic. The class is based on the \link[R6:R6Class]{R6} OO-system and
is thus reference-based with methods and data attached to each object, in
contrast to the more well known S3 and S4 systems.
}
\section{Initialization}{

A new 'Carbon'-object is initialized using the \code{new()} method on the generator:

\tabular{l}{
\code{x <- carbon$new(code = clipr::read_clip())}
}
}

\section{Fields}{


\foldstart{Public Fields}

Description of fields of the R6 object that can be set by the user can be found
in the following \link[=carbon-fields]{page}.

\foldend
}

\section{Methods}{


\foldstart{Interacting with Browser}

\tabular{ll}{
\link[=carbon-carbonate]{$carbonate} \tab Using RSelenium fetch the carbon image output \cr
\link[=.browse]{$browse} \tab open \link[=carbon-uri]{$uri} in the browser
}

\foldend

\foldstart{ Aesthetics }

\tabular{ll}{
\link[=carbon-set-fields]{$set_template} \tab set $template \cr
\link[=carbon-get-fields]{$get_templates} \tab get a list of possible templates \cr
\link[=carbon-set-fields]{$set_window_control_theme} \tab  set $windows_control_theme \cr
\link[=carbon-get-fields]{$get_windows_control_themes} \tab get a list of possible window control themes\cr
\link[=carbon-set-fields]{$set_font_family} \tab set $font_family\cr
\link[=carbon-get-fields]{$get_font_families} \tab get a list of possible fonts
}

\foldend

\foldstart{ URI Building }

\tabular{ll}{
\link[=carbon-uri]{$uri} \tab construct valid carbon.js uri \cr
\link[=carbon-options]{$options} \tab return all current carbon options\cr
\link[=carbon-encode]{$encode} \tab URL encode a string for the $uri \cr
\link[=carbon-tinyurl]{$tiny}  \tab Create tinyurl from \link[=carbon-uri]{$uri} \cr
\link[=carbon-rtweet]{$rtweet}  \tab Send tweets containing media generated from carbon
}

\foldend

\foldstart{ Webdriver Settings }

\tabular{ll}{
\link[=carbon-chrome]{$chromeOptions} \tab construct a chromeOptions object \cr
\link[=carbon-chrome]{$chrome_start} \tab start a chrome session \cr
\link[=carbon-chrome]{$chrome_stop} \tab stop a chrome session \cr
\link[=carbon-selenium]{$start} \tab start a RSelenium session \cr
\link[=carbon-selenium]{$stop} \tab stop a RSelenium session \cr
\link[=carbon-selenium]{$stop_all} \tab stop all active RSelenium sessions \cr
\link[=carbon-selenium]{$get_port} \tab Get active port  \cr
\link[=carbon-selenium]{$set_port} \tab Set new port
}

\foldend
}

