% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_CPI.R
\name{import_CPI}
\alias{import_CPI}
\title{Import CPI data from an Excel file}
\usage{
import_CPI(path, sheet = "Data_Price", skip = 2)
}
\arguments{
\item{path}{A character string specifying the file path of the Excel file.}

\item{sheet}{A character string specifying the name of the sheet in the Excel file to read data from.}

\item{skip}{An integer specifying the number of rows to skip while reading the Excel sheet.}
}
\value{
A processed data frame containing CPI data.
}
\description{
This function uses the downloaded data from the World Bank Carbon Pricing Dashboard (https://carbonpricingdashboard.worldbank.org/).
It imports data from an Excel file containing CPI (Carbon Price Index) data.
It filters the data for ETS (Emissions Trading Scheme) instruments, performs necessary transformations,
and returns a processed data frame.
}
