% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaport_finder.R
\name{seaport_finder}
\alias{seaport_finder}
\title{Check the code or name of a seaport}
\usage{
seaport_finder(city, country, port_code, distance = 0.1, ignore.case = FALSE)
}
\arguments{
\item{city}{Name of the city.}

\item{country}{Name of the country.}

\item{port_code}{Name of the port.}

\item{distance}{Maximum distance allowed for a match between the country/city given, and that of the value in the data set.}

\item{ignore.case}{If \code{FALSE}, the check is case-sensitive. If \code{TRUE}, case is ignored.}
}
\value{
Data frame containing the country, city, country code, port code, latitude, and longitude of a seaport.
}
\description{
Find the name and/or code of a seaport. For use in the \code{ferry_emissions} function.
}
\examples{
# Look up the city of Aberdeen to find the port_code for it
seaport_finder(city = "Aberdeen")

# Search for a country and city and it finds matches
seaport_finder(country = "United", city = "borunemouth", ignore.case = TRUE)
}
