% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor-constructor.R
\name{tidy.cosinor}
\alias{tidy.cosinor}
\title{Tidy a(n) cosinor object}
\usage{
\method{tidy}{cosinor}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A \code{cosinor} object created by \code{\link[card:cosinor]{card::cosinor()}}}

\item{conf.int}{Logical indicating whether or not to include confidence
interval in tidied output}

\item{conf.level}{The confidence level to use if \code{conf.int = TRUE}. Must be
between 0 and 1, with default to 0.95 (the 95\% confidence interval).}

\item{...}{For extensibility}
}
\value{
a \code{tibble} object
}
\description{
Tidy summarizes information about the components of a \code{cosinor}
model.
}
\details{
\code{cosinor} objects do not necessarily have a T-statistic as the
standard error is not based on a mean value, but form a joint-confidence
interval. The standard error is generated using Taylor series expansion as
the object is a subspecies of harmonic regressions.
}
