% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highd_obj.R
\name{cube_3d}
\alias{cube_3d}
\title{Generate a 3D cube with optional noise.}
\usage{
cube_3d(num_dims, num_noise, min_n, max_n)
}
\arguments{
\item{num_dims}{Number of effective dimensions (default is 3 for a 3D cube).}

\item{num_noise}{Number of additional noise dimensions to add to the data.}

\item{min_n}{Minimum value for the noise added to the data.}

\item{max_n}{Maximum value for the noise added to the data.}
}
\value{
A list containing the generated data matrix and the sample size.
}
\description{
This function generates a 3D cube along with optional noise.
}
\examples{
set.seed(20240412)
cube_3d(num_dims = 3, num_noise = 2, min_n = -0.01, max_n = 0.01)

}
