% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_curve.R
\name{scurve_hole}
\alias{scurve_hole}
\title{Generate S-curve Data with a Hole}
\usage{
scurve_hole(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the generated S-curve data with a hole.
}
\description{
This function generates S-curve data with a hole by filtering out samples that
are not close to a specified anchor point.
}
\examples{
set.seed(20240412)
s_curve_hole_data <- scurve_hole(
  n = 100, num_noise = 2,
  min_n = -0.05, max_n = 0.05
)
}
