% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{three_clust_mirror}
\alias{three_clust_mirror}
\title{Generate Three Cluster Mirror with Noise}
\usage{
three_clust_mirror(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated data, with each row representing a data point.
}
\description{
This function generates data with three clusters forming a mirror image,
along with added noise.
}
\examples{

# Generate three cluster mirror with noise with custom parameters
set.seed(20240412)
data <- three_clust_mirror(n = 300, num_noise = 2, min_n = -0.05, max_n = 0.05)
}
