% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{two_long_clust}
\alias{two_long_clust}
\title{Generate Long Cluster Data}
\usage{
two_long_clust(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the long cluster data with added noise.
}
\description{
This function generates a dataset consisting of two long clusters with added noise.
}
\examples{
set.seed(20240412)
long_cluster <- two_long_clust(
  n = 200, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
