# curv_2d() works

    Code
      curv_2d(n = 100, num_noise = 2, min_n = -0.01, max_n = 0.01)
    Output
                   [,1]        [,2]          [,3]          [,4]
        [1,] 1.81241781 -8.91992666  0.0079405268  2.917797e-03
        [2,] 1.13916432 -2.95207006 -0.0058152635 -5.731245e-03
        [3,] 0.52077018 -1.48232404 -0.0084472036 -5.219563e-03
        [4,] 0.71326385 -1.84338527  0.0042862004 -8.221478e-03
        [5,] 0.19633763 -2.30360778  0.0099886658 -9.930245e-03
        [6,] 1.61656492 -5.67179723  0.0071370359 -6.503715e-03
        [7,] 1.80114199 -6.45816914 -0.0003127460  4.562084e-03
        [8,] 0.93111798 -0.80073680  0.0024679349  9.377155e-03
        [9,] 1.29419869 -4.29338871  0.0056867863 -7.171829e-03
       [10,] 1.11790375 -2.75116533  0.0070165961  8.093255e-03
       [11,] 0.87749617 -1.74140235  0.0070687825 -2.179648e-03
       [12,] 0.81601983 -2.32693392 -0.0084628500 -6.827107e-03
       [13,] 0.12549133 -1.30399377  0.0010392493 -6.179010e-03
       [14,] 0.34449234 -1.15616456  0.0077893849  8.049303e-03
       [15,] 1.30396846 -2.04699007  0.0017315182 -5.638084e-03
       [16,] 1.19680972 -3.62879970 -0.0046408118 -7.542908e-03
       [17,] 0.64231274 -0.50221720  0.0049138256 -9.260504e-04
       [18,] 0.93743322 -1.50387990  0.0063177835 -8.984751e-03
       [19,] 1.99711034 -8.99202829 -0.0045468975  2.722302e-03
       [20,] 1.85101676 -8.90967059  0.0073298978 -5.522995e-03
       [21,] 1.28271391 -3.80878622 -0.0031569733  1.403361e-03
       [22,] 1.79838673 -5.96196888 -0.0014027103  1.446101e-03
       [23,] 0.98262282 -2.66042837 -0.0041639808  2.704042e-03
       [24,] 0.06164055 -0.84348820  0.0037844916 -8.914038e-03
       [25,] 1.20036394 -3.39659311 -0.0067643217 -2.620067e-04
       [26,] 1.82353506 -8.67947152  0.0092198479 -1.902759e-03
       [27,] 0.94232073 -1.63853152 -0.0089475669  6.007690e-03
       [28,] 0.13231871 -1.30225719 -0.0054499479  1.276564e-03
       [29,] 0.61031747 -0.43772368  0.0032194282 -4.889959e-03
       [30,] 1.31470991 -4.83770221 -0.0092889665 -5.354200e-03
       [31,] 1.29613733 -3.97137141 -0.0035869870  9.409730e-03
       [32,] 0.30113177 -0.13264243  0.0041476507 -5.923561e-03
       [33,] 0.75531666 -2.88086993 -0.0007488758  6.740342e-03
       [34,] 0.19355316 -0.33914052  0.0023716760  3.309367e-03
       [35,] 1.26684931 -3.75267684 -0.0012748077  3.666450e-03
       [36,] 0.02513317 -1.72914031  0.0059573099 -7.733417e-04
       [37,] 1.31669651 -4.23201010  0.0086696516 -8.126574e-03
       [38,] 0.42028633 -0.45525739  0.0032706525  6.802457e-03
       [39,] 1.67298187 -6.44164430 -0.0071983921  8.911312e-04
       [40,] 0.30513083 -0.02501438  0.0074180301  4.675507e-03
       [41,] 1.81894291 -6.70822235  0.0099276402  1.320145e-03
       [42,] 0.48680196 -1.86167615 -0.0022890385  1.486074e-03
       [43,] 0.31875460 -1.05947429  0.0031537260 -8.726588e-03
       [44,] 1.03855060 -3.10156388  0.0096545012  8.381871e-03
       [45,] 0.87979686 -2.90532486 -0.0083489244  6.850851e-03
       [46,] 0.89684694 -3.24643109 -0.0098152000 -7.720366e-03
       [47,] 0.18429762 -1.36701444  0.0028683354 -1.487052e-03
       [48,] 1.17180972 -1.60478143  0.0077938726  8.080831e-03
       [49,] 1.27189799 -4.43079411  0.0010104386 -8.553476e-03
       [50,] 1.16389407 -2.67673323  0.0067698057  5.989384e-03
       [51,] 1.29029013 -2.21193954 -0.0001441549 -8.913970e-03
       [52,] 1.85220913 -8.60998669 -0.0071712259 -2.164222e-03
       [53,] 1.08789316 -2.82628921  0.0068686553 -2.483721e-03
       [54,] 0.37198402 -0.85705169 -0.0076182519 -3.263303e-03
       [55,] 1.10793861 -2.51892795  0.0003530397  6.081672e-04
       [56,] 1.83643541 -8.21105286 -0.0054246164 -8.055756e-03
       [57,] 0.37966803 -2.71236718  0.0030734822 -1.870207e-03
       [58,] 1.76752447 -6.04815551  0.0087158333 -3.435507e-03
       [59,] 1.79036858 -7.59656343  0.0001407769 -1.427123e-03
       [60,] 1.97713338 -7.80236797  0.0008524857 -6.670750e-03
       [61,] 0.84484752 -2.95008158 -0.0061411715  6.862231e-04
       [62,] 0.29271951 -0.64175087  0.0034436384  3.733012e-03
       [63,] 0.37053471  0.07225120 -0.0068912965 -4.277005e-03
       [64,] 0.30705390 -2.16920595  0.0029105143  9.335539e-03
       [65,] 1.28311002 -3.49840793 -0.0004812824 -6.507916e-03
       [66,] 1.26498845 -2.69858190 -0.0094109036  5.609305e-03
       [67,] 1.49580126 -4.80475481  0.0085926273  1.801918e-03
       [68,] 1.88542781 -6.96529108 -0.0062896163 -5.976260e-03
       [69,] 1.21352943 -3.31295088  0.0093851401 -1.411748e-03
       [70,] 0.12296606 -0.77514406 -0.0013443732  3.417429e-03
       [71,] 0.67112639 -0.42729856  0.0073014144  5.132195e-03
       [72,] 1.43019465 -3.74993596 -0.0029618524  6.410127e-03
       [73,] 0.82837861 -0.94333359  0.0057631749  5.188265e-03
       [74,] 1.50491594 -4.11353175  0.0078781892 -7.606264e-03
       [75,] 1.68283860 -5.62210674  0.0087399051 -8.758609e-03
       [76,] 1.80715668 -7.82794502  0.0093043596  2.868308e-03
       [77,] 1.41543067 -5.34431624  0.0058278447  8.898322e-04
       [78,] 0.19287143 -1.40109369 -0.0022976296  1.500765e-03
       [79,] 0.38066456 -2.47877721  0.0038965767  9.313555e-03
       [80,] 0.41681336 -0.07528532  0.0097069791  5.421682e-03
       [81,] 0.52814749 -0.67705640  0.0019439889 -5.201622e-03
       [82,] 0.22297825 -1.06537269  0.0008956622  6.568626e-03
       [83,] 0.21132765 -0.49571023 -0.0073292305  8.958034e-03
       [84,] 1.49693606 -4.32980354  0.0079011023  6.354810e-03
       [85,] 1.94337330 -9.72989316  0.0010774986 -2.428218e-03
       [86,] 1.71273835 -7.66178735 -0.0011606926  5.091455e-04
       [87,] 1.79496680 -6.52506393 -0.0012195000  6.739245e-03
       [88,] 0.35361984 -0.75474110  0.0046834684  7.885662e-03
       [89,] 0.20516210 -0.48000497 -0.0037547271 -2.144002e-03
       [90,] 1.28332293 -1.96333421  0.0088425820  8.369593e-03
       [91,] 1.58049546 -4.85313062  0.0083874874  9.251521e-03
       [92,] 1.05169622 -2.72440891  0.0099780197  4.769873e-03
       [93,] 0.85893658 -1.58175917 -0.0021948213  4.059189e-03
       [94,] 0.92104507 -1.90029421  0.0014950385  6.178087e-06
       [95,] 1.72803056 -5.41271719  0.0061042596  4.328919e-03
       [96,] 0.37098133 -0.32110869  0.0034468541 -1.456172e-03
       [97,] 1.25854880 -2.72488789  0.0008139106  1.031921e-03
       [98,] 0.68838462 -2.53294886 -0.0078590608 -9.143837e-03
       [99,] 1.51972852 -5.71908735 -0.0067452238 -8.742367e-03
      [100,] 0.22662729  0.22534219 -0.0038019698  1.693190e-03

---

    Code
      curv_2d(n = 100, num_noise = 0)
    Output
                   [,1]        [,2]
        [1,] 0.80404859 -1.55121029
        [2,] 1.48452818 -5.45768853
        [3,] 0.34455950 -0.33556505
        [4,] 1.19994213 -3.51207334
        [5,] 1.61386404 -4.27805042
        [6,] 0.70467710 -1.10903261
        [7,] 1.36785652 -4.76747169
        [8,] 0.47083588 -2.93764272
        [9,] 0.74436093 -2.58017144
       [10,] 1.84553720 -6.17045446
       [11,] 1.19212210 -1.32467989
       [12,] 1.56605646 -5.18080015
       [13,] 1.83624824 -8.97107297
       [14,] 0.73777300 -2.30706224
       [15,] 0.62380860 -0.82092705
       [16,] 0.65754109 -1.16804496
       [17,] 0.84230490 -1.89574698
       [18,] 0.15987424 -0.70084280
       [19,] 0.42459141 -1.86731035
       [20,] 0.35429457 -0.65654807
       [21,] 0.44233613 -0.71067952
       [22,] 1.34839663 -2.58924987
       [23,] 0.89635739 -1.51922737
       [24,] 1.59494261 -5.70012794
       [25,] 0.59447124 -1.20592045
       [26,] 0.86109805 -0.60061748
       [27,] 1.05716461 -3.23369476
       [28,] 0.03713250 -1.24423657
       [29,] 1.32771143 -2.79840966
       [30,] 1.84793748 -8.57305766
       [31,] 0.59346769 -1.92071794
       [32,] 0.90951866 -2.19587339
       [33,] 0.65741631 -2.30737728
       [34,] 0.19999946 -2.08387875
       [35,] 1.62589249 -4.15986912
       [36,] 1.33930848 -4.92902119
       [37,] 1.51980476 -5.21152183
       [38,] 0.46282644 -1.21822008
       [39,] 0.36481462 -0.08494739
       [40,] 1.40351043 -4.29032160
       [41,] 0.71388760 -0.69921297
       [42,] 1.87764364 -7.08756899
       [43,] 0.05906569 -0.79155848
       [44,] 1.08865740 -2.77644077
       [45,] 1.73235635 -5.81717306
       [46,] 0.82942487 -1.74155223
       [47,] 1.15674088 -3.60603354
       [48,] 1.72893484 -5.63017089
       [49,] 0.33273455 -1.71241330
       [50,] 1.38159495 -3.38225116
       [51,] 1.02942335 -1.74883324
       [52,] 1.26858066 -4.48892587
       [53,] 0.29598720  0.02709424
       [54,] 1.47625207 -4.61853375
       [55,] 1.53237422 -6.02644894
       [56,] 0.28884753 -1.63380146
       [57,] 0.28095052 -1.97527162
       [58,] 1.27282046 -3.36840842
       [59,] 0.02492287 -1.37994714
       [60,] 0.50122571 -0.06037198
       [61,] 1.09793845 -1.91370826
       [62,] 1.79401134 -7.53590718
       [63,] 0.82550065 -1.64944779
       [64,] 0.68056816 -0.60008630
       [65,] 1.40395310 -4.22544860
       [66,] 0.81721904 -0.49458532
       [67,] 0.39432647 -2.65433041
       [68,] 0.64228399 -1.51999950
       [69,] 1.85801378 -8.79405377
       [70,] 1.44049078 -4.56328021
       [71,] 0.86667878 -0.76498925
       [72,] 0.12037928 -0.38223971
       [73,] 0.40313872 -1.98097269
       [74,] 0.90663818 -1.77048840
       [75,] 1.22957550 -3.52630038
       [76,] 1.58622108 -4.24886416
       [77,] 1.69923132 -4.85949638
       [78,] 0.98980486 -0.90305253
       [79,] 1.22151281 -2.48833221
       [80,] 0.31119918 -2.32944860
       [81,] 0.96557945 -2.66882970
       [82,] 0.89787855 -2.42451115
       [83,] 1.18942606 -1.63383426
       [84,] 0.54308347 -1.48017161
       [85,] 1.74225440 -8.08118626
       [86,] 0.11368395 -1.98270250
       [87,] 0.72321874 -1.00378782
       [88,] 1.79804627 -7.73578934
       [89,] 0.72137916 -0.47106047
       [90,] 1.09337891 -2.91488226
       [91,] 0.73259792 -0.33709642
       [92,] 1.61618407 -4.40322157
       [93,] 0.76191205 -0.30865403
       [94,] 0.56475296 -2.56149802
       [95,] 0.92382712 -0.65704421
       [96,] 1.40450688 -5.57559647
       [97,] 1.07285794 -3.06441031
       [98,] 0.88877521 -3.02489825
       [99,] 0.48284971 -1.11827718
      [100,] 1.31612402 -3.00954268

# nonlinear_2d() works

    Code
      nonlinear_2d(n = 100, num_noise = 2, min_n = -0.01, max_n = 0.01)
    Output
                  [,1]     [,2]          [,3]          [,4]
        [1,]  9.920071 10.94989  0.0019595141 -0.0024330894
        [2,] 10.406841 10.95933 -0.0048452818  0.0048760770
        [3,] 10.835481 10.49853  0.0065544050 -0.0073851340
        [4,] 10.677880 10.71917 -0.0019994213  0.0024597999
        [5,] 10.968458 10.33372 -0.0061386404 -0.0090854659
        [6,]  9.999524 10.96842  0.0029532290 -0.0021355029
        [7,]  9.859171 10.98535 -0.0036785652  0.0074561682
        [8,] 10.510103 10.82640  0.0052916412  0.0092691586
        [9,] 10.246776 10.94110  0.0025563907  0.0070103240
       [10,] 10.412656 10.92753 -0.0084553720 -0.0097716640
       [11,] 10.597312 10.81933 -0.0019212210 -0.0094755439
       [12,] 10.647572 10.79193 -0.0056605646  0.0020881218
       [13,] 10.959245 10.33060 -0.0083624824  0.0091108015
       [14,] 10.871459 10.51942  0.0026222700  0.0029313190
       [15,] 10.231121 10.95072  0.0037619140 -0.0030376368
       [16,] 10.369674 10.94899  0.0034245891 -0.0019588152
       [17,] 10.784806 10.67794  0.0015769510 -0.0004180963
       [18,] 10.565971 10.84071  0.0084012576 -0.0033459358
       [19,]  9.717541 10.90674  0.0057540859  0.0021061658
       [20,]  9.832276 11.01466  0.0064570543 -0.0051381362
       [21,] 10.271178 10.87763  0.0055766387 -0.0039039763
       [22,]  9.845751 10.97742 -0.0034839663 -0.0059516697
       [23,] 10.541550 10.89783  0.0010364261 -0.0022198708
       [24,] 10.977153 10.23825 -0.0059494261  0.0029831038
       [25,] 10.386926 10.93226  0.0040552876 -0.0032377896
       [26,]  9.797184 10.98688  0.0013890195 -0.0094732528
       [27,] 10.553649 10.80789 -0.0005716461  0.0054901890
       [28,] 10.954293 10.30514  0.0096286750  0.0008317638
       [29,] 10.795158 10.64314 -0.0032771143 -0.0067325067
       [30,] 10.274096 10.96504 -0.0084793748  0.0071255075
       [31,] 10.299373 10.98739  0.0040653231  0.0040336721
       [32,] 10.856545 10.46869  0.0009048134  0.0007948379
       [33,] 10.672661 10.74400  0.0034258369  0.0037801312
       [34,] 10.944658 10.31095  0.0080000054  0.0067890744
       [35,] 10.303134 10.89820 -0.0062589249 -0.0079096853
       [36,] 10.951067 10.18627 -0.0033930848  0.0070315687
       [37,] 10.241340 10.94200 -0.0051980476  0.0023691027
       [38,] 10.839797 10.48026  0.0053717356 -0.0005785696
       [39,] 10.019883 10.97492  0.0063518538 -0.0083209177
       [40,] 10.947085 10.42603 -0.0040351043  0.0026710216
       [41,]  9.813709 10.97958  0.0028611240 -0.0072595350
       [42,] 10.792806 10.60626 -0.0087764364 -0.0062834510
       [43,] 10.922353 10.44752  0.0094093431 -0.0035497907
       [44,] 10.463103 10.88417 -0.0008865740  0.0016241798
       [45,] 10.562166 10.82295 -0.0073235635 -0.0031732373
       [46,] 10.561583 10.77462  0.0017057513 -0.0018371879
       [47,] 10.929140 10.35620 -0.0015674088  0.0058190771
       [48,] 10.339282 10.90152 -0.0072893484 -0.0041072183
       [49,] 10.278816 10.95249  0.0066726545  0.0016127267
       [50,] 10.418569 10.95432 -0.0038159495 -0.0031067648
       [51,] 10.224350 10.97124 -0.0002942335 -0.0052057256
       [52,]  9.848340 10.96079 -0.0026858066  0.0089219462
       [53,] 10.444693 10.81764  0.0070401280 -0.0090417859
       [54,] 10.863781 10.50934 -0.0047625207 -0.0004654371
       [55,] 10.507592 10.87364 -0.0053237422  0.0077075013
       [56,]  9.791363 10.97619  0.0071115247  0.0014760667
       [57,] 10.894719 10.47054  0.0071904948  0.0044659154
       [58,]  9.906101 10.96965 -0.0027282046  0.0012131345
       [59,]  9.861101 10.98707  0.0097507713  0.0025180878
       [60,]  9.723760 10.96728  0.0049877429 -0.0086654357
       [61,] 10.581506 10.79589 -0.0009793845 -0.0047265252
       [62,] 10.928176 10.44228 -0.0079401134  0.0043176200
       [63,] 10.835117 10.48908  0.0017449935  0.0002468865
       [64,] 10.900820 10.46806  0.0031943184 -0.0075734958
       [65,] 10.260905 10.93858 -0.0040395310  0.0011978817
       [66,] 10.305239 11.01047  0.0018278096 -0.0093945484
       [67,] 10.130710 11.02336  0.0060567353  0.0092224759
       [68,]  9.815696 10.99072  0.0035771601 -0.0001127845
       [69,] 10.371784 10.90036 -0.0085801378  0.0076909859
       [70,] 11.004836 10.30231 -0.0044049078  0.0016325905
       [71,] 10.719404 10.69782  0.0013332122 -0.0087853309
       [72,] 10.131189 10.94053  0.0087962072 -0.0054189082
       [73,] 10.610107 10.81216  0.0059686128  0.0036734316
       [74,] 10.156961 10.98908  0.0009336182 -0.0012763747
       [75,]  9.955147 10.95514 -0.0022957550  0.0039806176
       [76,]  9.847790 10.94038 -0.0058622108 -0.0054615625
       [77,] 10.182639 10.97465 -0.0069923132 -0.0084524358
       [78,] 10.969424 10.35689  0.0001019514 -0.0093299974
       [79,] 10.832483 10.49039 -0.0022151281 -0.0042335966
       [80,] 10.841021 10.51828  0.0068880082  0.0086188323
       [81,] 10.747624 10.60374  0.0003442055  0.0038413546
       [82,] 10.943405 10.36126  0.0010212145  0.0044857961
       [83,] 10.923748 10.34101 -0.0018942606 -0.0083835474
       [84,] 10.141264 11.00083  0.0045691653 -0.0007348133
       [85,]  9.719888 10.95937 -0.0074225440  0.0088869130
       [86,]  9.995755 11.01826  0.0088631605  0.0037203620
       [87,]  9.908279 11.01115  0.0027678126 -0.0043509039
       [88,] 10.875546 10.43147 -0.0079804627  0.0043605085
       [89,] 10.959877 10.36762  0.0027862084 -0.0081848094
       [90,] 10.318097 11.01297 -0.0009337891  0.0023121875
       [91,] 10.005978 10.97803  0.0026740208 -0.0087822618
       [92,] 10.434114 10.93353 -0.0061618407 -0.0068433705
       [93,] 10.584853 10.78852  0.0023808795 -0.0084416190
       [94,] 10.562990 10.85770  0.0043524704  0.0080442910
       [95,]  9.887682 10.98823  0.0007617288 -0.0085931618
       [96,] 10.785070 10.54384 -0.0040450688  0.0090480520
       [97,] 10.301096 10.96817 -0.0007285794  0.0050223044
       [98,] 10.688445 10.72041  0.0011122479  0.0058133861
       [99,] 10.076253 10.99980  0.0051715029 -0.0004978115
      [100,] 10.981643 10.33512 -0.0031612402 -0.0037812646

---

    Code
      nonlinear_2d(n = 100, num_noise = 0)
    Output
                  [,1]     [,2]
        [1,] 10.842210 10.55177
        [2,] 10.915842 10.31120
        [3,] 10.843213 10.52813
        [4,] 10.937861 10.47806
        [5,] 10.936124 10.37723
        [6,]  9.949349 11.02680
        [7,] 10.034028 11.00767
        [8,] 10.942129 10.37537
        [9,] 10.125782 11.00796
       [10,] 10.742617 10.62875
       [11,]  9.788336 11.00800
       [12,]  9.782834 10.97134
       [13,] 10.850356 10.47226
       [14,] 10.969196 10.25744
       [15,]  9.801034 11.01961
       [16,] 10.261391 10.95883
       [17,] 10.721373 10.61820
       [18,] 10.363125 11.02272
       [19,] 10.979550 10.26707
       [20,] 10.829817 10.59522
       [21,] 10.364066 10.90753
       [22,]  9.823639 10.95028
       [23,] 10.090118 11.02871
       [24,] 10.363341 10.90407
       [25,] 10.996303 10.27052
       [26,] 10.831324 10.54313
       [27,] 10.449140 10.93480
       [28,] 10.105431 11.02854
       [29,] 10.905518 10.24214
       [30,] 10.410289 10.91389
       [31,] 10.033238 11.01980
       [32,] 10.689629 10.69015
       [33,] 10.878041 10.35688
       [34,]  9.885397 10.99674
       [35,]  9.868302 10.96759
       [36,] 10.913922 10.29331
       [37,] 10.767468 10.67192
       [38,] 10.351944 10.92461
       [39,] 10.628425 10.76198
       [40,] 10.133523 11.01306
       [41,] 10.909951 10.41761
       [42,] 10.859549 10.43614
       [43,] 10.664866 10.65366
       [44,] 10.461933 10.84147
       [45,]  9.987785 11.03493
       [46,] 10.968068 10.37237
       [47,] 10.257885 10.94409
       [48,]  9.990501 11.00566
       [49,] 10.918182 10.38953
       [50,] 10.375203 10.93674
       [51,] 10.950701 10.42389
       [52,] 10.031240 11.00832
       [53,] 10.617702 10.75780
       [54,] 10.941940 10.31369
       [55,] 10.569684 10.80694
       [56,] 10.810357 10.51421
       [57,] 10.629244 10.79628
       [58,] 10.055962 11.01142
       [59,]  9.665553 10.96680
       [60,] 10.454863 10.93112
       [61,] 10.613813 10.74220
       [62,] 10.037490 11.02648
       [63,]  9.847500 10.95358
       [64,] 10.869775 10.44353
       [65,] 10.563561 10.81145
       [66,] 10.782350 10.61285
       [67,] 10.373492 10.94399
       [68,] 10.582153 10.82243
       [69,] 10.429088 10.82647
       [70,] 10.699173 10.69175
       [71,] 10.888922 10.38000
       [72,] 10.350194 10.97499
       [73,] 10.777138 10.58866
       [74,] 10.455748 10.90891
       [75,]  9.878949 11.01378
       [76,]  9.937587 11.00883
       [77,] 10.403607 10.89023
       [78,] 10.697591 10.75492
       [79,] 10.626157 10.79904
       [80,]  9.742060 10.96136
       [81,] 10.276913 10.97434
       [82,]  9.758273 10.94139
       [83,] 10.395640 10.92421
       [84,] 10.864591 10.38275
       [85,] 11.001005 10.34130
       [86,] 10.924459 10.50034
       [87,] 10.637790 10.81720
       [88,] 10.574166 10.80089
       [89,] 10.712096 10.67099
       [90,] 10.557356 10.83162
       [91,] 10.581632 10.85705
       [92,] 10.382259 10.90184
       [93,] 10.122741 10.94605
       [94,] 10.230735 10.96777
       [95,] 10.260636 10.95151
       [96,] 10.933657 10.40038
       [97,]  9.947073 10.93540
       [98,] 10.908126 10.36687
       [99,]  9.930948 11.00869
      [100,] 10.625197 10.76152

# sine_curve() works

    Code
      sine_curve(n = 100, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                   [,1]        [,2]          [,3]         [,4]
        [1,] 5.12449062 -0.91628107 -0.0494111540 -0.046811273
        [2,] 3.22091124 -0.07923544 -0.0095421034  0.012496258
        [3,] 1.47244301  0.99516721 -0.0095423958  0.039036306
        [4,] 2.01670603  0.90221870 -0.0056648134 -0.012114244
        [5,] 0.55513158  0.52705513 -0.0361641475  0.007777032
        [6,] 4.57072964 -0.98998308 -0.0137938427  0.043311664
        [7,] 5.09260899 -0.92858301  0.0227676261 -0.009618158
        [8,] 2.63267406  0.48723317  0.0486252397 -0.040446538
        [9,] 3.65926058 -0.49485497 -0.0374798555  0.049745073
       [10,] 3.16079839 -0.01920456 -0.0060145900  0.015265306
       [11,] 2.48106197  0.61353600  0.0122375009 -0.036571148
       [12,] 2.30724173  0.74086071 -0.0151320067 -0.015919120
       [13,] 0.35481837  0.34742005 -0.0069745122  0.031443569
       [14,] 0.97402914  0.82715668  0.0119806817 -0.044940477
       [15,] 3.68688395 -0.51866716  0.0425165671  0.028938895
       [16,] 3.38389975 -0.23994296 -0.0198855986 -0.013595432
       [17,] 1.81609648  0.97006448  0.0341541310 -0.002368991
       [18,] 2.65052998  0.47156326  0.0139019090  0.030572272
       [19,] 5.64669645 -0.59437549  0.0043720318  0.018436977
       [20,] 5.23362660 -0.86720357 -0.0362611223 -0.045953311
       [21,] 3.62678812 -0.46638128 -0.0091411981 -0.034806118
       [22,] 5.08481868 -0.93144598  0.0375122381 -0.004200594
       [23,] 2.77830057  0.35535337 -0.0205436346  0.030929957
       [24,] 0.17428455  0.17340357  0.0096704798  0.023326323
       [25,] 3.39394907 -0.24968643 -0.0074246488 -0.038856192
       [26,] 5.15592392 -0.90324034 -0.0395226781 -0.036005257
       [27,] 2.66434909  0.45933248  0.0140160184  0.005547783
       [28,] 0.37412233  0.36545571  0.0001349537 -0.010797826
       [29,] 1.72563199  0.98803689  0.0395929786 -0.029635492
       [30,] 3.71725469 -0.54439025 -0.0421812224 -0.009967849
       [31,] 3.66474197 -0.49961070 -0.0192060802  0.006457079
       [32,] 0.85143002  0.75222343  0.0329963851  0.030954550
       [33,] 2.13560755  0.84468966 -0.0441801412  0.025088984
       [34,] 0.54725866  0.52034821  0.0359260298 -0.031934072
       [35,] 3.58193203 -0.42624649 -0.0215506210  0.035403466
       [36,] 0.07106238  0.07100258 -0.0231140854  0.042859625
       [37,] 3.72287166 -0.54909333 -0.0290469873  0.034428535
       [38,] 1.18833160  0.92774760  0.0346599014 -0.034162961
       [39,] 4.73024481 -0.99984059 -0.0245407152  0.045406635
       [40,] 0.86273710  0.75962551  0.0438232428 -0.012260502
       [41,] 5.14293991 -0.90873595  0.0190370204 -0.002252682
       [42,] 1.37640011  0.98116448 -0.0157330000 -0.004865140
       [43,] 0.90125740  0.78410790  0.0136145061 -0.037104514
       [44,] 2.93643263  0.20372383 -0.0211817049 -0.019189041
       [45,] 2.48756702  0.60838624 -0.0296529576 -0.016947191
       [46,] 2.53577498  0.56943442 -0.0385897858 -0.023474528
       [47,] 0.52108923  0.49782510 -0.0114352393  0.046460505
       [48,] 3.31321391 -0.17078002  0.0394679684  0.014047195
       [49,] 3.59620685 -0.43911573 -0.0379028531  0.002774406
       [50,] 3.29083295 -0.14868691  0.0086608654 -0.021978159
       [51,] 3.64820939 -0.48522173  0.0397832549 -0.001459893
       [52,] 5.23699795 -0.86551987 -0.0389684510  0.032680244
       [53,] 3.07594545  0.06560006 -0.0107839450  0.006952650
       [54,] 1.05176004  0.86829762  0.0229901668 -0.049056897
       [55,] 3.13262262  0.00896991 -0.0032016000  0.037429136
       [56,] 5.19239880 -0.88699039 -0.0188916723 -0.040186682
       [57,] 1.07348607  0.87886892 -0.0406173033 -0.037823953
       [58,] 4.99755769 -0.95961420  0.0218278701  0.013801423
       [59,] 5.06214790 -0.93945535 -0.0178925602 -0.014180800
       [60,] 5.59021294 -0.63882679  0.0418970450 -0.016110678
       [61,] 2.38875009  0.68371587 -0.0289520095 -0.045699345
       [62,] 0.82764491  0.73633993  0.0182308341  0.017281139
       [63,] 1.04766220  0.86625764  0.0420673159  0.022220930
       [64,] 0.86817444  0.76315049 -0.0215416480 -0.048801365
       [65,] 3.62790811 -0.46737170 -0.0032879685 -0.007458667
       [66,] 3.57667059 -0.42148108  0.0136172979  0.033425671
       [67,] 4.22927842 -0.88555424 -0.0128606171  0.035560294
       [68,] 5.33092155 -0.81473021  0.0406865353 -0.046699327
       [69,] 3.43117362 -0.28555067 -0.0056567913 -0.021227714
       [70,] 0.34767834  0.34071598  0.0206802091 -0.028738201
       [71,] 1.89756516  0.94708444  0.0293639539  0.048813058
       [72,] 4.04378010 -0.78468477  0.0099463716  0.025414831
       [73,] 2.34218534  0.71694304  0.0216768384  0.044960774
       [74,] 4.25504957 -0.89723049  0.0126717287  0.032921567
       [75,] 4.75811406 -0.99895479  0.0137911398 -0.004026652
       [76,] 5.10961515 -0.92213763 -0.0201560635 -0.014284641
       [77,] 4.00203595 -0.75813171 -0.0474466317  0.032963758
       [78,] 0.54533113  0.51870122  0.0034467781 -0.049464466
       [79,] 1.07630369  0.88020961 -0.0451321898  0.036069776
       [80,] 1.17851201  0.92403818  0.0449525188 -0.020289299
       [81,] 1.49330186  0.99699881  0.0301143471 -0.036633093
       [82,] 0.63045615  0.58951328  0.0015380326  0.029914531
       [83,] 0.59751485  0.56258965  0.0313923658 -0.035608689
       [84,] 4.23248700 -0.88704018  0.0142799772 -0.030768446
       [85,] 5.49475855 -0.70924508 -0.0342363236 -0.022653194
       [86,] 4.84265358 -0.99152756 -0.0437694831 -0.014886355
       [87,] 5.07514905 -0.93492096  0.0163590239  0.003475857
       [88,] 0.99983654  0.84138265  0.0215670073 -0.021506445
       [89,] 0.58008218  0.54809268  0.0312772650 -0.031937469
       [90,] 3.62851010 -0.46790382  0.0404797181  0.037160310
       [91,] 4.46874564 -0.97046550  0.0197967365 -0.049801787
       [92,] 2.97360102  0.16720260 -0.0082434738 -0.012772074
       [93,] 2.42858595  0.65411099  0.0110442976 -0.005877741
       [94,] 2.60419359  0.51190341  0.0086618911 -0.025761254
       [95,] 4.88589129 -0.98498619  0.0378016111 -0.027342288
       [96,] 1.04892501  0.86688784  0.0267662517  0.035392174
       [97,] 3.55846289 -0.40490071  0.0202962862 -0.018060863
       [98,] 1.94636167  0.93030040 -0.0326327926  0.004448415
       [99,] 4.29693117 -0.91493164 -0.0398299208  0.047147391
      [100,] 0.64077357  0.59781574  0.0465680600  0.017987990

---

    Code
      sine_curve(n = 100, num_noise = 0)
    Output
                    [,1]         [,2]
        [1,] 0.582302334  0.549948299
        [2,] 4.471660407 -0.971164533
        [3,] 5.215823945 -0.875930578
        [4,] 1.615538763  0.998999224
        [5,] 0.003204666  0.003204660
        [6,] 0.809484034  0.723931320
        [7,] 2.915860248  0.223820247
        [8,] 2.129641230  0.847868117
        [9,] 1.219532445  0.938938580
       [10,] 0.843537574  0.746999655
       [11,] 0.828782229  0.737108980
       [12,] 5.220247862 -0.873787751
       [13,] 2.533592572  0.571227086
       [14,] 0.625036697  0.585127032
       [15,] 2.337858146  0.719952939
       [16,] 4.139592020 -0.840388355
       [17,] 1.438081943  0.991206364
       [18,] 1.041122190  0.862971759
       [19,] 4.113038370 -0.825702114
       [20,] 0.754953613  0.685254886
       [21,] 3.720046570 -0.546730041
       [22,] 3.224040395 -0.082354365
       [23,] 4.004771215 -0.759912543
       [24,] 1.757393592  0.982641186
       [25,] 4.740000304 -0.999618832
       [26,] 0.220582812  0.218798351
       [27,] 5.357298336 -0.799154259
       [28,] 4.368369844 -0.941406725
       [29,] 1.917161513  0.940612874
       [30,] 5.453826786 -0.737498301
       [31,] 3.841630072 -0.644246306
       [32,] 1.654712769  0.996481081
       [33,] 3.039173021  0.102240666
       [34,] 2.156857798  0.833125472
       [35,] 3.187876775 -0.046267598
       [36,] 1.143043698  0.909900317
       [37,] 0.376147141  0.367339711
       [38,] 1.902678179  0.945430868
       [39,] 4.862730810 -0.988719938
       [40,] 0.730034797  0.666895564
       [41,] 0.020459237  0.020457810
       [42,] 3.474643781 -0.326928011
       [43,] 1.935738367  0.934144448
       [44,] 0.097687481  0.097532186
       [45,] 5.188036137 -0.888996566
       [46,] 5.602615815 -0.629235744
       [47,] 2.016430667  0.902337427
       [48,] 0.623767816  0.584097573
       [49,] 2.541738614  0.564522001
       [50,] 0.913315924  0.791534530
       [51,] 2.868192221  0.270007127
       [52,] 4.855049750 -0.989841199
       [53,] 0.885366844  0.774147253
       [54,] 4.981443365 -0.964022691
       [55,] 2.727613769  0.402255281
       [56,] 4.361207531 -0.938966941
       [57,] 1.958426773  0.925807339
       [58,] 0.363089576  0.355164072
       [59,] 2.787629671  0.346617823
       [60,] 2.586398746  0.527108093
       [61,] 4.563808714 -0.988982244
       [62,] 1.853767578  0.960230075
       [63,] 4.775901579 -0.997983753
       [64,] 2.004504846  0.907413529
       [65,] 2.963512786  0.177140135
       [66,] 5.488303690 -0.713780698
       [67,] 0.397925252  0.387506536
       [68,] 4.605780492 -0.994322695
       [69,] 0.173847549  0.172973173
       [70,] 3.207545963 -0.065905505
       [71,] 0.763007112  0.691097990
       [72,] 3.664877413 -0.499728030
       [73,] 1.197934085  0.931288497
       [74,] 0.599927880  0.564582948
       [75,] 0.356283445  0.348793497
       [76,] 0.196687702  0.195421974
       [77,] 1.179649132  0.924472301
       [78,] 3.477072853 -0.329222638
       [79,] 1.725702276  0.988026046
       [80,] 0.082849711  0.082754963
       [81,] 2.277783482  0.760322305
       [82,] 2.574190871  0.537442788
       [83,] 4.899724492 -0.982503961
       [84,] 0.593449338  0.559223903
       [85,] 2.522777834  0.580070160
       [86,] 3.155611484 -0.014018371
       [87,] 3.172238897 -0.030641446
       [88,] 1.503213891  0.997717176
       [89,] 3.889057470 -0.679781606
       [90,] 0.327252227  0.321442299
       [91,] 0.455927192  0.440294986
       [92,] 0.006214778  0.006214738
       [93,] 3.448004493 -0.301639554
       [94,] 2.404721209  0.671974276
       [95,] 1.101494651  0.891884332
       [96,] 1.852858339  0.960483547
       [97,] 2.597305579  0.517808317
       [98,] 5.049530488 -0.943704083
       [99,] 4.734600476 -0.999753335
      [100,] 3.902415029 -0.689517300

# nonlinear_connect() works

    Code
      nonlinear_connect(n = 400, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                  [,1]      [,2]      [,3]       [,4]          [,5]          [,6]
        [1,]  9.426193 10.722529  9.992557  -9.975523  0.0225046200 -0.0385602572
        [2,] 10.146076 11.032950  9.971644  -9.974227  0.0195495758 -0.0438696750
        [3,] 10.826033 10.511045 10.025999  -9.965498  0.0171381534  0.0076111420
        [4,] 10.606319 10.782206 10.014361 -10.027520  0.0072901649 -0.0165481713
        [5,] 11.004199 10.220622  9.990217 -10.021930 -0.0311489899 -0.0330893505
        [6,]  9.546128 10.864230 10.007295 -10.037832 -0.0439051131 -0.0238789355
        [7,]  9.366743 10.765679 10.041777  -9.971851 -0.0053917592 -0.0394945391
        [8,] 10.346859 10.914218  9.985286 -10.044806 -0.0416760790 -0.0468400013
        [9,]  9.914462 10.978628  9.994032  -9.982360  0.0113264317 -0.0105065495
       [10,] 10.161941 11.004398  9.976046  -9.950747 -0.0259034847  0.0254667256
       [11,] 10.458129 10.904624  9.976952 -10.006099 -0.0065685699  0.0474034305
       [12,] 10.534925 10.871387  9.996092 -10.018928  0.0435717741 -0.0304892378
       [13,] 10.993207 10.186659  9.984029  -9.946398  0.0070676897 -0.0294995918
       [14,] 10.896986 10.468105 10.002151 -10.003212 -0.0130117224 -0.0140611462
       [15,]  9.894472 10.985248 10.012690  -9.954448  0.0492103347  0.0331667699
       [16,] 10.081842 11.011743  9.983985 -10.023852 -0.0424193460  0.0249892669
       [17,] 10.738659 10.725142  9.986696  -9.959320  0.0080156112 -0.0443338630
       [18,] 10.399847 10.928661 10.026664 -10.039059 -0.0247982748 -0.0034853082
       [19,]  9.217364 10.545652 10.021180  -9.985005  0.0494386119  0.0292903203
       [20,]  9.334325 10.760492  9.972813  -9.994780  0.0031001754  0.0020995703
       [21,]  9.943995 10.918582  9.989001  -9.969081 -0.0384837404 -0.0417909439
       [22,]  9.353694 10.759619  9.943369  -9.988631  0.0133946033 -0.0393646501
       [23,] 10.354588 10.985725 10.033255 -10.026502  0.0444344055 -0.0364414532
       [24,] 11.005722 10.066354 10.005932 -10.009893  0.0412088149  0.0494153826
       [25,] 10.097438 10.994246  9.970941  -9.966584 -0.0482690136  0.0098536590
       [26,]  9.301991 10.751869 10.001107  -9.965108 -0.0288730615  0.0122078126
       [27,] 10.385290 10.895921  9.968648  -9.991895 -0.0473867274 -0.0183048289
       [28,] 10.988618 10.164184 10.021790  -9.996677  0.0318573298  0.0293500639
       [29,] 10.759559 10.682083  9.967654  -9.994982  0.0127151501  0.0298496166
       [30,]  9.932714 10.996166  9.932722 -10.078506 -0.0310874645  0.0009871742
       [31,]  9.966197 11.024333 10.003692  -9.992531  0.0415701205  0.0319117798
       [32,] 10.886964 10.399848  9.993386 -10.038489 -0.0046033602 -0.0447861338
       [33,] 10.584842 10.814737 10.015903  -9.995706 -0.0110073412  0.0376506117
       [34,] 10.980411 10.196643  9.974446 -10.006111  0.0042060562  0.0421038849
       [35,]  9.983096 10.943676 10.044053 -10.003597 -0.0147514978 -0.0375801469
       [36,] 10.974928  9.998476  9.994964  -9.967101 -0.0460891930 -0.0360514234
       [37,]  9.899087 10.972488  9.974919  -9.981717  0.0059436755 -0.0447320385
       [38,] 10.853156 10.458033 10.008755 -10.032338 -0.0396971727  0.0487984729
       [39,]  9.551671 10.837692 10.031044 -10.004373 -0.0243395832  0.0278718080
       [40,] 10.977118 10.358824 10.008439  -9.992281  0.0275306388  0.0145755523
       [41,]  9.319045 10.747740  9.998705 -10.008791  0.0312191814 -0.0283425041
       [42,] 10.791880 10.607582 10.007191 -10.006265  0.0077302772 -0.0314372709
       [43,] 10.950970 10.385869 10.033952  -9.958000 -0.0090521603  0.0235572706
       [44,] 10.249931 10.969508  9.989375  -9.995753  0.0129959400 -0.0220768404
       [45,] 10.421967 10.908410  9.989302  -9.988702 -0.0053369763 -0.0477736241
       [46,] 10.413804 10.861107  9.989750  -9.998307 -0.0006899428 -0.0138437658
       [47,] 10.964887 10.237890  9.990911 -10.018822 -0.0433534647  0.0167624947
       [48,] 10.063145 10.969365  9.997132 -10.014440 -0.0023328541 -0.0277741424
       [49,]  9.956497 10.996556 10.002743 -10.030791  0.0130878423  0.0288008057
       [50,] 10.146150 11.023650  9.978948 -10.029741 -0.0149118887 -0.0363385358
       [51,]  9.893779 11.009946  9.990705  -9.989296 -0.0128667695 -0.0189887146
       [52,]  9.350286 10.705782  9.966313  -9.977455 -0.0430241688 -0.0137734955
       [53,] 10.208189 10.898383  9.949367  -9.979803  0.0143187563 -0.0478930199
       [54,] 10.885416 10.468823 10.034193 -10.053303 -0.0044628767  0.0117170841
       [55,] 10.261595 10.951887 10.031159 -10.019291  0.0243798140  0.0252673091
       [56,]  9.294787 10.732231  9.941816  -9.995797  0.0206240318  0.0456749357
       [57,] 10.915159 10.432988 10.051034 -10.045759  0.0043487728 -0.0405517242
       [58,]  9.418672 10.772519  9.988288 -10.018155 -0.0313727285 -0.0039266809
       [59,]  9.370166 10.774682  9.998427 -10.048460  0.0423568445  0.0310922803
       [60,]  9.222603 10.621229 10.008013  -9.980687 -0.0010548269  0.0302557959
       [61,] 10.456573 10.878473  9.984681  -9.927410 -0.0006496763  0.0031932980
       [62,] 10.959365 10.369973  9.991543 -10.004890 -0.0024959060 -0.0422008535
       [63,] 10.856972 10.447998  9.987471  -9.969562 -0.0079855336  0.0351417393
       [64,] 10.930662 10.401642 10.022613 -10.018490  0.0123126329  0.0498009565
       [65,]  9.933545 10.979416  9.970580  -9.999871 -0.0042613463 -0.0146315253
       [66,]  9.986043 11.056462 10.015877  -9.980958 -0.0414011640 -0.0096379571
       [67,]  9.716324 10.982142 10.014791  -9.936852  0.0006285924  0.0370232024
       [68,]  9.315305 10.712091  9.962313 -10.015288 -0.0025430988 -0.0167045433
       [69,] 10.076181 10.959396 10.009043 -10.019827  0.0426988430 -0.0322707794
       [70,] 11.038654 10.157267  9.958631 -10.001650  0.0421615363 -0.0179057525
       [71,] 10.663260 10.751870  9.967186  -9.981469 -0.0132318267 -0.0356876918
       [72,]  9.741551 10.928732  9.986179 -10.033837  0.0466696334 -0.0491421592
       [73,] 10.492229 10.893044  9.987736  -9.959741  0.0381274384 -0.0034444314
       [74,]  9.739318 10.943505 10.024292 -10.025845 -0.0132470521  0.0431239444
       [75,]  9.484593 10.811926 10.006106 -10.030514  0.0021247955  0.0184773289
       [76,]  9.354574 10.716614  9.978783 -10.002564  0.0453311742 -0.0214480726
       [77,]  9.798863 10.968975  9.950036 -10.008349 -0.0213985977  0.0039396212
       [78,] 11.005179 10.242292 10.036069 -10.017268 -0.0243783228 -0.0321544330
       [79,] 10.852765 10.453224 10.017780  -9.952760 -0.0044371279 -0.0045817754
       [80,] 10.855034 10.494765 10.009631 -10.077939 -0.0043813414 -0.0473943979
       [81,] 10.736220 10.618611  9.981038  -9.988027 -0.0180668992  0.0071764838
       [82,] 10.978682 10.259610 10.000928  -9.987339  0.0206689905  0.0405699224
       [83,] 10.959303 10.234368 10.004521  -9.937820  0.0256352488  0.0243596796
       [84,]  9.726470 10.959073 10.052916 -10.005437 -0.0212119147 -0.0139811878
       [85,]  9.218020 10.638482 10.035941 -10.019343  0.0097237010 -0.0304546448
       [86,]  9.518567 10.856506  9.953541  -9.957026  0.0313594255 -0.0104742536
       [87,]  9.416694 10.795662 10.014340 -10.015644 -0.0109449895 -0.0405562304
       [88,] 10.899848 10.383762 10.015648  -9.981409  0.0033475545 -0.0066032809
       [89,] 10.995532 10.258320  9.957312 -10.027475 -0.0386246506  0.0367787153
       [90,]  9.990641 11.053746  9.983251 -10.026731  0.0446871840  0.0165217568
       [91,]  9.563247 10.893793 10.015052 -10.011705 -0.0402139632  0.0159038847
       [92,] 10.214738 11.017856  9.958013  -9.982951  0.0127152335 -0.0210098319
       [93,] 10.453812 10.872386 10.047770  -9.963659  0.0414065541 -0.0086848693
       [94,] 10.404321 10.945231  9.982733  -9.979648 -0.0302830698 -0.0085650964
       [95,]  9.407381 10.816773  9.959917  -9.984310  0.0372908417  0.0351366563
       [96,] 10.806858 10.502927  9.953579 -10.039472 -0.0277323624 -0.0390131298
       [97,]  9.984821 11.015930  9.957424  -9.952249 -0.0431726661 -0.0148358829
       [98,] 10.626097 10.778297  9.955803 -10.041466  0.0251979483 -0.0370112603
       [99,]  9.653420 10.946995 10.020340 -10.006542 -0.0287492317  0.0299610219
      [100,] 11.016808 10.235023  9.998127  -9.988428 -0.0066199879 -0.0227505828
      [101,]  9.482719  9.368260  9.935521  -9.948684  0.0483327051  0.0023537656
      [102,] 10.216561  9.119441  9.994123 -10.006766 -0.0357602461 -0.0202086667
      [103,] 10.860984  9.489266  9.954162  -9.983638  0.0237214818 -0.0229325502
      [104,] 10.710306  9.339711  9.983597 -10.041477  0.0463125654 -0.0285129161
      [105,] 11.072601  9.838859 10.020982  -9.949023  0.0298931180 -0.0109742342
      [106,]  9.627431  9.173393 10.027915  -9.986484  0.0498597955 -0.0246443385
      [107,]  9.493337  9.324718 10.023216  -9.955654 -0.0498459771  0.0378809836
      [108,] 10.441253  9.196148 10.011228  -9.984810  0.0469167612  0.0043263618
      [109,] 10.011938  9.115003 10.006101  -9.985047  0.0229818524 -0.0021737599
      [110,] 10.262497  9.155706 10.007125 -10.035894 -0.0283170298 -0.0116372551
      [111,] 10.525411  9.181060 10.039304 -10.003281  0.0256745207  0.0063890605
      [112,] 10.585315  9.274049  9.981580  -9.962834  0.0342376382 -0.0234760207
      [113,] 11.080653  9.907183 10.019665  -9.996683  0.0452259197  0.0165029785
      [114,] 10.984422  9.674176 10.011535 -10.022806 -0.0384821494  0.0244400954
      [115,] 10.011334  9.102327  9.976461 -10.038276  0.0076103407  0.0377864259
      [116,] 10.170663  9.087408 10.074552  -9.977667 -0.0369772738  0.0125167999
      [117,] 10.782714  9.397644 10.005421  -9.946895  0.0314044803 -0.0288294572
      [118,] 10.498366  9.174558  9.972524  -9.976390 -0.0197319452 -0.0005588992
      [119,]  9.289118  9.434398 10.038639  -9.999365  0.0414765459  0.0396701198
      [120,]  9.399318  9.363899  9.988520  -9.989635  0.0477895960 -0.0355235342
      [121,] 10.038788  9.064122 10.024991  -9.978597  0.0459068536  0.0488566168
      [122,]  9.483345  9.359547  9.985472  -9.961264  0.0185632379  0.0306863854
      [123,] 10.414914  9.133970 10.001007 -10.011212  0.0345583691  0.0332294965
      [124,] 11.148569 10.016846 10.002034  -9.975304 -0.0376880390 -0.0159922303
      [125,] 10.118573  9.118713  9.995178 -10.049747  0.0183102126 -0.0063363806
      [126,]  9.432266  9.358995 10.031133 -10.035017  0.0464615169  0.0221094545
      [127,] 10.463208  9.155364 10.044687 -10.041609  0.0308249471  0.0319584466
      [128,] 11.061281  9.998054 10.031684 -10.024851 -0.0477240694  0.0147328255
      [129,] 10.802449  9.439852  9.970447  -9.960721  0.0427803583  0.0046867761
      [130,] 10.048991  9.107082  9.979727  -9.992654 -0.0302785476  0.0456596915
      [131,]  9.991024  9.131320 10.020960  -9.958871 -0.0466766430 -0.0280311702
      [132,] 11.006269  9.696163 10.068394 -10.009200  0.0421236453 -0.0445009897
      [133,] 10.698786  9.285976 10.020039 -10.039243 -0.0232422486  0.0285561670
      [134,] 11.028356  9.820356  9.951393  -9.949386 -0.0065203519 -0.0174528039
      [135,] 10.135775  9.111744  9.964763  -9.987617  0.0272725250  0.0265721347
      [136,] 11.127411 10.125819  9.993645 -10.029399 -0.0246959622 -0.0404213407
      [137,] 10.070460  9.108681 10.013981 -10.107048 -0.0273174587  0.0240711657
      [138,] 10.980486  9.566724  9.953982  -9.971853 -0.0295885132 -0.0382431513
      [139,]  9.605081  9.194972  9.965733 -10.041871 -0.0476735735  0.0272634924
      [140,] 11.049155  9.713030  9.964919  -9.975707  0.0172092482 -0.0391933819
      [141,]  9.489593  9.357995 10.056343 -10.020443 -0.0248672731 -0.0333356429
      [142,] 10.923166  9.501641  9.993361 -10.029152  0.0302728377  0.0203458758
      [143,] 11.011285  9.664909 10.023583  -9.974185 -0.0442896850  0.0317576088
      [144,] 10.322113  9.140346  9.972228  -9.964868  0.0436296382  0.0168068055
      [145,] 10.594098  9.181206  9.997335  -9.999999 -0.0290978932 -0.0495184334
      [146,] 10.532841  9.230137  9.967481 -10.013918 -0.0489810087 -0.0340103626
      [147,] 11.077785  9.807521 10.069314 -10.003121  0.0472368702  0.0495090221
      [148,] 10.172354  9.114083 10.021986 -10.055487 -0.0007372304 -0.0067927132
      [149,] 10.046721  9.110003  9.994176 -10.019181 -0.0162147226  0.0454822187
      [150,] 10.199288  9.093953  9.955719  -9.981107 -0.0069884475  0.0455490139
      [151,] 10.079114  9.096091 10.020899  -9.989359  0.0126957817  0.0234323308
      [152,]  9.379045  9.391511 10.047626  -9.990695  0.0207508626  0.0180964782
      [153,] 10.325932  9.125863 10.023880 -10.003089 -0.0396806562 -0.0238754119
      [154,] 11.004353  9.671373 10.006193  -9.999226  0.0114937411  0.0267226202
      [155,] 10.255533  9.119038 10.000756  -9.982316 -0.0252508688  0.0157516812
      [156,]  9.455854  9.386854  9.990999  -9.971106 -0.0396966532 -0.0092611417
      [157,] 10.996065  9.672232  9.921428 -10.003629  0.0247620318 -0.0371690986
      [158,]  9.487462  9.312268  9.991813  -9.963161  0.0230056412 -0.0215685857
      [159,]  9.482898  9.372443 10.032308  -9.978911  0.0455540400  0.0057153021
      [160,]  9.289296  9.490528  9.942780  -9.969236  0.0089315842 -0.0181335367
      [161,] 10.605140  9.278118  9.935194  -9.989315 -0.0397695648  0.0008270615
      [162,] 11.029407  9.752599 10.009523 -10.042476 -0.0485527028  0.0221203280
      [163,] 10.992302  9.583570 10.014170 -10.044069 -0.0212572423  0.0089697792
      [164,] 10.973819  9.747985 10.021292 -10.009220  0.0015459983  0.0184873088
      [165,] 10.097982  9.114450 10.015951 -10.029068 -0.0273074393 -0.0044518304
      [166,] 10.080127  9.127443 10.007437 -10.043778 -0.0243289019  0.0134616330
      [167,]  9.794101  9.175955 10.042452  -9.985424  0.0302957357  0.0081428607
      [168,]  9.468853  9.403992 10.007169 -10.006898  0.0434862528 -0.0216416175
      [169,] 10.131935  9.148854 10.050682  -9.999507  0.0417276127 -0.0189556189
      [170,] 11.122825  9.984283 10.033224  -9.984370  0.0214424367  0.0378057358
      [171,] 10.748571  9.372424  9.984997  -9.984809  0.0167204565 -0.0480461512
      [172,]  9.848113  9.099409  9.977311 -10.017681  0.0073230340  0.0381279632
      [173,] 10.642629  9.226774 10.042336  -9.974914 -0.0107139109 -0.0199171046
      [174,]  9.747859  9.146370 10.031923  -9.993548  0.0348785687 -0.0040971001
      [175,]  9.593692  9.275781  9.962566 -10.010588 -0.0377071361 -0.0473993108
      [176,]  9.439201  9.325445 10.012270 -10.035304 -0.0191097278  0.0378264694
      [177,]  9.930797  9.104614 10.003909 -10.024331  0.0092591256 -0.0374183131
      [178,] 11.103206  9.879742 10.016079  -9.996581 -0.0352319249  0.0149352954
      [179,] 10.926166  9.642948 10.020474 -10.025015  0.0361107086  0.0301842002
      [180,] 10.936665  9.599446  9.986618 -10.032583 -0.0016365814  0.0050910465
      [181,] 10.908548  9.451989  9.971928 -10.014340  0.0357929136 -0.0404882460
      [182,] 11.039254  9.861597 10.030233 -10.075129 -0.0036173277  0.0163872222
      [183,] 11.081262  9.871556 10.036240  -9.948309 -0.0490100167  0.0213582122
      [184,]  9.798616  9.149656 10.029517 -10.017514 -0.0381735008  0.0239104756
      [185,]  9.313883  9.490210  9.991794 -10.013504  0.0065597456  0.0466961040
      [186,]  9.553610  9.287028  9.954971 -10.001978  0.0234647081 -0.0147770010
      [187,]  9.480020  9.351355 10.005358 -10.054593 -0.0341191301  0.0047623601
      [188,] 10.998668  9.648488  9.986870 -10.028688 -0.0264865382 -0.0361832076
      [189,] 11.029639  9.827180  9.959904 -10.017878 -0.0159871888  0.0057247489
      [190,] 10.076911  9.093042 10.019008 -10.010693 -0.0231319534  0.0192149301
      [191,]  9.674642  9.247177 10.017605 -10.005307  0.0280873668  0.0485318382
      [192,] 10.301537  9.107931  9.966789 -10.010585 -0.0180703882  0.0211568187
      [193,] 10.512589  9.218673  9.986114  -9.969119  0.0064256240  0.0256750039
      [194,] 10.467156  9.157356  9.955723  -9.989477 -0.0111786412 -0.0415075377
      [195,]  9.569705  9.275977 10.003380 -10.026161  0.0463510622 -0.0014992020
      [196,] 10.994564  9.683477 10.027007  -9.998701 -0.0089371387 -0.0440246237
      [197,] 10.081201  9.095362  9.949183  -9.962427 -0.0275398864 -0.0115535300
      [198,] 10.755563  9.333951 10.014798  -9.964294  0.0408656812  0.0094685840
      [199,]  9.746047  9.124325 10.011041 -10.026064 -0.0472839592 -0.0308369652
      [200,] 11.074289  9.785436  9.993293  -9.997223 -0.0195624441 -0.0372050841
      [201,]  9.487287 10.008871  9.378034  -9.960561  0.0244766761  0.0447508821
      [202,] 10.230064  9.958092  9.082994 -10.071916 -0.0053734576 -0.0019355883
      [203,] 10.891787 10.034155  9.494202 -10.011129  0.0094885572  0.0356580262
      [204,] 10.758974  9.984920  9.312908 -10.027635 -0.0343428181 -0.0070626808
      [205,] 11.089502 10.039119  9.837907  -9.985690 -0.0009376471 -0.0326783209
      [206,]  9.627707  9.974938  9.220849  -9.968920  0.0360802436  0.0033434652
      [207,]  9.422106 10.001839  9.325618 -10.001025 -0.0446025453  0.0374764030
      [208,] 10.491247  9.945107  9.182311  -9.956827 -0.0450157726 -0.0002425560
      [209,] 10.003464 10.047870  9.120513  -9.999144  0.0139321176 -0.0121341058
      [210,] 10.324483 10.024972  9.101104 -10.040526 -0.0203976764 -0.0021605209
      [211,] 10.609805 10.010124  9.176960 -10.074171  0.0126082447 -0.0041230764
      [212,] 10.675975  9.972089  9.247169  -9.956029 -0.0461121622  0.0020533215
      [213,] 11.090772  9.968498  9.950202 -10.036488 -0.0479281968  0.0128588187
      [214,] 11.052794 10.033847  9.673325 -10.008176 -0.0157145554  0.0262427827
      [215,] 10.021890 10.041179  9.051162  -9.976099  0.0302659268 -0.0180606284
      [216,] 10.216172  9.940656  9.087794 -10.046444 -0.0080713003  0.0332408979
      [217,] 10.780353 10.025658  9.436862  -9.959604 -0.0267913693 -0.0313106603
      [218,] 10.516048  9.983317  9.136964 -10.008437 -0.0166274108 -0.0252807128
      [219,]  9.297879 10.024452  9.472945  -9.952020 -0.0249728224  0.0340357163
      [220,]  9.448502  9.988939  9.402847  -9.995120  0.0171969758  0.0148256515
      [221,] 10.081175  9.980452  9.064985  -9.995876 -0.0482995042  0.0289218798
      [222,]  9.493161  9.986200  9.288150 -10.026381  0.0352094295  0.0404034142
      [223,] 10.402755 10.033706  9.236264  -9.982955 -0.0213022456  0.0341126797
      [224,] 11.042501  9.993344 10.050183 -10.010126  0.0138682634 -0.0481067907
      [225,] 10.149463 10.001203  9.067774  -9.987115 -0.0390272422  0.0381767643
      [226,]  9.410432 10.035305  9.344945  -9.991285 -0.0040549630  0.0024647791
      [227,] 10.458567  9.996986  9.153028 -10.067113  0.0291478295  0.0486691287
      [228,] 11.125171  9.984004  9.957267 -10.031833  0.0347272362 -0.0447890904
      [229,] 10.806232 10.059590  9.436459 -10.025456  0.0288602716  0.0434614059
      [230,] 10.015616 10.020780  9.080013  -9.915122  0.0499461943 -0.0476655861
      [231,] 10.070191 10.024223  9.078529 -10.013222 -0.0350972506 -0.0323759506
      [232,] 11.011515  9.982282  9.682695  -9.979387 -0.0355795055  0.0481960721
      [233,] 10.702100 10.056007  9.293773 -10.020650 -0.0105960785 -0.0357497556
      [234,] 11.090838 10.052365  9.865098  -9.979519 -0.0230840914  0.0240873739
      [235,] 10.176898 10.023626  9.082503 -10.016194 -0.0054424388 -0.0411740734
      [236,] 11.120389  9.966539 10.012270 -10.031121 -0.0021116634 -0.0131928147
      [237,] 10.016870 10.002797  9.117286  -9.986292 -0.0225366552  0.0206003706
      [238,] 10.973441  9.982106  9.565371 -10.061723  0.0042736926 -0.0163254672
      [239,]  9.635741  9.951045  9.249382 -10.055526 -0.0374822610  0.0344169003
      [240,] 11.050102 10.033937  9.765154  -9.976375 -0.0120773189 -0.0145707705
      [241,]  9.425184  9.982574  9.314720  -9.969866  0.0426886674  0.0439335123
      [242,] 10.892105 10.027329  9.507860 -10.036110  0.0442100232  0.0236824496
      [243,] 11.008318 10.006622  9.694529 -10.037252  0.0103077525 -0.0443057064
      [244,] 10.283590  9.999044  9.128662  -9.999173  0.0337946883 -0.0352155169
      [245,] 10.553760 10.054931  9.221713  -9.970739  0.0362450532 -0.0451604840
      [246,] 10.537070 10.061946  9.202908 -10.000673 -0.0133359334 -0.0368181931
      [247,] 11.061083  9.987963  9.827735 -10.030847  0.0016571980 -0.0361767955
      [248,] 10.209033  9.983732  9.095877  -9.993084  0.0002469047 -0.0178727972
      [249,] 10.100212  9.961450  9.096425 -10.045252  0.0337113976 -0.0117487694
      [250,] 10.188340  9.987350  9.117031  -9.978269  0.0014563282 -0.0074288770
      [251,] 10.069294 10.016716  9.066977 -10.012674  0.0437713026 -0.0050437279
      [252,]  9.406576 10.008452  9.411347 -10.010283  0.0358254800 -0.0235458253
      [253,] 10.291634 10.022906  9.081687 -10.051488  0.0154345437 -0.0460284576
      [254,] 11.014069 10.025412  9.655811 -10.030523  0.0496529681 -0.0331662704
      [255,] 10.246029 10.048564  9.153723  -9.992091 -0.0480151394 -0.0413235605
      [256,]  9.413004  9.966803  9.326153 -10.039732  0.0492496840 -0.0337843216
      [257,] 10.935914  9.972590  9.622042 -10.024933  0.0280839966  0.0457194595
      [258,]  9.473776  9.992642  9.301262  -9.980856 -0.0376185214  0.0396562419
      [259,]  9.443157 10.015697  9.282762  -9.990349 -0.0311636561  0.0432316922
      [260,]  9.298950  9.998341  9.522691 -10.021916  0.0383112867  0.0213184044
      [261,] 10.592288 10.058550  9.197410 -10.016947  0.0320685174 -0.0185876067
      [262,] 11.049973 10.024307  9.788968  -9.979016 -0.0393998234 -0.0168925647
      [263,] 11.032722 10.059037  9.617859  -9.996239  0.0292636265 -0.0344679947
      [264,] 11.014840  9.991418  9.749718 -10.021943  0.0472320024  0.0443521362
      [265,] 10.076511  9.957552  9.117719  -9.938494 -0.0267783721 -0.0127077339
      [266,] 10.081250  9.984478  9.091032  -9.993926  0.0090592828 -0.0316858062
      [267,]  9.727450 10.027498  9.164879  -9.980755 -0.0137783547 -0.0496898152
      [268,]  9.371864  9.968516  9.330677 -10.017160  0.0103359589 -0.0383714422
      [269,] 10.162215  9.966427  9.126372  -9.982554  0.0452758347  0.0179363494
      [270,] 11.132335 10.011177  9.910339  -9.939150  0.0116192605  0.0145006229
      [271,] 10.765690  9.960297  9.343242 -10.008690  0.0384730642 -0.0100292620
      [272,]  9.882590 10.000379  9.193514  -9.982597  0.0258117034 -0.0087647789
      [273,] 10.660827  9.987492  9.205300 -10.016650  0.0096875740  0.0232130204
      [274,]  9.778495 10.036532  9.191573 -10.054095  0.0423080660  0.0482281497
      [275,]  9.577381 10.009489  9.226541 -10.042525  0.0312945098  0.0177722458
      [276,]  9.458547  9.976057  9.309614 -10.042156 -0.0122278057  0.0484181462
      [277,]  9.891983 10.022222  9.093466 -10.021722 -0.0231889707  0.0018852996
      [278,] 11.088916  9.975434  9.815830 -10.060459  0.0071398405 -0.0484040677
      [279,] 10.994333  9.996522  9.620782  -9.997737  0.0384482094  0.0219025641
      [280,] 11.014313  9.946321  9.567568  -9.921346  0.0338895001 -0.0448206488
      [281,] 10.854611 10.012094  9.476855 -10.001275 -0.0271819704  0.0019625368
      [282,] 11.060737 10.026245  9.858181 -10.010303 -0.0273003266 -0.0221990925
      [283,] 11.057904  9.983653  9.855521  -9.981220  0.0391067472  0.0161041779
      [284,]  9.773934 10.000731  9.131272  -9.990570 -0.0181239964 -0.0482553899
      [285,]  9.332641 10.035279  9.457149 -10.002227 -0.0375134063  0.0384755546
      [286,]  9.544060  9.986004  9.257122  -9.986594  0.0393063551  0.0364846878
      [287,]  9.430835 10.016152  9.354136  -9.956314 -0.0206675111  0.0405275994
      [288,] 10.963539 10.031108  9.682288 -10.028333  0.0401219919  0.0104522991
      [289,] 11.054170 10.040200  9.870164 -10.001769  0.0308955889  0.0318824909
      [290,] 10.081042  9.989653  9.111618  -9.971210 -0.0336780538 -0.0452825597
      [291,]  9.672054  9.976290  9.170532 -10.006518  0.0369213085  0.0412930056
      [292,] 10.332864  9.957095  9.158432  -9.967836 -0.0286272308 -0.0029700580
      [293,] 10.572682 10.051964  9.224061  -9.984955  0.0281960141 -0.0296049030
      [294,] 10.506273 10.019280  9.166660  -9.998632 -0.0234851779 -0.0346257976
      [295,]  9.539593 10.015288  9.280202  -9.968713 -0.0184172086 -0.0298931300
      [296,] 10.984801 10.024778  9.650354 -10.050790  0.0233295335 -0.0280175163
      [297,] 10.068621 10.009456  9.135839 -10.026580 -0.0229673963  0.0488728838
      [298,] 10.742307 10.029013  9.326672  -9.995743  0.0069681013 -0.0385496345
      [299,]  9.782302  9.996382  9.126397  -9.997472  0.0227114360 -0.0237733764
      [300,] 11.097148  9.981619  9.826405 -10.020766  0.0122387226  0.0215514072
      [301,]  9.429434 10.039234 10.880584 -10.038154  0.0454699713  0.0379760035
      [302,] 10.228776  9.984819 11.053287 -10.008829  0.0278107758  0.0361577343
      [303,] 10.857955 10.044426 10.723530 -10.019149 -0.0182650794 -0.0093108524
      [304,] 10.697560 10.041709 10.804257  -9.996711 -0.0233770639 -0.0295295400
      [305,] 11.029969  9.969272 10.329162 -10.020224  0.0419600051 -0.0145944843
      [306,]  9.611429 10.021062 10.974944 -10.008310 -0.0358260987  0.0369442605
      [307,]  9.421629  9.990535 10.848620  -9.927928 -0.0434728231 -0.0233984392
      [308,] 10.517625  9.991149 10.985646  -9.986450 -0.0339682872  0.0203286116
      [309,] 10.002159 10.004870 11.043275 -10.043616 -0.0223456543  0.0193158545
      [310,] 10.268101  9.997314 11.109575 -10.019323  0.0480838691 -0.0166681225
      [311,] 10.557441  9.971518 10.943360  -9.947985  0.0186019200 -0.0042781141
      [312,] 10.681100  9.961567 10.931640  -9.975380 -0.0021891248 -0.0069307584
      [313,] 11.028993  9.973723 10.245036  -9.959937  0.0286534895 -0.0050247361
      [314,] 11.039398  9.957122 10.543276  -9.969063 -0.0426012113 -0.0328895615
      [315,] 10.088088  9.997968 11.110964 -10.032485 -0.0472591315 -0.0214719620
      [316,] 10.168066 10.031369 11.141693 -10.031308  0.0446095075 -0.0154110126
      [317,] 10.780413 10.022020 10.809509  -9.999418  0.0118993945 -0.0273178134
      [318,] 10.487468 10.014249 11.011130  -9.977671 -0.0346750762  0.0389716067
      [319,]  9.293187  9.977258 10.670429  -9.976297  0.0011571342 -0.0264587402
      [320,]  9.463401 10.000668 10.822939  -9.947148 -0.0375055467  0.0260141017
      [321,] 10.061450  9.973783 11.115812 -10.009586  0.0110466035 -0.0454146732
      [322,]  9.510958  9.945495 10.905561 -10.013147  0.0422951483 -0.0343617160
      [323,] 10.412517 10.018126 11.046108 -10.028312  0.0259430340 -0.0393893886
      [324,] 11.124286  9.972824 10.193287 -10.007443  0.0175417706 -0.0062888798
      [325,] 10.141817 10.011810 11.051572  -9.990580  0.0360627378 -0.0026580849
      [326,]  9.451854 10.018965 10.894393  -9.973127  0.0216988620 -0.0232452503
      [327,] 10.470234 10.037796 11.019746 -10.019812  0.0097494817  0.0472530056
      [328,] 11.070594  9.951700 10.250530  -9.970028 -0.0250557348  0.0491323636
      [329,] 10.822772  9.999581 10.793400 -10.044263  0.0488264570  0.0457078692
      [330,] 10.036355  9.998752 11.140219 -10.003055 -0.0385003785 -0.0339180249
      [331,] 10.018755  9.972515 11.072261 -10.023445 -0.0086049601  0.0134880540
      [332,] 11.034682 10.019705 10.469880  -9.984786 -0.0039979489  0.0298509193
      [333,] 10.664920  9.955964 10.896940 -10.067637 -0.0305361871  0.0023079393
      [334,] 11.112410 10.036897 10.354077  -9.991712  0.0103045935 -0.0027118025
      [335,] 10.140055 10.043621 11.109231  -9.986768  0.0111885274  0.0114181349
      [336,] 11.080180  9.984486 10.122819  -9.990977  0.0194391182 -0.0177017732
      [337,]  9.993421 10.032031 11.108565  -9.987159 -0.0177664547  0.0413969031
      [338,] 10.940932  9.987442 10.588222  -9.996822 -0.0047821336  0.0051335554
      [339,]  9.599382  9.976343 10.939961 -10.025138  0.0263023578  0.0336220825
      [340,] 11.012033  9.981767 10.449557 -10.002462 -0.0457994790  0.0478982451
      [341,]  9.390572 10.014758 10.851141 -10.012416 -0.0286195565  0.0117290431
      [342,] 10.915345  9.984311 10.754777 -10.003413  0.0448301831 -0.0013139883
      [343,] 11.011087  9.971036 10.476185 -10.001424 -0.0297265657  0.0227216205
      [344,] 10.349084  9.978703 11.093640 -10.014314  0.0228803106 -0.0087150672
      [345,] 10.525112  9.981013 10.972886  -9.983500  0.0464948675 -0.0296174343
      [346,] 10.516327 10.005618 11.015348 -10.019975 -0.0321041915 -0.0140012085
      [347,] 11.113737 10.017443 10.326289 -10.010750 -0.0283149217  0.0439492659
      [348,] 10.140628 10.043685 11.067530  -9.974914  0.0273754125 -0.0338465700
      [349,] 10.101945  9.963856 11.095038 -10.055476 -0.0133892791 -0.0264507694
      [350,] 10.211987 10.010161 11.066399  -9.975796  0.0299700973 -0.0474960129
      [351,] 10.044850  9.991848 11.144860 -10.032400 -0.0103543116  0.0160985956
      [352,]  9.360215 10.030901 10.827235  -9.999414  0.0036961856 -0.0133054836
      [353,] 10.293291  9.964218 11.126889  -9.999730 -0.0319266365  0.0264024789
      [354,] 10.973459 10.063028 10.576597 -10.005739 -0.0361515193 -0.0086709876
      [355,] 10.302367 10.030806 11.101790 -10.057261 -0.0403837138 -0.0254857665
      [356,]  9.418684 10.014703 10.888188  -9.980358 -0.0319668279 -0.0301387348
      [357,] 10.974184 10.044375 10.586979  -9.983850 -0.0424192730 -0.0046650829
      [358,]  9.537438 10.018509 10.890850 -10.047127  0.0052324366 -0.0447167940
      [359,]  9.533580 10.017131 10.837228  -9.952011 -0.0391176392 -0.0213253971
      [360,]  9.292257 10.005318 10.690033 -10.011445  0.0308104230 -0.0069320709
      [361,] 10.561467  9.983558 10.936916 -10.006381  0.0113062888 -0.0295811104
      [362,] 11.083069  9.985944 10.438554  -9.952838 -0.0317451806  0.0009706396
      [363,] 10.982140  9.980190 10.559217 -10.032117  0.0381190123 -0.0400468783
      [364,] 11.027662 10.050959 10.512270 -10.015016  0.0372705338  0.0182469598
      [365,] 10.081709  9.960745 11.153540  -9.947127  0.0122616475 -0.0121749337
      [366,] 10.090986  9.979219 11.122264 -10.016119  0.0117000077  0.0141001274
      [367,]  9.793986  9.949120 11.041944 -10.003563  0.0278764592 -0.0292279188
      [368,]  9.374554  9.988136 10.814707 -10.027025 -0.0147691548  0.0033596433
      [369,] 10.138633 10.001105 11.137840  -9.994869 -0.0051004100 -0.0280103731
      [370,] 11.126544 10.011289 10.306195  -9.985383 -0.0126961445  0.0045063278
      [371,] 10.775693  9.989621 10.834020  -9.978110  0.0207732450 -0.0134750763
      [372,]  9.877094 10.043277 11.112203  -9.960084  0.0200881377  0.0406903448
      [373,] 10.639218  9.940542 10.995212 -10.009821  0.0090530590 -0.0209627424
      [374,]  9.815055 10.043417 11.074819 -10.033515 -0.0427385204 -0.0116895677
      [375,]  9.530838 10.018426 10.925549 -10.008698 -0.0231872070  0.0103836846
      [376,]  9.483411  9.993854 10.854032  -9.982140  0.0338549325 -0.0188758440
      [377,]  9.914938 10.012121 11.078777 -10.010755  0.0103117034 -0.0189502850
      [378,] 11.063529  9.974790 10.402938  -9.984408  0.0382265334  0.0176795577
      [379,] 10.926886  9.942181 10.574723 -10.003298 -0.0039828484 -0.0139887957
      [380,] 10.966376  9.959212 10.600851 -10.048206  0.0261988359 -0.0215361432
      [381,] 10.897352 10.017230 10.725156 -10.011080 -0.0054243475  0.0042168261
      [382,] 11.063235 10.028052 10.402861  -9.947733 -0.0360136640 -0.0388852667
      [383,] 11.051737  9.969755 10.361049  -9.983865 -0.0250549288 -0.0056271989
      [384,]  9.806330 10.016000 11.039480 -10.026639 -0.0465260323 -0.0469597559
      [385,]  9.337772 10.021352 10.729422 -10.005148  0.0358493101  0.0423056992
      [386,]  9.540034  9.988355 10.913526 -10.043503 -0.0357465198  0.0390516727
      [387,]  9.468498 10.016671 10.845628 -10.017665 -0.0167808782 -0.0286652839
      [388,] 10.961952  9.989004 10.535890  -9.994907  0.0223033675  0.0154136852
      [389,] 11.065120  9.948017 10.322689 -10.020097 -0.0035612491  0.0443061021
      [390,] 10.058311  9.991254 11.115330 -10.055597 -0.0159403007 -0.0053298225
      [391,]  9.751443  9.998182 11.037604  -9.981624 -0.0213623951 -0.0102889067
      [392,] 10.337085  9.977575 11.034493  -9.963651  0.0496237982 -0.0245657971
      [393,] 10.570505  9.973737 10.971596 -10.075946  0.0491231042 -0.0173880970
      [394,] 10.496049 10.016248 11.039081  -9.978393 -0.0030399055  0.0200900385
      [395,]  9.475652 10.060368 10.893228 -10.022556  0.0323651782  0.0194947439
      [396,] 10.988925 10.025772 10.569055  -9.985410  0.0181941361  0.0130977940
      [397,] 10.045246 10.037126 11.110207  -9.981932 -0.0470080843 -0.0480340153
      [398,] 10.712520 10.017199 10.831899 -10.031847 -0.0193337502  0.0022504559
      [399,]  9.759807 10.033352 11.029290  -9.972512 -0.0229093032  0.0488592336
      [400,] 11.097237 10.012626 10.400526 -10.011779  0.0283505697  0.0378799118

---

    Code
      nonlinear_connect(n = 400, num_noise = 0)
    Output
                  [,1]      [,2]      [,3]       [,4]
        [1,]  9.765728 10.923346 10.002187 -10.047067
        [2,] 10.047467 11.001032  9.980725  -9.965872
        [3,] 10.099176 10.977022  9.991845 -10.009669
        [4,] 10.967622 10.399277 10.023428  -9.996511
        [5,] 10.610557 10.760335 10.007136  -9.982167
        [6,]  9.561395 10.898554  9.978081 -10.015145
        [7,]  9.278665 10.736796  9.985188 -10.019155
        [8,] 10.299834 10.960815  9.994460 -10.060343
        [9,]  9.506483 10.810973 10.011989  -9.944942
       [10,] 10.874891 10.485905  9.998938  -9.997018
       [11,] 10.027401 11.041307 10.000103 -10.003174
       [12,] 10.186269 10.950490 10.008462 -10.043828
       [13,] 10.815169 10.592480 10.050926  -9.995281
       [14,]  9.498678 10.857684  9.972135  -9.958898
       [15,] 10.947597 10.302599 10.023480 -10.019243
       [16,] 10.317790 10.918483 10.003754 -10.008163
       [17,]  9.279450 10.679951 10.011050 -10.015777
       [18,] 10.716109 10.682111  9.992666 -10.057627
       [19,] 10.727323 10.740346  9.978810 -10.006511
       [20,] 10.950718 10.225972 10.043076  -9.974957
       [21,]  9.881774 10.966771  9.977235 -10.075722
       [22,] 10.748560 10.636897 10.014250 -10.004242
       [23,]  9.994076 10.997907  9.949005 -10.023035
       [24,] 10.005700 10.969311 10.043753  -9.967751
       [25,] 10.732739 10.647303 10.038195  -9.985483
       [26,]  9.782938 10.979832  9.992838 -10.033136
       [27,] 10.116089 10.980010 10.047728 -10.062599
       [28,]  9.686145 10.941633 10.017856 -10.002755
       [29,] 10.631838 10.712215 10.044078  -9.998902
       [30,] 10.553875 10.794696 10.026629 -10.006412
       [31,] 10.934632 10.145719 10.042692 -10.017808
       [32,] 10.299418 10.969260 10.016148 -10.071599
       [33,] 10.493148 10.866456 10.009874  -9.991519
       [34,] 10.367510 10.930496 10.010256 -10.014140
       [35,]  9.377644 10.773126  9.961670  -9.975686
       [36,] 10.947704 10.144324 10.008397  -9.966839
       [37,] 10.826652 10.459856 10.035980  -9.999561
       [38,] 10.529072 10.829469  9.999423 -10.000318
       [39,] 10.424065 10.889912  9.929144  -9.978557
       [40,]  9.816012 10.955687 10.062561 -10.013004
       [41,] 10.785699 10.571478 10.014720  -9.988419
       [42,]  9.855140 11.022266  9.999638  -9.958512
       [43,]  9.430981 10.860910 10.030976  -9.965457
       [44,]  9.589679 10.934022 10.045173  -9.950938
       [45,] 10.032174 11.005012 10.008132  -9.987102
       [46,]  9.638246 10.911962  9.985155  -9.985417
       [47,] 10.666461 10.795944 10.034159 -10.022803
       [48,] 10.760090 10.643650 10.016126  -9.962288
       [49,]  9.272024 10.686197 10.008423  -9.973828
       [50,] 11.033198 10.185667  9.973198 -10.005117
       [51,] 10.880230 10.461046 10.021464 -10.065365
       [52,] 10.854557 10.602041 10.002895 -10.025027
       [53,] 10.852579 10.495566 10.051455 -10.021597
       [54,] 10.531434 10.825967 10.023919 -10.007170
       [55,] 10.889129 10.383407  9.991630  -9.979373
       [56,]  9.390259 10.804168 10.031878 -10.020798
       [57,] 10.634349 10.773454 10.017573 -10.030721
       [58,] 10.393525 10.909935  9.965590  -9.978198
       [59,] 10.637161 10.808344  9.968196 -10.036495
       [60,] 10.964731 10.419425  9.982848 -10.082066
       [61,] 10.755471 10.707043 10.048023 -10.025402
       [62,] 10.733542 10.726464  9.940670  -9.999250
       [63,]  9.924232 10.967800 10.014873  -9.950829
       [64,]  9.518348 10.825352 10.009638  -9.979285
       [65,] 10.474937 10.873519  9.953633 -10.008712
       [66,] 10.158201 10.973985  9.994065  -9.977504
       [67,]  9.171782 10.652833  9.992928  -9.978648
       [68,] 10.850470 10.587783  9.959055 -10.073014
       [69,] 10.516835 10.870246 10.032537 -10.020760
       [70,] 10.072985 10.975001 10.028077  -9.990989
       [71,] 11.012476 10.139883  9.974686  -9.990156
       [72,]  9.584214 10.866234  9.975630  -9.989860
       [73,]  9.795257 10.979596  9.996796 -10.055292
       [74,]  9.825899 10.984242  9.974297 -10.035135
       [75,] 10.998859 10.216548 10.010679 -10.000022
       [76,] 10.675702 10.710017  9.988217  -9.972658
       [77,] 10.082881 10.966584  9.979675  -9.985570
       [78,]  9.165261 10.576604  9.995820 -10.058475
       [79,]  9.524135 10.807680 10.037468 -10.010181
       [80,]  9.435709 10.819288  9.999859  -9.984746
       [81,]  9.460148 10.839854  9.958172 -10.043744
       [82,]  9.303821 10.667318  9.987832 -10.020974
       [83,] 10.952882 10.241997 10.010483  -9.993103
       [84,] 10.163447 10.962140  9.999576  -9.991703
       [85,]  9.747875 11.049398  9.992145 -10.015817
       [86,] 10.739996 10.661135 10.031292  -9.943213
       [87,] 10.973527 10.395707 10.049818  -9.979011
       [88,] 10.905657 10.383273  9.996146 -10.023170
       [89,] 10.363397 10.982234 10.019000 -10.060690
       [90,]  9.511409 10.817719 10.035728  -9.979683
       [91,] 10.617778 10.806590 10.044494  -9.997070
       [92,]  9.868330 11.050389 10.001884  -9.993444
       [93,]  9.954673 10.993666  9.950384  -9.985619
       [94,] 10.870027 10.430184  9.949801 -10.031025
       [95,] 10.954769 10.369839 10.017928 -10.011594
       [96,] 10.483658 10.949401  9.949431  -9.955004
       [97,]  9.933045 11.003893  9.965176 -10.019047
       [98,]  9.683391 10.944775 10.053968  -9.969060
       [99,]  9.484140 10.878577 10.036504 -10.005049
      [100,]  9.289375 10.644392  9.986870  -9.976240
      [101,]  9.853941  9.188268 10.005819  -9.953042
      [102,] 10.149328  9.182346 10.003240  -9.983120
      [103,] 10.182473  9.127511  9.991262 -10.051382
      [104,] 11.097493  9.825699  9.960816  -9.977416
      [105,] 10.721806  9.287005 10.014878  -9.947653
      [106,]  9.741522  9.146382  9.994887 -10.011666
      [107,]  9.381029  9.429095 10.014516  -9.939217
      [108,] 10.424647  9.129924 10.015736  -9.976521
      [109,]  9.544543  9.292916  9.984176  -9.945941
      [110,] 10.998115  9.684317 10.010683  -9.961564
      [111,] 10.115420  9.094282 10.028795 -10.013488
      [112,] 10.293501  9.071468 10.034777 -10.009434
      [113,] 10.919167  9.490828  9.999011 -10.040678
      [114,]  9.625096  9.228597 10.001891  -9.957373
      [115,] 11.058069  9.770758 10.016939 -10.014690
      [116,] 10.500262  9.131707 10.031061  -9.973148
      [117,]  9.394846  9.407736 10.023492  -9.973611
      [118,] 10.870826  9.421911  9.988896  -9.973610
      [119,] 10.810439  9.366888 10.024281 -10.018522
      [120,] 11.063068  9.785844 10.013913 -10.078077
      [121,]  9.916071  9.071873  9.994515 -10.029774
      [122,] 10.866204  9.438701  9.968060 -10.007484
      [123,]  9.991935  9.116550 10.027274  -9.967192
      [124,] 10.149565  9.106862  9.944189  -9.947342
      [125,] 10.802394  9.444104 10.021555  -9.945950
      [126,]  9.913373  9.151266  9.997329 -10.013266
      [127,] 10.192099  9.121212 10.073655  -9.992169
      [128,]  9.769734  9.132742 10.043351 -10.004035
      [129,] 10.732723  9.345078 10.023870  -9.976710
      [130,] 10.610528  9.257829 10.018300  -9.975007
      [131,] 11.097370  9.900567  9.981154  -9.953037
      [132,] 10.321912  9.190163  9.978126  -9.961474
      [133,] 10.628517  9.209301  9.997258 -10.044668
      [134,] 10.478981  9.155380 10.072114 -10.052052
      [135,]  9.520647  9.313732 10.026060  -9.975249
      [136,] 11.059030  9.894470  9.955283 -10.009364
      [137,] 10.967141  9.590820  9.987198  -9.975644
      [138,] 10.683751  9.270993  9.973746  -9.985250
      [139,] 10.447738  9.165411 10.030699  -9.982723
      [140,]  9.853053  9.147306  9.935612  -9.995244
      [141,] 10.963234  9.524776 10.033589  -9.994229
      [142,]  9.992659  9.062158 10.005689  -9.941759
      [143,]  9.519398  9.267634 10.019891  -9.998621
      [144,]  9.703780  9.128718 10.006368  -9.998426
      [145,] 10.119914  9.101995 10.030452 -10.002130
      [146,]  9.741438  9.127989 10.022919 -10.003237
      [147,] 10.752673  9.332108  9.974886 -10.004263
      [148,] 10.881257  9.427545  9.982868  -9.944596
      [149,]  9.317451  9.439444 10.018392 -10.043292
      [150,] 11.090355  9.932062 10.037623 -10.001341
      [151,] 10.927390  9.622369 10.004840  -9.957190
      [152,] 10.955045  9.504716 10.003816 -10.036018
      [153,] 10.993346  9.583556 10.040332 -10.006466
      [154,] 10.636922  9.224459 10.001873  -9.998883
      [155,] 11.034057  9.748752 10.006485  -9.994159
      [156,]  9.518557  9.271047  9.990970 -10.020435
      [157,] 10.743268  9.352575 10.043180  -9.997648
      [158,] 10.451387  9.157784 10.018043  -9.989702
      [159,] 10.701524  9.290829 10.007007 -10.028113
      [160,] 10.985940  9.677307 10.058251 -10.024093
      [161,] 10.824088  9.413611 10.039675  -9.979983
      [162,] 10.842299  9.435853  9.990426  -9.959082
      [163,] 10.120642  9.131809  9.981985 -10.046244
      [164,]  9.583333  9.258214  9.945805  -9.979375
      [165,] 10.611100  9.149806 10.006042  -9.988048
      [166,] 10.243233  9.171006  9.945301 -10.005298
      [167,]  9.311114  9.478024 10.002359  -9.980334
      [168,] 10.937722  9.557944  9.992334 -10.021588
      [169,] 10.532744  9.200519 10.048525  -9.991445
      [170,] 10.184815  9.086961  9.989555  -9.929502
      [171,] 11.132182  9.986918  9.982317 -10.001999
      [172,]  9.668719  9.163780 10.018899  -9.999169
      [173,]  9.856436  9.147841  9.996112 -10.031375
      [174,]  9.959931  9.124804 10.012003  -9.934223
      [175,] 11.122891  9.878209 10.013100 -10.015163
      [176,] 10.651538  9.289775 10.010252  -9.974427
      [177,] 10.217380  9.135662 10.036627  -9.991520
      [178,]  9.274803  9.454261  9.994470 -10.015749
      [179,]  9.600871  9.251330  9.995518 -10.038946
      [180,]  9.504845  9.238747  9.997344  -9.997291
      [181,]  9.530776  9.289437  9.998834 -10.032101
      [182,]  9.384108  9.345323 10.012918  -9.979318
      [183,] 11.053088  9.872994  9.988283 -10.020674
      [184,] 10.227916  9.136649  9.989474 -10.076812
      [185,]  9.769686  9.115056 10.003529  -9.971004
      [186,] 10.847500  9.448659  9.986948 -10.016626
      [187,] 11.046635  9.708627 10.012518 -10.033798
      [188,] 10.995245  9.688005  9.982845 -10.004241
      [189,] 10.464161  9.215639 10.031910 -10.010212
      [190,]  9.616713  9.219898  9.948105 -10.027418
      [191,] 10.694764  9.363648 10.038005  -9.992018
      [192,]  9.973742  9.137221  9.997026 -10.016853
      [193,] 10.074784  9.088624 10.020563 -10.028331
      [194,] 10.984431  9.688316  9.985236 -10.031156
      [195,] 11.005457  9.760020 10.010188  -9.988388
      [196,] 10.498918  9.184084  9.990940  -9.932911
      [197,] 10.076694  9.129245 10.018871  -9.965644
      [198,]  9.823640  9.099882  9.994027  -9.989845
      [199,]  9.561677  9.263923 10.022961  -9.992810
      [200,]  9.413514  9.397073  9.934509  -9.968678
      [201,]  9.884654 10.035157  9.156500  -9.954825
      [202,] 10.045137  9.997995  9.092325  -9.987742
      [203,] 10.171453  9.970876  9.107877 -10.011496
      [204,] 11.020233 10.029205  9.784930  -9.968723
      [205,] 10.703209 10.014167  9.272198 -10.023871
      [206,]  9.661918 10.033084  9.153153 -10.007982
      [207,]  9.358985  9.998217  9.438559 -10.019358
      [208,] 10.335236  9.981470  9.136412 -10.023218
      [209,]  9.603669  9.962890  9.254332  -9.969319
      [210,] 11.020504  9.958230  9.676121 -10.043191
      [211,] 10.154470 10.051197  9.147586  -9.937829
      [212,] 10.325090 10.061635  9.110398 -10.031564
      [213,] 10.926735  9.985676  9.558633 -10.003933
      [214,]  9.572088  9.952632  9.270097  -9.981523
      [215,] 11.042536 10.009518  9.780828 -10.043473
      [216,] 10.466362  9.972351  9.161104 -10.007758
      [217,]  9.368135  9.959710  9.389933 -10.027369
      [218,] 10.813006  9.999866  9.351277 -10.015687
      [219,] 10.830375  9.970665  9.404989 -10.030347
      [220,] 11.061301  9.973443  9.807740  -9.967053
      [221,]  9.928643 10.073273  9.087367  -9.999290
      [222,] 10.764868  9.987532  9.441644  -9.950091
      [223,] 10.085303  9.989116  9.144708 -10.023644
      [224,] 10.161221 10.009281  9.121333  -9.925020
      [225,] 10.785999  9.962891  9.475076 -10.000178
      [226,]  9.846192  9.955733  9.178794  -9.993974
      [227,] 10.218351  9.940412  9.109740 -10.006329
      [228,]  9.846837 10.009411  9.168737 -10.023993
      [229,] 10.722765 10.019119  9.335632 -10.058536
      [230,] 10.630765 10.043503  9.303245  -9.992204
      [231,] 11.070977  9.981927  9.943803 -10.031509
      [232,] 10.365601  9.973440  9.119177 -10.037378
      [233,] 10.597292 10.018209  9.249967  -9.994615
      [234,] 10.466598 10.007341  9.166003 -10.046969
      [235,]  9.500337 10.038890  9.289667  -9.965998
      [236,] 11.116840 10.050594  9.918351  -9.995471
      [237,] 10.900913  9.969546  9.563622 -10.009763
      [238,] 10.641538 10.037572  9.271670 -10.001180
      [239,] 10.448312 10.022109  9.183587 -10.009647
      [240,]  9.903890 10.018662  9.137298 -10.013889
      [241,] 10.861251  9.968203  9.525676  -9.981515
      [242,]  9.963400 10.022174  9.169273 -10.051988
      [243,]  9.586902 10.009186  9.231471 -10.021500
      [244,]  9.681732  9.985392  9.207128 -10.025273
      [245,] 10.038472 10.029253  9.115855  -9.980425
      [246,]  9.793640  9.989544  9.159464 -10.022891
      [247,] 10.752508 10.056408  9.304321  -9.979673
      [248,] 10.884080  9.962700  9.450998  -9.995642
      [249,]  9.365773  9.985089  9.375798  -9.956202
      [250,] 11.081540  9.979498  9.954202 -10.030848
      [251,] 10.899326 10.030741  9.596162 -10.028146
      [252,] 10.872006  9.966760  9.560338 -10.005193
      [253,] 10.990895 10.002860  9.591948  -9.956339
      [254,] 10.650297  9.995268  9.291906  -9.969726
      [255,] 11.031413  9.975133  9.745808  -9.992594
      [256,]  9.541054  9.942115  9.305491 -10.026063
      [257,] 10.761884 10.008055  9.401757  -9.989763
      [258,] 10.453714  9.998478  9.115539  -9.994870
      [259,] 10.693093 10.019627  9.286884  -9.987466
      [260,] 11.020064 10.005928  9.751996 -10.045586
      [261,] 10.800740  9.989417  9.447214 -10.028244
      [262,] 10.816989  9.986807  9.424702  -9.978082
      [263,] 10.110242 10.026842  9.112039  -9.971970
      [264,]  9.582934  9.934166  9.223367  -9.947025
      [265,] 10.579860  9.940935  9.180773  -9.991187
      [266,] 10.253917 10.034151  9.088251  -9.971709
      [267,]  9.274879  9.962280  9.457649 -10.051148
      [268,] 10.943046 10.071629  9.519314 -10.027094
      [269,] 10.568817 10.053071  9.273877  -9.973573
      [270,] 10.194356  9.978566  9.118297 -10.037812
      [271,] 11.104831  9.997739  9.993505  -9.964751
      [272,]  9.689913  9.999213  9.197205 -10.068830
      [273,]  9.889734 10.009414  9.173723  -9.998448
      [274,]  9.932423 10.012975  9.101283 -10.044511
      [275,] 11.130505 10.000718  9.870965  -9.975071
      [276,] 10.760021  9.994856  9.357780 -10.012759
      [277,] 10.209747 10.020523  9.112213  -9.956851
      [278,]  9.283126  9.976022  9.441380 -10.028408
      [279,]  9.607820 10.017966  9.276772  -9.996772
      [280,]  9.448899  9.999795  9.248813 -10.031368
      [281,]  9.528443  9.981645  9.292121  -9.975785
      [282,]  9.389092 10.001818  9.439523  -9.952642
      [283,] 11.055675  9.976121  9.860921 -10.030116
      [284,] 10.201363  9.997292  9.091090 -10.003687
      [285,]  9.841290 10.016472  9.047631 -10.019543
      [286,] 10.835394  9.995933  9.334098 -10.051601
      [287,] 11.008074 10.008103  9.735133  -9.986923
      [288,] 11.105583 10.008153  9.644849  -9.976377
      [289,] 10.453332 10.009297  9.206016  -9.959791
      [290,]  9.603274 10.018360  9.226262 -10.011565
      [291,] 10.592926  9.960368  9.292163 -10.049632
      [292,]  9.960920  9.996254  9.144821 -10.016494
      [293,] 10.036138  9.987787  9.122332  -9.995932
      [294,] 10.974135 10.001498  9.639547  -9.974757
      [295,] 11.015335 10.004154  9.782123  -9.979747
      [296,] 10.508952  9.966911  9.135461 -10.021380
      [297,] 10.007873 10.024563  9.100247  -9.984347
      [298,]  9.842120 10.036669  9.190001  -9.980263
      [299,]  9.632686 10.015658  9.218457 -10.021617
      [300,]  9.423011 10.039321  9.374640 -10.036236
      [301,]  9.851632 10.011380 11.013145  -9.992041
      [302,] 10.133883 10.044826 11.095180  -9.985948
      [303,] 10.209829 10.043025 11.081466  -9.950871
      [304,] 11.024267 10.039985 10.368916 -10.011007
      [305,] 10.712756  9.982645 10.905088 -10.009141
      [306,]  9.724856  9.944680 11.068069  -9.988251
      [307,]  9.359711  9.989548 10.789295  -9.979357
      [308,] 10.395120  9.998044 11.053066  -9.963253
      [309,]  9.614186 10.040776 10.972100  -9.967467
      [310,] 11.000451 10.013089 10.481203  -9.976114
      [311,] 10.079606 10.041306 11.144060 -10.017122
      [312,] 10.345219  9.962659 11.094136 -10.012081
      [313,] 10.909809  9.995104 10.687063 -10.039605
      [314,]  9.562213 10.056018 10.924518  -9.942871
      [315,] 11.062625 10.060244 10.430667  -9.961813
      [316,] 10.460970  9.985467 11.042485 -10.012478
      [317,]  9.433041  9.988310 10.777294 -10.043814
      [318,] 10.823877  9.971550 10.777284  -9.983470
      [319,] 10.901075  9.999532 10.824586 -10.049437
      [320,] 11.077961 10.043739 10.409190 -10.011815
      [321,]  9.927569 10.035001 11.076944 -10.001925
      [322,] 10.896148 10.038091 10.784210 -10.043219
      [323,]  9.998987 10.020801 11.075817 -10.007734
      [324,] 10.109544  9.984790 11.109940  -9.970821
      [325,] 10.907464 10.043990 10.739455  -9.965222
      [326,]  9.876211 10.010059 11.089070 -10.003106
      [327,] 10.217648 10.011299 11.059772  -9.981439
      [328,]  9.806478  9.979276 11.022855  -9.996466
      [329,] 10.724570  9.991064 10.901869  -9.990688
      [330,] 10.649286 10.015338 10.930410 -10.020947
      [331,] 11.079012 10.087822 10.232531  -9.991465
      [332,] 10.332203  9.975402 11.111376  -9.942857
      [333,] 10.690453  9.985245 10.989604 -10.025192
      [334,] 10.457137 10.019284 11.020829 -10.020078
      [335,]  9.528486  9.978283 10.985197  -9.953235
      [336,] 11.038802  9.951087 10.287564  -9.963061
      [337,] 10.971119 10.014283 10.619568 -10.033792
      [338,] 10.663535  9.968217 10.902069 -10.023445
      [339,] 10.500359  9.975569 11.004588  -9.981575
      [340,]  9.852800  9.990369 11.083714  -9.994077
      [341,] 10.839461 10.026607 10.668558 -10.028079
      [342,]  9.983466 10.001053 11.043009  -9.925160
      [343,]  9.533116 10.017168 10.926858  -9.986672
      [344,]  9.779903 10.038469 11.006409 -10.067043
      [345,] 10.093094 10.016953 11.102492  -9.965803
      [346,]  9.829763  9.997426 11.081595  -9.992183
      [347,] 10.756615 10.014449 10.857420 -10.031323
      [348,] 10.828212 10.049327 10.769883 -10.015771
      [349,]  9.380510  9.969449 10.767717 -10.022778
      [350,] 11.153239 10.023516 10.214083 -10.031560
      [351,] 10.915698  9.976989 10.619879 -10.020996
      [352,] 10.891662 10.030663 10.689769 -10.006417
      [353,] 10.917663 10.011030 10.623218  -9.999209
      [354,] 10.580623  9.980130 10.990920 -10.019043
      [355,] 11.007891  9.978572 10.450755  -9.978304
      [356,]  9.521504 10.057232 10.906475 -10.006274
      [357,] 10.763424  9.997578 10.871891  -9.977545
      [358,] 10.489638 10.029121 11.039707 -10.005903
      [359,] 10.694889  9.971892 10.863346  -9.953620
      [360,] 11.037098 10.015179 10.537341 -10.023747
      [361,] 10.830542  9.971237 10.790051 -10.013304
      [362,] 10.822063 10.014198 10.798362 -10.006977
      [363,] 10.104996  9.982967 11.071885 -10.007621
      [364,]  9.582508 10.028396 10.923244  -9.962850
      [365,] 10.528588 10.026502 11.012879  -9.974835
      [366,] 10.273716 10.038053 11.099338 -10.034651
      [367,]  9.353999  9.988239 10.786277 -10.016550
      [368,] 10.994816  9.978109 10.719957 -10.035143
      [369,] 10.573030 10.020102 10.962017  -9.997095
      [370,] 10.195161  9.968496 11.105146  -9.979709
      [371,] 11.114971 10.004762 10.208235 -10.017370
      [372,]  9.690272 10.026983 10.996384 -10.006436
      [373,]  9.810931 10.031454 11.079774 -10.004431
      [374,]  9.887614  9.988676 11.082595 -10.008701
      [375,] 11.080447 10.019792 10.310275  -9.984541
      [376,] 10.728805  9.961377 10.866132 -10.009118
      [377,] 10.195062  9.997811 11.056577 -10.056538
      [378,]  9.287948  9.990576 10.678951  -9.994227
      [379,]  9.555382 10.006959 10.951521  -9.965165
      [380,]  9.507220  9.990118 10.959344  -9.996078
      [381,]  9.535377  9.998514 10.935558 -10.023263
      [382,]  9.349882 10.020807 10.828306  -9.980743
      [383,] 11.119765  9.990157 10.327532  -9.955394
      [384,] 10.247315  9.986494 11.106940 -10.026277
      [385,]  9.848046 10.006687 11.045813 -10.003919
      [386,] 10.802327  9.993715 10.800396  -9.984252
      [387,] 11.075718 10.011299 10.446191  -9.995430
      [388,] 10.944614  9.945813 10.482269  -9.970640
      [389,] 10.443754  9.989365 11.018648 -10.013574
      [390,]  9.600446 10.039044 10.994875  -9.994185
      [391,] 10.711211 10.037647 10.881929 -10.019840
      [392,]  9.965974  9.965528 11.079044 -10.006276
      [393,] 10.063221  9.980195 11.145889 -10.029466
      [394,] 11.048402  9.921647 10.591762  -9.986070
      [395,] 11.036007  9.977424 10.428528  -9.995841
      [396,] 10.483897  9.997016 11.005579  -9.981842
      [397,] 10.020322  9.997773 11.119281  -9.952558
      [398,]  9.789129 10.014908 11.095890  -9.944986
      [399,]  9.625266  9.992081 10.932299 -10.007678
      [400,]  9.460843 10.011227 10.797311 -10.005987

# nonlinear_mirror() works

    Code
      nonlinear_mirror(n = 400, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                     [,1]         [,2]      [,3]       [,4]          [,5]
        [1,]  0.608984575 -1.418327886  9.990705 -10.029723 -0.0437980292
        [2,] -2.588969468 -0.550653558  9.966313  -9.965613 -0.0036500691
        [3,] -5.526341627 -0.727028288  9.949367 -10.023628 -0.0002254789
        [4,] -4.611996707 -0.326541254 10.034193 -10.011632  0.0209161229
        [5,] -7.067396240 -0.576181340 10.031159  -9.977960 -0.0443578024
        [6,] -0.321316607 -1.535940291  9.941816 -10.027876  0.0364700880
        [7,]  0.555424430 -1.636825946 10.051034 -10.007737 -0.0306815123
        [8,] -3.577189611  0.554711673  9.988288  -9.992919  0.0372616613
        [9,] -1.852556227 -1.055300483  9.998427 -10.010950 -0.0222206160
       [10,] -2.689957177 -0.087272992 10.008013  -9.981091 -0.0118054725
       [11,] -3.831893193  0.117755235  9.984681 -10.017722 -0.0443920108
       [12,] -4.123905786 -0.245938751  9.991543  -9.996302 -0.0377650341
       [13,] -7.403916198 -0.681309908  9.987471  -9.998762 -0.0322687983
       [14,] -6.363661392  0.579407318 10.022613  -9.947342 -0.0229534643
       [15,] -1.806149836 -0.801007339  9.970580 -10.039578  0.0066551930
       [16,] -2.315153851 -0.376798450 10.015877  -9.998961  0.0376758143
       [17,] -4.949014503 -0.165812247 10.014791  -9.998096  0.0413840837
       [18,] -3.547192218 -0.798994424  9.962313 -10.085165 -0.0003749861
       [19,]  1.486274103 -4.659683327 10.009043  -9.986121  0.0255459007
       [20,]  0.792329632 -2.092307223  9.958631 -10.034740  0.0458720704
       [21,] -1.907108949  0.098669705  9.967186  -9.983615  0.0386560721
       [22,]  0.542336960 -1.777402312  9.986179  -9.972622 -0.0388836589
       [23,] -3.332541603 -0.400360328  9.987736 -10.037247  0.0258542876
       [24,] -7.707207386 -0.695704145 10.024292  -9.962745  0.0398634303
       [25,] -2.298271300  0.128959379 10.006106 -10.011188 -0.0133491926
       [26,]  0.661791544 -1.794805708  9.978783  -9.983529  0.0132178108
       [27,] -3.523976537 -0.024690644  9.950036 -10.037189 -0.0384399180
       [28,] -7.371486148  0.002029076 10.036069 -10.032434  0.0082040838
       [29,] -5.100992020 -0.030884350 10.017780  -9.938414 -0.0465123677
       [30,] -1.755127940 -0.410603642 10.009631  -9.970732 -0.0353569864
       [31,] -1.843347675 -0.043516897  9.981038 -10.020823 -0.0272786889
       [32,] -6.569624095 -0.668272453 10.000928  -9.978255 -0.0070700946
       [33,] -4.412245857 -0.177105770 10.004521 -10.016317  0.0139698428
       [34,] -7.080622501  0.284327312 10.052916 -10.003968  0.0401721801
       [35,] -1.982465790 -0.513438109 10.035941  -9.979061 -0.0213697925
       [36,] -7.880617424 -0.606041210  9.953541 -10.002883 -0.0113422715
       [37,] -1.745691601 -0.953239676 10.014340 -10.012558 -0.0402571670
       [38,] -6.003639937  0.427245846 10.015648  -9.995788 -0.0123143165
       [39,] -0.053336100 -1.520938073  9.957312  -9.962690 -0.0459319559
       [40,] -6.550628544  0.134818562  9.983251 -10.018774 -0.0128077659
       [41,]  0.639978807 -1.977708779 10.015052  -9.978119  0.0165956280
       [42,] -5.687690701 -0.052723408  9.958013  -9.954912 -0.0295102948
       [43,] -6.485915653 -0.085910214 10.047770  -9.940706 -0.0395748729
       [44,] -3.066884670  0.288689890  9.982733  -9.965452 -0.0426114799
       [45,] -3.820964916  0.237345044  9.959917 -10.034934 -0.0359305440
       [46,] -3.739977036 -0.209222165  9.953579 -10.001276  0.0080750209
       [47,] -7.124586328 -0.667456921  9.957424  -9.991944 -0.0304088222
       [48,] -2.433903850 -0.095336671  9.955803 -10.006961  0.0011101453
       [49,] -1.958484537 -0.618187753 10.020340  -9.978545  0.0342450157
       [50,] -2.471503181  0.194952222  9.998127 -10.014567 -0.0083081025
       [51,] -1.871121897 -0.601340870  9.975523 -10.028733  0.0139552013
       [52,]  0.797993387 -2.773629822  9.974227 -10.009757  0.0390740565
       [53,] -2.832507481 -0.365321810  9.965498  -9.997965 -0.0004091924
       [54,] -6.233075908  0.224389948 10.027520 -10.020741  0.0342320334
       [55,] -2.737291594 -0.567750980 10.021930  -9.983089 -0.0482039690
       [56,]  0.723068205 -2.090830956 10.037832  -9.969161  0.0218271215
       [57,] -6.196576847  0.160745895  9.971851  -9.994316 -0.0184403669
       [58,]  0.395741218 -1.893741814 10.044806 -10.016928  0.0203559038
       [59,]  0.504250750 -1.713885788  9.982360 -10.013461 -0.0009199083
       [60,]  1.391383569 -4.242778178  9.950747 -10.041960 -0.0434941146
       [61,] -3.986974267  0.312455486 10.006099  -9.973486 -0.0119538720
       [62,] -6.609582335 -0.193503378 10.018928 -10.028992  0.0158433118
       [63,] -6.239960138 -0.523854410  9.946398  -9.964227 -0.0309763666
       [64,] -6.541493996  0.663315165 10.003212  -9.993683  0.0182142716
       [65,] -1.905227413 -0.451979194  9.954448 -10.000028  0.0018643952
       [66,] -1.991304845 -0.424448228 10.023852  -9.985175  0.0023591111
       [67,] -0.894944016 -0.851166270  9.959320 -10.019966  0.0164695550
       [68,]  0.955782112 -2.492879673 10.039059  -9.998406  0.0207410021
       [69,] -2.235735217 -0.094047528  9.985005  -9.925117  0.0184342620
       [70,] -7.415911222  0.256390417  9.994780  -9.991992 -0.0176811004
       [71,] -4.812149648 -0.466634130  9.969081  -9.963277  0.0269511534
       [72,] -1.206575429 -0.479014110  9.988631 -10.031351  0.0496286601
       [73,] -4.065201603 -0.435178006 10.026502  -9.978052  0.0332324397
       [74,] -0.851649296 -1.172145505 10.009893  -9.994228  0.0049006361
       [75,] -0.006516627 -1.409789337  9.966584 -10.016769 -0.0079248331
       [76,]  0.583994248 -1.699949385  9.965108 -10.010322  0.0112130031
       [77,] -1.276704297 -0.727448600  9.991895  -9.981545  0.0359030013
       [78,] -7.083860699  0.396332919  9.996677 -10.063565 -0.0136129837
       [79,] -6.191843331 -0.186769385  9.994982 -10.033793 -0.0205480455
       [80,] -6.020136544  0.240222530 10.078506 -10.003778  0.0157463099
       [81,] -5.491299399  0.030151663  9.992531 -10.029640 -0.0274516019
       [82,] -6.940853307 -0.220210855 10.038489  -9.965610  0.0066466491
       [83,] -6.996193671  0.518702709  9.995706  -9.998902  0.0375733656
       [84,] -0.889553708 -0.030736253 10.006111  -9.961191 -0.0137405454
       [85,]  1.231023160 -3.433187471 10.003597 -10.011520  0.0131386925
       [86,]  0.135507143 -1.128433728  9.967101 -10.057397  0.0404015963
       [87,]  0.526092281 -1.641191304  9.981717 -10.005171 -0.0281439012
       [88,] -6.320305767  0.339263235 10.032338  -9.970658 -0.0246387038
       [89,] -7.025480005  0.093445690 10.004373  -9.957002  0.0354712028
       [90,] -1.904216081 -0.377606703  9.992281  -9.987141  0.0334144203
       [91,] -0.492646556  0.060813911 10.008791 -10.013117 -0.0242902575
       [92,] -3.004442938  0.095099928 10.006265  -9.975929 -0.0199337242
       [93,] -3.920051268  0.031008944  9.958000  -9.954842 -0.0133882536
       [94,] -3.625035900  0.081180636  9.995753 -10.005251 -0.0451405852
       [95,]  0.208145147 -0.956456844  9.988702  -9.974932  0.0335045154
       [96,] -6.237838662 -0.556841841  9.998307 -10.033270  0.0125029671
       [97,] -2.021893218 -0.065678706 10.018822  -9.937051  0.0177404839
       [98,] -4.730173039 -0.523343396 10.014440 -10.009260  0.0432093392
       [99,] -0.781289513 -1.385272025 10.030791 -10.009625 -0.0242927737
      [100,] -6.923520371 -0.271602593 10.029741  -9.988104 -0.0350120575
      [101,]  1.444059630 -4.059421762  9.989296  -9.994809 -0.0404531073
      [102,] -2.343500180 -0.367169374  9.977455 -10.018576  0.0312919826
      [103,] -2.343472394 -0.897758086  9.979803 -10.005186  0.0193579829
      [104,] -2.711842731  0.067875458 10.053303 -10.021983 -0.0010376472
      [105,]  0.185594017 -0.639647682 10.019291 -10.003145 -0.0430677718
      [106,] -1.939584948 -0.040274828  9.995797 -10.027384 -0.0346067100
      [107,] -5.412924482 -0.041346101 10.045759 -10.031441 -0.0417781525
      [108,] -7.869397772 -0.212192960 10.018155 -10.008146  0.0088694958
      [109,]  0.310586274 -1.319359051 10.048460 -10.050614  0.0347147152
      [110,] -2.678613949  0.428109575  9.980687 -10.001315  0.0307908484
      [111,] -4.412562582  0.258557790  9.927410 -10.051287 -0.0258679933
      [112,] -1.812459361 -0.538274889 10.004890 -10.012202 -0.0147317452
      [113,] -2.587421337  0.119435607  9.969562  -9.932554  0.0123812752
      [114,] -4.388164760  0.135266286 10.018490 -10.024336  0.0211714026
      [115,] -7.289073876 -0.195774039  9.999871 -10.013585  0.0116014153
      [116,] -1.360868132 -0.758339270  9.980958 -10.027266  0.0376548839
      [117,] -6.494642446  0.038986479  9.936852 -10.028629 -0.0064472855
      [118,] -4.570681353 -0.138505748 10.015288 -10.001772 -0.0313423233
      [119,] -3.665343021 -0.604333273 10.019827 -10.047804  0.0035675545
      [120,]  0.194806616 -1.224578000 10.001650 -10.038192  0.0430576486
      [121,] -2.381586182 -0.595434913  9.981469 -10.019308  0.0328795129
      [122,] -6.813662623 -0.099295357 10.033837  -9.973881 -0.0289452860
      [123,] -1.298354714 -0.667454506  9.959741  -9.989669  0.0399918800
      [124,] -4.168695577  0.231982064 10.025845  -9.995500  0.0382319655
      [125,] -2.544658366 -0.708651018 10.030514 -10.031467  0.0309460114
      [126,]  0.504654424 -1.394036293 10.002564  -9.990195 -0.0419049777
      [127,] -4.581521751 -0.587610036 10.008349  -9.983084  0.0423536710
      [128,] -3.262820605 -0.797781291 10.017268 -10.019745 -0.0370899657
      [129,] -7.011332964  0.124768803  9.952760 -10.003269  0.0027001838
      [130,]  0.757216123 -2.450002007 10.077939  -9.999606  0.0215451797
      [131,] -1.425422382 -0.712042559  9.988027  -9.968017 -0.0352134072
      [132,] -6.384656582  0.024026820  9.987339 -10.038147  0.0411301832
      [133,]  0.947113414 -2.885604630  9.937820 -10.034008 -0.0268529668
      [134,] -6.662972827 -0.312693732 10.005437 -10.001895  0.0296570386
      [135,] -1.202691001 -0.295062801 10.019343 -10.034028 -0.0182598494
      [136,] -1.054161884 -0.081860911  9.957026 -10.022670  0.0073898806
      [137,] -0.490536202 -0.146883742 10.015644 -10.025884  0.0275797444
      [138,] -6.542690633 -0.175918729  9.981409  -9.978379  0.0046037377
      [139,] -0.918632054 -1.131299055 10.027475  -9.982148 -0.0008885216
      [140,] -7.413208068  0.361526922 10.026731  -9.992165  0.0377823472
      [141,] -5.058516935  0.239887695 10.011705 -10.062167  0.0308913827
      [142,] -1.755364997 -0.130120795  9.982951  -9.977042 -0.0035594503
      [143,] -4.543378078 -0.332278121  9.963659 -10.000334  0.0465379529
      [144,] -1.237738035  0.073715615  9.979648  -9.973125 -0.0219281841
      [145,] -0.432969026 -0.959702075  9.984310 -10.000911 -0.0227144775
      [146,]  0.416029649 -2.216392111 10.039472 -10.032962 -0.0196243592
      [147,] -2.163652262 -0.066628614  9.952249  -9.995304  0.0317497474
      [148,] -6.999456995  0.493908449 10.041466  -9.995079  0.0450590917
      [149,]  0.350771047 -1.753183118 10.006542  -9.967430 -0.0153085198
      [150,] -4.072782210  0.305018576  9.988428  -9.966390 -0.0452211075
      [151,] -7.029409215 -0.147795025 10.032088  -9.935521 -0.0236363590
      [152,]  0.452002849 -1.986014490  9.977730  -9.994123  0.0006830867
      [153,] -2.225525221 -0.160982388  9.967582  -9.954162 -0.0396140647
      [154,] -5.434065850 -0.368589681  9.985813  -9.983597 -0.0177247408
      [155,] -2.945847995  0.001425489 10.002884 -10.020982  0.0446302462
      [156,] -1.455291127 -0.903466606  9.971951 -10.027915  0.0125947152
      [157,]  0.608643815 -2.085930335 10.031866 -10.023216  0.0005567049
      [158,] -5.323647663  0.376403889  9.951173 -10.011228 -0.0087786607
      [159,] -1.550206779 -0.696442242  9.967451 -10.006101  0.0016595799
      [160,] -7.230219278 -0.282671080  9.997261 -10.007125  0.0119186168
      [161,] -0.499559094 -1.029578258  9.974218 -10.039304  0.0320210357
      [162,] -4.981929236  0.293225072  9.966593  -9.981580 -0.0026288818
      [163,] -7.246395010 -0.556352338  9.993062 -10.019665 -0.0244355528
      [164,] -1.203543439 -0.416404263  9.976670 -10.011535 -0.0257460898
      [165,] -2.937642990 -0.085671016  9.979101  -9.976461  0.0428931245
      [166,] -4.543643297 -0.695153107 10.003872 -10.074552 -0.0077596843
      [167,] -2.028241374 -0.063921066  9.991157 -10.005421 -0.0390629916
      [168,] -7.115220856 -0.590494059 10.015605  -9.972524  0.0260861394
      [169,] -2.712604825  0.553198112  9.995995 -10.038639 -0.0427029533
      [170,] -5.214619865 -0.068483388  9.984796  -9.988520  0.0138775558
      [171,] -6.039575616  0.166025720  9.979886 -10.024991  0.0197468126
      [172,] -4.194905299 -0.621032039 10.019206  -9.985472  0.0146881150
      [173,] -5.309299646 -0.075688095  9.985204 -10.001007 -0.0357172512
      [174,] -4.453814228  0.199598714 10.051568 -10.002034  0.0284941336
      [175,] -4.560158281  0.356886276  9.956239  -9.995178  0.0162242621
      [176,] -1.335173964  0.257282955  9.992195 -10.031133 -0.0429736349
      [177,]  1.257430012 -3.130249636  9.986128 -10.044687  0.0284815339
      [178,] -3.577443919 -0.296396822  9.975073 -10.031684  0.0109361930
      [179,]  1.037558027 -2.699958252  9.982416  -9.970447  0.0228333794
      [180,] -7.520489286  0.093726799 10.030219  -9.979727  0.0387186738
      [181,] -6.110862976 -0.067066385  9.948969 -10.020960 -0.0188617764
      [182,] -3.396113094 -0.174462639  9.977017 -10.068394 -0.0342062203
      [183,] -6.232274754 -0.452127380 10.016419 -10.020039  0.0199497722
      [184,] -4.606597835  0.075148597  9.957790  -9.951393 -0.0316422078
      [185,]  0.002450738 -0.838789774 10.056947  -9.964763  0.0332846919
      [186,]  0.908100897 -2.997854275 10.027910  -9.993645  0.0378497328
      [187,] -4.804107267 -0.316044455 10.054176 -10.013981  0.0261121768
      [188,] -5.298865695  0.358492357 10.016744  -9.953982 -0.0286099870
      [189,] -6.221340175 -0.437240233 10.011938  -9.965733  0.0236602983
      [190,] -7.095573217  0.323982954 10.021772  -9.964919  0.0299686022
      [191,] -5.130689969  0.169871163 10.045176 -10.056343 -0.0074272136
      [192,] -2.466869993  0.479715387 10.004512  -9.993361 -0.0397015664
      [193,] -4.299208272 -0.356651155  9.990441 -10.023583 -0.0219520928
      [194,] -4.072879655 -0.244612821  9.959514  -9.972228 -0.0360059618
      [195,] -6.841153059  0.127483601 10.045487  -9.997335 -0.0427325397
      [196,] -5.792793910  0.160870665 10.003480  -9.967481 -0.0467693679
      [197,] -5.178147192 -0.089442632 10.004484 -10.069314  0.0385861343
      [198,] -0.149884705 -1.442688934  9.974255 -10.021986 -0.0233669168
      [199,]  0.533842480 -2.373736770  9.974235  -9.994176 -0.0132586608
      [200,] -7.673965697 -0.229919855  9.991295  -9.955719 -0.0226476024
      [201,] -0.808639137  1.329394651  9.965695 -10.012674  0.0107092464
      [202,] -2.259272621  0.297058784 10.038413 -10.010283 -0.0363172620
      [203,]  0.966140033  3.292735368  9.961010 -10.051488 -0.0348498990
      [204,] -2.534555633  1.360050402 10.006421 -10.030523 -0.0117724683
      [205,] -0.523674989  1.386083869 10.037831  -9.992091  0.0383510526
      [206,] -3.346347929  1.567146847  9.966684 -10.039732  0.0110821610
      [207,] -2.473200967  1.107172921  9.981251 -10.024933 -0.0482176183
      [208,]  1.207297297  4.007011880  9.997140  -9.980856  0.0017465049
      [209,] -3.154527620  0.422998160  9.960933  -9.990349 -0.0347755222
      [210,] -3.971113254  1.151935269 10.033478 -10.021916  0.0390735438
      [211,] -4.370248030  0.396579346  9.970579 -10.016947 -0.0187968245
      [212,] -6.212418294  1.391889057 10.048570  -9.979016  0.0350151796
      [213,] -7.958120204  0.576701127  9.966842  -9.996239 -0.0430454235
      [214,] -1.375592695  1.590459902 10.026069 -10.021943 -0.0130140794
      [215,] -4.271544022  0.294767505 10.016854  -9.938494 -0.0231373987
      [216,]  0.173412692  2.023178091  9.990854  -9.993926 -0.0335328357
      [217,]  0.162807303  1.535866177 10.017553  -9.980755 -0.0216011271
      [218,] -0.680000453  0.781303720  9.928458 -10.017160 -0.0143017165
      [219,] -7.731724976  0.418207437 10.025322  -9.982554 -0.0070346893
      [220,]  0.411899418  2.236895848  9.964248  -9.939150 -0.0089109006
      [221,] -7.853900734  0.756387771  9.990125 -10.008690  0.0208178906
      [222,] -7.133863882  0.803735121 10.067986  -9.982597 -0.0049476946
      [223,] -2.066853008  1.547296675  9.968196 -10.016650  0.0180299126
      [224,] -6.165593255  0.693182963 10.040702 -10.054095  0.0204452296
      [225,] -1.524266521  1.779825528  9.982228 -10.042525  0.0245475481
      [226,] -3.871604323  0.888013686  9.974364 -10.042156 -0.0325322130
      [227,] -0.769874281  1.328105037  9.971935 -10.021722 -0.0455306102
      [228,]  0.139909680  1.981248792  9.955834 -10.060459  0.0278807708
      [229,] -1.325927773  1.608112592  9.981103  -9.997737  0.0404650056
      [230,] -2.776571289  0.958235352  9.967728  -9.921346  0.0339578096
      [231,] -2.320017401  1.376807844  9.992882 -10.001275  0.0255747881
      [232,] -0.843644391  1.432809833 10.034732 -10.010303 -0.0100037781
      [233,]  0.754033135  2.446891433 10.017972  -9.981220  0.0455058546
      [234,] -4.519844015  0.652021694  9.983511  -9.990570  0.0384461113
      [235,] -2.352906453  0.928733973 10.000967 -10.002227  0.0153756047
      [236,] -6.747439959  0.860659464  9.992764  -9.986594 -0.0400002404
      [237,]  1.067085807  3.895733523 10.028665  -9.956314 -0.0014695861
      [238,] -7.702951221  1.044237682 10.012179 -10.028333 -0.0368186970
      [239,]  0.226588506  2.206418447 10.025132 -10.001769 -0.0146648792
      [240,] -7.122571846  0.318972448 10.010741  -9.971210  0.0242084797
      [241,] -5.069192190  0.669429026  9.985522 -10.006518  0.0135313842
      [242,] -2.541005370  0.690132417 10.027543  -9.967836  0.0487753063
      [243,] -5.865036620  1.140496032 10.005723  -9.984955 -0.0425427449
      [244,] -6.578055667  1.308281650  9.982429  -9.998632 -0.0488992309
      [245,]  0.748634457  2.993031767 10.005136  -9.968713  0.0476256880
      [246,] -0.223438928  1.858981405  9.999839 -10.050790  0.0334913072
      [247,]  0.135397528  1.848734016 10.035782 -10.026580 -0.0426085782
      [248,] -4.249228442  0.939302734  9.987799  -9.995743  0.0352680525
      [249,] -6.992494190  0.941391518  9.969501  -9.997472 -0.0230456172
      [250,] -7.873222426  0.805393715 10.007359 -10.020766  0.0239943789
      [251,] -1.742028037  1.432246192 10.008871  -9.978803  0.0081165335
      [252,] -0.023001381  1.324319523  9.958092  -9.989946 -0.0259227228
      [253,] -2.757548318  1.189651994 10.034155  -9.964554 -0.0156911270
      [254,] -3.809955867  1.232356380  9.984920  -9.973067  0.0399855165
      [255,] -1.311912357  1.233075668 10.039119  -9.960252  0.0299643832
      [256,] -0.372428969  1.671352598  9.974938  -9.955950 -0.0104316566
      [257,] -0.851004080  1.635566099 10.001839  -9.960158  0.0473028292
      [258,] -6.868813801  0.635443965  9.945107 -10.027544 -0.0452194851
      [259,] -4.886101494  1.531444618 10.047870  -9.957672  0.0413021792
      [260,] -2.746909011  0.889596688 10.024972 -10.002866 -0.0168948047
      [261,] -6.340295509  0.779825277 10.010124 -10.006248 -0.0217131028
      [262,] -6.936953520  1.593336929  9.972089 -10.062378 -0.0484017081
      [263,]  0.010554189  2.352033006  9.968498  -9.941402 -0.0325122841
      [264,] -3.564234623  0.869094711 10.033847 -10.031646 -0.0178046789
      [265,]  0.421504737  1.851746750 10.041179 -10.055854  0.0343310878
      [266,] -6.038390545  0.251561021  9.940656 -10.001274  0.0198556353
      [267,] -0.044560166  1.848216789 10.025658  -9.988856 -0.0203098150
      [268,] -7.485717736  1.106562125  9.983317 -10.004707  0.0142972067
      [269,] -4.273896458  1.017335598 10.024452 -10.000064 -0.0261684653
      [270,] -5.679885185  0.590568499  9.988939 -10.048879  0.0221447836
      [271,] -7.366500755  0.815367300  9.980452 -10.002548  0.0151047887
      [272,] -1.348958872  0.777830276  9.986200 -10.046819  0.0103291712
      [273,] -2.576680190  1.119374056 10.033706  -9.982807 -0.0210791810
      [274,] -6.975756682  0.463279737  9.993344 -10.027285  0.0107304781
      [275,] -4.857235441  0.904711023 10.001203  -9.979483  0.0143019429
      [276,] -0.750739459  0.878118555 10.035305 -10.011784  0.0498698028
      [277,] -7.138462673  0.959727155  9.996986  -9.993154  0.0458431272
      [278,]  1.089027105  3.710341331  9.984004  -9.984386  0.0454449338
      [279,] -1.000087585  1.551281919 10.059590 -10.002740  0.0114684443
      [280,] -0.583868529  1.882996990 10.020780 -10.017583 -0.0046648704
      [281,] -1.147232646  1.032871757 10.024223  -9.976700  0.0024163717
      [282,] -3.647626607  0.122953784  9.982282 -10.005430  0.0275898947
      [283,] -6.725644039  0.865348317 10.056007  -9.982553  0.0272622008
      [284,] -7.407768738  0.778999566 10.052365 -10.041844  0.0364293487
      [285,] -4.943602277  0.516224183 10.023626 -10.061227  0.0309327350
      [286,]  0.631805151  2.577043137  9.966539  -9.980678 -0.0296519995
      [287,] -7.335157364  0.755906713 10.002797  -9.977136 -0.0205950031
      [288,] -5.882876847  1.194704122  9.982106  -9.977190 -0.0459227742
      [289,] -2.823936440  1.262470697  9.951045 -10.006239 -0.0477904299
      [290,] -3.124172349  1.616118540 10.033937  -9.984649  0.0405245173
      [291,] -0.248007869  1.535134557  9.982574  -9.946156 -0.0304850290
      [292,] -5.863268760  0.296739841 10.027329  -9.996691  0.0157263169
      [293,] -7.571162709  0.277752634 10.006622  -9.990244 -0.0392056732
      [294,] -3.992234034  0.452183808  9.999044  -9.986485  0.0037289331
      [295,] -1.453627347  0.642535094 10.054931  -9.976501 -0.0216777676
      [296,] -0.078536525  1.182554029 10.061946  -9.986966  0.0396881675
      [297,] -1.886080204  1.441561807  9.987963 -10.040435 -0.0366874143
      [298,] -7.817102493  0.823406116  9.983732  -9.942529 -0.0192671251
      [299,] -4.090287306  1.105594247  9.961450 -10.029459 -0.0163077996
      [300,] -2.411015504  0.635262271  9.987350 -10.003994 -0.0478473094
      [301,] -7.585946476  1.519879199 10.016716  -9.995458 -0.0398279809
      [302,] -6.725180668  1.178978913 10.008452  -9.946784  0.0476461635
      [303,] -2.402461210  0.606343709 10.022906  -9.990987 -0.0115731091
      [304,] -6.433775323  1.291497734 10.025412  -9.980738 -0.0480831801
      [305,] -5.218941569  0.860908693 10.048564 -10.024794 -0.0238364849
      [306,] -4.014064183  0.879954823  9.966803  -9.990706 -0.0129535138
      [307,]  0.707719614  3.198108271  9.972590  -9.985856  0.0043645946
      [308,] -0.880288185  1.829999115  9.992642 -10.042896  0.0049098072
      [309,] -7.575936676  0.938753846 10.015697 -10.061632 -0.0249883467
      [310,] -1.620294258  1.213652805  9.998341  -9.984052 -0.0109812774
      [311,] -4.901451536  0.681858788 10.058550  -9.974050 -0.0109105099
      [312,] -0.055326482  1.967416237 10.024307 -10.049964 -0.0098786488
      [313,] -7.338061257  0.401033282 10.059037  -9.988600  0.0491856167
      [314,] -0.067234368  1.708794048  9.991418 -10.001185  0.0093101903
      [315,] -5.089997069  0.900399492  9.957552 -10.023304  0.0174248512
      [316,] -5.097040892  0.705564103  9.984478 -10.009819  0.0461459515
      [317,] -5.063625986  0.607564035 10.027498  -9.997980 -0.0427010586
      [318,] -0.359401764  1.798122968  9.968516  -9.990866 -0.0118736496
      [319,]  0.400304205  2.703854444  9.966427  -9.992819 -0.0240240101
      [320,] -6.542675913  1.196152577 10.011177 -10.038459  0.0186267743
      [321,] -2.836365596  1.140898719  9.960297 -10.010738  0.0458526994
      [322,] -2.286118133  0.874731093 10.000379 -10.001603  0.0153174600
      [323,] -6.976864091  1.342410957  9.987492 -10.033835  0.0294077890
      [324,] -3.417996136  0.989387752 10.036532 -10.029941 -0.0095667423
      [325,] -3.668193870  0.984545868 10.009489  -9.948333  0.0409134390
      [326,]  0.417599134  1.770979617  9.976057 -10.027739  0.0078788311
      [327,] -0.623912922  1.753119024 10.022222 -10.021330  0.0348781692
      [328,] -1.047930516  1.374859125  9.975434  -9.992757  0.0493942986
      [329,]  0.540510550  2.112910551  9.996522  -9.939133 -0.0360556579
      [330,] -5.645733345  0.408364332  9.946321 -10.000442 -0.0104569928
      [331,] -5.831043063  1.173659485 10.012094 -10.009627 -0.0351667408
      [332,] -7.105747277  0.863717126 10.026245 -10.002235 -0.0116525801
      [333,] -7.635684553  1.037903554  9.983653  -9.986792  0.0007742667
      [334,] -5.527018364  1.152226868 10.000731 -10.011683  0.0396974565
      [335,] -5.951374923  0.936021334 10.035279 -10.002950  0.0271651650
      [336,] -7.356249314  1.228956220  9.986004  -9.989307  0.0312885590
      [337,] -3.330225156  0.677798941 10.016152 -10.001035  0.0285264278
      [338,] -7.347373732  1.548269577 10.031108  -9.959071 -0.0396778687
      [339,] -4.533813735  1.476225780 10.040200  -9.998170  0.0460942727
      [340,] -5.533333015  0.883652940  9.989653 -10.000174  0.0409880836
      [341,] -5.741041789  0.855483520  9.976290 -10.054919 -0.0125339646
      [342,] -0.839048377  1.369123992  9.957095  -9.990460 -0.0247812803
      [343,] -7.065992585  0.897851535 10.051964  -9.998622 -0.0169392463
      [344,] -1.842082261  1.470335331 10.019280  -9.994345  0.0495260336
      [345,] -1.865862758  1.036634360 10.015288  -9.940881 -0.0327344286
      [346,] -7.313692226  0.702050196 10.024778  -9.995637  0.0110578050
      [347,] -6.050640102  0.611630104 10.009456  -9.955989 -0.0097977272
      [348,] -4.264171202  0.289539871 10.029013  -9.963917 -0.0089933715
      [349,]  1.037979554  3.246599171  9.996382  -9.992305  0.0123233595
      [350,] -7.560271908  1.007766890  9.981619 -10.037516  0.0236370778
      [351,]  0.345205902  1.889263524  9.960561 -10.020111  0.0314808176
      [352,] -6.459666449  0.713210484 10.071916  -9.962970 -0.0052764100
      [353,]  0.714093280  2.481816062 10.011129 -10.014832 -0.0245506608
      [354,] -6.789016126  0.663478077 10.027635  -9.923227  0.0295174006
      [355,] -0.435477264  2.093255654  9.985690  -9.984932  0.0341121246
      [356,] -7.798867685  0.457208351  9.968920  -9.979176  0.0293830940
      [357,] -7.095422709  0.914769977 10.001025  -9.979022 -0.0429953310
      [358,] -1.282715370  1.320742249  9.956827  -9.964865  0.0238097583
      [359,] -4.168784044  0.626701560  9.999144  -9.944817 -0.0040556213
      [360,] -3.209421402  0.889982692 10.040526 -10.023321  0.0290921700
      [361,] -7.190663626  0.980703152 10.074171  -9.950934 -0.0282746627
      [362,] -3.002066384  1.322580352  9.956029  -9.976697 -0.0157569766
      [363,] -2.105724471  0.437671637 10.036488  -9.987992  0.0193973952
      [364,] -1.807393000  0.462494959 10.008176 -10.023769  0.0079421847
      [365,]  0.593513527  2.966838272  9.976099 -10.013263 -0.0487919415
      [366,] -7.111496089  0.213382938 10.046444 -10.043926 -0.0305934193
      [367,] -7.565005481  1.155791190  9.959604  -9.987187  0.0108824828
      [368,] -1.038059887  1.124146296 10.008437  -9.987283  0.0008504821
      [369,] -4.771059940  1.202082047  9.952020  -9.979710  0.0170417387
      [370,] -4.163233582  0.731578158  9.995120  -9.994846  0.0464184270
      [371,] -0.053709614  1.726009046  9.995876 -10.016657  0.0118198337
      [372,]  0.241311023  1.723534158 10.026381 -10.033757  0.0223265183
      [373,]  1.498293086  5.455698773  9.982955 -10.002026  0.0165689954
      [374,]  1.027332658  3.485586434 10.010126 -10.015905 -0.0171838681
      [375,] -6.346386701  0.735700660  9.987115  -9.953516  0.0042185053
      [376,] -4.602250199  0.331254889  9.991285 -10.043066 -0.0249359633
      [377,]  0.726666961  3.444090472 10.067113  -9.993565 -0.0298969204
      [378,] -0.647508861  1.368009110 10.031833  -9.985019  0.0109674703
      [379,] -6.014113972  1.411292247 10.025456  -9.999459 -0.0032705371
      [380,]  0.937231519  3.571904080  9.915122 -10.043523  0.0145442782
      [381,] -0.854097111  0.796578685 10.013222  -9.973941 -0.0160515127
      [382,] -3.554151586  1.121505090  9.979387 -10.000434  0.0195470848
      [383,] -0.073127472  1.310695841 10.020650  -9.984014 -0.0045294957
      [384,] -2.291001705  1.011767120  9.979519 -10.013242  0.0480125775
      [385,] -6.149820512  0.551863626 10.016194 -10.009455 -0.0018926770
      [386,] -2.147433159  1.040223670 10.031121  -9.991241 -0.0319420340
      [387,] -6.852506877  0.295851990  9.986292 -10.012075 -0.0183369605
      [388,] -0.249789768  1.695796871 10.061723  -9.984288  0.0459261568
      [389,] -3.250137250  1.094527564 10.055526  -9.977931  0.0208843993
      [390,] -7.791667307  1.401172344  9.976375  -9.975446 -0.0149954758
      [391,] -1.552767755  1.218910177  9.969866  -9.996018 -0.0247239927
      [392,] -4.037503349  0.996593611 10.036110 -10.080489  0.0264804634
      [393,] -2.856487526  0.453375768 10.037252  -9.986252 -0.0139952490
      [394,] -0.515866244  1.414736661  9.999173 -10.028735 -0.0207657282
      [395,]  1.194206230  4.211123362  9.970739  -9.979159  0.0298479932
      [396,] -2.561365821  1.217952714 10.000673 -10.012215  0.0468177041
      [397,] -0.982324896  1.510053533 10.030847  -9.996758 -0.0467784934
      [398,] -0.601103193  1.222801839  9.993084  -9.972353  0.0229971079
      [399,] -5.487998972  0.712073782 10.045252  -9.995416  0.0290110841
      [400,] -4.112026734  1.062482158  9.978269  -9.972247 -0.0163030809
                      [,6]
        [1,]  0.0359930183
        [2,]  0.0391829056
        [3,] -0.0007797753
        [4,] -0.0257705497
        [5,] -0.0003595334
        [6,] -0.0317866206
        [7,]  0.0075854585
        [8,]  0.0369168865
        [9,]  0.0471848964
       [10,] -0.0448185394
       [11,] -0.0243685251
       [12,]  0.0306072855
       [13,] -0.0204828955
       [14,] -0.0286209604
       [15,]  0.0441898395
       [16,]  0.0249873501
       [17,] -0.0445161339
       [18,]  0.0317941884
       [19,]  0.0148583225
       [20,]  0.0082525456
       [21,]  0.0084217807
       [22,] -0.0125677991
       [23,] -0.0442033564
       [24,] -0.0108832577
       [25,]  0.0357817216
       [26,] -0.0427162361
       [27,]  0.0191645199
       [28,]  0.0408592896
       [29,] -0.0461002005
       [30,] -0.0017143632
       [31,]  0.0204467894
       [32,] -0.0362488516
       [33,]  0.0047268782
       [34,] -0.0392856859
       [35,]  0.0316157651
       [36,] -0.0116076417
       [37,] -0.0067904739
       [38,]  0.0373270290
       [39,] -0.0186952641
       [40,]  0.0055863998
       [41,] -0.0267207064
       [42,]  0.0476969513
       [43,] -0.0408327662
       [44,] -0.0300739495
       [45,]  0.0128309683
       [46,] -0.0254998236
       [47,]  0.0368039088
       [48,]  0.0404451984
       [49,]  0.0114070552
       [50,]  0.0360081776
       [51,] -0.0224193861
       [52,]  0.0301543643
       [53,]  0.0140020505
       [54,] -0.0193725071
       [55,] -0.0198374213
       [56,] -0.0299423354
       [57,]  0.0043765077
       [58,]  0.0130153314
       [59,]  0.0445957415
       [60,]  0.0165921058
       [61,]  0.0144059786
       [62,] -0.0286737445
       [63,] -0.0459265233
       [64,] -0.0494955947
       [65,] -0.0204653413
       [66,] -0.0353885247
       [67,]  0.0312724704
       [68,]  0.0357693285
       [69,]  0.0068128975
       [70,] -0.0420383352
       [71,]  0.0426482607
       [72,] -0.0064203122
       [73,]  0.0222017498
       [74,]  0.0466327467
       [75,] -0.0067406867
       [76,] -0.0113580145
       [77,]  0.0248535921
       [78,] -0.0002419315
       [79,]  0.0468074596
       [80,]  0.0074736375
       [81,] -0.0229902867
       [82,]  0.0332021134
       [83,] -0.0387170729
       [84,]  0.0421645744
       [85,]  0.0494321901
       [86,]  0.0222273530
       [87,] -0.0264308586
       [88,] -0.0093039250
       [89,]  0.0273933636
       [90,] -0.0434736632
       [91,] -0.0186634808
       [92,] -0.0220876258
       [93,] -0.0226503788
       [94,]  0.0242954168
       [95,]  0.0355783315
       [96,]  0.0459465368
       [97,] -0.0320236968
       [98,] -0.0205145546
       [99,]  0.0152705015
      [100,] -0.0153252888
      [101,] -0.0225046200
      [102,] -0.0195495758
      [103,] -0.0171381534
      [104,] -0.0072901649
      [105,]  0.0311489899
      [106,]  0.0439051131
      [107,]  0.0053917592
      [108,]  0.0416760790
      [109,] -0.0113264317
      [110,]  0.0259034847
      [111,]  0.0065685699
      [112,] -0.0435717741
      [113,] -0.0070676897
      [114,]  0.0130117224
      [115,] -0.0492103347
      [116,]  0.0424193460
      [117,] -0.0080156112
      [118,]  0.0247982748
      [119,] -0.0494386119
      [120,] -0.0031001754
      [121,]  0.0384837404
      [122,] -0.0133946033
      [123,] -0.0444344055
      [124,] -0.0412088149
      [125,]  0.0482690136
      [126,]  0.0288730615
      [127,]  0.0473867274
      [128,] -0.0318573298
      [129,] -0.0127151501
      [130,]  0.0310874645
      [131,] -0.0415701205
      [132,]  0.0046033602
      [133,]  0.0110073412
      [134,] -0.0042060562
      [135,]  0.0147514978
      [136,]  0.0460891930
      [137,] -0.0059436755
      [138,]  0.0396971727
      [139,]  0.0243395832
      [140,] -0.0275306388
      [141,] -0.0312191814
      [142,] -0.0077302772
      [143,]  0.0090521603
      [144,] -0.0129959400
      [145,]  0.0053369763
      [146,]  0.0006899428
      [147,]  0.0433534647
      [148,]  0.0023328541
      [149,] -0.0130878423
      [150,]  0.0149118887
      [151,]  0.0128667695
      [152,]  0.0430241688
      [153,] -0.0143187563
      [154,]  0.0044628767
      [155,] -0.0243798140
      [156,] -0.0206240318
      [157,] -0.0043487728
      [158,]  0.0313727285
      [159,] -0.0423568445
      [160,]  0.0010548269
      [161,]  0.0006496763
      [162,]  0.0024959060
      [163,]  0.0079855336
      [164,] -0.0123126329
      [165,]  0.0042613463
      [166,]  0.0414011640
      [167,] -0.0006285924
      [168,]  0.0025430988
      [169,] -0.0426988430
      [170,] -0.0421615363
      [171,]  0.0132318267
      [172,] -0.0466696334
      [173,] -0.0381274384
      [174,]  0.0132470521
      [175,] -0.0021247955
      [176,] -0.0453311742
      [177,]  0.0213985977
      [178,]  0.0243783228
      [179,]  0.0044371279
      [180,]  0.0043813414
      [181,]  0.0180668992
      [182,] -0.0206689905
      [183,] -0.0256352488
      [184,]  0.0212119147
      [185,] -0.0097237010
      [186,] -0.0313594255
      [187,]  0.0109449895
      [188,] -0.0033475545
      [189,]  0.0386246506
      [190,] -0.0446871840
      [191,]  0.0402139632
      [192,] -0.0127152335
      [193,] -0.0414065541
      [194,]  0.0302830698
      [195,] -0.0372908417
      [196,]  0.0277323624
      [197,]  0.0431726661
      [198,] -0.0251979483
      [199,]  0.0287492317
      [200,]  0.0066199879
      [201,] -0.0483327051
      [202,]  0.0357602461
      [203,] -0.0237214818
      [204,] -0.0463125654
      [205,] -0.0298931180
      [206,] -0.0498597955
      [207,]  0.0498459771
      [208,] -0.0469167612
      [209,] -0.0229818524
      [210,]  0.0283170298
      [211,] -0.0256745207
      [212,] -0.0342376382
      [213,] -0.0452259197
      [214,]  0.0384821494
      [215,] -0.0076103407
      [216,]  0.0369772738
      [217,] -0.0314044803
      [218,]  0.0197319452
      [219,] -0.0414765459
      [220,] -0.0477895960
      [221,] -0.0459068536
      [222,] -0.0185632379
      [223,] -0.0345583691
      [224,]  0.0376880390
      [225,] -0.0183102126
      [226,] -0.0464615169
      [227,] -0.0308249471
      [228,]  0.0477240694
      [229,] -0.0427803583
      [230,]  0.0302785476
      [231,]  0.0466766430
      [232,] -0.0421236453
      [233,]  0.0232422486
      [234,]  0.0065203519
      [235,] -0.0272725250
      [236,]  0.0246959622
      [237,]  0.0273174587
      [238,]  0.0295885132
      [239,]  0.0476735735
      [240,] -0.0172092482
      [241,]  0.0248672731
      [242,] -0.0302728377
      [243,]  0.0442896850
      [244,] -0.0436296382
      [245,]  0.0290978932
      [246,]  0.0489810087
      [247,] -0.0472368702
      [248,]  0.0007372304
      [249,]  0.0162147226
      [250,]  0.0069884475
      [251,] -0.0126957817
      [252,] -0.0207508626
      [253,]  0.0396806562
      [254,] -0.0114937411
      [255,]  0.0252508688
      [256,]  0.0396966532
      [257,] -0.0247620318
      [258,] -0.0230056412
      [259,] -0.0455540400
      [260,] -0.0089315842
      [261,]  0.0397695648
      [262,]  0.0485527028
      [263,]  0.0212572423
      [264,] -0.0015459983
      [265,]  0.0273074393
      [266,]  0.0243289019
      [267,] -0.0302957357
      [268,] -0.0434862528
      [269,] -0.0417276127
      [270,] -0.0214424367
      [271,] -0.0167204565
      [272,] -0.0073230340
      [273,]  0.0107139109
      [274,] -0.0348785687
      [275,]  0.0377071361
      [276,]  0.0191097278
      [277,] -0.0092591256
      [278,]  0.0352319249
      [279,] -0.0361107086
      [280,]  0.0016365814
      [281,] -0.0357929136
      [282,]  0.0036173277
      [283,]  0.0490100167
      [284,]  0.0381735008
      [285,] -0.0065597456
      [286,] -0.0234647081
      [287,]  0.0341191301
      [288,]  0.0264865382
      [289,]  0.0159871888
      [290,]  0.0231319534
      [291,] -0.0280873668
      [292,]  0.0180703882
      [293,] -0.0064256240
      [294,]  0.0111786412
      [295,] -0.0463510622
      [296,]  0.0089371387
      [297,]  0.0275398864
      [298,] -0.0408656812
      [299,]  0.0472839592
      [300,]  0.0195624441
      [301,] -0.0244766761
      [302,]  0.0053734576
      [303,] -0.0094885572
      [304,]  0.0343428181
      [305,]  0.0009376471
      [306,] -0.0360802436
      [307,]  0.0446025453
      [308,]  0.0450157726
      [309,] -0.0139321176
      [310,]  0.0203976764
      [311,] -0.0126082447
      [312,]  0.0461121622
      [313,]  0.0479281968
      [314,]  0.0157145554
      [315,] -0.0302659268
      [316,]  0.0080713003
      [317,]  0.0267913693
      [318,]  0.0166274108
      [319,]  0.0249728224
      [320,] -0.0171969758
      [321,]  0.0482995042
      [322,] -0.0352094295
      [323,]  0.0213022456
      [324,] -0.0138682634
      [325,]  0.0390272422
      [326,]  0.0040549630
      [327,] -0.0291478295
      [328,] -0.0347272362
      [329,] -0.0288602716
      [330,] -0.0499461943
      [331,]  0.0350972506
      [332,]  0.0355795055
      [333,]  0.0105960785
      [334,]  0.0230840914
      [335,]  0.0054424388
      [336,]  0.0021116634
      [337,]  0.0225366552
      [338,] -0.0042736926
      [339,]  0.0374822610
      [340,]  0.0120773189
      [341,] -0.0426886674
      [342,] -0.0442100232
      [343,] -0.0103077525
      [344,] -0.0337946883
      [345,] -0.0362450532
      [346,]  0.0133359334
      [347,] -0.0016571980
      [348,] -0.0002469047
      [349,] -0.0337113976
      [350,] -0.0014563282
      [351,] -0.0437713026
      [352,] -0.0358254800
      [353,] -0.0154345437
      [354,] -0.0496529681
      [355,]  0.0480151394
      [356,] -0.0492496840
      [357,] -0.0280839966
      [358,]  0.0376185214
      [359,]  0.0311636561
      [360,] -0.0383112867
      [361,] -0.0320685174
      [362,]  0.0393998234
      [363,] -0.0292636265
      [364,] -0.0472320024
      [365,]  0.0267783721
      [366,] -0.0090592828
      [367,]  0.0137783547
      [368,] -0.0103359589
      [369,] -0.0452758347
      [370,] -0.0116192605
      [371,] -0.0384730642
      [372,] -0.0258117034
      [373,] -0.0096875740
      [374,] -0.0423080660
      [375,] -0.0312945098
      [376,]  0.0122278057
      [377,]  0.0231889707
      [378,] -0.0071398405
      [379,] -0.0384482094
      [380,] -0.0338895001
      [381,]  0.0271819704
      [382,]  0.0273003266
      [383,] -0.0391067472
      [384,]  0.0181239964
      [385,]  0.0375134063
      [386,] -0.0393063551
      [387,]  0.0206675111
      [388,] -0.0401219919
      [389,] -0.0308955889
      [390,]  0.0336780538
      [391,] -0.0369213085
      [392,]  0.0286272308
      [393,] -0.0281960141
      [394,]  0.0234851779
      [395,]  0.0184172086
      [396,] -0.0233295335
      [397,]  0.0229673963
      [398,] -0.0069681013
      [399,] -0.0227114360
      [400,] -0.0122387226

---

    Code
      nonlinear_mirror(n = 400, num_noise = 0)
    Output
                    [,1]          [,2]      [,3]       [,4]
        [1,] -7.56964727  0.0917784937  9.999466 -10.002187
        [2,] -5.89202370  0.3024294247 10.057956  -9.980725
        [3,] -1.51481745 -0.2056987783 10.017002  -9.991845
        [4,] -1.02917893 -0.4288778283 10.018214 -10.023428
        [5,] -7.23620048 -0.1431390903  9.997303 -10.007136
        [6,]  0.15347938 -0.8108305352  9.936884  -9.978081
        [7,]  0.87991819 -3.1033013956 10.019383  -9.985188
        [8,] -0.02301272 -1.0282133939  9.995047  -9.994460
        [9,] -1.12716284 -0.3170024749 10.013468 -10.011989
       [10,] -7.81796757 -0.1507067448  9.976827  -9.998938
       [11,] -5.01718240 -0.2504605656  9.993562 -10.000103
       [12,] -3.04203314 -0.0114928346  9.988360 -10.008462
       [13,] -5.97208150 -0.3527518682 10.002454 -10.050926
       [14,]  0.79711508 -2.8437575532 10.035584  -9.972135
       [15,]  1.23961750 -4.1324599252  9.997687 -10.023480
       [16,] -7.48790322 -0.3836049031  9.975227 -10.003754
       [17,] -4.38044248 -0.0654499394 10.013856 -10.011050
       [18,]  0.04413224 -0.9167303114  9.992278  -9.992666
       [19,] -3.35992775 -0.7666501481 10.006151  -9.978810
       [20,]  0.31302693 -0.9802243081  9.995717 -10.043076
       [21,] -4.29942733 -0.9700452121 10.037072  -9.977235
       [22,] -7.26803909 -0.6980933444  9.982577 -10.014250
       [23,] -5.71458823 -0.7613181935 10.033542  -9.949005
       [24,] -4.91646820 -0.0414248111  9.975198 -10.043753
       [25,] -6.67596009 -0.1065036503  9.966414 -10.038195
       [26,] -5.31139189 -0.5387463505  9.992718  -9.992838
       [27,] -4.17620076 -0.1541701673 10.011233 -10.047728
       [28,] -0.86970519 -0.3724767884  9.995730 -10.017856
       [29,] -7.88851341  0.1227122967  9.992602 -10.044078
       [30,]  0.40753595 -2.3471325773 10.009485 -10.026629
       [31,] -2.43252879  0.1369135935  9.949692 -10.042692
       [32,] -2.87019486  0.4472784527 10.052568 -10.016148
       [33,] -0.34906223 -1.1247553311  9.974432 -10.009874
       [34,] -4.22893638 -0.0090224558 10.016436 -10.010256
       [35,] -4.31291010 -0.3491889162  9.960333  -9.961670
       [36,] -5.09671623  0.1241841946  9.966188 -10.008397
       [37,] -1.56218680 -0.3106103833  9.962649 -10.035980
       [38,] -2.79569730  0.2072941272  9.984989  -9.999423
       [39,] -5.74872399 -0.1904671913 10.031396  -9.929144
       [40,]  1.10095051 -2.4298013236 10.014862 -10.062561
       [41,] -0.53114213 -0.3224733589  9.975489 -10.014720
       [42,] -7.50886740 -0.3632048781  9.978719  -9.999638
       [43,] -0.42597626 -0.9616565939  9.979927 -10.030976
       [44,] -5.42362950 -0.3834846326  9.966469 -10.045173
       [45,] -7.66701242  0.1373942798 10.069163 -10.008132
       [46,] -0.20010181 -0.7265522372  9.959777  -9.985155
       [47,] -0.56008243 -0.9086073383 10.048955 -10.034159
       [48,] -5.85066419 -0.3218768456 10.001370 -10.016126
       [49,] -1.97801848 -0.9283206673 10.003762 -10.008423
       [50,] -6.09715924 -0.9402114782 10.042222  -9.973198
       [51,] -2.26634039 -0.3753240930 10.024270 -10.021464
       [52,] -3.60113763 -0.4513958234 10.035179 -10.002895
       [53,] -0.21696954 -0.5313830198  9.983905 -10.051455
       [54,]  0.18439433 -1.6804130270 10.003393 -10.023919
       [55,]  0.58645281 -2.2835178425  9.960305  -9.991630
       [56,] -0.21315135 -1.0763935592  9.970418 -10.031878
       [57,]  0.77983093 -1.9920680726  9.982842 -10.017573
       [58,] -3.74708147 -0.2709181839 10.023358  -9.965590
       [59,]  0.46617572 -1.9503178535 10.029559  -9.968196
       [60,] -6.17699018 -0.0192657980 10.045759  -9.982848
       [61,] -4.32409743 -0.3785838876 10.039349 -10.048023
       [62,] -0.23420785 -1.1556061540 10.005814  -9.940670
       [63,] -6.87130617 -0.5210630613  9.936092 -10.014873
       [64,] -6.79070071 -0.2082685503  9.996214 -10.009638
       [65,] -4.41485651 -0.2028025215 10.008987  -9.953633
       [66,] -4.36150074 -0.1986746634  9.981585  -9.994065
       [67,] -5.89826362 -0.4387682448  9.942184  -9.992928
       [68,] -1.84693029 -0.0677869014 10.012555  -9.959055
       [69,] -2.76546105 -0.2194634934 10.030339 -10.032537
       [70,] -2.04386628 -0.6260400176  9.981339 -10.028077
       [71,] -5.22345827  0.2307473167 10.019551  -9.974686
       [72,] -5.15837308 -0.2521982667 10.021239  -9.975630
       [73,] -4.11004060 -0.1139752590 10.053513  -9.996796
       [74,]  0.81015944 -2.4391223853 10.008473  -9.974297
       [75,] -1.04721533  0.0457653337 10.025306 -10.010679
       [76,] -6.46621859 -0.6619506965 10.050416  -9.988217
       [77,] -4.22961182  0.0769730958 10.000257  -9.979675
       [78,] -6.88152067 -0.1766226317  9.972232  -9.995820
       [79,] -2.87162940 -0.6063701881 10.029096 -10.037468
       [80,] -5.73888941 -0.3548818078 10.000087  -9.999859
       [81,] -2.73468699  0.2194859192 10.011084  -9.958172
       [82,]  0.17129808 -1.7729135575 10.017907  -9.987832
       [83,] -0.86978176 -0.8220155052  9.981308 -10.010483
       [84,]  1.16997307 -3.9397289180 10.014158  -9.999576
       [85,] -6.65568446 -0.3221078326 10.001832  -9.992145
       [86,]  0.14591938 -0.8859711815  9.993068 -10.031292
       [87,] -1.65581657 -0.5892166667 10.050671 -10.049818
       [88,] -5.36881992  0.3150682460  9.998204  -9.996146
       [89,] -2.91168134  0.0485110107  9.981957 -10.019000
       [90,] -1.73567143 -0.5557398580 10.014122 -10.035728
       [91,] -1.22057246 -1.0024019354 10.005564 -10.044494
       [92,] -7.96426083 -0.5338764355 10.012217 -10.001884
       [93,] -7.91669490 -0.5288313233  9.979237  -9.950384
       [94,] -2.96120897  0.3539493390  9.974197  -9.949801
       [95,] -6.32469192 -0.0003362907 10.020999 -10.017928
       [96,] -4.97844293  0.3750460203 10.070895  -9.949431
       [97,]  1.21576801 -3.7435862937  9.999742  -9.965176
       [98,] -1.41329373 -0.4722731123  9.963930 -10.053968
       [99,] -1.07361620  0.1586139170  9.987079 -10.036504
      [100,] -5.94330412  0.4845868763  9.990323  -9.986870
      [101,] -6.91322443 -0.4452946878  9.951046 -10.047067
      [102,] -7.41761913 -0.0408232172 10.001087  -9.965872
      [103,] -2.52694151 -0.5218964165  9.980404 -10.009669
      [104,] -4.82207628 -0.3484500039 10.085234  -9.996511
      [105,] -6.39348830  0.0787385834  9.970449  -9.982167
      [106,] -5.51849888  0.0072629996  9.971727 -10.015145
      [107,] -7.00198122 -0.2058488316 10.064980 -10.019155
      [108,] -7.69980013 -0.1467894792 10.008394 -10.060343
      [109,] -4.24812220  0.1926349270  9.949018  -9.944942
      [110,] -0.83066107 -0.7873042029 10.046041  -9.997018
      [111,]  1.25332590 -3.5326665700 10.041880 -10.003174
      [112,] -6.14647759 -0.1406625005  9.970270 -10.043828
      [113,] -6.05246122 -0.4577005678 10.009820  -9.995281
      [114,] -4.58580889 -0.1772673797 10.014041  -9.958898
      [115,] -0.09915686 -1.1364666735  9.990075 -10.019243
      [116,] -0.87601965 -0.9087292883  9.978989 -10.008163
      [117,] -7.46171698  0.4797538304 10.001241 -10.015777
      [118,] -3.58110428 -0.0629558457  9.992134 -10.057627
      [119,] -0.46741957 -1.2538211376 10.047590 -10.006511
      [120,] -3.05054083 -0.6117180733  9.929371  -9.974957
      [121,] -7.22013967 -0.3090210383  9.978903 -10.075722
      [122,] -6.98964176 -0.7104843317  9.994036 -10.004242
      [123,] -6.71193805 -0.3938481750  9.998686 -10.023035
      [124,]  1.44446135 -3.8294967576  9.969776  -9.967751
      [125,] -2.31390240 -0.7863190770 10.004849  -9.985483
      [126,] -2.09025780 -0.1519378033 10.002084 -10.033136
      [127,] -4.98895874 -0.5852624777  9.985523 -10.062599
      [128,] -0.46174393 -0.1571264775  9.990761 -10.002755
      [129,] -0.41428643 -1.3510813633  9.943205  -9.998902
      [130,] -3.15621845  0.2112354880  9.955863 -10.006412
      [131,] -0.21838092 -0.9316620610  9.972826 -10.017808
      [132,] -7.50468271 -0.6144824608 10.000206 -10.071599
      [133,]  0.32680811 -1.2434289101 10.011509  -9.991519
      [134,]  0.74986906 -2.5200072098  9.994149 -10.014140
      [135,] -6.82011396  0.5213983699  9.960431  -9.975686
      [136,] -6.67488522 -0.3156994737  9.952943  -9.966839
      [137,] -7.49954366 -0.5596009202  9.956369  -9.999561
      [138,]  1.38585493 -4.0577199832  9.990437 -10.000318
      [139,] -0.60217824 -1.0666785396  9.970232  -9.978557
      [140,] -1.86532253 -0.0158828970  9.975657 -10.013004
      [141,] -5.94253789 -0.7675266602  9.985339  -9.988419
      [142,] -6.23654074 -0.2667735763 10.029931  -9.958512
      [143,] -1.01205929  0.1789365576 10.025052  -9.965457
      [144,] -5.34729984  0.3924948628 10.007723  -9.950938
      [145,] -7.78849429  0.3989947364 10.005696  -9.987102
      [146,] -4.56515775  0.3864466459  9.965063  -9.985417
      [147,] -1.65756301 -0.0767094267 10.009378 -10.022803
      [148,] -5.88854353 -0.1264461622  9.992234  -9.962288
      [149,] -0.51392346 -0.3145271482 10.004612  -9.973828
      [150,] -6.70216090 -0.3894934217 10.051626 -10.005117
      [151,] -5.05392789 -0.3046009003  9.944004 -10.065365
      [152,] -4.55848207 -0.1049904549 10.028788 -10.025027
      [153,] -7.79983689  0.1042262256 10.000181 -10.021597
      [154,] -2.13687701 -0.0037993230  9.976749 -10.007170
      [155,] -0.84960564 -0.4086294620 10.012886  -9.979373
      [156,]  1.08911889 -2.5239280547  9.989665 -10.020798
      [157,] -7.10241380 -0.7181477608 10.014811 -10.030721
      [158,] -3.62303469 -0.5913759369  9.980969  -9.978198
      [159,] -0.29623337 -1.4203156140 10.014102 -10.036495
      [160,] -0.37569939 -1.2870993251 10.025101 -10.082066
      [161,] -2.94663669 -0.1514637633 10.009067 -10.025402
      [162,] -7.25908108 -0.1212741514 10.040599  -9.999250
      [163,]  0.08846524 -0.8070128602  9.967871  -9.950829
      [164,]  1.48109087 -4.7649957147  9.946920  -9.979285
      [165,] -4.63999490 -0.0800817735  9.988708 -10.008712
      [166,] -4.16560592  0.1893871145  9.989705  -9.977504
      [167,]  0.26720423 -0.6269577371 10.015274  -9.978648
      [168,] -4.83693162  0.0365854421 10.041983 -10.073014
      [169,] -6.31572404 -0.3851806911  9.996563 -10.020760
      [170,] -4.95104649 -0.2401434165  9.979209  -9.990989
      [171,] -6.64033072 -0.3678648164 10.021145  -9.990156
      [172,] -7.91850513  0.1507560142  9.966785  -9.989860
      [173,] -3.57722098 -0.2498290399 10.013519 -10.055292
      [174,]  0.84677471 -2.8257569092 10.001050 -10.035135
      [175,] -1.49465376 -0.8378501760  9.988086 -10.000022
      [176,] -5.28756690 -0.7398760236  9.929621  -9.972658
      [177,] -2.87573598 -0.1607664710  9.970003  -9.985570
      [178,] -6.30467114  0.6812454419  9.986012 -10.058475
      [179,] -3.68526866 -0.1591848481  9.944537 -10.010181
      [180,] -7.75246781  0.5522999642  9.993771  -9.984746
      [181,] -2.56823404  0.0037169552 10.005307 -10.043744
      [182,]  0.60414263 -1.4486794110  9.967259 -10.020974
      [183,] -0.93583044 -0.9867337349 10.005261  -9.993103
      [184,] -4.57821284  0.3680445844  9.973347  -9.991703
      [185,] -6.14319126 -0.3778881947 10.082182 -10.015817
      [186,] -4.24505409 -0.6765950495  9.996230  -9.943213
      [187,] -7.10284189 -0.7959812434 10.010562  -9.979011
      [188,] -3.87731169 -0.5044585156  9.963119 -10.023170
      [189,]  0.24397795 -1.7666413150 10.057841 -10.060690
      [190,] -1.68043310  0.3507388789  9.953266  -9.979683
      [191,] -1.73913095 -0.8346088039 10.015898  -9.997070
      [192,] -5.24593403  0.0021468376 10.060795  -9.993444
      [193,] -4.07506259  0.2234000649  9.993968  -9.985619
      [194,] -4.06368416 -0.0426681020  9.985787 -10.031025
      [195,]  0.08798235 -1.1911017556 10.011966 -10.011594
      [196,] -6.95624733  0.0982156551 10.038562  -9.955004
      [197,] -4.65940888 -0.5421104612 10.006120 -10.019047
      [198,] -6.76606973  0.4010430676  9.984933  -9.969060
      [199,] -0.40370292 -0.3458291679 10.014255 -10.005049
      [200,] -5.41130536 -0.0661450315  9.931180  -9.976240
      [201,] -4.76389273  1.3906124945  9.953042 -10.028799
      [202,] -1.83125553  1.2936528960  9.983120  -9.992270
      [203,]  1.28073056  4.9763250126 10.051382 -10.004495
      [204,] -6.32743167  1.3376442722  9.977416  -9.998974
      [205,] -3.21230233  1.0994482716  9.947653  -9.962084
      [206,] -5.20164358  0.7433206411 10.011666  -9.979980
      [207,]  0.98237514  3.6451929179  9.939217 -10.010375
      [208,]  0.06619211  1.3325719558  9.976521  -9.988833
      [209,] -2.18403894  0.8161675367  9.945941 -10.016288
      [210,] -5.96639546  0.6906450496  9.961564 -10.015985
      [211,] -1.21083393  0.7865045381 10.013488 -10.047013
      [212,]  0.28486317  2.3763279654 10.009434  -9.990618
      [213,] -0.72539754  1.4762654112 10.040678 -10.041294
      [214,] -1.42625589  1.5740393696  9.957373 -10.013739
      [215,] -0.91281616  1.1695173130 10.014690  -9.993353
      [216,] -6.24405978  0.6598123664  9.973148 -10.000599
      [217,] -7.49579176  1.1761130622  9.973611  -9.968643
      [218,] -5.24027801  1.1881679727  9.973610  -9.941254
      [219,] -3.24360141  1.2762870620 10.018522  -9.997745
      [220,] -0.49536292  1.2265635719 10.078077 -10.004342
      [221,] -5.43856993  1.0032974871 10.029774  -9.975235
      [222,] -0.28333318  2.3745368422 10.007484  -9.984505
      [223,] -3.80492341  0.6896933425  9.967192 -10.043929
      [224,] -1.64620505  1.4467241263  9.947342 -10.020868
      [225,] -2.44127299  0.6162662313  9.945950 -10.017530
      [226,] -4.91194827  0.2890661409 10.013266 -10.056543
      [227,]  1.31588588  4.2730380173  9.992169 -10.004227
      [228,] -4.14020889  1.1625421092 10.004035 -10.019609
      [229,] -2.23176710  0.8957021192  9.976710 -10.004642
      [230,] -4.76725567  0.7567918119  9.975007 -10.042078
      [231,]  1.24139940  4.2238186685  9.953037 -10.016697
      [232,] -3.10926725  0.3339331330  9.961474  -9.988231
      [233,] -0.06521692  1.8108142412 10.044668 -10.004913
      [234,] -4.91524738  0.6449846659 10.052052 -10.002351
      [235,]  0.94314472  3.4710354990  9.975249 -10.002363
      [236,]  0.93421589  2.9568429221 10.009364 -10.009732
      [237,] -4.57753390  0.6531534609  9.975644  -9.967109
      [238,] -7.55199494  0.9229213916  9.985250 -10.010701
      [239,] -2.24306307  0.8603781504  9.982723 -10.003267
      [240,] -3.72390553  0.6433873664  9.995244 -10.017328
      [241,] -6.38548621  0.3907115944  9.994229 -10.011815
      [242,] -2.45747206  0.6862747393  9.941759 -10.061608
      [243,] -3.22205499  0.4097409773  9.998621  -9.967330
      [244,]  0.04304089  1.8795066013  9.998426 -10.033427
      [245,] -7.89446957  1.2736701126 10.002130 -10.015171
      [246,] -4.12789525  1.5744838614 10.003237 -10.006363
      [247,] -0.99440651  0.9763604156 10.004263  -9.990888
      [248,] -4.66586740  0.7974635836  9.944596 -10.002414
      [249,] -7.84283442  0.8620926996 10.043292  -9.957384
      [250,] -7.55945337  0.9160757083 10.001341  -9.988244
      [251,] -0.59122355  1.7120861173  9.957190 -10.013204
      [252,] -2.83908033  1.3966739756 10.036018 -10.033592
      [253,] -4.81435633  1.4028047675 10.006466  -9.987334
      [254,] -3.89853418  0.9815119058  9.998883 -10.041124
      [255,] -5.66973479  0.9439565968  9.994159 -10.016330
      [256,] -0.74854604  1.3396686677 10.020435 -10.019995
      [257,] -4.06644333  1.2486456037  9.997648 -10.060400
      [258,] -0.53350883  1.4367599450  9.989702  -9.944505
      [259,] -6.76968025  0.9671995104 10.028113  -9.981125
      [260,] -1.53080664  0.6048282622 10.024093 -10.046320
      [261,] -1.72352210  0.5520699254  9.979983 -10.045189
      [262,]  0.12688033  1.7910554668  9.959082 -10.010567
      [263,] -6.07242743  1.1411780918 10.046244 -10.011968
      [264,] -4.82462967  0.8747666456  9.979375 -10.001800
      [265,] -2.03349587  0.5720678774  9.988048  -9.965584
      [266,] -5.66969905  0.6471641543 10.005298  -9.972530
      [267,] -0.17326184  1.9266056164  9.980334  -9.995207
      [268,] -2.04619143  1.5916249795 10.021588  -9.965114
      [269,] -2.82954857  1.4350997920  9.991445 -10.047560
      [270,] -3.49227526  1.1353063661  9.929502 -10.014089
      [271,] -5.84564553  0.3691127222 10.001999 -10.012243
      [272,] -2.96158200  1.1524568193  9.999169  -9.996654
      [273,] -2.85420973  0.7166963987 10.031375 -10.039800
      [274,] -4.10662224  0.8065035797  9.934223  -9.984476
      [275,]  0.61610732  2.6160951235 10.015163  -9.999427
      [276,] -1.82586943  0.8920773177  9.974427 -10.038176
      [277,] -7.36247040  0.9030806092  9.991520 -10.008794
      [278,] -4.62159483  1.1452646961 10.015749  -9.931972
      [279,] -7.48278485  0.8306145988 10.038946 -10.039915
      [280,] -1.31457620  1.2619668389  9.997291  -9.974330
      [281,]  1.13354214  4.3566459205 10.032101 -10.026668
      [282,] -1.41921807  1.0140986624  9.979318 -10.039582
      [283,] -1.29454647  0.7413083107 10.020674  -9.997658
      [284,] -0.86257136  1.4858363252 10.076812  -9.979883
      [285,] -6.61623442  1.0701122612  9.971004  -9.914847
      [286,]  1.18614727  4.0126928570 10.016626  -9.899002
      [287,] -5.54325727  0.4796301741 10.033798 -10.020278
      [288,] -0.83599344  1.6290540377 10.004241  -9.965003
      [289,]  1.22516193  4.5136168554 10.010212 -10.030410
      [290,] -5.68439099  0.4606851929 10.027418  -9.990716
      [291,] -6.96890382  0.7465071619  9.992018  -9.982855
      [292,] -0.70763869  1.4657661945 10.016853 -10.034415
      [293,]  0.35480782  2.2999769298 10.028331 -10.022031
      [294,]  1.08567034  3.7595568692 10.031156  -9.983944
      [295,] -0.64945442  0.9626817573  9.988388 -10.039996
      [296,] -1.28278205  0.9463199551  9.932911  -9.946299
      [297,] -7.57095797  1.2699183001  9.965644  -9.998020
      [298,] -5.94277199  0.9607132726  9.989845 -10.049843
      [299,] -3.32835932  0.7916803927  9.992810  -9.982779
      [300,]  0.62604336  2.2829430304  9.968678  -9.987852
      [301,] -6.38058795  1.3020809893 10.018392 -10.035157
      [302,] -6.38711543  0.8244537902  9.955626  -9.997995
      [303,]  0.38623493  2.0882299152  9.989279  -9.970876
      [304,] -5.84916373  0.7501078711  9.970824 -10.029205
      [305,] -0.45150024  1.5154381202  9.989956 -10.014167
      [306,] -1.62331493  1.2374774576  9.937407 -10.033084
      [307,] -2.14419486  0.6747177732  9.999703  -9.998217
      [308,] -4.20574328  1.6198767927  9.930449  -9.981470
      [309,] -2.59220610  1.2244620802 10.010654  -9.962890
      [310,] -6.91505101  0.6074713940 10.022439  -9.958230
      [311,] -3.41214568  0.6151911396 10.020631 -10.051197
      [312,] -4.92119620  0.6397071972 10.027181 -10.061635
      [313,] -4.27792616  1.3071189315 10.014019  -9.985676
      [314,] -6.50675728  0.5122386209 10.008994  -9.952632
      [315,] -5.47618131  0.8418984424  9.992626 -10.009518
      [316,] -6.98337587  0.6717273448 10.023799  -9.972351
      [317,] -4.01262675  0.7420882115 10.002541  -9.959710
      [318,] -5.61452166  1.4589696186  9.989174  -9.999866
      [319,] -6.71334485  0.8551223394 10.009203  -9.970665
      [320,] -0.64303446  1.3862007913 10.006300  -9.973443
      [321,] -2.25523496  1.3900844165  9.983941 -10.073273
      [322,] -1.58141347  1.2357059501  9.898885  -9.987532
      [323,] -1.47918963  1.2556359818 10.024769  -9.989116
      [324,] -0.81177789  1.3137259433 10.030719 -10.009281
      [325,]  0.17655112  2.2399148449  9.919674  -9.962891
      [326,] -5.37862189  0.8516795724  9.955971  -9.955733
      [327,] -7.06952220  0.9147041947 10.013495  -9.940412
      [328,]  0.51825906  2.3383230952 10.056422 -10.009411
      [329,]  0.87146391  2.8109220571  9.983529 -10.019119
      [330,]  0.26281580  2.7251529358  9.986375 -10.043503
      [331,] -6.73742244  0.9923996125  9.986037  -9.981927
      [332,] -5.26202754  0.9013706064 10.018751  -9.973440
      [333,] -5.44546479  1.0745171286  9.978576 -10.018209
      [334,] -0.19200894  2.0866232161 10.015523 -10.007341
      [335,] -3.27446409  0.8669078261  9.983025 -10.038890
      [336,] -6.46248105  1.1510769489 10.035324 -10.050594
      [337,] -7.65242023  0.8583658390  9.936911  -9.969546
      [338,] -6.74420661  0.6421396204  9.997455 -10.037572
      [339,] -4.10556517  0.5538576537  9.955644 -10.022109
      [340,] -0.20831929  1.8915779903 10.002740 -10.018662
      [341,]  0.59424690  2.5808844136  9.951041  -9.968203
      [342,] -6.99668131  0.0921870757  9.986979 -10.022174
      [343,] -2.52863010  0.7048732561 10.035847 -10.009186
      [344,] -3.97540613  0.9984420539  9.958522  -9.985392
      [345,] -1.46554311  1.2235061487  9.975461 -10.029253
      [346,] -6.17820762  0.3534214191 10.015171  -9.989544
      [347,]  0.75650002  3.1947126070 10.035003 -10.056408
      [348,] -3.70000144  1.0931494125 10.025360  -9.962700
      [349,]  1.02475804  3.8425945961  9.997512  -9.985089
      [350,] -7.43583214  0.2614897142  9.990565  -9.979498
      [351,] -7.93368915  0.6039942151  9.943366 -10.030741
      [352,] -6.38244051  1.3652480111  9.952629  -9.966760
      [353,]  0.32839952  2.8697561815 10.022222 -10.002860
      [354,] -4.39598669  0.8904454428 10.022256  -9.995268
      [355,] -5.41842252  0.3362563943 10.002589  -9.975133
      [356,] -4.55570680  0.2546383895 10.021213  -9.942115
      [357,] -2.51789546  1.0743100396 10.010377 -10.008055
      [358,] -0.47591450  1.3754895891  9.983547  -9.998478
      [359,] -6.55160420  0.4435304209  9.985491 -10.019627
      [360,] -6.95804459  1.2341852508 10.001092 -10.005928
      [361,] -5.42485243  1.1315492543  9.984619  -9.989417
      [362,] -1.49260940  0.6335243983  9.989260  -9.986807
      [363,] -3.47814161  0.5318357334 10.022102 -10.026842
      [364,] -3.68750689  0.6305940854  9.960801  -9.934166
      [365,] -5.44561437  0.8751118935 10.013910  -9.940935
      [366,] -5.24342017  0.0144785912  9.977301 -10.034151
      [367,] -5.73800424  1.0590140694  9.945281  -9.962280
      [368,]  0.26405693  1.5300498441 10.005130 -10.071629
      [369,] -7.94813300  0.6604013025  9.982321 -10.053071
      [370,]  0.17159360  2.1765438538 10.002710  -9.978566
      [371,] -3.17776394  0.9483114836 10.011905  -9.997739
      [372,] -4.49175641  0.9389866083 10.026939  -9.999213
      [373,] -0.53292946  1.4678802457 10.047990 -10.009414
      [374,] -4.40182977  1.1636719833 10.014997 -10.012975
      [375,] -4.75070039  0.8144215508 10.056953 -10.000718
      [376,] -5.61110771  1.2539127624 10.034735  -9.994856
      [377,] -5.31797371  1.5132557871 10.027123 -10.020523
      [378,] -6.99127721  0.9483508696  9.990096  -9.976022
      [379,] -0.95711347  0.7142546579 10.012780 -10.017966
      [380,] -1.42434163  1.0699331025  9.913276  -9.999795
      [381,] -5.33624243  1.5979455816  9.979379  -9.981645
      [382,]  0.97088631  3.5240837205 10.003178 -10.001818
      [383,] -1.14470261  1.4549759532  9.984101  -9.976121
      [384,] -7.09996392  1.2957615414  9.952075  -9.997292
      [385,] -3.33234480  0.9116808502  9.995246 -10.016472
      [386,] -4.61461635  0.7256816577  9.988466  -9.995933
      [387,] -4.65606596  1.0896658769  9.985218 -10.008103
      [388,] -0.93831948  1.1676828898 10.098130 -10.008153
      [389,] -6.35985337  1.1693366791  9.971892 -10.009297
      [390,] -4.90017595  0.1805938538 10.005987 -10.018360
      [391,] -4.93892317  0.7068854858  9.880712  -9.960368
      [392,]  0.38826080  2.2641068838 10.004807  -9.996254
      [393,]  0.79666661  3.5489748113  9.960702  -9.987787
      [394,]  0.69529850  2.6659435768  9.978306 -10.001498
      [395,] -2.72386791  0.4501032895  9.981565 -10.004154
      [396,] -6.71464488  0.8398521439  9.996188  -9.966911
      [397,] -6.86847504  1.3723927104  9.974571 -10.024563
      [398,]  0.24598322  2.6066191367 10.022659 -10.036669
      [399,] -1.49129326  0.8693741644 10.035625 -10.015658
      [400,] -2.86330712  1.0953917209 10.023960 -10.039321

# two_curvy_panckakes() works

    Code
      two_curvy_panckakes(n = 300, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]          [,2]     [,3]     [,4]          [,5]          [,6]
        [1,] 0.582302334  0.5499482990 4.265722 3.822351  4.456985e-02 -0.0377598689
        [2,] 4.471660407 -0.9711645333 3.145488 3.600634  1.082111e-02  0.0281777969
        [3,] 5.215823945 -0.8759305779 3.949163 4.777981  1.241861e-02 -0.0106485355
        [4,] 1.615538763  0.9989992242 3.677272 4.407364  1.631652e-02 -0.0442246798
        [5,] 0.003204666  0.0032046602 4.594986 4.421910 -3.040836e-03 -0.0044094845
        [6,] 0.809484034  0.7239313202 4.297201 3.225024  4.027878e-02 -0.0276584150
        [7,] 2.915860248  0.2238202467 4.772131 3.443235  9.351035e-03 -0.0066415980
        [8,] 2.129641230  0.8478681173 3.481605 4.113965  1.717753e-02  0.0251244939
        [9,] 1.219532445  0.9389385804 3.503615 3.342332  7.135615e-03  0.0495563033
       [10,] 0.843537574  0.7469996551 3.734648 3.896956  3.335375e-02  0.0031468394
       [11,] 0.828782229  0.7371089803 3.176446 4.333585 -3.431115e-03 -0.0098312909
       [12,] 5.220247862 -0.8737877515 3.527915 4.307941 -1.866506e-02  0.0271438907
       [13,] 2.533592572  0.5712270861 4.260044 4.108184  2.138503e-02  0.0400247400
       [14,] 0.625036697  0.5851270324 4.396977 4.746877 -4.667769e-02 -0.0341779724
       [15,] 2.337858146  0.7199529391 3.578321 3.404125  3.253958e-02 -0.0056912830
       [16,] 4.139592020 -0.8403883546 3.508488 3.650368 -2.804652e-02 -0.0215980678
       [17,] 1.438081943  0.9912063645 3.657219 4.714918 -9.009592e-03  0.0080712251
       [18,] 1.041122190  0.8629717593 3.700697 4.059600  2.988130e-02 -0.0043913169
       [19,] 4.113038370 -0.8257021138 4.746004 3.993227  7.058739e-03  0.0047715123
       [20,] 0.754953613  0.6852548858 4.483243 3.755717 -1.708714e-02 -0.0158707107
       [21,] 3.720046570 -0.5467300414 3.713433 3.647524 -2.566097e-02 -0.0363597272
       [22,] 3.224040395 -0.0823543647 4.510118 3.625413 -3.205063e-02  0.0113337014
       [23,] 4.004771215 -0.7599125434 3.468598 4.029039 -2.594132e-02 -0.0228879017
       [24,] 1.757393592  0.9826411855 4.599549 4.117576  3.803132e-02  0.0066610883
       [25,] 4.740000304 -0.9996188316 3.513588 3.645751  4.379304e-02  0.0359466498
       [26,] 0.220582812  0.2187983512 4.712143 3.559077 -1.434154e-02  0.0345976077
       [27,] 5.357298336 -0.7991542588 3.029012 4.177899 -4.449161e-03  0.0057953600
       [28,] 4.368369844 -0.9414067246 4.624193 4.275528 -7.503827e-03 -0.0165653628
       [29,] 1.917161513  0.9406128743 3.668694 4.917365 -4.656778e-02 -0.0101520649
       [30,] 5.453826786 -0.7374983008 3.876482 3.812335 -2.710841e-02  0.0487028622
       [31,] 3.841630072 -0.6442463058 3.733528 3.642440  2.600811e-02  0.0115250749
       [32,] 1.654712769  0.9964810811 4.407179 4.564646 -3.284313e-02  0.0444430579
       [33,] 3.039173021  0.1022406664 3.689926 4.299885 -4.479017e-02  0.0082711114
       [34,] 2.156857798  0.8331254723 4.490534 4.341433 -3.177405e-02 -0.0360433521
       [35,] 3.187876775 -0.0462675980 3.386261 3.317587  1.214109e-02 -0.0419245044
       [36,] 1.143043698  0.9099003167 4.965329 4.076379 -2.545728e-03 -0.0346357887
       [37,] 0.376147141  0.3673397114 3.684150 3.513534 -3.369623e-02 -0.0056294389
       [38,] 1.902678179  0.9454308676 4.132143 4.516593 -3.942831e-02 -0.0037365437
       [39,] 4.862730810 -0.9887199377 4.223740 3.629639  1.072001e-02 -0.0146769820
       [40,] 0.730034797  0.6668955643 4.177314 4.252513 -4.184796e-02 -0.0021888600
       [41,] 0.020459237  0.0204578100 4.463041 3.703984 -4.625760e-02 -0.0022501174
       [42,] 3.474643781 -0.3269280109 4.031634 4.762518 -2.384936e-02  0.0083656044
       [43,] 1.935738367  0.9341444482 4.336493 4.525671 -2.029594e-02  0.0234801304
       [44,] 0.097687481  0.0975321859 3.361762 3.922323 -3.089043e-05  0.0150542545
       [45,] 5.188036137 -0.8889965657 3.675347 4.128779 -2.164460e-02  0.0184855636
       [46,] 5.602615815 -0.6292357435 3.543075 4.153484  7.280862e-03 -0.0395605636
       [47,] 2.016430667  0.9023374272 4.456183 4.298218 -5.159603e-03  0.0347641557
       [48,] 0.623767816  0.5840975728 3.220207 3.532827  4.571919e-02 -0.0401655558
       [49,] 2.541738614  0.5645220010 3.377468 3.285330  4.371184e-02  0.0339249040
       [50,] 0.913315924  0.7915345299 3.838764 3.908773 -8.465952e-03 -0.0093930904
       [51,] 2.868192221  0.2700071266 3.890682 3.858802  9.797570e-03 -0.0139380306
       [52,] 4.855049750 -0.9898411994 4.706855 3.645997 -2.422641e-02 -0.0222554683
       [53,] 0.885366844  0.7741472533 3.092153 3.742750  3.277202e-02 -0.0273821183
       [54,] 4.981443365 -0.9640226908 4.240924 4.566404 -9.997107e-03  0.0307347960
       [55,] 2.727613769  0.4022552809 3.283173 3.747158 -3.069320e-02 -0.0249599343
       [56,] 4.361207531 -0.9389669410 4.841230 3.525186  1.476614e-02 -0.0402429315
       [57,] 1.958426773  0.9258073394 4.234547 4.590598 -1.839283e-02  0.0462197369
       [58,] 0.363089576  0.3551640722 4.230253 3.793800  2.645821e-02 -0.0393223643
       [59,] 2.787629671  0.3466178230 4.789855 3.388789  1.278195e-02  0.0239902109
       [60,] 2.586398746  0.5271080926 4.805786 3.942015 -4.227686e-02 -0.0487629842
       [61,] 4.563808714 -0.9889822437 3.676223 4.171630 -9.606105e-03 -0.0055707767
       [62,] 1.853767578  0.9602300753 4.353854 4.464323 -2.830282e-02  0.0371936114
       [63,] 4.775901579 -0.9979837528 4.357019 4.828839 -4.181241e-02  0.0436406263
       [64,] 2.004504846  0.9074135291 4.128148 4.184860  1.311135e-02  0.0390775228
       [65,] 2.963512786  0.1771401347 3.440380 3.309917  1.880957e-02  0.0227467791
       [66,] 5.488303690 -0.7137806980 3.593914 3.553749  1.712295e-02 -0.0276411119
       [67,] 0.397925252  0.3875065363 3.990897 3.309908  7.884755e-03  0.0446881498
       [68,] 4.605780492 -0.9943226952 4.840100 3.683843  4.200629e-02  0.0016349768
       [69,] 0.173847549  0.1729731729 3.351993 3.485746  2.877043e-02 -0.0240139348
       [70,] 3.207545963 -0.0659055053 4.186339 4.075793  3.228527e-02  0.0181266045
       [71,] 0.763007112  0.6910979901 3.800393 4.334807  2.788319e-02 -0.0492232343
       [72,] 3.664877413 -0.4997280298 3.852775 3.339456 -1.741983e-02 -0.0329920338
       [73,] 1.197934085  0.9312884972 3.228010 4.461877  5.182130e-03  0.0064743672
       [74,] 0.599927880  0.5645829483 4.013224 3.143794 -2.974713e-02  0.0422361016
       [75,] 0.356283445  0.3487934968 4.181378 3.719750  2.027644e-02 -0.0344848166
       [76,] 0.196687702  0.1954219743 4.307517 3.786972  6.945097e-03  0.0305266531
       [77,] 1.179649132  0.9244723013 3.804307 3.280846 -2.858230e-03  0.0231167459
       [78,] 3.477072853 -0.3292226376 4.514653 4.356587  4.814338e-02 -0.0194286022
       [79,] 1.725702276  0.9880260459 4.165247 4.419927 -1.638557e-02 -0.0001718890
       [80,] 0.082849711  0.0827549628 4.163476 4.611226 -4.239687e-02  0.0340480692
       [81,] 2.277783482  0.7603223052 3.933644 4.748443  2.032662e-02 -0.0237194850
       [82,] 2.574190871  0.5374427879 4.687871 4.579982  4.524067e-03  0.0004342598
       [83,] 4.899724492 -0.9825039610 4.682479 4.533959  1.712918e-02 -0.0482351774
       [84,] 0.593449338  0.5592239030 3.995909 3.574979  4.000003e-02 -0.0196492030
       [85,] 2.522777834  0.5800701595 4.909555 3.836463 -3.129462e-02  0.0194835741
       [86,] 3.155611484 -0.0140183714 4.597148 3.243686 -1.696542e-02 -0.0159249835
       [87,] 3.172238897 -0.0306414462 4.734733 3.448227 -2.599024e-02  0.0245666893
       [88,] 1.503213891  0.9977171763 4.176625 4.356615  2.685868e-02 -0.0478778662
       [89,] 3.889057470 -0.6797816060 4.780804 4.586866  3.175927e-02  0.0021930194
       [90,] 0.327252227  0.3214422990 3.613377 3.522593 -2.017552e-02  0.0416788434
       [91,] 0.455927192  0.4402949856 4.172885 3.330983  1.430562e-02 -0.0231610519
       [92,] 0.006214778  0.0062147375 3.337016 3.891369 -4.388218e-02 -0.0262300945
       [93,] 3.448004493 -0.3016395543 3.675587 4.153983  4.704672e-02  0.0370317762
       [94,] 2.404721209  0.6719742759 3.461912 4.136276 -4.432870e-03  0.0346316919
       [95,] 1.101494651  0.8918843323 4.377523 3.566405 -3.661782e-02 -0.0410195358
       [96,] 1.852858339  0.9604835468 4.203084 4.473298  8.528756e-03 -0.0166052091
       [97,] 2.597305579  0.5178083168 3.324420 3.287121 -7.837044e-03  0.0305520805
       [98,] 5.049530488 -0.9437040828 3.553532 4.664183 -3.644674e-02  0.0245675498
       [99,] 4.734600476 -0.9997533349 4.044996 3.274935  3.336327e-02  0.0345455090
      [100,] 3.902415029 -0.6895172997 4.400763 4.345843 -1.907975e-02  0.0003508595
      [101,] 3.652421182 -0.4889001731 4.696231 3.974229 -1.471168e-03  0.0034057023
      [102,] 1.206961947  0.9345391936 3.249301 3.486917 -1.342903e-02  0.0011862537
      [103,] 1.351636731  0.9760805057 3.376959 3.574151  3.520064e-02  0.0109603464
      [104,] 0.502865297  0.4819381017 3.908973 3.966160 -2.381260e-02 -0.0212193804
      [105,] 0.019722826  0.0197215472 4.603413 3.285728 -2.661871e-02  0.0217553976
      [106,] 0.988551220  0.8352301705 3.797209 3.761234  3.555762e-02  0.0191707506
      [107,] 4.117332336 -0.8281167478 3.951216 4.345515  3.595247e-02 -0.0442334460
      [108,] 5.478761638 -0.7204310622 4.795780 4.068910 -1.364102e-02  0.0219509164
      [109,] 0.799646614  0.7171098401 4.422661 3.576267  4.875386e-02  0.0495311228
      [110,] 5.115747202 -0.9197480496 3.458932 3.785202  2.493871e-02 -0.0113840646
      [111,] 2.211152357  0.8018830872 3.850962 4.144202 -4.896922e-03 -0.0155089854
      [112,] 0.897114273  0.7815298540 3.523389 3.332427 -3.970057e-02  0.0401021889
      [113,] 1.080359399  0.8821271447 3.230473 3.639392  8.724967e-03 -0.0163494704
      [114,] 5.103320075 -0.9245546676 3.920100 4.074849  1.597159e-02  0.0425397867
      [115,] 1.233302640  0.9435875269 4.581455 4.295504 -2.019766e-02 -0.0480898142
      [116,] 0.694726381  0.6401752616 3.711514 3.133379  9.139048e-03 -0.0308108424
      [117,] 2.565598793  0.5446685619 4.503173 4.776157  3.028368e-02  0.0071905138
      [118,] 0.287054802  0.2831287707 3.883334 4.139269  1.788580e-02 -0.0412790195
      [119,] 3.597146055 -0.4399593458 3.483714 4.145504 -4.290069e-02  0.0240459894
      [120,] 1.265843397  0.9538610864 4.299709 3.649582 -2.202454e-02  0.0193376644
      [121,] 3.224224389 -0.0825377329 3.165456 3.459938  6.666061e-03 -0.0423996357
      [122,] 3.236308846 -0.0945746370 4.614536 4.613591  4.398104e-02  0.0184977262
      [123,] 3.591983386 -0.4353173349 3.730696 3.063473  2.984306e-02  0.0198984539
      [124,] 0.307048435  0.3022464375 3.252376 4.519878  4.668091e-03  0.0116929745
      [125,] 2.753352736  0.3785599112 3.394414 3.695042 -1.147877e-02 -0.0232275496
      [126,] 2.289440948  0.7526987546 4.472736 3.634386 -2.931105e-02  0.0192702085
      [127,] 4.526067752 -0.9826923574 3.420113 4.702402 -3.496157e-02  0.0320126913
      [128,] 3.188373420 -0.0467637050 3.926822 4.000621  5.097572e-04  0.0081955564
      [129,] 1.444830016  0.9920767295 4.736366 4.564325 -1.107564e-02  0.0313546496
      [130,] 1.313568953  0.9670990510 4.480612 3.742864  3.444004e-02 -0.0244275016
      [131,] 5.487971798 -0.7140131060 3.869824 3.658352  1.721028e-03  0.0151788390
      [132,] 1.152586062  0.9138172609 4.430485 4.783472  5.106072e-03  0.0351408962
      [133,] 4.733220306 -0.9997830358 4.354277 3.864350 -9.471303e-03 -0.0215082376
      [134,] 3.763134840 -0.5822896212 4.277961 4.339195  2.284583e-02 -0.0027284850
      [135,] 3.864097749 -0.6612659459 3.887548 3.489292 -3.711272e-02 -0.0387120224
      [136,] 2.608776168  0.5079614166 3.929948 3.411588  4.431580e-02 -0.0227838194
      [137,] 0.529698795  0.5052734361 4.183950 3.292242  1.383906e-02 -0.0251240733
      [138,] 4.750782685 -0.9992630522 4.304457 4.438454 -3.990231e-02  0.0464932609
      [139,] 3.079394806  0.0621577529 3.987737 3.575177  1.393104e-02 -0.0199507820
      [140,] 4.149401926 -0.8456646515 4.864166 4.353299 -4.668946e-03  0.0256514851
      [141,] 3.200695695 -0.0590686375 3.983707 4.041433  1.337010e-02  0.0405866878
      [142,] 3.247610979 -0.1058198316 3.664471 3.490393 -3.080920e-02 -0.0028731658
      [143,] 0.360048662  0.3523197757 3.564322 4.501406  1.190440e-02 -0.0444275602
      [144,] 5.197351545 -0.8846924014 3.883015 3.521772  2.176235e-02  0.0491111540
      [145,] 4.764465869 -0.9986443053 4.137187 3.544196  3.808644e-03  0.0416546314
      [146,] 0.644551400  0.6008399017 4.696598 3.392816 -2.022534e-02  0.0341986140
      [147,] 2.406979433  0.6703001803 3.574560 3.627989 -3.642897e-03  0.0086308938
      [148,] 5.112234654 -0.9211210805 4.582137 4.453432  5.561239e-03 -0.0107749348
      [149,] 0.408995148  0.3976875565 4.714364 3.320914  2.585751e-02 -0.0150154262
      [150,] 4.520891848 -0.9817203879 3.294555 4.426881 -1.580620e-02 -0.0324984893
      [151,] 1.582302334  1.5499482990 6.265722 5.822351  1.216545e-02  0.0357600727
      [152,] 5.471660407  0.0288354667 5.145488 5.600634 -2.438039e-02  0.0185067930
      [153,] 6.215823945  0.1240694221 5.949163 6.777981  3.692567e-02 -0.0271053146
      [154,] 2.615538763  1.9989992242 5.677272 6.407364 -1.229900e-02 -0.0223568213
      [155,] 1.003204666  1.0032046602 6.594986 6.421910  4.542733e-02 -0.0360059179
      [156,] 1.809484034  1.7239313202 6.297201 5.225024  1.067751e-02  0.0107024108
      [157,] 3.915860248  1.2238202467 6.772131 5.443235 -3.728084e-02 -0.0181858625
      [158,] 3.129641230  1.8478681173 5.481605 6.113965 -4.634579e-02 -0.0281567011
      [159,] 2.219532445  1.9389385804 5.503615 5.342332 -3.505162e-02  0.0038288075
      [160,] 1.843537574  1.7469996551 5.734648 5.896956  4.885832e-02  0.0409427823
      [161,] 1.828782229  1.7371089803 5.176446 6.333585  4.737772e-02 -0.0325093341
      [162,] 6.220247862  0.1262122485 5.527915 6.307941 -1.044061e-02  0.0205325620
      [163,] 3.533592572  1.5712270861 6.260044 6.108184 -4.555401e-02  0.0355930796
      [164,] 1.625036697  1.5851270324 6.396977 6.746877 -1.465659e-02 -0.0487806467
      [165,] 3.337858146  1.7199529391 5.578321 5.404125  1.518818e-02 -0.0448191922
      [166,] 5.139592020  0.1596116454 5.508488 5.650368  9.794076e-03  0.0439755222
      [167,] 2.438081943  1.9912063645 5.657219 6.714918  2.090481e-03 -0.0361030853
      [168,] 2.041122190  1.8629717593 5.700697 6.059600  1.672968e-02  0.0213141399
      [169,] 5.113038370  0.1742978862 6.746004 5.993227 -1.053083e-02 -0.0036367978
      [170,] 1.754953613  1.6852548858 6.483243 5.755717  2.569068e-02 -0.0340218931
      [171,] 4.720046570  0.4532699586 5.713433 5.647524  1.951988e-02 -0.0304943694
      [172,] 4.224040395  0.9176456353 6.510118 5.625413  2.975835e-02  0.0085205035
      [173,] 5.004771215  0.2400874566 5.468598 6.029039  1.109935e-02 -0.0367266138
      [174,] 2.757393592  1.9826411855 6.599549 6.117576 -1.491552e-02 -0.0264216963
      [175,] 5.740000304  0.0003811684 5.513588 5.645751  1.618895e-02 -0.0091447428
      [176,] 1.220582812  1.2187983512 6.712143 5.559077  4.736626e-02  0.0059495745
      [177,] 6.357298336  0.2008457412 5.029012 6.177899 -2.745094e-02 -0.0281619394
      [178,] 5.368369844  0.0585932754 6.624193 6.275528 -4.158819e-03  0.0017269597
      [179,] 2.917161513  1.9406128743 5.668694 6.917365  3.366253e-02 -0.0256983434
      [180,] 6.453826786  0.2625016992 5.876482 5.812335 -3.562754e-02 -0.0496705881
      [181,] 4.841630072  0.3557536942 5.733528 5.642440 -2.016836e-02  0.0051352489
      [182,] 2.654712769  1.9964810811 6.407179 6.564646 -3.974189e-03 -0.0273578355
      [183,] 4.039173021  1.1022406664 5.689926 6.299885 -1.890066e-02 -0.0115915452
      [184,] 3.156857798  1.8331254723 6.490534 6.341433 -3.394537e-02  0.0264064001
      [185,] 4.187876775  0.9537324020 5.386261 5.317587  3.954843e-02  0.0198529340
      [186,] 2.143043698  1.9099003167 6.965329 6.076379 -3.515784e-02 -0.0002438598
      [187,] 1.376147141  1.3673397114 5.684150 5.513534 -1.184551e-02 -0.0053096824
      [188,] 2.902678179  1.9454308676 6.132143 6.516593  2.892848e-03 -0.0362229523
      [189,] 5.862730810  0.0112800623 6.223740 5.629639  4.160459e-02 -0.0193852589
      [190,] 1.730034797  1.6668955643 6.177314 6.252513 -1.335511e-02  0.0093251564
      [191,] 1.020459237  1.0204578100 6.463041 5.703984  3.629767e-02 -0.0248719533
      [192,] 4.474643781  0.6730719891 6.031634 6.762518  3.141726e-02  0.0473052719
      [193,] 2.935738367  1.9341444482 6.336493 6.525671  1.774895e-02  0.0238977435
      [194,] 1.097687481  1.0975321859 5.361762 5.922323 -8.120899e-03 -0.0264777167
      [195,] 6.188036137  0.1110034343 5.675347 6.128779  1.586619e-02 -0.0189059034
      [196,] 6.602615815  0.3707642565 5.543075 6.153484  9.185939e-03 -0.0349754151
      [197,] 3.016430667  1.9023374272 6.456183 6.298218 -2.909539e-02  0.0457185472
      [198,] 1.623767816  1.5840975728 5.220207 5.532827  2.053609e-02  0.0108053458
      [199,] 3.541738614  1.5645220010 5.377468 5.285330 -8.063634e-03 -0.0427678243
      [200,] 1.913315924  1.7915345299 5.838764 5.908773  1.553382e-02  0.0155390420
      [201,] 3.868192221  1.2700071266 5.890682 5.858802  2.602863e-02 -0.0102627469
      [202,] 5.855049750  0.0101588006 6.706855 5.645997 -4.460973e-02 -0.0254389687
      [203,] 1.885366844  1.7741472533 5.092153 5.742750  4.520893e-02 -0.0178099468
      [204,] 5.981443365  0.0359773092 6.240924 6.566404  2.327186e-03 -0.0105336501
      [205,] 3.727613769  1.4022552809 5.283173 5.747158 -3.853751e-02 -0.0296980240
      [206,] 5.361207531  0.0610330590 6.841230 5.525186 -7.380333e-03 -0.0131823413
      [207,] 2.958426773  1.9258073394 6.234547 6.590598 -2.232958e-02 -0.0221103435
      [208,] 1.363089576  1.3551640722 6.230253 5.793800 -6.065673e-03 -0.0194955980
      [209,] 3.787629671  1.3466178230 6.789855 5.388789 -1.259044e-02  0.0343102385
      [210,] 3.586398746  1.5271080926 6.805786 5.942015  4.332718e-02 -0.0354791025
      [211,] 5.563808714  0.0110177563 5.676223 6.171630  2.363263e-02 -0.0455530925
      [212,] 2.853767578  1.9602300753 6.353854 6.464323 -2.158810e-02  0.0444633594
      [213,] 5.775901579  0.0020162472 6.357019 6.828839 -1.234432e-03 -0.0278191108
      [214,] 3.004504846  1.9074135291 6.128148 6.184860  3.786748e-02 -0.0100205618
      [215,] 3.963512786  1.1771401347 5.440380 5.309917 -5.989409e-03  0.0207915091
      [216,] 6.488303690  0.2862193020 5.593914 5.553749  4.697274e-02  0.0194021311
      [217,] 1.397925252  1.3875065363 5.990897 5.309908 -4.611238e-02 -0.0420285729
      [218,] 5.605780492  0.0056773048 6.840100 5.683843  5.639224e-04  0.0143736571
      [219,] 1.173847549  1.1729731729 5.351993 5.485746 -3.845493e-02  0.0471166582
      [220,] 4.207545963  0.9340944947 6.186339 6.075793 -8.162953e-03  0.0011105877
      [221,] 1.763007112  1.6910979901 5.800393 6.334807  4.392665e-02  0.0323901738
      [222,] 4.664877413  0.5002719702 5.852775 5.339456  2.709454e-02  0.0133922930
      [223,] 2.197934085  1.9312884972 5.228010 6.461877 -1.836716e-02  0.0464529631
      [224,] 1.599927880  1.5645829483 6.013224 5.143794  6.381873e-03  0.0119273066
      [225,] 1.356283445  1.3487934968 6.181378 5.719750 -1.990309e-02  0.0211618534
      [226,] 1.196687702  1.1954219743 6.307517 5.786972  2.730781e-02  0.0163164396
      [227,] 2.179649132  1.9244723013 5.804307 5.280846  4.226218e-02  0.0154660322
      [228,] 4.477072853  0.6707773624 6.514653 6.356587  4.664999e-02 -0.0006941579
      [229,] 2.725702276  1.9880260459 6.165247 6.419927  2.116798e-02  0.0265995397
      [230,] 1.082849711  1.0827549628 6.163476 6.611226 -4.309416e-02 -0.0164671519
      [231,] 3.277783482  1.7603223052 5.933644 6.748443 -1.920677e-02  0.0433949099
      [232,] 3.574190871  1.5374427879 6.687871 6.579982 -2.242898e-02 -0.0214593931
      [233,] 5.899724492  0.0174960390 6.682479 6.533959  4.191774e-02  0.0059777297
      [234,] 1.593449338  1.5592239030 5.995909 5.574979  3.674067e-03 -0.0331852962
      [235,] 3.522777834  1.5800701595 6.909555 5.836463 -4.443457e-02 -0.0124993692
      [236,] 4.155611484  0.9859816286 6.597148 5.243686 -1.860181e-02  0.0065300648
      [237,] 4.172238897  0.9693585538 6.734733 5.448227  2.175452e-02 -0.0411417381
      [238,] 2.503213891  1.9977171763 6.176625 6.356615 -2.180254e-02 -0.0247844953
      [239,] 4.889057470  0.3202183940 6.780804 6.586866  4.092405e-02  0.0435268620
      [240,] 1.327252227  1.3214422990 5.613377 5.522593 -1.156094e-02 -0.0458923144
      [241,] 1.455927192  1.4402949856 6.172885 5.330983  4.391131e-02  0.0046170085
      [242,] 1.006214778  1.0062147375 5.337016 5.891369  3.421685e-02  0.0450764619
      [243,] 4.448004493  0.6983604457 5.675587 6.153983  4.220810e-02  0.0059401513
      [244,] 3.404721209  1.6719742759 5.461912 6.136276 -4.022145e-02 -0.0081883668
      [245,] 2.101494651  1.8918843323 6.377523 5.566405  4.296581e-02 -0.0304601316
      [246,] 2.852858339  1.9604835468 6.203084 6.473298 -4.524026e-02 -0.0020829631
      [247,] 3.597305579  1.5178083168 5.324420 5.287121 -2.511152e-02 -0.0304781620
      [248,] 6.049530488  0.0562959172 5.553532 6.664183 -2.906693e-02  0.0425765788
      [249,] 5.734600476  0.0002466651 6.044996 5.274935  2.489058e-03 -0.0114159942
      [250,] 4.902415029  0.3104827003 6.400763 6.345843  1.890632e-02 -0.0233740703
      [251,] 4.652421182  0.5110998269 6.696231 5.974229  2.927220e-02  0.0339096562
      [252,] 2.206961947  1.9345391936 5.249301 5.486917  4.092765e-02 -0.0414377427
      [253,] 2.351636731  1.9760805057 5.376959 5.574151  3.048572e-02 -0.0374152880
      [254,] 1.502865297  1.4819381017 5.908973 5.966160  3.307067e-02  0.0403944338
      [255,] 1.019722826  1.0197215472 6.603413 5.285728  3.749385e-02  0.0284535438
      [256,] 1.988551220  1.8352301705 5.797209 5.761234 -3.411267e-02  0.0143401542
      [257,] 5.117332336  0.1718832522 5.951216 6.345515 -3.205123e-02  0.0150897518
      [258,] 6.478761638  0.2795689378 6.795780 6.068910  3.857820e-02 -0.0294666313
      [259,] 1.799646614  1.7171098401 6.422661 5.576267 -2.676152e-02 -0.0268727275
      [260,] 6.115747202  0.0802519504 5.458932 5.785202  2.005807e-02  0.0245010051
      [261,] 3.211152357  1.8018830872 5.850962 6.144202 -3.963579e-02  0.0323609477
      [262,] 1.897114273  1.7815298540 5.523389 5.332427 -4.464460e-02 -0.0283407058
      [263,] 2.080359399  1.8821271447 5.230473 5.639392  3.259540e-02  0.0101760890
      [264,] 6.103320075  0.0754453324 5.920100 6.074849  4.315758e-02 -0.0049510104
      [265,] 2.233302640  1.9435875269 6.581455 6.295504 -4.323491e-02 -0.0093291366
      [266,] 1.694726381  1.6401752616 5.711514 5.133379 -1.448548e-02  0.0092357021
      [267,] 3.565598793  1.5446685619 6.503173 6.776157  2.217300e-02  0.0142444834
      [268,] 1.287054802  1.2831287707 5.883334 6.139269 -1.027064e-02  0.0276593626
      [269,] 4.597146055  0.5600406542 5.483714 6.145504  4.496821e-02 -0.0235752249
      [270,] 2.265843397  1.9538610864 6.299709 5.649582  2.655916e-02 -0.0009247106
      [271,] 4.224224389  0.9174622671 5.165456 5.459938 -8.054416e-03  0.0222653301
      [272,] 4.236308846  0.9054253630 6.614536 6.613591 -4.392374e-02  0.0108763634
      [273,] 4.591983386  0.5646826651 5.730696 5.063473 -2.359525e-02 -0.0049058254
      [274,] 1.307048435  1.3022464375 5.252376 6.519878 -1.092390e-02 -0.0245505164
      [275,] 3.753352736  1.3785599112 5.394414 5.695042  4.630102e-02 -0.0016452796
      [276,] 3.289440948  1.7526987546 6.472736 5.634386  2.662198e-02 -0.0233802950
      [277,] 5.526067752  0.0173076426 5.420113 6.702402 -4.263518e-03 -0.0460393964
      [278,] 4.188373420  0.9532362950 5.926822 6.000621 -2.611584e-02  0.0332867402
      [279,] 2.444830016  1.9920767295 6.736366 6.564325  4.355451e-02  0.0406457410
      [280,] 2.313568953  1.9670990510 6.480612 5.742864 -1.124803e-02 -0.0129818394
      [281,] 6.487971798  0.2859868940 5.869824 5.658352 -2.867090e-02 -0.0013812454
      [282,] 2.152586062  1.9138172609 6.430485 6.783472  1.485437e-02 -0.0099141791
      [283,] 5.733220306  0.0002169642 6.354277 5.864350  4.124495e-02 -0.0025305262
      [284,] 4.763134840  0.4177103788 6.277961 6.339195 -3.849647e-02 -0.0272961495
      [285,] 4.864097749  0.3387340541 5.887548 5.489292 -4.035356e-02  0.0497736051
      [286,] 3.608776168  1.5079614166 5.929948 5.411588  4.438101e-02 -0.0373848314
      [287,] 1.529698795  1.5052734361 6.183950 5.292242  1.914029e-02 -0.0178189527
      [288,] 5.750782685  0.0007369478 6.304457 6.438454 -8.827151e-03  0.0290966723
      [289,] 4.079394806  1.0621577529 5.987737 5.575177  6.906394e-03  0.0376571369
      [290,] 5.149401926  0.1543353485 6.864166 6.353299 -2.500496e-02 -0.0122225274
      [291,] 4.200695695  0.9409313625 5.983707 6.041433  3.486415e-02 -0.0207520892
      [292,] 4.247610979  0.8941801684 5.664471 5.490393  3.207366e-02  0.0489874637
      [293,] 1.360048662  1.3523197757 5.564322 6.501406  1.476420e-02 -0.0319272961
      [294,] 6.197351545  0.1153075986 5.883015 5.521772 -1.487132e-03  0.0234734462
      [295,] 5.764465869  0.0013556947 6.137187 5.544196 -3.114883e-02  0.0392798880
      [296,] 1.644551400  1.6008399017 6.696598 5.392816  3.930624e-02  0.0412171215
      [297,] 3.406979433  1.6703001803 5.574560 5.627989 -1.292091e-02 -0.0392849744
      [298,] 6.112234654  0.0788789195 6.582137 6.453432 -3.438110e-02  0.0370253569
      [299,] 1.408995148  1.3976875565 6.714364 5.320914  3.673330e-02  0.0145395615
      [300,] 5.520891848  0.0182796121 5.294555 6.426881 -7.785790e-03  0.0151166953

---

    Code
      two_curvy_panckakes(n = 300, num_noise = 0)
    Output
                   [,1]          [,2]     [,3]     [,4]
        [1,] 4.80839657 -9.953948e-01 3.830720 4.634556
        [2,] 2.36215220  7.028815e-01 4.071892 3.130379
        [3,] 5.26938669 -8.488461e-01 4.667575 3.464785
        [4,] 0.41343499  4.017573e-01 4.231563 3.823302
        [5,] 4.83234392 -9.928140e-01 4.481318 3.419520
        [6,] 1.52123810  9.987722e-01 3.784980 4.914352
        [7,] 0.91772536  7.942215e-01 4.869502 4.110080
        [8,] 0.72757292  6.650591e-01 4.305061 4.235079
        [9,] 1.41141090  9.873250e-01 4.376137 4.632672
       [10,] 1.58215012  9.999355e-01 3.811190 3.954683
       [11,] 4.28423925 -9.097355e-01 4.035209 3.095517
       [12,] 5.15053342 -9.055405e-01 4.525877 4.236229
       [13,] 5.59091174 -6.382890e-01 4.091083 4.918909
       [14,] 1.65665409  9.963165e-01 3.111611 4.139731
       [15,] 4.22943074 -8.856250e-01 3.790870 3.249485
       [16,] 4.95009214 -9.718814e-01 4.231029 4.877269
       [17,] 0.29739625  2.930318e-01 3.076066 3.682892
       [18,] 0.10090613  1.007350e-01 3.186580 3.937252
       [19,] 0.67905339  6.280567e-01 4.033425 4.718582
       [20,] 1.43366228  9.906119e-01 4.412465 4.020695
       [21,] 2.35310325  7.092892e-01 3.050233 3.767045
       [22,] 1.32246844  9.693248e-01 4.727989 4.073371
       [23,] 3.84196403 -6.445017e-01 3.575078 3.309106
       [24,] 5.02562239 -9.513422e-01 4.947029 3.822709
       [25,] 0.35355734  3.462373e-01 3.895928 4.038086
       [26,] 1.31213042  9.667321e-01 3.757415 4.566617
       [27,] 0.71636620  6.566484e-01 4.696675 4.553193
       [28,] 3.56077466 -4.070134e-01 3.858795 4.598025
       [29,] 0.68496793  6.326482e-01 3.918972 3.182627
       [30,] 3.70258780 -5.320291e-01 4.159300 3.429880
       [31,] 5.48418318 -7.166605e-01 4.097087 4.899369
       [32,] 5.00811464 -9.565909e-01 3.303640 4.127152
       [33,] 2.33219943  7.238687e-01 4.832851 4.369316
       [34,] 1.20955798  9.354599e-01 4.235158 3.701041
       [35,] 4.43395058 -9.614858e-01 4.715325 4.108931
       [36,] 3.13107581  1.051665e-02 3.973162 4.501140
       [37,] 1.00255720  8.428499e-01 4.688310 4.686077
       [38,] 0.82407067  7.339169e-01 4.897330 4.182416
       [39,] 2.62729640  4.919223e-01 4.682287 3.341982
       [40,] 2.03640422  8.935488e-01 4.847976 3.948643
       [41,] 0.78709618  7.083064e-01 3.144606 3.908467
       [42,] 3.10661706  3.496847e-02 3.670779 3.346026
       [43,] 5.59587834 -6.344579e-01 3.655245 4.270409
       [44,] 0.73660447  6.717765e-01 4.357472 3.655705
       [45,] 4.34396183 -9.328950e-01 3.493269 3.670587
       [46,] 4.98076567 -9.642026e-01 4.295681 4.090220
       [47,] 2.39217840  6.812101e-01 4.053108 4.661483
       [48,] 1.52380436  9.988961e-01 3.987976 3.032103
       [49,] 0.39565019  3.854082e-01 3.640524 3.149315
       [50,] 5.56756276 -6.560874e-01 4.300873 3.887010
       [51,] 4.28065133 -9.082400e-01 4.296833 3.467288
       [52,] 3.41716300 -2.720958e-01 3.339746 3.974243
       [53,] 5.33708709 -8.111397e-01 3.627545 3.615686
       [54,] 3.25330103 -1.114762e-01 4.029444 3.172084
       [55,] 4.45027599 -9.658446e-01 3.149419 4.145944
       [56,] 2.77008237  3.630231e-01 3.831723 4.313368
       [57,] 3.28982234 -1.476875e-01 4.024714 3.263267
       [58,] 5.48063575 -7.191301e-01 3.359362 4.719540
       [59,] 2.88426324  2.544988e-01 3.840202 4.684996
       [60,] 2.39819135  6.767958e-01 4.780568 4.289005
       [61,] 2.16060672  8.310462e-01 4.218584 4.308884
       [62,] 1.06405646  8.743314e-01 3.528362 3.765529
       [63,] 0.02492891  2.492633e-02 3.155931 4.431029
       [64,] 3.94317271 -7.184560e-01 3.702874 3.089639
       [65,] 2.21936019  7.969521e-01 3.789022 3.090601
       [66,] 4.86521683 -9.883445e-01 3.761479 4.145260
       [67,] 4.85890398 -9.892859e-01 3.663612 3.358103
       [68,] 4.35722339 -9.375889e-01 4.346670 4.117967
       [69,] 0.15969048  1.590126e-01 4.815425 3.545311
       [70,] 5.00717585 -9.568641e-01 3.871574 3.597888
       [71,] 0.08696546  8.685588e-02 4.332275 4.815275
       [72,] 0.51556677  4.930280e-01 3.931103 4.570217
       [73,] 3.53170061 -3.802883e-01 4.447586 3.221833
       [74,] 1.09192903  8.875174e-01 4.810513 3.688192
       [75,] 3.85467475 -6.541680e-01 4.360918 4.324469
       [76,] 2.45742395  6.320290e-01 3.912269 3.271803
       [77,] 4.30372608 -9.176530e-01 3.545206 4.262788
       [78,] 4.84527419 -9.911837e-01 4.304827 3.718062
       [79,] 3.97273572 -7.387023e-01 3.369935 3.998522
       [80,] 3.10924142  3.234559e-02 4.456855 4.079947
       [81,] 3.38100473 -2.371315e-01 3.631964 4.919471
       [82,] 4.25981448 -8.993243e-01 3.209963 3.569874
       [83,] 5.21083065 -8.783286e-01 3.991560 3.528844
       [84,] 2.07155984  8.772163e-01 3.508500 4.312604
       [85,] 3.36142755 -2.180685e-01 3.296043 4.094286
       [86,] 0.74558528  6.784019e-01 4.167998 3.275237
       [87,] 5.39717498 -7.745544e-01 4.429983 4.016970
       [88,] 0.17681803  1.758981e-01 3.425919 3.956996
       [89,] 4.89686969 -9.830316e-01 3.435199 4.439439
       [90,] 0.52228835  4.988647e-01 3.376765 3.227589
       [91,] 1.74456081  9.849409e-01 4.714520 4.594574
       [92,] 3.24946183 -1.076601e-01 3.875945 3.802393
       [93,] 1.27083510  9.553479e-01 4.395600 3.469614
       [94,] 0.84641113  7.489070e-01 4.614174 4.286075
       [95,] 5.20761709 -8.798603e-01 4.073566 4.655315
       [96,] 4.62899125 -9.965244e-01 4.482315 3.207484
       [97,] 4.84258834 -9.915360e-01 3.669410 4.171814
       [98,] 2.23264352  7.888583e-01 3.046123 3.911360
       [99,] 0.59971696  5.644088e-01 3.914095 3.647992
      [100,] 0.07546424  7.539264e-02 3.694526 3.687387
      [101,] 3.72505239 -5.509146e-01 3.916624 3.905905
      [102,] 4.74830152 -9.993552e-01 3.780576 4.322326
      [103,] 3.12056483  2.102628e-02 3.921716 4.645151
      [104,] 2.49412014  6.031724e-01 4.674324 3.639143
      [105,] 3.98107838 -7.442998e-01 4.250086 3.973103
      [106,] 4.54030505 -9.852301e-01 3.782021 3.208903
      [107,] 4.25543363 -8.974000e-01 4.370095 3.605919
      [108,] 0.67333761  6.235986e-01 4.079815 4.691244
      [109,] 1.85354539  9.602921e-01 3.172234 3.730452
      [110,] 3.12689786  1.469426e-02 3.934734 3.717362
      [111,] 0.98793766  8.348926e-01 4.478750 3.228807
      [112,] 0.63277750  5.913868e-01 3.949375 4.679503
      [113,] 4.76827545 -9.984388e-01 4.621440 4.627938
      [114,] 2.64038550  4.804846e-01 3.994842 4.580008
      [115,] 5.01289340 -9.551873e-01 3.199698 4.073609
      [116,] 1.16764633  9.198298e-01 3.466872 4.161647
      [117,] 4.73546867 -9.997337e-01 4.622295 4.439681
      [118,] 0.30612607  3.013671e-01 4.870739 3.598511
      [119,] 2.21795991  7.977972e-01 3.545122 3.377941
      [120,] 1.38104634  9.820514e-01 3.423500 4.491098
      [121,] 0.37708988  3.682164e-01 4.936739 3.834334
      [122,] 3.95902647 -7.293927e-01 4.791492 4.148695
      [123,] 3.22822642 -8.652544e-02 3.528018 3.783573
      [124,] 0.60967995  5.726051e-01 3.619088 3.601129
      [125,] 1.87072788  9.553567e-01 4.443612 4.739688
      [126,] 4.31511606 -9.221195e-01 4.583744 4.196160
      [127,] 0.51282935  4.906446e-01 4.716126 4.369949
      [128,] 5.41023552 -7.662277e-01 4.376238 4.617082
      [129,] 4.16669181 -8.547657e-01 3.765509 4.401681
      [130,] 4.41444584 -9.559423e-01 3.966302 4.103722
      [131,] 4.07910384 -8.060877e-01 3.514516 3.129466
      [132,] 2.59074649  5.234084e-01 3.350949 4.469191
      [133,] 0.75855928  6.878764e-01 4.182666 4.733708
      [134,] 0.35252515  3.452688e-01 4.118200 4.426580
      [135,] 1.81931810  9.692771e-01 4.388021 4.171185
      [136,] 5.13807454 -9.107558e-01 3.701098 3.980716
      [137,] 0.39574700  3.854976e-01 3.139742 3.598658
      [138,] 1.26021572  9.521563e-01 4.273201 4.680879
      [139,] 3.08104735  6.050832e-02 4.177066 4.565359
      [140,] 2.90233219  2.369842e-01 3.923131 4.017626
      [141,] 4.61436661 -9.951997e-01 4.595987 3.334877
      [142,] 1.27188742  9.556584e-01 4.003864 4.107599
      [143,] 0.25526503  2.525019e-01 4.556893 4.063040
      [144,] 2.38561922  6.859973e-01 4.766690 4.014172
      [145,] 3.89672265 -6.853833e-01 3.481440 3.505543
      [146,] 4.71524428 -9.999959e-01 4.393661 3.277847
      [147,] 3.63930547 -4.774171e-01 3.489340 3.484008
      [148,] 0.10886958  1.086546e-01 3.698455 4.002975
      [149,] 2.32725310  7.272725e-01 3.625841 4.544198
      [150,] 3.32683818 -1.841879e-01 4.185734 3.688693
      [151,] 5.80839657  4.605189e-03 5.830720 6.634556
      [152,] 3.36215220  1.702882e+00 6.071892 5.130379
      [153,] 6.26938669  1.511539e-01 6.667575 5.464785
      [154,] 1.41343499  1.401757e+00 6.231563 5.823302
      [155,] 5.83234392  7.185971e-03 6.481318 5.419520
      [156,] 2.52123810  1.998772e+00 5.784980 6.914352
      [157,] 1.91772536  1.794222e+00 6.869502 6.110080
      [158,] 1.72757292  1.665059e+00 6.305061 6.235079
      [159,] 2.41141090  1.987325e+00 6.376137 6.632672
      [160,] 2.58215012  1.999936e+00 5.811190 5.954683
      [161,] 5.28423925  9.026448e-02 6.035209 5.095517
      [162,] 6.15053342  9.445954e-02 6.525877 6.236229
      [163,] 6.59091174  3.617110e-01 6.091083 6.918909
      [164,] 2.65665409  1.996316e+00 5.111611 6.139731
      [165,] 5.22943074  1.143750e-01 5.790870 5.249485
      [166,] 5.95009214  2.811862e-02 6.231029 6.877269
      [167,] 1.29739625  1.293032e+00 5.076066 5.682892
      [168,] 1.10090613  1.100735e+00 5.186580 5.937252
      [169,] 1.67905339  1.628057e+00 6.033425 6.718582
      [170,] 2.43366228  1.990612e+00 6.412465 6.020695
      [171,] 3.35310325  1.709289e+00 5.050233 5.767045
      [172,] 2.32246844  1.969325e+00 6.727989 6.073371
      [173,] 4.84196403  3.554983e-01 5.575078 5.309106
      [174,] 6.02562239  4.865779e-02 6.947029 5.822709
      [175,] 1.35355734  1.346237e+00 5.895928 6.038086
      [176,] 2.31213042  1.966732e+00 5.757415 6.566617
      [177,] 1.71636620  1.656648e+00 6.696675 6.553193
      [178,] 4.56077466  5.929866e-01 5.858795 6.598025
      [179,] 1.68496793  1.632648e+00 5.918972 5.182627
      [180,] 4.70258780  4.679709e-01 6.159300 5.429880
      [181,] 6.48418318  2.833395e-01 6.097087 6.899369
      [182,] 6.00811464  4.340909e-02 5.303640 6.127152
      [183,] 3.33219943  1.723869e+00 6.832851 6.369316
      [184,] 2.20955798  1.935460e+00 6.235158 5.701041
      [185,] 5.43395058  3.851418e-02 6.715325 6.108931
      [186,] 4.13107581  1.010517e+00 5.973162 6.501140
      [187,] 2.00255720  1.842850e+00 6.688310 6.686077
      [188,] 1.82407067  1.733917e+00 6.897330 6.182416
      [189,] 3.62729640  1.491922e+00 6.682287 5.341982
      [190,] 3.03640422  1.893549e+00 6.847976 5.948643
      [191,] 1.78709618  1.708306e+00 5.144606 5.908467
      [192,] 4.10661706  1.034968e+00 5.670779 5.346026
      [193,] 6.59587834  3.655421e-01 5.655245 6.270409
      [194,] 1.73660447  1.671777e+00 6.357472 5.655705
      [195,] 5.34396183  6.710504e-02 5.493269 5.670587
      [196,] 5.98076567  3.579739e-02 6.295681 6.090220
      [197,] 3.39217840  1.681210e+00 6.053108 6.661483
      [198,] 2.52380436  1.998896e+00 5.987976 5.032103
      [199,] 1.39565019  1.385408e+00 5.640524 5.149315
      [200,] 6.56756276  3.439126e-01 6.300873 5.887010
      [201,] 5.28065133  9.176000e-02 6.296833 5.467288
      [202,] 4.41716300  7.279042e-01 5.339746 5.974243
      [203,] 6.33708709  1.888603e-01 5.627545 5.615686
      [204,] 4.25330103  8.885238e-01 6.029444 5.172084
      [205,] 5.45027599  3.415539e-02 5.149419 6.145944
      [206,] 3.77008237  1.363023e+00 5.831723 6.313368
      [207,] 4.28982234  8.523125e-01 6.024714 5.263267
      [208,] 6.48063575  2.808699e-01 5.359362 6.719540
      [209,] 3.88426324  1.254499e+00 5.840202 6.684996
      [210,] 3.39819135  1.676796e+00 6.780568 6.289005
      [211,] 3.16060672  1.831046e+00 6.218584 6.308884
      [212,] 2.06405646  1.874331e+00 5.528362 5.765529
      [213,] 1.02492891  1.024926e+00 5.155931 6.431029
      [214,] 4.94317271  2.815440e-01 5.702874 5.089639
      [215,] 3.21936019  1.796952e+00 5.789022 5.090601
      [216,] 5.86521683  1.165546e-02 5.761479 6.145260
      [217,] 5.85890398  1.071414e-02 5.663612 5.358103
      [218,] 5.35722339  6.241108e-02 6.346670 6.117967
      [219,] 1.15969048  1.159013e+00 6.815425 5.545311
      [220,] 6.00717585  4.313591e-02 5.871574 5.597888
      [221,] 1.08696546  1.086856e+00 6.332275 6.815275
      [222,] 1.51556677  1.493028e+00 5.931103 6.570217
      [223,] 4.53170061  6.197117e-01 6.447586 5.221833
      [224,] 2.09192903  1.887517e+00 6.810513 5.688192
      [225,] 4.85467475  3.458320e-01 6.360918 6.324469
      [226,] 3.45742395  1.632029e+00 5.912269 5.271803
      [227,] 5.30372608  8.234702e-02 5.545206 6.262788
      [228,] 5.84527419  8.816255e-03 6.304827 5.718062
      [229,] 4.97273572  2.612977e-01 5.369935 5.998522
      [230,] 4.10924142  1.032346e+00 6.456855 6.079947
      [231,] 4.38100473  7.628685e-01 5.631964 6.919471
      [232,] 5.25981448  1.006757e-01 5.209963 5.569874
      [233,] 6.21083065  1.216714e-01 5.991560 5.528844
      [234,] 3.07155984  1.877216e+00 5.508500 6.312604
      [235,] 4.36142755  7.819315e-01 5.296043 6.094286
      [236,] 1.74558528  1.678402e+00 6.167998 5.275237
      [237,] 6.39717498  2.254456e-01 6.429983 6.016970
      [238,] 1.17681803  1.175898e+00 5.425919 5.956996
      [239,] 5.89686969  1.696836e-02 5.435199 6.439439
      [240,] 1.52228835  1.498865e+00 5.376765 5.227589
      [241,] 2.74456081  1.984941e+00 6.714520 6.594574
      [242,] 4.24946183  8.923399e-01 5.875945 5.802393
      [243,] 2.27083510  1.955348e+00 6.395600 5.469614
      [244,] 1.84641113  1.748907e+00 6.614174 6.286075
      [245,] 6.20761709  1.201397e-01 6.073566 6.655315
      [246,] 5.62899125  3.475576e-03 6.482315 5.207484
      [247,] 5.84258834  8.463969e-03 5.669410 6.171814
      [248,] 3.23264352  1.788858e+00 5.046123 5.911360
      [249,] 1.59971696  1.564409e+00 5.914095 5.647992
      [250,] 1.07546424  1.075393e+00 5.694526 5.687387
      [251,] 4.72505239  4.490854e-01 5.916624 5.905905
      [252,] 5.74830152  6.447861e-04 5.780576 6.322326
      [253,] 4.12056483  1.021026e+00 5.921716 6.645151
      [254,] 3.49412014  1.603172e+00 6.674324 5.639143
      [255,] 4.98107838  2.557002e-01 6.250086 5.973103
      [256,] 5.54030505  1.476994e-02 5.782021 5.208903
      [257,] 5.25543363  1.026000e-01 6.370095 5.605919
      [258,] 1.67333761  1.623599e+00 6.079815 6.691244
      [259,] 2.85354539  1.960292e+00 5.172234 5.730452
      [260,] 4.12689786  1.014694e+00 5.934734 5.717362
      [261,] 1.98793766  1.834893e+00 6.478750 5.228807
      [262,] 1.63277750  1.591387e+00 5.949375 6.679503
      [263,] 5.76827545  1.561242e-03 6.621440 6.627938
      [264,] 3.64038550  1.480485e+00 5.994842 6.580008
      [265,] 6.01289340  4.481270e-02 5.199698 6.073609
      [266,] 2.16764633  1.919830e+00 5.466872 6.161647
      [267,] 5.73546867  2.663243e-04 6.622295 6.439681
      [268,] 1.30612607  1.301367e+00 6.870739 5.598511
      [269,] 3.21795991  1.797797e+00 5.545122 5.377941
      [270,] 2.38104634  1.982051e+00 5.423500 6.491098
      [271,] 1.37708988  1.368216e+00 6.936739 5.834334
      [272,] 4.95902647  2.706073e-01 6.791492 6.148695
      [273,] 4.22822642  9.134746e-01 5.528018 5.783573
      [274,] 1.60967995  1.572605e+00 5.619088 5.601129
      [275,] 2.87072788  1.955357e+00 6.443612 6.739688
      [276,] 5.31511606  7.788046e-02 6.583744 6.196160
      [277,] 1.51282935  1.490645e+00 6.716126 6.369949
      [278,] 6.41023552  2.337723e-01 6.376238 6.617082
      [279,] 5.16669181  1.452343e-01 5.765509 6.401681
      [280,] 5.41444584  4.405769e-02 5.966302 6.103722
      [281,] 5.07910384  1.939123e-01 5.514516 5.129466
      [282,] 3.59074649  1.523408e+00 5.350949 6.469191
      [283,] 1.75855928  1.687876e+00 6.182666 6.733708
      [284,] 1.35252515  1.345269e+00 6.118200 6.426580
      [285,] 2.81931810  1.969277e+00 6.388021 6.171185
      [286,] 6.13807454  8.924415e-02 5.701098 5.980716
      [287,] 1.39574700  1.385498e+00 5.139742 5.598658
      [288,] 2.26021572  1.952156e+00 6.273201 6.680879
      [289,] 4.08104735  1.060508e+00 6.177066 6.565359
      [290,] 3.90233219  1.236984e+00 5.923131 6.017626
      [291,] 5.61436661  4.800347e-03 6.595987 5.334877
      [292,] 2.27188742  1.955658e+00 6.003864 6.107599
      [293,] 1.25526503  1.252502e+00 6.556893 6.063040
      [294,] 3.38561922  1.685997e+00 6.766690 6.014172
      [295,] 4.89672265  3.146167e-01 5.481440 5.505543
      [296,] 5.71524428  4.076354e-06 6.393661 5.277847
      [297,] 4.63930547  5.225829e-01 5.489340 5.484008
      [298,] 1.10886958  1.108655e+00 5.698455 6.002975
      [299,] 3.32725310  1.727272e+00 5.625841 6.544198
      [300,] 4.32683818  8.158121e-01 6.185734 5.688693

# two_curvilinear() works

    Code
      two_curvilinear(n = 250, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]      [,2]      [,3]       [,4]          [,5]          [,6]
        [1,] -0.64068665 0.5162680  9.962056  -9.992557 -0.0246466353 -0.0303597360
        [2,] -1.14562676 1.4969953 10.042634  -9.971644  0.0286719019  0.0269148656
        [3,] -1.60942236 2.8278553  9.902346 -10.025999  0.0090375905 -0.0325234700
        [4,] -1.46505211 2.2778140 10.001176 -10.014361 -0.0310135099  0.0406052619
        [5,] -1.85274677 3.6343888  9.976392  -9.990217  0.0138944465 -0.0429517061
        [6,] -0.78757631 0.8706936  9.968461 -10.007295 -0.0493711286 -0.0373039443
        [7,] -0.64914351 0.5293834  9.996081 -10.041777 -0.0261650979 -0.0235617852
        [8,] -1.30166152 1.7148044  9.993438  -9.985286  0.0158594090 -0.0465717762
        [9,] -1.02935098 1.3465334  9.980170  -9.994032  0.0353473900 -0.0358979357
       [10,] -1.16157219 1.5357951 10.018144  -9.976046 -0.0489415217 -0.0193528889
       [11,] -1.34187787 1.8652564 10.012198  -9.976952  0.0191155797 -0.0093770281
       [12,] -1.38798512 2.0597965 10.016444  -9.996092 -0.0403015139  0.0038209194
       [13,] -1.90588150 3.8522460 10.029615  -9.984029  0.0459693101  0.0376510656
       [14,] -1.74163075 3.0814160 10.048598 -10.002151 -0.0438209248  0.0470694425
       [15,] -1.02202366 1.2098936  9.987547 -10.012690  0.0255604122  0.0225439527
       [16,] -1.10239271 1.3579644 10.013976  -9.983985 -0.0182058296  0.0030947095
       [17,] -1.51826545 2.4162379 10.002820  -9.986696  0.0331395424 -0.0208713121
       [18,] -1.29692509 1.8792573 10.004814 -10.026664  0.0251638927 -0.0413186719
       [19,] -0.50216725 0.4346739  9.954933 -10.021180  0.0121143198  0.0012861763
       [20,] -0.61173743 0.4685772 10.032399  -9.972813 -0.0135838595 -0.0119707113
       [21,] -1.03796457 1.1668994  9.919426  -9.989001 -0.0064484152 -0.0095294843
       [22,] -0.65120995 0.5281610  9.987815  -9.943369  0.0299037965  0.0456220332
       [23,] -1.26303288 1.8276556 10.041643 -10.033255 -0.0213027125  0.0330339241
       [24,] -1.95376959 4.0041978  9.988972 -10.005932  0.0447672747  0.0252465551
       [25,] -1.09972705 1.2891118  9.996191  -9.970941 -0.0404237678  0.0157615585
       [26,] -0.63234870 0.5173770 10.000542 -10.001107  0.0032765444 -0.0058709195
       [27,] -1.29325945 1.8195996  9.969740  -9.968648  0.0150954234  0.0298905298
       [28,] -1.90076097 3.7411617  9.998672 -10.021790 -0.0314755479  0.0471171957
       [29,] -1.54226190 2.4297078  9.988142  -9.967654 -0.0226925637  0.0139846260
       [30,] -1.01396757 1.2003758  9.999471  -9.932722  0.0141525237 -0.0219329814
       [31,] -1.02789700 1.2386925 10.026013 -10.003692 -0.0001119100 -0.0185305859
       [32,] -1.77415117 3.3265251 10.030402  -9.993386  0.0204349153 -0.0259436109
       [33,] -1.43351250 2.2993162 10.001811 -10.015903  0.0488848316  0.0320716231
       [34,] -1.85483513 3.4906192  9.955808  -9.974446  0.0214586929  0.0122858452
       [35,] -1.04986302 1.3445699  9.943900 -10.044053  0.0153261439  0.0075640236
       [36,] -1.98115012 4.1837891  9.966898  -9.994964  0.0195601537  0.0361005353
       [37,] -1.01247762 1.2730150  9.975999  -9.974919 -0.0207710271 -0.0220959383
       [38,] -1.68478525 2.8855155  9.954099 -10.008755 -0.0289871663 -0.0148026521
       [39,] -0.74526359 0.8207718  9.975662 -10.031044 -0.0429893192  0.0067970889
       [40,] -1.77115188 3.2186347  9.984712 -10.008439  0.0428698729 -0.0122637500
       [41,] -0.63579282 0.5306901  9.992617  -9.998705 -0.0009771545 -0.0002143220
       [42,] -1.63489853 2.8288959 10.033295 -10.007191  0.0195070854 -0.0095261451
       [43,] -1.76093405 3.1630652  9.995936 -10.033952 -0.0093528624  0.0383511453
       [44,] -1.22108705 1.6238572 10.004603  -9.989375 -0.0430808672 -0.0285375111
       [45,] -1.34015236 1.9417669 10.014683  -9.989302 -0.0467709012 -0.0157883245
       [46,] -1.32736480 1.9035380  9.957974  -9.989750 -0.0347616446  0.0050888009
       [47,] -1.86177679 3.7205691 10.008359  -9.990911  0.0087308710 -0.0345333143
       [48,] -1.12114271 1.3955874  9.974188  -9.997132 -0.0450407169 -0.0455619792
       [49,] -1.04607651 1.2877277  9.996934 -10.002743  0.0067803029  0.0096887467
       [50,] -1.12707945 1.3676909 10.029498  -9.978948  0.0288252228 -0.0173282908
       [51,] -1.03228240 1.1729039 10.011227  -9.990705 -0.0038166018  0.0116275290
       [52,] -0.61084315 0.6274583  9.978716  -9.966313  0.0486105582 -0.0112091000
       [53,] -1.18408013 1.5767350  9.919060  -9.949367  0.0021601004 -0.0418783873
       [54,] -1.72101199 2.9907783 10.018213 -10.034193 -0.0069361420  0.0026603673
       [55,] -1.16904604 1.5947285  9.967780 -10.031159 -0.0227345258  0.0372542120
       [56,] -0.62267344 0.4762405  9.991700  -9.941816  0.0204304920  0.0433450281
       [57,] -1.71524898 3.0570484  9.973779 -10.051034 -0.0086812787 -0.0192403497
       [58,] -0.67435665 0.6105319  9.976641  -9.988288 -0.0176266116  0.0338090247
       [59,] -0.65722357 0.5714738  9.996510  -9.998427 -0.0446591742  0.0403875436
       [60,] -0.51714996 0.3433257 10.010443 -10.008013  0.0116508403 -0.0028063231
       [61,] -1.36636436 1.9545049 10.005304  -9.984681  0.0365155592 -0.0298251742
       [62,] -1.78046037 3.3363706 10.010370  -9.991543 -0.0410749313 -0.0032823595
       [63,] -1.72209897 3.1179994  9.999015  -9.987471  0.0003489026  0.0024434743
       [64,] -1.76970958 3.2058109 10.025290 -10.022613 -0.0083496098  0.0375077707
       [65,] -1.03766749 1.2151244  9.980282  -9.970580  0.0092782517 -0.0466357397
       [66,] -1.05125866 1.3083788 10.056640 -10.015877  0.0426000219 -0.0332118956
       [67,] -0.87814906 1.0051270 10.029468 -10.014791  0.0255040729  0.0444718203
       [68,] -0.58592914 0.3592278 10.014310  -9.962313  0.0001728088  0.0162042385
       [69,] -1.08985293 1.3009808  9.960446 -10.009043  0.0028969513  0.0297408582
       [70,] -1.90777546 3.7114506 10.003358  -9.958631  0.0493421179  0.0499447828
       [71,] -1.49665521 2.4582390 10.004987  -9.967186  0.0087926188  0.0132112680
       [72,] -0.92735402 1.0508688  9.954260  -9.986179  0.0323484757 -0.0102981293
       [73,] -1.37871604 2.1191026 10.030149  -9.987736  0.0388936645 -0.0323907212
       [74,] -0.87131305 0.9623578  9.994376 -10.024292  0.0161420531  0.0481277417
       [75,] -0.73787105 0.6726092  9.956240 -10.006106  0.0405136661 -0.0353159780
       [76,] -0.64463249 0.5571378  9.951865  -9.978783  0.0340131112  0.0290311078
       [77,] -0.93842699 1.1440194  9.990505  -9.950036  0.0164936603  0.0370387824
       [78,] -1.85534643 3.4899347 10.002289 -10.036069 -0.0442476367  0.0270279932
       [79,] -1.71450158 3.2067874  9.992902 -10.017780 -0.0277410613  0.0415069370
       [80,] -1.68738998 2.9117538  9.994605 -10.009631 -0.0372946189  0.0251418293
       [81,] -1.60388938 2.6190806 10.002583  -9.981038  0.0292649085 -0.0476042713
       [82,] -1.83276631 3.5673234  9.983060 -10.000928  0.0418943465  0.0041391176
       [83,] -1.84150426 3.4385282  9.971916 -10.004521  0.0176777414  0.0303798981
       [84,] -0.87729795 0.8438348 10.006834 -10.052916 -0.0179060518 -0.0060540041
       [85,] -0.54247003 0.4332037  9.994664 -10.035941 -0.0010635727 -0.0210924581
       [86,] -0.71544624 0.6758601 10.020863  -9.953541 -0.0195397868  0.0330376656
       [87,] -0.65377490 0.5680143 10.021132 -10.014340 -0.0060524350  0.0292480736
       [88,] -1.73478512 3.0948995  9.953871 -10.015648 -0.0200844127 -0.0435781101
       [89,] -1.84612842 3.4630379 10.003353  -9.957312 -0.0063851769 -0.0143819636
       [90,] -1.03750780 1.2602633 10.054623  -9.983251 -0.0478999935 -0.0321920014
       [91,] -0.81462840 0.6942191  9.978803 -10.015052  0.0111365698 -0.0242666359
       [92,] -1.21122783 1.5997722 10.048745  -9.958013  0.0363566660  0.0249976477
       [93,] -1.35579757 1.9653873  9.990724 -10.047770  0.0254237552 -0.0177244761
       [94,] -1.30921619 1.8038626 10.029461  -9.982733  0.0221478056  0.0044021047
       [95,] -0.70397708 0.5530975  9.991839  -9.959917  0.0083099368  0.0369394224
       [96,] -1.72176400 3.1584894 10.053442  -9.953579  0.0269827349  0.0144854619
       [97,] -1.05608840 1.2089047 10.015988  -9.957424 -0.0189107459 -0.0087791027
       [98,] -1.48371153 2.3929295 10.017169  -9.955803 -0.0365085322 -0.0249628162
       [99,] -0.86020361 1.0240749 10.003891 -10.020340 -0.0393903044  0.0015996212
      [100,] -1.83002953 3.4884160  9.954069  -9.998127  0.0350126693  0.0415833517
      [101,]  0.81091700 0.8651685 10.029723  -9.994809 -0.0400356260  0.0380366813
      [102,]  0.63608528 0.5693626  9.965613 -10.018576  0.0233934288  0.0465834866
      [103,]  0.79271417 0.6968030 10.023628 -10.005186  0.0313171485 -0.0040008845
      [104,]  0.75394000 0.7044467 10.011632 -10.021983 -0.0384349646  0.0076150128
      [105,]  0.68759229 0.5258114  9.977960 -10.003145 -0.0038506775 -0.0203057111
      [106,]  1.76169001 3.2347136 10.027876 -10.027384  0.0300782986 -0.0198581789
      [107,]  1.73076839 3.1554072 10.007737 -10.031441  0.0080068660  0.0476501956
      [108,]  0.67132699 0.5050442  9.992919 -10.008146 -0.0388110975 -0.0125901363
      [109,]  1.65142277 2.9088450 10.010950 -10.050614  0.0224232804  0.0255737485
      [110,]  0.94912888 1.0839682  9.981091 -10.001315  0.0029089619 -0.0171372454
      [111,]  1.84453683 3.4817267 10.017722 -10.051287 -0.0210186607  0.0290295028
      [112,]  1.91966896 3.9133877  9.996302 -10.012202 -0.0487220891 -0.0059841295
      [113,]  0.76106906 0.8440529  9.998762  -9.932554  0.0063353033 -0.0222604845
      [114,]  0.60263627 0.4546867  9.947342 -10.024336  0.0241672918 -0.0109771356
      [115,]  1.89852363 3.6875004 10.039578 -10.013585 -0.0041039575  0.0469041090
      [116,]  1.46728220 2.3632270  9.998961 -10.027266  0.0372081593 -0.0255797171
      [117,]  0.91740502 0.9641139  9.998096 -10.028629 -0.0236420715  0.0459549752
      [118,]  1.40405954 2.1656465 10.085165 -10.001772 -0.0007637792 -0.0267173836
      [119,]  0.57547686 0.4498861  9.986121 -10.047804  0.0163263864  0.0284516421
      [120,]  0.85161261 0.8253269 10.034740 -10.038192 -0.0485800780 -0.0375702585
      [121,]  1.37081624 1.9189252  9.983615 -10.019308  0.0346247053 -0.0367650446
      [122,]  1.90885603 3.7777803  9.972622  -9.973881 -0.0324471058  0.0309639698
      [123,]  1.60392875 2.6556086 10.037247  -9.989669 -0.0028063926  0.0037136571
      [124,]  1.41385849 2.1383885  9.962745  -9.995500 -0.0365844120 -0.0317855162
      [125,]  0.55548474 0.4057890 10.011188 -10.031467 -0.0095437097 -0.0224571433
      [126,]  0.85067023 0.9160656  9.983529  -9.990195  0.0320327094 -0.0359659464
      [127,]  1.31395277 1.8432648 10.037189  -9.983084  0.0094428010 -0.0448643628
      [128,]  1.64173759 2.8293276 10.032434 -10.019745 -0.0167712621 -0.0039709064
      [129,]  0.59668236 0.4544613  9.938414 -10.003269  0.0455863151  0.0371021925
      [130,]  1.41872052 2.0974748  9.970732  -9.999606  0.0423809031 -0.0211910621
      [131,]  1.68006353 2.9591645 10.020823  -9.968017  0.0184853648 -0.0219338316
      [132,]  1.02718439 1.1508264  9.978255 -10.038147 -0.0223153867 -0.0058851186
      [133,]  0.63132568 0.4771538 10.016317 -10.034008 -0.0475741066  0.0318846274
      [134,]  1.82744704 3.5227263 10.003968 -10.001895  0.0106778947 -0.0169525247
      [135,]  1.85530339 3.6513401  9.979061 -10.034028  0.0404270058  0.0087349280
      [136,]  0.58428489 0.4749761 10.002883 -10.022670  0.0040346600  0.0121261802
      [137,]  0.96289558 1.0911152 10.012558 -10.025884  0.0387092629 -0.0012706998
      [138,]  1.38240727 1.9407261  9.995788  -9.978379 -0.0335777354 -0.0192272061
      [139,]  1.14640408 1.4276648  9.962690  -9.982148 -0.0348807987  0.0466451617
      [140,]  1.62507434 2.8511958 10.018774  -9.992165 -0.0241375537 -0.0256251766
      [141,]  0.72703776 0.6056789  9.978119 -10.062167  0.0384020367  0.0480531712
      [142,]  0.76889513 0.8095802  9.954912  -9.977042  0.0148499553 -0.0178853331
      [143,]  1.02853694 1.2927155  9.940706 -10.000334  0.0409040730 -0.0155870373
      [144,]  1.27230697 1.7504413  9.965452  -9.973125 -0.0323941917 -0.0362235341
      [145,]  1.71723242 3.0200558 10.034934 -10.000911 -0.0496299119 -0.0206181577
      [146,]  0.66040639 0.4995806 10.001276 -10.032962 -0.0105419639  0.0357071559
      [147,]  1.44381366 2.3565871  9.991944  -9.995304 -0.0320913974 -0.0400606687
      [148,]  1.76571653 3.3139331 10.006961  -9.995079  0.0359244549 -0.0219971110
      [149,]  0.69900055 0.5876116  9.978545  -9.967430  0.0372656309 -0.0163365343
      [150,]  1.36678684 2.0495352 10.014567  -9.966390 -0.0266114885  0.0195872578
      [151,]  0.68360197 0.6001919 10.028733  -9.935521  0.0049439669  0.0211302730
      [152,]  1.67266695 2.8981231 10.009757  -9.994123 -0.0369018801  0.0396419236
      [153,]  1.09027197 1.3140334  9.997965  -9.954162  0.0255862110  0.0110923532
      [154,]  0.58662980 0.4518478 10.020741  -9.983597  0.0269299798  0.0391812961
      [155,]  1.18385773 1.5138785  9.983089 -10.020982 -0.0276159731  0.0277424756
      [156,]  0.83512378 0.8402378  9.969161 -10.027915 -0.0149854349  0.0489850755
      [157,]  1.15037603 1.3849109  9.994316 -10.023216 -0.0344542947  0.0301523507
      [158,]  1.62686741 2.7796573 10.016928 -10.011228 -0.0270341264 -0.0294701772
      [159,]  1.99334455 4.2415741 10.013461 -10.006101  0.0281238979  0.0447253486
      [160,]  1.29720259 1.7503923 10.041960 -10.007125 -0.0456946079 -0.0282002091
      [161,]  1.10253064 1.2589586  9.973486 -10.039304  0.0279852576 -0.0365759518
      [162,]  1.65715836 3.0252027 10.028992  -9.981580 -0.0246647664  0.0092774051
      [163,]  1.85037110 3.5018855  9.964227 -10.019665  0.0444674614 -0.0319550125
      [164,]  0.73733041 0.7161548  9.993683 -10.011535  0.0435221594 -0.0334051919
      [165,]  1.16463076 1.4998580 10.000028  -9.976461 -0.0088350729 -0.0096876160
      [166,]  0.92602898 1.0155231  9.985175 -10.074552  0.0326332482  0.0370069354
      [167,]  1.37106838 1.9529619 10.019966 -10.005421 -0.0078391619  0.0199589521
      [168,]  1.18413025 1.5396327  9.998406  -9.972524  0.0063317120 -0.0018917130
      [169,]  1.32157268 2.0148337  9.925117 -10.038639  0.0222642435 -0.0022048189
      [170,]  1.01193934 1.1955801  9.991992  -9.988520  0.0142094533 -0.0168870137
      [171,]  0.70460409 0.6688476  9.963277 -10.024991  0.0469377057  0.0474511615
      [172,]  1.42000552 2.2116980 10.031351  -9.985472  0.0332570319 -0.0250236757
      [173,]  0.90668147 1.0848757  9.978052 -10.001007 -0.0176954782  0.0291095996
      [174,]  1.34991632 2.0078217  9.994228 -10.002034  0.0157166082  0.0456319631
      [175,]  1.78919975 3.3703319 10.016769  -9.995178  0.0346887904  0.0475459471
      [176,]  1.76896412 3.3311371 10.010322 -10.031133  0.0446391628 -0.0208746986
      [177,]  1.33693040 2.0003277  9.981545 -10.044687 -0.0148180687 -0.0112582754
      [178,]  1.00151956 1.1598487 10.063565 -10.031684 -0.0083624055 -0.0341073811
      [179,]  1.09771903 1.4395408 10.033793  -9.970447 -0.0404706010 -0.0421455409
      [180,]  1.98054293 4.0151885 10.003778  -9.979727  0.0021061570 -0.0081570214
      [181,]  1.42287612 2.2765451 10.029640 -10.020960  0.0342605341 -0.0197564095
      [182,]  1.91664587 3.8157535  9.965610 -10.068394 -0.0397209174  0.0484505952
      [183,]  1.37406667 2.0285064  9.998902 -10.020039  0.0224108175  0.0320326174
      [184,]  0.70934972 0.5840779  9.961191  -9.951393 -0.0007425372 -0.0075467648
      [185,]  0.62113243 0.4720947 10.011520  -9.964763  0.0197746748 -0.0353020210
      [186,]  0.73046317 0.6738528 10.057397  -9.993645 -0.0240005002 -0.0152449868
      [187,]  1.16555842 1.4011189 10.005171 -10.013981  0.0084897659 -0.0368450529
      [188,]  1.19395184 1.5724453  9.970658  -9.953982 -0.0186154638  0.0484752014
      [189,]  1.02984527 1.2776842  9.957002  -9.965733 -0.0196606750  0.0145270658
      [190,]  1.21716710 1.5653626  9.987141  -9.964919 -0.0476733031  0.0123740624
      [191,]  1.21624824 1.6790805 10.013117 -10.056343 -0.0079788845 -0.0407154984
      [192,]  1.37548407 2.1292362  9.975929  -9.993361 -0.0096360007  0.0082684050
      [193,]  1.60220196 2.6845038  9.954842 -10.023583  0.0422849359  0.0005035731
      [194,]  1.47581382 2.3607608 10.005251  -9.972228  0.0096345347  0.0273028755
      [195,]  1.52728345 2.4633291  9.974932  -9.997335  0.0117229666 -0.0161636332
      [196,]  0.65659155 0.6111451 10.033270  -9.967481 -0.0351311293  0.0258473551
      [197,]  1.77146233 3.2357534  9.937051 -10.069314  0.0052423162  0.0388338244
      [198,]  0.64751666 0.6436561 10.009260 -10.021986 -0.0353690719 -0.0229592581
      [199,]  1.75887356 3.2057888 10.009625  -9.994176 -0.0145336741  0.0124106927
      [200,]  1.10910364 1.3008643  9.988104  -9.955719  0.0258576252 -0.0136160975
      [201,]  0.27865525 0.6447384  9.989359 -10.036656  0.0373581534 -0.0287596528
      [202,]  0.63501393 1.6127626  9.990695  -9.991234  0.0483009097  0.0148003248
      [203,]  0.31839669 1.2273055 10.003089  -9.998386 -0.0399802218  0.0270577303
      [204,]  0.08256774 2.1912864  9.999226 -10.034481 -0.0460939502  0.0345774974
      [205,]  0.01007744 0.6503867  9.982316 -10.019784  0.0403142707 -0.0293564787
      [206,] -0.12000988 1.2747334  9.971106  -9.972228 -0.0069598126  0.0333989013
      [207,] -1.04763081 0.7609024 10.003629  -9.960635 -0.0084743712 -0.0046153712
      [208,] -0.10915583 1.2468401  9.963161 -10.001167  0.0123832032  0.0422258466
      [209,]  0.43076958 1.2507871  9.978911  -9.958977 -0.0396350289 -0.0463215775
      [210,] -0.76292862 2.0982328  9.969236 -10.059247  0.0258205185  0.0228497851
      [211,] -0.86407715 1.5546787  9.989315 -10.058612  0.0366614435  0.0156579840
      [212,]  0.12697248 0.8805696 10.042476 -10.057253 -0.0173215574  0.0339446843
      [213,]  0.18893400 1.4447162 10.044069 -10.003181  0.0234004494  0.0309171630
      [214,]  0.28389414 1.8800962 10.009220 -10.045042  0.0226957487  0.0162746326
      [215,]  0.21268094 2.1379402 10.029068  -9.989657  0.0037979327 -0.0207092173
      [216,]  0.09915876 1.1277901 10.043778 -10.049381  0.0136277327 -0.0239421536
      [217,]  0.56603116 0.6149125  9.985424  -9.988796  0.0403580836  0.0009716894
      [218,]  0.09558317 1.1065065 10.006898 -10.033287 -0.0363383943 -0.0274106946
      [219,]  0.67576619 1.4894153  9.999507 -10.004756 -0.0367771948  0.0380198223
      [220,]  0.44299183 1.3272533  9.984370 -10.033980  0.0155085563  0.0485247135
      [221,] -0.20003574 1.1432773  9.984809 -10.022273  0.0336633054 -0.0179583907
      [222,] -0.30252226 0.8543983 10.017681 -10.029022 -0.0130527864 -0.0171249152
      [223,]  0.56448465 1.6868667  9.974914  -9.973045 -0.0447277976  0.0204849507
      [224,]  0.42563883 1.0883976  9.993548  -9.945500 -0.0415772713 -0.0179980048
      [225,] -0.49911763 2.3291239 10.010588  -9.987129  0.0365474737  0.0350112810
      [226,]  0.16360406 2.0836186 10.035304  -9.970362  0.0083916613  0.0322723470
      [227,]  0.05212157 2.1934798 10.024331  -9.981487 -0.0307570757  0.0409875852
      [228,]  0.21438669 1.9141780  9.996581 -10.038963  0.0458279741 -0.0472463219
      [229,]  0.27298393 0.8453568 10.025015  -9.986200 -0.0212873796 -0.0134920967
      [230,] -0.17842196 1.3775745 10.032583  -9.996843 -0.0329685016 -0.0032567904
      [231,] -0.37429259 0.8145187 10.014340 -10.028136  0.0119761993 -0.0285329087
      [232,]  0.40310579 1.6533315 10.075129  -9.982263  0.0296102357 -0.0335137849
      [233,]  0.48319545 2.1540502  9.948309 -10.019733 -0.0220758918 -0.0423664921
      [234,]  0.39355522 0.6564335 10.017514 -10.020272  0.0107386628  0.0134145463
      [235,] -0.10941356 1.2936162 10.013504 -10.098070  0.0491454314  0.0458375993
      [236,] -0.60038036 1.9899892 10.001978 -10.020888 -0.0133206401  0.0167461503
      [237,]  0.07144169 3.2841364 10.054593 -10.000585 -0.0300680688  0.0239781460
      [238,] -0.17506296 1.0308878 10.028688 -10.009699  0.0360130097 -0.0402660282
      [239,] -0.53461177 2.1978465 10.017878 -10.042598  0.0383316165  0.0194831758
      [240,]  0.25344470 1.0951227 10.010693 -10.022718 -0.0102652837 -0.0450241640
      [241,]  0.23473542 1.8407150 10.005307  -9.980768  0.0128983588  0.0295578158
      [242,] -0.44280784 1.9858652 10.010585  -9.973451  0.0440748508 -0.0347286321
      [243,] -0.18515101 1.0697482  9.969119  -9.987475 -0.0488280118  0.0123693719
      [244,] -0.59036577 0.9144735  9.989477  -9.920990  0.0376225896  0.0065094367
      [245,]  0.04506284 1.4999819 10.026161 -10.005149  0.0355459322  0.0333256996
      [246,]  0.36008914 1.7319719  9.998701 -10.007709 -0.0359852067 -0.0418847026
      [247,] -0.67756579 1.5520089  9.962427  -9.987782 -0.0412567737 -0.0047995879
      [248,]  0.19731114 2.4247778  9.964294 -10.010934  0.0170483147 -0.0098169956
      [249,]  0.14720763 1.8196754 10.026064 -10.027726  0.0223214171 -0.0229965936
      [250,] -0.08942517 1.1851129  9.997223  -9.980347  0.0398934386  0.0450571919

---

    Code
      two_curvilinear(n = 250, num_noise = 0)
    Output
                    [,1]      [,2]      [,3]       [,4]
        [1,] -1.85852763 3.5684742  9.995458 -10.046141
        [2,] -1.37748595 2.1305819  9.946784 -10.000170
        [3,] -0.51239058 0.3997076  9.990987 -10.047566
        [4,] -0.79208276 0.8651298  9.980738 -10.025987
        [5,] -1.03299221 1.1865057 10.024794 -10.017682
        [6,] -1.65226726 2.7424935  9.990706 -10.047657
        [7,] -0.76772269 0.7108808  9.985856 -10.027770
        [8,] -1.47659887 2.3376490 10.042896  -9.994972
        [9,] -1.52496961 2.3836547 10.061632  -9.959056
       [10,] -1.89776780 3.7757513  9.984052  -9.979247
       [11,] -1.77485119 3.2550294  9.974050  -9.963747
       [12,] -1.87118815 3.6967473 10.049964  -9.978951
       [13,] -1.22955806 1.6099327  9.988600 -10.010233
       [14,] -0.91119973 0.8883395 10.001185 -10.035918
       [15,] -1.88740831 3.7526253 10.023304 -10.054405
       [16,] -0.91874685 1.1225143 10.009819 -10.022442
       [17,] -1.26707561 1.6586909  9.997980  -9.989270
       [18,] -0.63713467 0.4480295  9.990866 -10.016927
       [19,] -0.63255193 0.5844784  9.992819 -10.038890
       [20,] -0.86735187 0.8762722 10.038459 -10.052285
       [21,] -0.51006639 0.4480578 10.010738  -9.987137
       [22,] -0.96089710 1.1144462 10.001603 -10.037731
       [23,] -1.89295562 3.8037346 10.033835 -10.032316
       [24,] -1.89213226 3.5907767 10.029941 -10.025689
       [25,] -0.66791717 0.4962037  9.948333  -9.969863
       [26,] -1.06910120 1.3074564 10.027739  -9.989282
       [27,] -1.08891716 1.4333662 10.021330 -10.000308
       [28,] -0.86338337 0.9649848  9.992757 -10.062935
       [29,] -1.68078589 3.0207955  9.939133 -10.014401
       [30,] -1.97217894 3.9552322 10.000442 -10.000692
       [31,] -0.59119140 0.4948738 10.009627 -10.009128
       [32,] -1.93437835 3.9360101 10.002235 -10.026311
       [33,] -1.86640503 3.5805568  9.986792  -9.998597
       [34,] -1.53434841 2.4356536 10.011683  -9.987241
       [35,] -1.08390212 1.3589465 10.002950  -9.985604
       [36,] -1.47242700 2.4162642  9.989307  -9.977883
       [37,] -1.91769123 3.8057553 10.001035  -9.971098
       [38,] -1.56553811 2.6017275  9.959071 -10.005999
       [39,] -1.34691429 2.0059794  9.998170  -9.967721
       [40,] -0.60892742 0.4517563 10.000174 -10.016207
       [41,] -1.33199886 1.9423861 10.054919 -10.022614
       [42,] -0.63129769 0.6582714  9.990460  -9.965382
       [43,] -0.78440077 0.8315154  9.998622  -9.989934
       [44,] -1.08998969 1.3268728  9.994345 -10.023312
       [45,] -1.57256397 2.6006699  9.940881  -9.968294
       [46,] -1.11698525 1.4465640  9.995637 -10.019570
       [47,] -1.05177967 1.3663633  9.955989 -10.010265
       [48,] -1.62828798 2.8112300  9.963917  -9.970771
       [49,] -1.49932248 2.3895544  9.992305  -9.986186
       [50,] -1.96055820 3.9255308 10.037516 -10.019572
       [51,] -1.42141519 2.2429761 10.020111 -10.039234
       [52,] -0.86227546 0.8621128  9.962970  -9.984819
       [53,] -0.51895971 0.4278165 10.014832 -10.044426
       [54,] -1.32621257 1.8598441  9.923227 -10.041709
       [55,] -0.71648342 0.6714298  9.984932  -9.969272
       [56,] -1.67202242 2.8999995  9.979176 -10.021062
       [57,] -0.79710397 0.7896462  9.979022  -9.990535
       [58,] -1.64713581 2.7716741  9.964865  -9.991149
       [59,] -1.99650080 4.1306711  9.944817 -10.004870
       [60,] -1.04242506 1.2333282 10.023321  -9.997314
       [61,] -0.99455890 1.0845787  9.950934  -9.971518
       [62,] -1.40798407 2.1521330  9.976697  -9.961567
       [63,] -1.63099243 2.8379358  9.987992  -9.973723
       [64,] -1.19065726 1.5305287 10.023769  -9.957122
       [65,] -0.86842977 0.8368203 10.013263  -9.997968
       [66,] -1.25413448 1.7341808 10.043926 -10.031369
       [67,] -1.62889480 2.8746547  9.987187 -10.022020
       [68,] -1.05065421 1.2050195  9.987283 -10.014249
       [69,] -0.94200434 1.1362044  9.979710  -9.977258
       [70,] -1.76691802 3.1464781  9.994846 -10.000668
       [71,] -0.72467275 0.6098528 10.016657  -9.973783
       [72,] -1.86490972 3.6643247 10.033757  -9.945495
       [73,] -1.51421867 2.3447240 10.002026 -10.018126
       [74,] -1.92226034 3.8975279 10.015905  -9.972824
       [75,] -0.52973267 0.4080749  9.953516 -10.011810
       [76,] -0.53127682 0.5166468 10.043066 -10.018965
       [77,] -0.54814153 0.4692842  9.993565 -10.037796
       [78,] -1.19482356 1.5369185  9.985019  -9.951700
       [79,] -1.67675841 2.8892662  9.999459  -9.999581
       [80,] -0.89308939 1.0534338 10.043523  -9.998752
       [81,] -1.76363330 3.1762704  9.973941  -9.972515
       [82,] -1.61871848 2.7496124 10.000434 -10.019705
       [83,] -0.67153790 0.5563641  9.984014  -9.955964
       [84,] -1.59754804 2.7506594 10.013242 -10.036897
       [85,] -0.66075360 0.5418992 10.009455 -10.043621
       [86,] -1.82736585 3.6067159  9.991241  -9.984486
       [87,] -1.26649142 1.7174163 10.012075 -10.032031
       [88,] -1.97594285 4.0190444  9.984288  -9.987442
       [89,] -1.75296185 3.1310691  9.977931  -9.976343
       [90,] -1.50017408 2.4317612  9.975446  -9.981767
       [91,] -1.23658362 1.6910114  9.996018 -10.014758
       [92,] -0.66417481 0.6356790 10.080489  -9.984311
       [93,] -0.72788460 0.7932648  9.986252  -9.971036
       [94,] -1.74638336 3.1515663 10.028735  -9.978703
       [95,] -1.38674897 1.9729713  9.979159  -9.981013
       [96,] -1.29141631 1.7523809 10.012215 -10.005618
       [97,] -0.59859174 0.5723431  9.996758 -10.017443
       [98,] -1.50896365 2.5164990  9.972353 -10.043685
       [99,] -1.64837281 2.9032841  9.995416  -9.963856
      [100,] -0.87003565 0.8681277  9.972247 -10.010161
      [101,]  1.08936130 1.4485221  9.982063  -9.980257
      [102,]  1.79475893 3.4018793  9.986688  -9.992796
      [103,]  1.77274849 3.3026508 10.026502 -10.000705
      [104,]  1.42658702 2.1816926 10.004067 -10.048224
      [105,]  0.67473421 0.6283837  9.991365  -9.989301
      [106,]  1.08376759 1.2739325 10.004962  -9.990355
      [107,]  1.97326427 4.0545782  9.994657 -10.061174
      [108,]  1.22380243 1.7166163  9.927590  -9.974465
      [109,]  1.77163283 3.4080410  9.993931 -10.021960
      [110,]  0.66389684 0.5121032  9.923934 -10.020209
      [111,]  1.53195237 2.4590515 10.035986 -10.063599
      [112,]  0.72477231 0.7463881  9.952230 -10.016867
      [113,]  1.89568135 3.6534564 10.063383 -10.036839
      [114,]  1.44521119 2.1720833 10.058228  -9.975653
      [115,]  1.59706098 2.7715586  9.990270  -9.975953
      [116,]  1.75299254 3.2268116  9.958698 -10.031218
      [117,]  1.57401691 2.5811980 10.008385 -10.008064
      [118,]  1.46452575 2.3702977 10.011359 -10.004105
      [119,]  1.35552034 2.0411760  9.995514 -10.017966
      [120,]  1.38366351 2.0624030 10.019616 -10.034485
      [121,]  0.93773164 1.0003315  9.973420  -9.956410
      [122,]  1.32421542 1.8630934 10.006867  -9.992160
      [123,]  0.97955131 0.9917063 10.004025  -9.967258
      [124,]  0.94332156 1.0276558 10.045079  -9.998753
      [125,]  0.88178678 0.9581979  9.989975  -9.970520
      [126,]  1.73798320 3.0772743 10.009850  -9.953924
      [127,]  1.93295915 3.8897820  9.988990  -9.988088
      [128,]  0.83178844 0.8741963  9.980347 -10.061707
      [129,]  0.64302492 0.5073363  9.996723  -9.976749
      [130,]  0.74063286 0.7055653  9.957115 -10.026518
      [131,]  0.86637818 0.9766715 10.000489  -9.972461
      [132,]  1.40005667 2.0493136 10.006046  -9.975532
      [133,]  0.56741218 0.4806361 10.003211 -10.021947
      [134,]  0.67330833 0.4850753  9.999527 -10.010576
      [135,]  1.01936593 1.2251733  9.956388  -9.949834
      [136,]  1.85000361 3.5180095 10.010140  -9.964031
      [137,]  1.27204379 1.7259880  9.964559  -9.992642
      [138,]  1.80228045 3.5125468  9.998401  -9.973336
      [139,]  1.46997319 2.2273364 10.016952 -10.018556
      [140,]  0.88687280 0.9067281 10.003344  -9.964069
      [141,]  1.04702924 1.2053628 10.014087 -10.022346
      [142,]  0.51837041 0.5388831  9.979161  -9.963033
      [143,]  1.88814117 3.6503508  9.992614 -10.034530
      [144,]  1.98348846 3.9745526 10.008337 -10.016311
      [145,]  0.53561468 0.4952795 10.036204  -9.973778
      [146,]  0.74763039 0.6468938 10.038815  -9.966320
      [147,]  1.88912867 3.8022127  9.959013  -9.976635
      [148,]  0.72097921 0.7596948  9.965793 -10.014382
      [149,]  1.59568426 2.7066990 10.044663 -10.018355
      [150,]  0.89008432 0.9906294 10.023933  -9.981877
      [151,]  1.12825200 1.3466330  9.936163  -9.949233
      [152,]  1.63884084 2.9013844  9.980957 -10.014254
      [153,]  1.48536690 2.4088696  9.974866  -9.957928
      [154,]  0.65021725 0.5045201 10.088788 -10.045359
      [155,]  0.80053425 0.7170681  9.981632 -10.017794
      [156,]  1.40647485 2.0389037  9.979124  -9.985462
      [157,]  0.54045756 0.4938427  9.949985  -9.976166
      [158,]  1.92829228 3.8705320  9.994242 -10.057610
      [159,]  0.63046731 0.6407361  9.973213  -9.990915
      [160,]  1.50342207 2.4143700  9.958879  -9.999130
      [161,]  1.57569654 2.6899062  9.947801  -9.991584
      [162,]  1.97602562 4.0130867  9.969470  -9.978866
      [163,]  1.73768426 3.0582961  9.985708  -9.967506
      [164,]  1.51707018 2.3445686  9.973856  -9.992594
      [165,]  0.73503368 0.6981358  9.956211  -9.932030
      [166,]  0.95216547 1.0164355 10.055058 -10.006522
      [167,]  1.55464723 2.6185905 10.018605 -10.025828
      [168,]  1.03554190 1.2930352  9.977564  -9.991473
      [169,]  1.64252698 2.8444789 10.022480 -10.013835
      [170,]  0.91782825 0.8619136 10.059717  -9.978518
      [171,]  1.02342817 1.2708819 10.020110 -10.023799
      [172,]  1.09506243 1.3139946 10.047387 -10.024957
      [173,]  1.56618772 2.6307785 10.024295  -9.945663
      [174,]  1.08904283 1.4464636  9.942496 -10.023486
      [175,]  1.03547086 1.2045000 10.012550 -10.010265
      [176,]  0.50195296 0.4041767  9.990286 -10.007876
      [177,]  0.56235309 0.5458451 10.037907 -10.027377
      [178,]  0.56832599 0.4615431 10.020472 -10.039112
      [179,]  1.07797333 1.4089120  9.979989 -10.043016
      [180,]  1.31997306 1.8927319  9.948966 -10.036984
      [181,]  1.21375442 1.5932707 10.038056  -9.991381
      [182,]  0.83615158 0.8960066 10.016827  -9.964571
      [183,]  0.84106699 0.7844890 10.022470  -9.990629
      [184,]  0.70355977 0.6813129  9.974433  -9.976959
      [185,]  0.78600897 0.8685672  9.958391 -10.003846
      [186,]  1.69477999 3.0986760  9.987034  -9.983597
      [187,]  1.55892505 2.5457225 10.008156  -9.993133
      [188,]  1.93884161 3.8445728 10.034814 -10.018555
      [189,]  1.96685645 4.0524266  9.992974  -9.992157
      [190,]  0.64213224 0.4903820  9.967441 -10.003000
      [191,]  1.70727543 3.0521864  9.967868 -10.004092
      [192,]  1.01410525 1.1077537 10.069904 -10.020287
      [193,]  1.83808510 3.4972513  9.995045  -9.967793
      [194,]  1.19406600 1.6451502 10.029981 -10.013016
      [195,]  1.57516651 2.6724582 10.012363 -10.002682
      [196,]  0.65467749 0.6236780  9.976746 -10.016920
      [197,]  1.80031121 3.3738516  9.995147  -9.928743
      [198,]  1.53900688 2.4545159  9.946211  -9.972119
      [199,]  1.49461699 2.3854099 10.022702 -10.056459
      [200,]  1.96770964 4.0075337 10.057728 -10.018302
      [201,] -0.48138764 1.5295172 10.048635 -10.035214
      [202,]  0.07678215 1.1946128 10.031952  -9.992934
      [203,] -0.38308085 1.3606762  9.971754  -9.988768
      [204,] -0.50130608 2.0845289 10.034476  -9.981253
      [205,] -0.10659229 1.4727425  9.990730 -10.015145
      [206,]  0.77748081 1.5804204  9.996894  -9.996777
      [207,] -0.32955170 1.7131149 10.009843  -9.996211
      [208,]  0.38431057 2.0821882  9.985918  -9.982983
      [209,] -0.63337331 1.0997411  9.973318  -9.977519
      [210,]  0.32661443 2.1314883 10.029878  -9.978366
      [211,] -0.55645846 2.6378193 10.024111  -9.949406
      [212,] -0.44014800 1.9816370 10.029973  -9.962575
      [213,]  0.09982442 1.4202484 10.035516  -9.998000
      [214,] -0.19049599 1.9568913 10.066512 -10.057581
      [215,]  0.33450470 1.5588758 10.045332 -10.051532
      [216,]  0.36480327 1.1133768  9.972106 -10.010344
      [217,]  0.46307875 1.8955577  9.967926 -10.001737
      [218,] -0.46170062 1.8624142  9.959453 -10.008707
      [219,] -0.64776369 1.8227705 10.016252 -10.040968
      [220,]  0.30714839 1.8737762 10.030352 -10.029371
      [221,] -0.31352516 1.0162430 10.046476 -10.008951
      [222,]  0.25190218 1.9530832  9.952571 -10.018132
      [223,] -0.80363626 0.2056040  9.950181  -9.975159
      [224,]  0.17334573 2.7910597  9.967351 -10.046516
      [225,]  0.31981150 2.3467624  9.991033  -9.978374
      [226,] -0.19821220 1.8129707  9.996197 -10.012455
      [227,] -0.81285555 1.1802454  9.947380 -10.021579
      [228,]  0.27317027 1.7028477  9.959171  -9.979304
      [229,] -0.52545821 0.9327895 10.051571  -9.996484
      [230,]  0.35252080 1.5718775 10.044798  -9.983113
      [231,]  0.03205191 1.5103664  9.985474  -9.975197
      [232,]  0.41701271 1.6133838  9.969584  -9.961473
      [233,] -0.15015651 1.4440883  9.990276  -9.990698
      [234,]  0.45099545 1.6027748  9.917895  -9.975569
      [235,] -0.37029346 1.2527036 10.013978  -9.976824
      [236,] -0.42655709 0.4683123  9.992377  -9.989666
      [237,] -0.03457865 1.2389911 10.018578  -9.983431
      [238,]  0.19243550 0.5284902 10.013840 -10.007899
      [239,]  0.03956509 0.9268049 10.001418  -9.985167
      [240,] -0.04604069 1.9241095 10.017398  -9.989255
      [241,]  0.07234764 0.8450580 10.001476 -10.003177
      [242,]  0.26178964 1.7819400 10.012459  -9.995754
      [243,] -0.34318940 2.4189473 10.035973 -10.042778
      [244,] -0.52556530 1.5598298 10.039366  -9.976154
      [245,]  0.44639668 1.5719971 10.027327 -10.047430
      [246,]  0.16393655 2.5892876 10.040771  -9.992175
      [247,] -0.08777842 1.8479432  9.975172  -9.986480
      [248,]  0.41692494 1.4812059  9.974866 -10.015298
      [249,] -0.15235736 1.3531122 10.068433  -9.938175
      [250,]  0.33609191 1.0640479  9.980909 -10.068295

# swiss_roll() works

    Code
      swiss_roll(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                   [,1]        [,2]        [,3]          [,4]          [,5]
        [1,] 10.2481231   8.4037765 0.318872707 -1.458899e-02 -0.0121654471
        [2,] -7.9894855  -6.1470400 6.249625811  2.865623e-02  0.0243803850
        [3,]  4.5480029   5.5383958 8.903630597  2.609781e-02 -0.0369256699
        [4,] -1.7586139   7.8797043 3.788575628  4.110739e-02  0.0122989997
        [5,]  4.5030550  -3.3919202 5.777703228  4.965122e-02 -0.0454273297
        [6,] 11.9882039  -2.8841928 9.331166439  3.251858e-02 -0.0106775143
        [7,] 10.6371732   7.8161635 4.038184236 -2.281042e-02  0.0372808408
        [8,] -8.6249562   2.9023078 0.955346192 -4.688578e-02  0.0463457931
        [9,] -1.9824862 -10.6278340 9.974507350  3.585914e-02  0.0350516201
       [10,] -8.4791338  -5.2642569 6.526530553 -4.046627e-02 -0.0488583200
       [11,] -7.4137302   4.8285323 1.342885210  1.089824e-02 -0.0473777195
       [12,] -5.5379801   6.5243067 3.408088041  3.413554e-02  0.0104406092
       [13,]  2.9568097  -4.4030752 8.144356858  3.089505e-02  0.0455540076
       [14,]  6.3270129   0.3330166 0.505952255 -4.024651e-02  0.0146565949
       [15,] -1.4976146 -10.7534109 7.893889458  2.819042e-02 -0.0151881842
       [16,] -6.2101014  -8.2827012 3.640456786  3.771454e-02 -0.0097940761
       [17,]  0.8862442   7.6883056 4.763100885  4.630252e-03 -0.0020904814
       [18,] -8.7359723   2.6530308 8.057227228  4.492376e-02 -0.0167296790
       [19,]  0.1923175  14.1222403 6.843697676 -1.361151e-02  0.0105308289
       [20,]  8.6763500  10.2578195 0.404668932  2.761497e-02 -0.0256906810
       [21,] -2.5417015 -10.4524434 1.519388198 -7.016805e-03 -0.0195198813
       [22,] 10.7271957   7.6698455 4.579940606 -7.230506e-03 -0.0297583484
       [23,] -9.3115824   0.7642161 8.092995663 -1.352021e-02 -0.0110993539
       [24,]  1.4328533  -4.7932841 7.332632295  4.457019e-02  0.0149155190
       [25,] -6.0803325  -8.3991138 1.114380751  1.310034e-03 -0.0161889479
       [26,]  9.8327151   8.9641835 1.399474347  9.513795e-03 -0.0473662638
       [27,] -8.8169405   2.4573227 5.554778329 -3.003845e-02  0.0274509448
       [28,]  3.1157027  -4.3318016 3.920217387 -6.382821e-03  0.0041588190
       [29,]  1.9914329   7.3224758 2.036450787  2.444980e-02 -0.0336625336
       [30,] -0.9560504 -10.8658346 4.003215141  2.677100e-02  0.0356275376
       [31,] -1.8869059 -10.6544972 5.645707923 -4.704865e-02  0.0201683607
       [32,]  6.0609802  -0.9268565 8.095455044  2.961780e-02  0.0039741894
       [33,] -3.3559086   7.5603886 7.508898443 -3.370171e-02  0.0189006558
       [34,]  4.4477850  -3.4426820 1.806592804 -1.654683e-02  0.0339453720
       [35,] -3.2922595 -10.1622852 8.540346581 -1.833225e-02 -0.0395484263
       [36,]  0.5708133  -4.7969839 9.285962505  3.866709e-03  0.0351578433
       [37,] -0.8550213 -10.8836414 8.442853487  4.063287e-02  0.0118455134
       [38,]  6.1388860   2.6663732 1.583703898 -3.401228e-02 -0.0028928479
       [39,] 12.5905529   0.3748019 9.540663501 -4.455656e-03 -0.0416045885
       [40,]  6.0960487  -0.8149758 3.773949752 -2.337754e-02  0.0133551081
       [41,] 10.0080793   8.7350914 4.774731784 -6.600727e-03 -0.0362976748
       [42,]  5.2526150   4.6367580 4.513485997 -7.430371e-03 -0.0314172552
       [43,]  6.1998249  -0.4266035 1.289548583  4.363294e-02 -0.0177489534
       [44,] -9.4483614  -1.7355752 3.081095926 -4.190935e-02  0.0081208988
       [45,] -7.4747916   4.7536903 3.305280874 -3.425425e-02 -0.0158661866
       [46,] -7.9032491   4.1759627 2.652547152  3.860183e-02 -0.0091859393
       [47,]  4.2601537  -3.6051646 9.646050469  7.435258e-03  0.0290953855
       [48,] -7.0593222  -7.4100717 6.404719518 -4.040416e-02 -0.0205360916
       [49,] -3.0563679 -10.2605305 5.277440599  4.276738e-02  0.0080636337
       [50,] -7.3040365  -7.1156247 2.802184133 -2.994692e-02 -0.0155338238
       [51,] -2.1741789 -10.5714776 4.854010744  4.456985e-02 -0.0260286279
       [52,]  8.6221801  10.3107194 8.268024425  1.082111e-02  0.0446097311
       [53,] -9.0070203  -3.9596480 5.695264961  1.241861e-02 -0.0452089297
       [54,]  6.3583785   1.1710749 0.094310297  1.631652e-02 -0.0023271855
       [55,] -8.6758884  -4.8375538 8.742913639 -3.040836e-03  0.0385375064
       [56,]  9.3122946   9.5886115 0.981331794  4.027878e-02  0.0073803334
       [57,]  6.3471654   1.4083378 1.217604685  9.351035e-03  0.0223295768
       [58,] 11.5961684   5.9677097 6.380142334  1.717753e-02  0.0060656726
       [59,] 10.9777279   7.2383449 3.581919970  7.135615e-03  0.0125904391
       [60,]  1.5088348  13.9480385 3.388932224  3.335375e-02 -0.0433271786
       [61,] -6.4716708   5.8048978 0.430065477 -3.431115e-03 -0.0236326260
       [62,]  5.9805678  -1.1587931 6.728113880 -1.866506e-02  0.0215880999
       [63,]  6.3595032   1.1264308 7.222092994  2.138503e-02  0.0012344324
       [64,]  6.1121766  -0.7608187 0.119863527 -4.667769e-02 -0.0378674791
       [65,] -2.5226238 -10.4589843 4.254133280  3.253958e-02  0.0059894086
       [66,] -3.3784699 -10.1247067 8.342567140 -2.804652e-02 -0.0469727421
       [67,]  8.1502481  -8.4793254 8.556029391 -9.009592e-03  0.0461123795
       [68,]  6.9897752  11.6631246 0.330067349  2.988130e-02 -0.0005639224
       [69,] -5.5810747  -8.8123555 2.877228602  7.058739e-03  0.0384549295
       [70,]  2.8976886  -4.4279914 2.126179852 -1.708714e-02  0.0081629527
       [71,] -0.1654884   7.8732586 9.881305785 -2.566097e-02 -0.0439266545
       [72,]  5.0476244 -10.2796064 7.541483133 -3.205063e-02 -0.0270945408
       [73,] -5.9485562   6.2330308 9.496077376 -2.594132e-02  0.0183671580
       [74,]  8.5378894  -8.1512039 8.292156688  3.803132e-02 -0.0063818733
       [75,] 12.6058845   0.9625392 4.597334778  4.379304e-02  0.0199030881
       [76,] 10.4337478   8.1319032 3.571535943 -1.434154e-02 -0.0273078126
       [77,]  4.2945508 -10.5412037 8.296375847 -4.449161e-03 -0.0422621792
       [78,]  4.4341682  -3.4549785 0.053553383 -7.503827e-03 -0.0466499872
       [79,]  6.3450615   1.4391675 8.606977584 -4.656778e-02 -0.0211679828
       [80,]  6.1665839   2.5592783 2.971070099 -2.710841e-02  0.0430941616
       [81,]  4.3738679   5.7207453 1.336690679  2.600811e-02  0.0192067729
       [82,]  5.0012681  -2.8637748 7.991453141 -3.284313e-02  0.0224289806
       [83,]  4.7905087  -3.1040475 1.439131112 -4.479017e-02 -0.0419177369
       [84,]  8.1992020  -8.4394555 1.923155410 -3.177405e-02 -0.0036740666
       [85,]  3.6574840  13.3794090 2.734680581  1.214109e-02  0.0444345651
       [86,] 12.4833805   2.7536392 3.511364465 -2.545728e-03  0.0186018101
       [87,] 10.8361458   7.4868160 5.347585659 -3.369623e-02 -0.0217545194
       [88,]  6.3496577   0.6088699 2.849355498 -3.942831e-02  0.0218025423
       [89,]  4.6743992  -3.2254024 1.806253111  1.072001e-02 -0.0409240471
       [90,] -2.5123630 -10.4624856 8.716031015 -4.184796e-02  0.0115609377
       [91,] 11.1714155  -4.8033668 0.019821257 -4.625760e-02 -0.0439113088
       [92,] -9.3829110  -2.3321148 3.722792580 -2.384936e-02 -0.0342168524
       [93,] -6.8947906   5.4037049 4.412225892 -2.029594e-02 -0.0422080951
       [94,] -8.4333083   3.2910332 2.423874566 -3.089043e-05  0.0402214550
       [95,] 12.3217885   3.6658512 2.265771236 -2.164460e-02 -0.0429658090
       [96,]  6.3591900   1.1401844 8.539217352  7.280862e-03  0.0452402598
       [97,] -3.6736389  -9.9890561 3.193913724 -5.159603e-03  0.0251115222
       [98,] -0.8128571   7.9146934 5.444841450  4.571919e-02  0.0290669307
       [99,]  9.1393385  -7.5804330 9.714739081  4.371184e-02 -0.0024890576
      [100,]  5.0648381  -2.7856423 6.798799008 -8.465952e-03 -0.0189063230
      [101,]  0.7810953  14.0599896 1.029736609  9.797570e-03 -0.0292722002
      [102,] -6.4230446  -8.0827927 7.907631751 -2.422641e-02 -0.0409276481
      [103,] -6.4228390  -8.0829914 9.223601813  3.277202e-02 -0.0304857217
      [104,] -8.5727346  -5.0678802 2.856899777 -9.997107e-03 -0.0330706669
      [105,] 12.3791316   3.3833884 0.005667093 -3.069320e-02 -0.0374938477
      [106,] -2.8684725 -10.3340972 1.431482059  1.476614e-02  0.0341126673
      [107,]  3.9585739   6.1084563 5.156373021 -1.839283e-02  0.0320512261
      [108,]  0.6256093  -4.8013708 3.766032541  2.645821e-02 -0.0385782004
      [109,] 11.9802577   4.9357582 2.156606854  1.278195e-02  0.0267615181
      [110,] -8.4288506  -5.3653837 1.491701941 -4.227686e-02 -0.0200580744
      [111,] -3.3534055   7.5611555 1.465608762 -9.606105e-03  0.0396357887
      [112,] -1.5639943 -10.7376317 9.231425016 -2.830282e-02  0.0446445973
      [113,] -7.9812509  -6.1602420 4.480375352 -4.181241e-02 -0.0325953962
      [114,] -3.5457660   7.4996628 1.105307555  1.311135e-02 -0.0431575823
      [115,]  3.5120688  -4.1251295 4.134240891  1.880957e-02  0.0432349087
      [116,]  3.3755038 -10.7829624 7.320405915  1.712295e-02  0.0144854801
      [117,]  6.1872674  -0.4795939 2.543087220  7.884755e-03 -0.0221729990
      [118,] -2.0905813   7.8406285 1.841108254  4.200629e-02  0.0102706363
      [119,] -8.2583590   3.6095284 7.273448752  2.877043e-02 -0.0449682095
      [120,] 12.3564859   3.4988765 1.335051104  3.228527e-02 -0.0265591595
      [121,] -6.6991834  -7.8057178 6.578486669  2.788319e-02  0.0080544160
      [122,]  5.4384309  -2.2600244 5.701355173 -1.741983e-02  0.0439237355
      [123,]  4.0594884 -10.6109468 7.081990386  5.182130e-03  0.0235952500
      [124,] -5.2154786   6.7287462 3.107754190 -2.974713e-02  0.0109238994
      [125,] -7.7452581  -6.5205198 8.382160873  2.027644e-02 -0.0463010175
      [126,] 10.9751625   7.2429612 0.390076055  6.945097e-03 -0.0266219847
      [127,] -2.0034807   7.8522372 9.473783465 -2.858230e-03  0.0042635182
      [128,] -9.4112976   0.1197096 7.724973932  4.814338e-02  0.0261158390
      [129,]  4.7308685  -3.1672897 3.390285906 -1.638557e-02 -0.0435545094
      [130,]  9.0049406   9.9236150 9.644483242 -4.239687e-02  0.0112480344
      [131,]  2.6632996 -10.9146691 6.793493505  2.032662e-02  0.0286709019
      [132,]  6.3117579   0.2005075 2.926174628  4.524067e-03 -0.0148543742
      [133,]  7.0853348  11.5952431 5.374437880  1.712918e-02 -0.0412449545
      [134,]  5.8594361  -1.4609824 3.814162002  4.000003e-02  0.0384964693
      [135,]  5.0889129 -10.2635308 5.637403852 -3.129462e-02  0.0403535591
      [136,]  6.6247910  -9.5261258 2.021345051 -1.696542e-02 -0.0443810073
      [137,] 11.1833726  -4.7807903 0.665174187 -2.599024e-02 -0.0191402950
      [138,]  6.1100912  -0.7679263 3.364673748  2.685868e-02  0.0088271511
      [139,]  7.9328651  -8.6511803 8.599196060  3.175927e-02 -0.0069063945
      [140,]  2.9110274  -4.4224446 1.290984962 -2.017552e-02  0.0250049557
      [141,]  1.6905321   7.4409588 0.036179875  1.430562e-02 -0.0348641495
      [142,] -0.9585851 -10.8653752 6.144519257 -4.388218e-02 -0.0320736578
      [143,] -2.3098531   7.8071055 3.423136997  4.704672e-02 -0.0147642042
      [144,]  4.7146979 -10.4025622 0.172749395 -4.432870e-03  0.0014871315
      [145,] 11.4917381  -4.1540605 9.174462180 -3.661782e-02  0.0311488281
      [146,] 11.4914188   6.2094589 9.907600014  8.528756e-03 -0.0393062410
      [147,] -4.9710039  -9.2516014 3.565832311 -7.837044e-03  0.0129209106
      [148,]  4.7777230  -3.1177711 1.103063680 -3.644674e-02  0.0343811021
      [149,] 11.8102451   5.4259653 4.494780716  3.336327e-02 -0.0367332967
      [150,] -5.8963613   6.2721112 1.615097155 -1.907975e-02  0.0077857896
      [151,]  4.6585910  -3.2413728 5.072077441 -1.471168e-03 -0.0377598689
      [152,] 11.2933155   6.6336032 8.585612962 -1.342903e-02  0.0281777969
      [153,] -5.4968608  -8.8770459 1.565672329  3.520064e-02 -0.0106485355
      [154,]  4.0740394   6.0067338 8.809125947 -2.381260e-02 -0.0442246798
      [155,] -9.2870749  -2.8905819 4.823480158 -2.661871e-02 -0.0044094845
      [156,]  2.3325831 -10.9598024 7.712308182  3.555762e-02 -0.0276584150
      [157,] 10.2507021   8.4000972 3.463258906  3.595247e-02 -0.0066415980
      [158,]  3.4441431   6.5129614 0.642083343 -1.364102e-02  0.0251244939
      [159,]  1.2808986 -11.0370335 4.929611573  4.875386e-02  0.0495563033
      [160,]  3.7871882  -3.9553251 4.573757169  2.493871e-02  0.0031468394
      [161,] 11.1319311  -4.8771127 8.070585735 -4.896922e-03 -0.0098312909
      [162,]  1.1319855   7.6229726 3.278180815 -3.970057e-02  0.0271438907
      [163,]  3.7123187  -4.0038210 8.445648267  8.724967e-03  0.0400247400
      [164,]  5.0798563 -10.2670728 3.544742831  1.597159e-02 -0.0341779724
      [165,] -9.2709903  -2.9685647 5.240641208 -2.019766e-02 -0.0056912830
      [166,] -2.3077242   7.8074607 9.705451794  9.139048e-03 -0.0215980678
      [167,] -3.7342647  -9.9598249 0.703686343  3.028368e-02  0.0080712251
      [168,]  4.3006140  -3.5713631 8.144808135  1.788580e-02 -0.0043913169
      [169,] -8.5759127  -5.0610130 0.307429964 -4.290069e-02  0.0047715123
      [170,]  2.7608632   6.9472251 5.672186613 -2.202454e-02 -0.0158707107
      [171,]  6.1968389   2.4328387 1.349292817  6.666061e-03 -0.0363597272
      [172,] -5.0233833   6.8411115 6.480926180  4.398104e-02  0.0113337014
      [173,]  3.3575636   6.5740020 2.118412568  2.984306e-02 -0.0228879017
      [174,] -3.0261963   7.6539660 1.060905417  4.668091e-03  0.0066610883
      [175,] -2.1751149   7.8284352 0.630047461 -1.147877e-02  0.0359466498
      [176,]  3.6574756 -10.7175493 0.347820222 -2.931105e-02  0.0345976077
      [177,]  3.3120023  13.4960677 2.086077672 -3.496157e-02  0.0057953600
      [178,] -8.6239845   2.9044032 6.148814801  5.097572e-04 -0.0165653628
      [179,]  6.0575401  12.2639500 3.051711640 -1.107564e-02 -0.0101520649
      [180,]  2.3760120  -4.6120471 0.146510457  3.444004e-02  0.0487028622
      [181,]  6.2857689   1.9677354 4.028005560  1.721028e-03  0.0115250749
      [182,] -9.1824973   1.3404614 4.552168907  5.106072e-03  0.0444430579
      [183,]  6.3582273   1.1762728 8.664615252 -9.471303e-03  0.0082711114
      [184,] -1.8019878   7.8753932 1.049448841  2.284583e-02 -0.0360433521
      [185,] 12.6056868   1.0754023 4.461250696 -3.711272e-02 -0.0419245044
      [186,]  7.5072509  11.2801796 5.580346291  4.431580e-02 -0.0346357887
      [187,] -0.2285321   7.8796629 5.609750012  1.383906e-02 -0.0056294389
      [188,]  3.2939478   6.6176713 2.658265792 -3.990231e-02 -0.0037365437
      [189,]  6.3557381   1.2472652 6.877363559  1.393104e-02 -0.0146769820
      [190,]  4.3846414  -3.4990203 0.578708996 -4.668946e-03 -0.0021888600
      [191,]  2.1977120   7.2324431 0.806256293  1.337010e-02 -0.0022501174
      [192,] -7.2745301  -7.1523450 0.010990140 -3.080920e-02  0.0083656044
      [193,] -4.2375758   7.2341103 6.097410654  1.190440e-02  0.0234801304
      [194,] -5.8956887   6.2726108 4.252480746  2.176235e-02  0.0150542545
      [195,]  5.3498891  -2.3963378 1.947870206  3.808644e-03  0.0184855636
      [196,]  5.6217617   4.0043764 3.276572928 -2.022534e-02 -0.0395605636
      [197,]  2.5198713   7.0766419 4.593044685 -3.642897e-03  0.0347641557
      [198,] 12.4731102  -0.8247285 8.929530417  5.561239e-03 -0.0401655558
      [199,] 10.7845532   7.5743303 8.372611881  2.585751e-02  0.0339249040
      [200,]  1.6006027  -4.7747013 6.900984910 -1.580620e-02 -0.0093930904

---

    Code
      swiss_roll(n = 200, num_noise = 0)
    Output
                    [,1]         [,2]       [,3]
        [1,] -2.06301086   7.84440774 8.39096562
        [2,]  3.68348976   6.33407360 0.85622573
        [3,]  5.79544326   3.64063015 1.25847120
        [4,] 11.95379212  -2.98752993 9.03944338
        [5,]  4.98199383   5.01976170 7.84535438
        [6,]  4.47937881  -3.41383407 6.43401542
        [7,]  4.80665686  12.91545029 6.50897518
        [8,]  4.83165075  -3.05925672 2.05333687
        [9,]  7.44050024  -9.01093370 2.31272725
       [10,]  0.56171634  -4.79619371 7.45010051
       [11,] -7.70101339   4.46092447 8.23609477
       [12,] 12.08382641   4.60119950 2.16592942
       [13,]  7.63683494  11.17815074 6.01760890
       [14,] 11.23333782   6.75464075 4.50489896
       [15,]  6.27234478  -9.72062036 4.06708634
       [16,]  5.86159385   3.48561930 5.92357021
       [17,]  6.54524312  11.96306523 6.42444834
       [18,] -9.46537236  -1.47020188 7.76593626
       [19,]  4.57216635   5.51204445 2.64247751
       [20,]  1.52704941 -11.02794625 4.90752894
       [21,]  0.35003327  -4.77277900 7.22653301
       [22,]  6.31208507   0.20310914 6.08763634
       [23,] -8.22402584  -5.75031096 4.50941746
       [24,]  8.95694884   9.97390606 2.54494836
       [25,]  6.13833483  -0.66878887 4.83547204
       [26,] 11.87395483  -3.21630876 2.66197050
       [27,]  6.62732257  -9.52467018 0.39606036
       [28,]  1.95443387   7.33785346 8.32867402
       [29,] -9.40734321   0.15241380 9.06457410
       [30,] 12.60507983   0.85039348 3.70181606
       [31,]  4.43457732   5.65863191 4.86187546
       [32,] -9.45777907  -0.38730444 4.00858209
       [33,]  0.80774387  -4.81138802 4.74694738
       [34,]  2.10079507   7.27566048 2.27038505
       [35,]  2.95467167 -10.86652763 9.97736051
       [36,] -0.55344426   7.90453232 1.26151686
       [37,]  7.95567833  -8.63353495 3.21810473
       [38,]  0.97597312  -4.81446828 7.90966723
       [39,] -9.42647032  -1.97655728 8.76571369
       [40,]  9.43109564   9.45276741 3.77774726
       [41,]  4.16099472   5.92716139 2.92479108
       [42,]  5.45194884   4.31457912 9.89874637
       [43,] 12.13826305   4.41115200 1.80727039
       [44,] 12.59385730   1.54881599 7.34734462
       [45,]  4.16292526  -3.68375675 8.92798880
       [46,] -0.04552544   7.85964203 9.12171215
       [47,] 11.88394312  -3.18846501 1.07150256
       [48,]  7.95643347  -8.63294934 8.70253569
       [49,] 12.59795245   1.44554590 6.45395615
       [50,] -9.45267520  -0.31269247 6.51166953
       [51,] -9.24801006  -3.07475298 2.91491437
       [52,] -9.47703990  -1.06398676 7.63127579
       [53,] -5.35703963  -8.98148105 8.92443858
       [54,]  3.08903437   6.75181338 8.96260771
       [55,]  5.29494169 -10.18053309 8.60179453
       [56,]  2.62616341 -10.92023922 2.86759122
       [57,]  2.71792749  -4.49856427 0.20042569
       [58,]  5.49043351 -10.09742798 1.04493458
       [59,]  0.62257485  14.07921808 1.64632158
       [60,] -3.98849767   7.33794050 5.37490580
       [61,] -0.86712107   7.91573823 7.56192339
       [62,] 10.60727544   7.86382733 0.67194600
       [63,] -0.23565371   7.88035397 2.34275741
       [64,]  8.68635619  10.24798230 4.75170634
       [65,]  0.87603593  -4.81334936 7.06748786
       [66,]  6.33750976   1.53571680 2.09017000
       [67,] -7.87005670  -6.33419810 5.52619396
       [68,]  4.05368738  -3.76780293 5.12253103
       [69,]  7.49113614  -8.97573069 2.42602132
       [70,]  2.80153882 -10.89281231 0.07978852
       [71,]  3.56455190  -4.09448694 5.38281123
       [72,]  1.91777180 -11.00225757 0.15986687
       [73,]  3.38892909 -10.78002063 6.62242120
       [74,] -4.75580333  -9.39128135 9.70545943
       [75,]  4.19442677   5.89586030 4.44165591
       [76,]  2.73068646 -10.90423590 3.14381083
       [77,] 12.34565129  -1.54461813 1.06809036
       [78,] -7.30352193  -7.11626804 2.86903622
       [79,] 12.16523815  -2.29532356 7.34274061
       [80,]  4.75745144   5.30068244 7.93364196
       [81,] -1.51720193 -10.74880079 2.32885415
       [82,] 12.55235254   2.15933357 4.71255659
       [83,]  3.25968344   6.64078679 0.66428375
       [84,] -8.86617267   2.33159120 8.56078255
       [85,]  5.04983004  -2.80434442 0.24051522
       [86,]  3.96706000   6.10112821 2.58515353
       [87,]  5.04798309   4.93128390 1.24741475
       [88,]  4.48051464  13.05944008 0.31919220
       [89,]  2.29805818   7.18594609 8.77881441
       [90,]  8.87188077  -7.84420430 9.90372739
       [91,] 10.27266030   8.36866203 5.16966163
       [92,] -8.82041723   2.44862098 6.75773777
       [93,]  2.62600418  -4.53170348 3.94142131
       [94,]  1.17590113  14.00411271 8.77988065
       [95,]  9.45102623   9.42960997 5.91741279
       [96,] 12.60588701   1.03030500 0.47134463
       [97,] -7.03366714  -7.43966976 2.37249410
       [98,] -4.43322538   7.14578467 7.48023016
       [99,] -1.24147566   7.91280915 6.86367779
      [100,]  6.34218486   0.50004941 9.42824661
      [101,] 12.46188333   2.90097819 8.30908355
      [102,]  1.92732027 -11.00145648 5.06205570
      [103,]  5.72022621   3.80501530 6.27493830
      [104,]  3.73894507   6.29038806 7.55657729
      [105,]  5.84097826  -1.50318141 4.72955368
      [106,] -5.56081718  -8.82804197 3.28432195
      [107,]  1.10027045   7.63189714 7.55336919
      [108,]  5.98106170   3.17400517 3.65777908
      [109,] -9.15538802  -3.45507078 2.86475806
      [110,] 10.01136049   8.73070501 0.56436216
      [111,]  6.34167363   0.49348748 1.51985004
      [112,]  4.04804104 -10.61420228 5.73427645
      [113,] 12.49061260   2.70116617 4.24857267
      [114,]  0.55354065  -4.79546845 6.99789487
      [115,]  2.43967139  -4.59292473 7.13718267
      [116,]  7.29724545  11.44019669 4.12940227
      [117,]  5.81812013  -1.55424465 6.73175141
      [118,]  4.84946300 -10.35420932 0.52202062
      [119,] -8.55372244   3.05235656 9.19043258
      [120,]  6.20520084  -0.40325420 7.00798752
      [121,]  6.31765763   1.73191957 1.88405646
      [122,] -7.10346184  -7.35860449 2.69137378
      [123,]  5.66100578  -1.87479834 8.33074008
      [124,]  5.51460824   4.20448079 9.41550157
      [125,] -5.57460496   6.49978023 1.16544235
      [126,] -8.45637969  -5.31037620 7.30917390
      [127,]  5.98219175   3.17082076 4.16610956
      [128,] -9.46082599  -1.55360751 8.81205521
      [129,]  5.26665470   4.61530954 5.00373365
      [130,]  0.14724264  -4.74114946 0.27572036
      [131,] -8.77071570  -4.61065563 3.10596422
      [132,]  5.78903130   3.65510588 5.79348751
      [133,] -3.83525316   7.39716607 7.47149424
      [134,]  9.46358946  -7.23688425 4.09841114
      [135,]  3.34138104 -10.79036225 4.78809305
      [136,] -9.39931167   0.21606473 7.86251563
      [137,] -7.83003342   4.28189661 0.06278183
      [138,]  5.78930978  -1.61683378 5.11899914
      [139,]  1.92547769   7.34972775 3.94765486
      [140,] -6.57391217  -7.93403737 6.41947250
      [141,]  4.94599124   5.06683309 1.10457971
      [142,]  3.48816180  13.43785046 6.60777596
      [143,]  7.35619969  -9.06866540 8.51995069
      [144,]  5.53251456   4.17212738 0.69376520
      [145,]  1.60104246   7.47336421 2.32207644
      [146,]  6.05517680  -0.94466882 8.37011507
      [147,]  5.39259557  12.63063902 4.23717442
      [148,] -5.48000326  -8.88983180 5.14747253
      [149,]  3.39848855  -4.18874333 7.11903928
      [150,] -1.15509509 -10.82786082 6.26838079
      [151,] -4.80027081   6.96328441 6.34600675
      [152,]  5.17025461   4.75921955 3.45125414
      [153,]  0.83305456   7.70130506 2.69218223
      [154,] -4.60698896   7.06217800 9.21797246
      [155,]  6.24069845   2.22597767 9.82948302
      [156,] -2.63897371   7.74512893 7.07208320
      [157,]  3.60322599   6.39577785 8.70005909
      [158,]  1.99906371   7.31927546 2.31704158
      [159,] 12.60482624   1.16383123 5.50102595
      [160,]  5.95702343  -1.22140942 7.13881427
      [161,]  2.08825730  -4.68737401 8.38421308
      [162,]  6.78664452  11.80335694 2.61835773
      [163,]  5.90468005   3.37846798 1.25827720
      [164,] -4.97132705   6.87040403 2.51415322
      [165,]  4.31510199 -10.53484215 4.85402641
      [166,]  2.86921888 -10.88146468 4.53145574
      [167,]  3.72940606  -3.99290756 0.97897286
      [168,] -2.31147026 -10.52871942 9.31239095
      [169,]  3.72170351  13.35659948 6.49511215
      [170,] -9.47729420  -0.99563107 3.87704505
      [171,] 12.42821662  -1.10767178 9.72140865
      [172,] -3.24592621 -10.18210833 0.29555425
      [173,]  4.52883560  13.03874128 5.68427182
      [174,] -4.55679144  -9.51393429 6.28664751
      [175,]  4.69445764 -10.40965947 1.64021305
      [176,] -0.36178805 -10.95659465 0.51595162
      [177,] -1.22879681 -10.81281932 0.75891088
      [178,] -9.33933256   0.61187886 1.62858806
      [179,]  9.60840574  -7.07422171 3.34098108
      [180,] -0.14802978   7.87139366 2.99995602
      [181,]  7.88012705  10.97949966 6.69033943
      [182,]  3.23108762   6.65986408 4.00381401
      [183,] -8.44450196  -5.33421418 2.11165783
      [184,]  6.29652458   0.08785587 2.06979570
      [185,] -3.15634379   7.61880681 0.66127525
      [186,] -8.19801337  -5.79643303 5.10253629
      [187,]  4.11168643  -3.72372578 5.69474311
      [188,]  4.90976812   5.11337458 1.89269313
      [189,]  7.75010317  11.08683959 2.01694072
      [190,]  1.92528571  -4.72212593 4.64125362
      [191,] -8.94107332  -4.15635001 8.66283601
      [192,]  6.11951860  12.22726857 2.44287021
      [193,] -8.46034005  -5.30239221 0.17939926
      [194,] -6.20164878   6.03445922 0.02941653
      [195,]  6.31514537   1.75315975 6.21213908
      [196,] -9.05120379   1.80006805 8.29432523
      [197,]  6.31647727   1.74197396 6.25826487
      [198,]  8.65300132  10.28069417 4.98430085
      [199,] -3.96496848   7.34726154 3.45861648
      [200,]  4.26728194   5.82623746 8.35615125

