% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometric.R
\name{gen_nonlinear}
\alias{gen_nonlinear}
\title{Generate Nonlinear Hyperbola}
\usage{
gen_nonlinear(n = 500, p = 4, hc = 1, non_fac = 0.5)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{hc}{A numeric value (default: 1) representing the hyperbolic component which define the steepness and vertical scaling of the hyperbola. Larger values of this make the curve more pronounced (sharper dips/rises near 0), while smaller values make it flatter.}

\item{non_fac}{A numeric value (default: 1) representing the nonlinear factor which describes the strength of this sinusoidal effect. When this is 0, the curve is purely hyperbolic; as it increases, the wave-like fluctuations become more prominent.}
}
\value{
A data containing a nonlinear hyperbola structure.
}
\description{
This function generates a dataset representing a nonlinear hyperbola structure.
}
\examples{
set.seed(20240412)
nonlinear <- gen_nonlinear(n = 500, p = 4, hc = 1, non_fac = 0.5)
}
