% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swiss_roll.R
\name{gen_swissroll}
\alias{gen_swissroll}
\title{Generate Swiss Roll Data}
\usage{
gen_swissroll(n = 500, p = 4, w = c(-1, 1), noise_fun = gen_noisedims, ...)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{w}{A numeric vector (default: c(-1, 1)) representing the vertical variation.}

\item{noise_fun}{A function specifying which noise generation function to use for the additional dimensions. Default is \code{gen_noisedims}. Other options include \code{gen_wavydims1}, \code{gen_wavydims2}, and \code{gen_wavydims3}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun} (e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing the generated swiss roll data.
}
\description{
This function generates swiss roll data.
}
\examples{
set.seed(20240412)
swissroll <- gen_swissroll(n = 500, p = 4)
}
\references{
Agrafiotis, D. K., & Xu, H. (2002).
A self-organizing principle for learning nonlinear manifolds.
\emph{Proceedings of the National Academy of Sciences}, \emph{99}(25), 15869-15872.


Roweis, S. T., & Saul, L. K. (2000).
Nonlinear dimensionality reduction by locally linear embedding.
\emph{Science}, \emph{290}(5500), 2323-2326.
}
