% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_hole}
\alias{gen_hole}
\title{Remove points within a spherical hole in the middle}
\usage{
gen_hole(df, anchor = NULL, r = 0.5)
}
\arguments{
\item{df}{A data frame or matrix of coordinates.}

\item{anchor}{A numeric vector giving the center of the hole.}

\item{r}{A numeric value for the hole radius.}
}
\value{
A tibble with the hole removed.
}
\description{
Remove points within a spherical hole in the middle
}
\examples{
set.seed(20240412)
df <- gen_scurve(n = 1000)
gen_hole(df, r = 0.5)

}
