% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survival_survfit.R
\name{ard_survival_survfit}
\alias{ard_survival_survfit}
\title{ARD Survival Estimates}
\usage{
ard_survival_survfit(x, times = NULL, probs = NULL, type = NULL)
}
\arguments{
\item{x}{(\code{\link[survival:survfit]{survival::survfit()}})\cr
a \code{\link[survival:survfit]{survival::survfit()}} object. See below for details.}

\item{times}{(\code{numeric})\cr
a vector of times for which to return survival probabilities.}

\item{probs}{(\code{numeric})\cr
a vector of probabilities with values in (0,1) specifying the survival quantiles to return.}

\item{type}{(\code{string} or \code{NULL})\cr
type of statistic to report. Available for Kaplan-Meier time estimates only, otherwise \code{type}
is ignored. Default is \code{NULL}.
Must be one of the following:\tabular{ll}{
   type \tab transformation \cr
   \code{"survival"} \tab \code{x} \cr
   \code{"risk"} \tab \code{1 - x} \cr
   \code{"cumhaz"} \tab \code{-log(x)} \cr
}}
}
\value{
an ARD data frame of class 'card'
}
\description{
Analysis results data for survival quantiles and x-year survival estimates, extracted
from a \code{\link[survival:survfit]{survival::survfit()}} model.
}
\details{
\itemize{
\item Only one of either the \code{times} or \code{probs} parameters can be specified.
\item Times should be provided using the same scale as the time variable used to fit the provided
survival fit model.
}
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survival", "broom", "ggsurvfit"), reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)
library(ggsurvfit)

survfit(Surv_CNSR(AVAL, CNSR) ~ TRTA, cards::ADTTE) |>
  ard_survival_survfit(times = c(60, 180))

survfit(Surv_CNSR(AVAL, CNSR) ~ TRTA, cards::ADTTE) |>
  ard_survival_survfit(probs = c(0.25, 0.5, 0.75))

# Competing Risks Example ---------------------------
set.seed(1)
ADTTE_MS <- cards::ADTTE \%>\%
  dplyr::mutate(
    CNSR = dplyr::case_when(
      CNSR == 0 ~ "censor",
      runif(dplyr::n()) < 0.5 ~ "death from cancer",
      TRUE ~ "death other causes"
    ) \%>\% factor()
  )

survfit(Surv(AVAL, CNSR) ~ TRTA, data = ADTTE_MS) \%>\%
  ard_survival_survfit(times = c(60, 180))
\dontshow{\}) # examplesIf}
}
