% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_wilcox_test.R
\name{.format_wilcoxtest_results}
\alias{.format_wilcoxtest_results}
\title{Convert Wilcoxon test to ARD}
\usage{
.format_wilcoxtest_results(by = NULL, variable, lst_tidy, paired, ...)
}
\arguments{
\item{by}{(\code{string})\cr by column name}

\item{variable}{(\code{string})\cr variable column name}

\item{lst_tidy}{(named \code{list})\cr
list of tidied results constructed with \code{\link[cards:eval_capture_conditions]{eval_capture_conditions()}},
e.g. \code{eval_capture_conditions(t.test(mtcars$mpg ~ mtcars$am) |> broom::tidy())}.}

\item{paired}{a logical indicating whether you want a paired test.}

\item{...}{passed to \code{stats::wilcox.test(...)}}
}
\value{
ARD data frame
}
\description{
Convert Wilcoxon test to ARD
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pre-processing ADSL to have grouping factor (ARM here) with 2 levels
ADSL <- cards::ADSL |>
  dplyr::filter(ARM \%in\% c("Placebo", "Xanomeline High Dose")) |>
  ard_stats_wilcox_test(by = "ARM", variables = "AGE")

cardx:::.format_wilcoxtest_results(
  by = "ARM",
  variable = "AGE",
  paired = FALSE,
  lst_tidy =
    cards::eval_capture_conditions(
      stats::wilcox.test(ADSL[["AGE"]] ~ ADSL[["ARM"]], paired = FALSE) |>
        broom::tidy()
    )
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
