#' Paraná State
#'
#' A \code{sf} object with a polygon for the Paraná state in Brazil. This is a subset of the
#' brazilian map provided by official government agency (IBGE)
#'
#' @format ## `parana`
#' A \code{sf} with 1 row and 5 columns:
#' \describe{
#'   \item{GID0}{State code}
#'   \item{CODIGOIB1}{State's phone code}
#'   \item{NOMEUF2}{Name of the state}
#'   \item{SIGLAUF3}{Abbreviation of the state's name}
#'   \item{geom}{Geometry column of the \code{sf}}
#' }
#' @source <https://www.ibge.gov.br/geociencias/cartas-e-mapas/bases-cartograficas-continuas/15759-brasil.html>
"parana"
