% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_area.R
\name{sdm_area}
\alias{sdm_area}
\alias{get_sdm_area}
\alias{add_sdm_area}
\title{Create a \code{sdm_area} object}
\usage{
sdm_area(x, cell_size = NULL, crs = NULL, variables_selected = NULL,
                gdal = TRUE, crop_by = NULL, lines_as_sdm_area = FALSE)

get_sdm_area(i)

add_sdm_area(sa1, sa2)
}
\arguments{
\item{x}{A shape or a raster. Usually a shape from \code{sf} class, but rasters from
\code{stars}, \code{rasterStack} or \code{SpatRaster} class are also allowed.}

\item{cell_size}{\code{numeric}. The cell size to be used in models.}

\item{crs}{\code{numeric}. Indicates which EPSG should the output grid be in. If \code{NULL},
epsg from \code{x} is used.}

\item{variables_selected}{A \code{character} vector with variables in \code{x} to be used in
models.
If \code{NULL} (standard), all variables in \code{x} are used.}

\item{gdal}{Boolean. Force the use or not of GDAL when available. See details.}

\item{crop_by}{A shape from \code{sf} to crop \code{x}.}

\item{lines_as_sdm_area}{Boolean. If \code{x} is a \code{sf} with LINESTRING geometry, it can be
used
to model species distribution in lines and not grid cells.}

\item{i}{A \code{sdm_area} or a \code{input_sdm} object.}

\item{sa1}{A \code{sdm_area} object.}

\item{sa2}{A \code{sdm_area} object.}
}
\value{
A \code{sdm_area} object containing:
   \item{grid}{\code{sf} with \code{POLYGON} geometry representing the grid for the study area.}
   \item{cell_size}{\code{numeric} information regarding the size of the cell used to rescale
   variables to the study area, representing also the cell size in the \code{grid}.}
}
\description{
This function creates a new \code{sdm_area} object.
}
\details{
The function returns a \code{sdm_area} object with a grid built upon the \code{x} parameter.
There are two ways to make the grid and resample the variables in \code{sdm_area}: with and
without gdal. As standard, if gdal is available in you machine it will be used
(\code{gdal = TRUE}),
otherwise sf/stars will be used.
\code{get_sdm_area} will return the grid built by \code{sdm_area}.
\code{add_sdm_area} will sum two \code{sdm_area} objects. As geoprocessing in \code{caretSDM} is
performed using \code{sf} objects, \code{add_sdm_area} simply applies a \code{rbind} in the two
different areas.
}
\examples{
# Create sdm_area object:
sa_area <- sdm_area(parana, cell_size = 50000, crs = 6933)

# Create sdm_area using a subset of rivs (lines):
sa_rivers <- sdm_area(rivs[c(1:100),], cell_size = 100000, crs = 6933, lines_as_sdm_area = TRUE)

}
\seealso{
\code{\link{WorldClim_data} \link{parana} \link{input_sdm}, \link{add_predictors}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com) and Reginaldo Ré.
https://luizfesser.wordpress.com
}
