# train_sdm

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Araucaria angustifolia 
      Number of presences           : 420 
      Pseudoabsence methods         :
          Method to obtain PAs      : random 
          Number of PA sets         : 3 
          Number of PAs in each set : 420 
      --------  Predictors  ---------
      Number of Predictors          : 2 
      Predictors Names              : bio1, bio12 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : kknn naive_bayes 
      Variables Names               : bio1 bio12 
      Model Validation              :
          Method                    : cv 
          Number                    : 2 
          Metrics                   :
      $`Araucaria angustifolia`
               algo       ROC      Sens      Spec      ROCSD
      1        kknn 0.6605192 0.9920635 0.1097222 0.08681466
      2 naive_bayes 0.8402910 0.9706349 0.3631944 0.11121967
      

# train_sdm - pca

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Araucaria angustifolia 
      Number of presences           : 420 
      Pseudoabsence methods         :
          Method to obtain PAs      : random 
          Number of PA sets         : 3 
          Number of PAs in each set : 420 
      --------  Predictors  ---------
      Number of Predictors          : 4 
      Predictors Names              : bio1, bio12, PC1, PC2 
      PCA-transformed variables     : DONE 
      Cummulative proportion ( 0.99 ) : PC1 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : kknn naive_bayes 
      Variables Names               : PC1 
      Model Validation              :
          Method                    : cv 
          Number                    : 2 
          Metrics                   :
      $`Araucaria angustifolia`
               algo       ROC      Sens       Spec     ROCSD
      1        kknn 0.5741815 0.9801587 0.08819444 0.0710965
      2 naive_bayes 0.8392427 0.9857143 0.15208333 0.1099336
      

# train_sdm - vif

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Araucaria angustifolia 
      Number of presences           : 420 
      Pseudoabsence methods         :
          Method to obtain PAs      : random 
          Number of PA sets         : 3 
          Number of PAs in each set : 420 
      --------  Predictors  ---------
      Number of Predictors          : 2 
      Predictors Names              : bio1, bio12 
      Area (VIF)                    : all
      Threshold                     : 0.5
      Selected Variables (VIF)      : bio1, bio12 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : naive_bayes kknn 
      Variables Names               : bio1 bio12 
      Model Validation              :
          Method                    : cv 
          Number                    : 2 
          Metrics                   :
      $`Araucaria angustifolia`
               algo       ROC      Sens      Spec      ROCSD
      1        kknn 0.6314964 0.9865079 0.1381944 0.06344787
      2 naive_bayes 0.8625942 0.9666667 0.3645833 0.04378965
      

# train_sdm - change ctrl

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Araucaria angustifolia 
      Number of presences           : 420 
      Pseudoabsence methods         :
          Method to obtain PAs      : random 
          Number of PA sets         : 3 
          Number of PAs in each set : 420 
      --------  Predictors  ---------
      Number of Predictors          : 4 
      Predictors Names              : bio1, bio12, PC1, PC2 
      PCA-transformed variables     : DONE 
      Cummulative proportion ( 0.99 ) : PC1 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : kknn naive_bayes 
      Variables Names               : PC1 
      Model Validation              :
          Method                    : boot 
          Number                    : 10 
          Metrics                   :
      $`Araucaria angustifolia`
               algo       ROC      Sens       Spec      ROCSD
      1        kknn 0.5646017 0.9898871 0.07271169 0.06067877
      2 naive_bayes 0.8402030 0.9966436 0.14952596 0.10851423
      

# train_sdm - selecting vars

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Araucaria angustifolia 
      Number of presences           : 420 
      Pseudoabsence methods         :
          Method to obtain PAs      : random 
          Number of PA sets         : 3 
          Number of PAs in each set : 420 
      --------  Predictors  ---------
      Number of Predictors          : 2 
      Predictors Names              : bio1, bio12 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : naive_bayes kknn 
      Variables Names               : bio1 bio12 
      Model Validation              :
          Method                    : cv 
          Number                    : 2 
          Metrics                   :
      $`Araucaria angustifolia`
               algo       ROC      Sens       Spec      ROCSD
      1        kknn 0.5642758 0.9785714 0.05347222 0.08865492
      2 naive_bayes 0.8495552 0.9690476 0.40902778 0.04172257
      

# train_sdm - ESM

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Araucaria angustifolia 
      Number of presences           : 420 
      Pseudoabsence methods         :
          Method to obtain PAs      : random 
          Number of PA sets         : 3 
          Number of PAs in each set : 420 
      Ensemble of Small Models (ESM): TRUE
          Number of Records         : 20 
      --------  Predictors  ---------
      Number of Predictors          : 3 
      Predictors Names              : bio1, bio4, bio12 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : naive_bayes kknn 
      Variables Names               : bio1 bio4 bio12 
      Model Validation              :
          Method                    : cv 
          Number                    : 2 
          Metrics                   :
      $`Araucaria angustifolia`
               algo       ROC      Sens       Spec      ROCSD
      1        kknn 0.5662136 0.9883598 0.05787037 0.06801226
      2 naive_bayes 0.8406983 0.9748677 0.43356481 0.08100005
      

# mahal.dist train

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Araucaria angustifolia 
      Number of presences           : 420 
      Pseudoabsence methods         :
          Method to obtain PAs      : bioclim 
          Number of PA sets         : 3 
          Number of PAs in each set : 420 
      --------  Predictors  ---------
      Number of Predictors          : 7 
      Predictors Names              : GID0, CODIGOIB1, NOMEUF2, SIGLAUF3, bio1, bio4, bio12 
      -----------  Models  ----------
      Algorithms Names              : mahal.custom 
      Variables Names               : bio1 bio4 bio12 
      Model Validation              :
          Method                    : cv 
          Number                    : 3 
          Metrics                   :
      $`Araucaria angustifolia`
                algo       ROC       TSS Sensitivity Specificity
      1 mahal.custom 0.9886484 0.8152958   0.8254444           1
      

# train_sdm - one species ESM

    Code
      i1
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Salminus brasiliensis Araucaria angustifolia 
      Number of presences           : 82 21 
      Pseudoabsence methods         :
          Method to obtain PAs      : bioclim 
          Number of PA sets         : 10 
          Number of PAs in each set : 82 21 
      Data Cleaning                 : NAs, Capitals, Centroids, Geographically Duplicated, Identical Lat/Long, Institutions, Invalid, Non-terrestrial, Duplicated Cell (grid) 
      Ensemble of Small Models (ESM): TRUE
          Number of Records         : 30 
      --------  Predictors  ---------
      Number of Predictors          : 3 
      Predictors Names              : bio1, bio4, bio12 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : mahal.custom 
      Variables Names               : bio1 bio4 bio12 
      Model Validation              :
          Method                    : repeatedcv 
          Number                    : 4 
          Metrics                   :
      $`Salminus brasiliensis`
                algo       ROC       TSS Sensitivity Specificity
      1 mahal.custom 0.6988333 0.3477778      0.8586   0.9541667
      
      $`Araucaria angustifolia`
                algo       ROC       TSS Sensitivity Specificity
      1 mahal.custom 0.9612472 0.7656548     0.95015           1
      

---

    Code
      i2
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Salminus brasiliensis Araucaria angustifolia 
      Number of presences           : 82 21 
      Pseudoabsence methods         :
          Method to obtain PAs      : bioclim 
          Number of PA sets         : 10 
          Number of PAs in each set : 82 21 
      Data Cleaning                 : NAs, Capitals, Centroids, Geographically Duplicated, Identical Lat/Long, Institutions, Invalid, Non-terrestrial, Duplicated Cell (grid) 
      Ensemble of Small Models (ESM): TRUE
          Number of Records         : 30 
      --------  Predictors  ---------
      Number of Predictors          : 3 
      Predictors Names              : bio1, bio4, bio12 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : kknn 
      Variables Names               : bio1 bio4 bio12 
      Model Validation              :
          Method                    : repeatedcv 
          Number                    : 4 
          Metrics                   :
      $`Salminus brasiliensis`
        algo       ROC       TSS Sensitivity Specificity
      1 kknn 0.9059954 0.7541667   0.8386083   0.9205417
      
      $`Araucaria angustifolia`
        algo       ROC       TSS Sensitivity Specificity
      1 kknn 0.9562599 0.8770238       0.977    0.899875
      

---

    Code
      i1$models
    Output
               caretSDM        
      .........................
      Class                   : Models
      Algorithms Names        : mahal.custom 
      Variables Names         : bio1 bio4 bio12 
      Model Validation        :
               Method          : repeatedcv 
               Number          : 4 
               Metrics         :
      $`Salminus brasiliensis`
                     algo       ROC       TSS Sensitivity Specificity Pos Pred Value
      m1.11  mahal.custom 0.6950000 0.4166667     0.85000     1.00000      1.0000000
      m1.21  mahal.custom 0.7083333 0.3750000     0.85000     1.00000      1.0000000
      m1.31  mahal.custom 0.7166667 0.2750000     0.90000     0.90000      0.8750000
      m2.11  mahal.custom 0.6072222 0.3916667     0.85825     1.00000      1.0000000
      m2.21  mahal.custom 0.7058333 0.3333333     0.90000     0.95000      0.9333333
      m2.31  mahal.custom 0.6833333 0.2833333     0.90825     0.90000      0.8750000
      m3.11  mahal.custom 0.7966667 0.3166667     0.90000     0.85000      0.8750000
      m3.21  mahal.custom 0.7713889 0.4333333     0.86675     1.00000      1.0000000
      m3.31  mahal.custom 0.7666667 0.3916667     0.86675     1.00000      1.0000000
      m4.11  mahal.custom 0.6844444 0.2833333     0.90000     0.95000      0.8750000
      m4.21  mahal.custom 0.7100000 0.3333333     0.90000     1.00000      1.0000000
      m4.31  mahal.custom 0.7483333 0.3750000     0.90000     0.95000      0.9375000
      m5.11  mahal.custom 0.7866667 0.4250000     0.90825     1.00000      1.0000000
      m5.21  mahal.custom 0.7836111 0.4333333     0.90000     1.00000      1.0000000
      m5.31  mahal.custom 0.7250000 0.2916667     0.75825     0.95000      0.9167500
      m6.11  mahal.custom 0.6633333 0.2500000     0.90825     0.90000      0.7917500
      m6.21  mahal.custom 0.6158333 0.1916667     0.75825     0.90000      0.8666667
      m6.31  mahal.custom 0.7033333 0.4166667     0.80000     0.95000      0.8750000
      m7.11  mahal.custom 0.6800000 0.3000000     0.73325     0.95825      0.9167500
      m7.21  mahal.custom 0.7150000 0.4416667     0.86675     1.00000      1.0000000
      m7.31  mahal.custom 0.6266667 0.3583333     0.90825     1.00000      1.0000000
      m8.11  mahal.custom 0.6450000 0.3750000     0.90000     1.00000      1.0000000
      m8.21  mahal.custom 0.6650000 0.2333333     0.80825     0.90000      0.9000000
      m8.31  mahal.custom 0.5916667 0.4500000     0.81675     1.00000      1.0000000
      m9.11  mahal.custom 0.7283333 0.2916667     0.90825     0.95000      0.9167500
      m9.21  mahal.custom 0.6800000 0.3833333     0.76675     0.95000      0.9375000
      m9.31  mahal.custom 0.6933333 0.4083333     0.81675     0.91675      0.8332500
      m10.11 mahal.custom 0.6483333 0.3916667     0.85000     1.00000      1.0000000
      m10.21 mahal.custom 0.7533333 0.2750000     0.90000     0.85000      0.7556667
      m10.31 mahal.custom 0.6666667 0.3083333     0.85000     0.90000      0.7776667
             Neg Pred Value Precision  Recall        F1 Prevalence Detection Rate
      m1.11       0.7082500 1.0000000 0.85000 0.7070000        0.5        0.42950
      m1.21       0.7917500 1.0000000 0.85000 0.6690000        0.5        0.42500
      m1.31       0.6250000 0.8750000 0.90000 0.7030000        0.5        0.45000
      m2.11       0.6480000 1.0000000 0.85825 0.6775000        0.5        0.42925
      m2.21       0.8666667 0.9333333 0.90000 0.6827500        0.5        0.45000
      m2.31       0.5915000 0.8750000 0.90825 0.6995000        0.5        0.45250
      m3.11       0.8667500 0.8750000 0.90000 0.7270000        0.5        0.45225
      m3.21       0.8335000 1.0000000 0.86675 0.7180000        0.5        0.43325
      m3.31       0.8250000 1.0000000 0.86675 0.7245000        0.5        0.42975
      m4.11       0.7000000 0.8750000 0.90000 0.7087500        0.5        0.45000
      m4.21       0.6667500 1.0000000 0.90000 0.7082500        0.5        0.45225
      m4.31       0.7917500 0.9375000 0.90000 0.7002500        0.5        0.45000
      m5.11       0.8667500 1.0000000 0.90825 0.7355000        0.5        0.45250
      m5.21       0.8750000 1.0000000 0.90000 0.7322500        0.5        0.45000
      m5.31       0.6832500 0.9167500 0.75825 0.6617500        0.5        0.37750
      m6.11       0.8335000 0.7917500 0.90825 0.7042500        0.5        0.45250
      m6.21       0.7000000 0.8666667 0.75825 0.6480000        0.5        0.37925
      m6.31       0.7500000 0.8750000 0.80000 0.6510000        0.5        0.40000
      m7.11       0.7750000 0.9167500 0.73325 0.6180000        0.5        0.36375
      m7.21       0.7750000 1.0000000 0.86675 0.6912500        0.5        0.42975
      m7.31       0.8542500 1.0000000 0.90825 0.8295000        0.5        0.45475
      m8.11       0.7917500 1.0000000 0.90000 0.6880000        0.5        0.45225
      m8.21       0.7085000 0.9000000 0.80825 0.6745000        0.5        0.40700
      m8.31       0.6657500 1.0000000 0.81675 0.7366667        0.5        0.40475
      m9.11       0.8250000 0.9167500 0.90825 0.7030000        0.5        0.45425
      m9.21       0.7260000 0.9375000 0.76675 0.6107500        0.5        0.38650
      m9.31       0.7500000 0.8332500 0.81675 0.6495000        0.5        0.40925
      m10.11      0.8125000 1.0000000 0.85000 0.6755000        0.5        0.42500
      m10.21      0.8542500 0.7556667 0.90000 0.7120000        0.5        0.45225
      m10.31      0.8750000 0.7776667 0.85000 0.6877500        0.5        0.43175
             Detection Prevalence Balanced Accuracy Accuracy   Kappa AccuracyLower
      m1.11               0.76125           0.70825  0.71125 0.41650       0.37575
      m1.21               0.75675           0.68750  0.69075 0.37250       0.35100
      m1.31               0.78850           0.63750  0.64075 0.27250       0.30825
      m2.11               0.78325           0.69575  0.69575 0.39175       0.36575
      m2.21               0.80825           0.66675  0.66675 0.33325       0.33200
      m2.31               0.80900           0.64175  0.64550 0.28900       0.31575
      m3.11               0.74075           0.65825  0.66350 0.32000       0.32600
      m3.21               0.70000           0.71675  0.71675 0.43325       0.37850
      m3.31               0.69075           0.69575  0.69525 0.39200       0.36125
      m4.11               0.78325           0.64175  0.64175 0.28325       0.30800
      m4.21               0.78175           0.66675  0.66575 0.33325       0.32700
      m4.31               0.78325           0.68750  0.68750 0.37500       0.34650
      m5.11               0.73625           0.71250  0.70900 0.42250       0.37525
      m5.21               0.72925           0.71675  0.71675 0.43325       0.37225
      m5.31               0.64075           0.64575  0.64075 0.29375       0.31000
      m6.11               0.78400           0.62500  0.62050 0.24875       0.29175
      m6.21               0.66675           0.59575  0.59575 0.19175       0.28050
      m6.31               0.70900           0.70825  0.70675 0.41475       0.37950
      m7.11               0.62950           0.65000  0.64525 0.29875       0.31200
      m7.21               0.74300           0.72075  0.71350 0.44200       0.37925
      m7.31               0.76575           0.67925  0.68175 0.36025       0.36075
      m8.11               0.80900           0.68750  0.68625 0.37425       0.34900
      m8.21               0.69550           0.61675  0.61800 0.23150       0.28775
      m8.31               0.73850           0.72500  0.71825 0.45525       0.38800
      m9.11               0.79575           0.64575  0.64575 0.29175       0.31125
      m9.21               0.72275           0.69175  0.69075 0.38325       0.34850
      m9.31               0.74300           0.70400  0.70000 0.40400       0.38425
      m10.11              0.73625           0.69575  0.68625 0.38850       0.37100
      m10.21              0.76350           0.63750  0.64075 0.27775       0.30550
      m10.31              0.72275           0.65425  0.66350 0.30500       0.34675
             AccuracyUpper AccuracyNull AccuracyPValue McnemarPValue Positive
      m1.11        0.92625       0.5225        0.44900       0.38725     5.25
      m1.21        0.92100       0.5225        0.44250       0.47125     5.25
      m1.31        0.89425       0.5225        0.42375       0.40750     5.25
      m2.11        0.90825       0.5000        0.48650       0.45125     5.25
      m2.21        0.90550       0.5000        0.39275       0.36400     5.25
      m2.31        0.88975       0.5225        0.47100       0.38625     5.25
      m3.11        0.90900       0.5225        0.39200       0.49975     5.25
      m3.21        0.92725       0.5000        0.22875       0.52825     5.25
      m3.31        0.91350       0.5225        0.30900       0.59550     5.25
      m4.11        0.89500       0.5000        0.36350       0.37225     5.25
      m4.21        0.91050       0.5225        0.38750       0.36900     5.25
      m4.31        0.92225       0.5000        0.34150       0.40750     5.25
      m5.11        0.92350       0.5225        0.30050       0.47125     5.25
      m5.21        0.93550       0.5000        0.29825       0.58050     5.25
      m5.31        0.89150       0.5225        0.41275       0.70425     5.25
      m6.11        0.88375       0.5225        0.38875       0.38900     5.25
      m6.21        0.86800       0.5000        0.39275       0.68775     5.25
      m6.31        0.91650       0.5225        0.45350       0.59550     5.25
      m7.11        0.89425       0.5225        0.44775       0.43825     5.25
      m7.21        0.92425       0.5225        0.39200       0.43825     5.25
      m7.31        0.90025       0.5225        0.33000       0.40700     5.25
      m8.11        0.91825       0.5225        0.43875       0.30500     5.25
      m8.21        0.88450       0.5225        0.39125       0.55900     5.25
      m8.31        0.91825       0.5225        0.49900       0.46525     5.25
      m9.11        0.89475       0.5000        0.36250       0.40975     5.25
      m9.21        0.92425       0.5225        0.54825       0.48775     5.25
      m9.31        0.89350       0.5225        0.49700       0.51625     5.25
      m10.11       0.89475       0.5225        0.37075       0.43600     5.25
      m10.21       0.89675       0.5225        0.44000       0.45625     5.25
      m10.31       0.88600       0.5225        0.39625       0.56700     5.25
             Negative True Positive False Positive True Negative False Negative
      m1.11      5.25          4.50           3.00          5.25           3.50
      m1.21      5.25          4.50           3.25          5.25           3.50
      m1.31      5.25          4.75           3.25          4.75           3.50
      m2.11      5.25          4.50           3.25          5.25           3.75
      m2.21      5.25          4.75           3.25          5.00           3.75
      m2.31      5.25          4.75           3.25          4.75           3.75
      m3.11      5.25          4.75           3.25          4.50           3.00
      m3.21      5.25          4.50           3.00          5.25           2.75
      m3.31      5.25          4.50           3.25          5.25           2.75
      m4.11      5.25          4.75           3.50          5.00           3.50
      m4.21      5.25          4.75           3.50          5.25           3.50
      m4.31      5.25          4.75           3.00          5.00           3.50
      m5.11      5.25          4.75           3.00          5.25           3.00
      m5.21      5.25          4.75           3.00          5.25           3.00
      m5.31      5.25          4.00           3.50          5.00           2.75
      m6.11      5.25          4.75           3.50          4.75           3.50
      m6.21      5.25          4.00           3.75          4.75           3.00
      m6.31      5.25          4.25           2.75          5.00           3.25
      m7.11      5.25          3.75           3.50          5.00           2.75
      m7.21      5.25          4.50           3.00          5.25           3.25
      m7.31      5.25          4.75           3.25          5.25           3.25
      m8.11      5.25          4.75           3.25          5.25           3.75
      m8.21      5.25          4.25           3.50          4.75           3.00
      m8.31      5.25          4.25           3.00          5.25           3.50
      m9.11      5.25          4.75           3.50          5.00           3.50
      m9.21      5.25          4.00           3.00          5.00           3.50
      m9.31      5.25          4.25           2.75          4.75           3.50
      m10.11     5.25          4.50           3.25          5.25           3.25
      m10.21     5.25          4.75           3.50          4.50           3.25
      m10.31     5.25          4.50           3.00          4.75           3.00
                  ROCSD     TSSSD SensitivitySD SpecificitySD Pos Pred ValueSD
      m1.11  0.19077813 0.3774917     0.3000926    0.20059640       0.15591237
      m1.21  0.10754844 0.2061553     0.2061553    0.09428105       0.04201091
      m1.31  0.25655842 0.3862210     0.1258306    0.27537853       0.25000000
      m2.11  0.37074666 0.5000000     0.3714910    0.34996035       0.19341320
      m2.21  0.12893797 0.2494438     0.3283122    0.25163913       0.11547005
      m2.31  0.09714441 0.4255715     0.1667001    0.32015621       0.25000000
      m3.11  0.05347204 0.2061553     0.2061553    0.30000000       0.25000000
      m3.21  0.11993954 0.2581989     0.2582420    0.13350000       0.03934463
      m3.31  0.18102588 0.2910708     0.2909850    0.25000000       0.11199107
      m4.11  0.20646346 0.3333333     0.1154701    0.33993468       0.25000000
      m4.21  0.12806248 0.3415650     0.1154701    0.25166115       0.13874437
      m4.31  0.06540472 0.1763834     0.1707825    0.10000000       0.12500000
      m5.11  0.14636332 0.2872281     0.2872281    0.25824197       0.11518789
      m5.21  0.15881603 0.3468109     0.2000000    0.26287941       0.14752034
      m5.31  0.08766519 0.3457413     0.2005964    0.26880399       0.16870586
      m6.11  0.15818414 0.2061553     0.1165000    0.11650000       0.24994449
      m6.21  0.24608603 0.4229526     0.2629428    0.28722813       0.23094011
      m6.31  0.20551651 0.3785939     0.3127655    0.10000000       0.25000000
      m7.11  0.15748016 0.2018434     0.3267347    0.25000000       0.16650000
      m7.21  0.17086924 0.2629956     0.2628794    0.20615528       0.07387828
      m7.31  0.24962194 0.4245913     0.4244670    0.12583057       0.03603124
      m8.11  0.12897028 0.2061553     0.2061553    0.12572026       0.09136192
      m8.21  0.17725270 0.1663887     0.1885619    0.20000000       0.20000000
      m8.31  0.42768542 0.4776486     0.3415650    0.28493669       0.13947760
      m9.11  0.09758187 0.2061553     0.2005964    0.23350000       0.16650000
      m9.21  0.09797959 0.1575272     0.2905551    0.23350000       0.12500000
      m9.31  0.26975984 0.4961892     0.3918404    0.16650000       0.33350000
      m10.11 0.29471267 0.4374802     0.4374230    0.12583057       0.15427573
      m10.21 0.09933110 0.1374369     0.2494439    0.19148542       0.21423430
      m10.31 0.28394053 0.4879094     0.3773666    0.28722813       0.38509263
             Neg Pred ValueSD PrecisionSD  RecallSD       F1SD PrevalenceSD
      m1.11         0.3437134  0.15591237 0.3000926 0.17275513   0.03674235
      m1.21         0.2499445  0.04201091 0.2061553 0.21942709   0.03674235
      m1.31         0.4787136  0.25000000 0.1258306 0.14594377   0.03674235
      m2.11         0.4787136  0.19341320 0.3714910 0.31575993   0.00000000
      m2.21         0.2309401  0.11547005 0.3283122 0.15678116   0.00000000
      m2.31         0.5773503  0.25000000 0.1667001 0.18681631   0.03674235
      m3.11         0.1631633  0.25000000 0.2061553 0.16529872   0.03674235
      m3.21         0.1922576  0.03934463 0.2582420 0.23294402   0.00000000
      m3.31         0.2362908  0.11199107 0.2909850 0.27597509   0.03674235
      m4.11         0.4760952  0.25000000 0.1154701 0.13488514   0.00000000
      m4.21         0.4714046  0.13874437 0.1154701 0.13710671   0.03674235
      m4.31         0.2499445  0.12500000 0.1707825 0.15763566   0.00000000
      m5.11         0.1631633  0.11518789 0.2872281 0.27243776   0.03674235
      m5.21         0.2500000  0.14752034 0.2000000 0.15093348   0.00000000
      m5.31         0.2849367  0.16870586 0.2005964 0.20967813   0.03674235
      m6.11         0.1922576  0.24994449 0.1165000 0.15238766   0.03674235
      m6.21         0.3188521  0.23094011 0.2629428 0.19362507   0.00000000
      m6.31         0.2886751  0.25000000 0.3127655 0.31160338   0.03674235
      m7.11         0.2629956  0.16650000 0.3267347 0.20967813   0.03674235
      m7.21         0.2629956  0.07387828 0.2628794 0.24635797   0.03674235
      m7.31         0.1716748  0.03603124 0.4244670 0.11242998   0.03674235
      m8.11         0.2499445  0.09136192 0.2061553 0.21942709   0.03674235
      m8.21         0.2096736  0.20000000 0.1885619 0.13176874   0.03674235
      m8.31         0.5000556  0.13947760 0.3415650 0.16686596   0.03674235
      m9.11         0.2362908  0.16650000 0.2005964 0.20967813   0.00000000
      m9.21         0.3309713  0.12500000 0.2905551 0.13000865   0.03674235
      m9.31         0.2886751  0.33350000 0.3918404 0.36530672   0.03674235
      m10.11        0.3750000  0.15427573 0.4374230 0.35941202   0.03674235
      m10.21        0.1716748  0.21423430 0.2494439 0.06271098   0.03674235
      m10.31        0.2500000  0.38509263 0.3773666 0.34389000   0.03674235
             Detection RateSD Detection PrevalenceSD Balanced AccuracySD AccuracySD
      m1.11        0.15988642             0.15988642          0.18887099 0.20149835
      m1.21        0.11088432             0.13505894          0.10307764 0.09033779
      m1.31        0.07502444             0.12972535          0.19311050 0.19420500
      m2.11        0.18584649             0.18584649          0.25000000 0.25000000
      m2.21        0.16413079             0.21665391          0.12472202 0.12472202
      m2.31        0.08230836             0.11816796          0.21269442 0.19754578
      m3.11        0.11088432             0.23789774          0.10307764 0.09386648
      m3.21        0.12905651             0.14142136          0.12905651 0.12905651
      m3.31        0.14569489             0.16781215          0.14562137 0.15058857
      m4.11        0.05773503             0.19145648          0.16670008 0.16670008
      m4.21        0.08446054             0.10144416          0.17078251 0.19127184
      m4.31        0.08539126             0.12500000          0.08825484 0.08825484
      m5.11        0.13150760             0.17262363          0.14361407 0.14615745
      m5.21        0.10000000             0.15670221          0.17346157 0.17346157
      m5.31        0.08948929             0.14595290          0.17302601 0.17135830
      m6.11        0.05219435             0.09342733          0.10322588 0.12311648
      m6.21        0.13155069             0.21879728          0.21151576 0.21151576
      m6.31        0.15242047             0.13012302          0.18922363 0.18922892
      m7.11        0.16165472             0.28075672          0.10095874 0.10974326
      m7.21        0.11257701             0.14984214          0.13161402 0.14941776
      m7.31        0.22290357             0.22290357          0.21241998 0.21312966
      m8.11        0.09988160             0.09988160          0.10307764 0.11116504
      m8.21        0.09824799             0.19224355          0.08317251 0.08425359
      m8.31        0.16732877             0.16732877          0.23880885 0.22341218
      m9.11        0.10044360             0.14946209          0.10314512 0.10314512
      m9.21        0.15065524             0.25268871          0.07892824 0.06843488
      m9.31        0.19619803             0.16741764          0.24827001 0.24768932
      m10.11       0.19678838             0.19678838          0.21879728 0.22603005
      m10.21       0.12495733             0.20979593          0.06883979 0.05995206
      m10.31       0.20352621             0.21760113          0.24407427 0.23264924
               KappaSD AccuracyLowerSD AccuracyUpperSD AccuracyNullSD
      m1.11  0.3772377      0.16006353      0.12904521     0.02598076
      m1.21  0.1977768      0.08152709      0.04481815     0.02598076
      m1.31  0.3877563      0.16890505      0.11103453     0.02598076
      m2.11  0.5000000      0.20487618      0.14554953     0.00000000
      m2.21  0.2494439      0.10663645      0.06870953     0.00000000
      m2.31  0.4231488      0.15992368      0.12004825     0.02598076
      m3.11  0.1952323      0.08499951      0.05232272     0.02598076
      m3.21  0.2582420      0.12453246      0.05168091     0.00000000
      m3.31  0.2914653      0.13752909      0.06913513     0.02598076
      m4.11  0.3333000      0.13678785      0.09905891     0.00000000
      m4.21  0.3382021      0.14916965      0.12605125     0.02598076
      m4.31  0.1763205      0.07786527      0.05078304     0.00000000
      m5.11  0.2916316      0.15352171      0.05762812     0.02598076
      m5.21  0.3467548      0.15668945      0.08316800     0.00000000
      m5.31  0.3438879      0.14848906      0.09895117     0.02598076
      m6.11  0.2106949      0.09876698      0.08042958     0.02598076
      m6.21  0.4229132      0.16057086      0.13928987     0.00000000
      m6.31  0.3788363      0.18656992      0.08659677     0.02598076
      m7.11  0.2039532      0.09313789      0.05929235     0.02598076
      m7.21  0.2737736      0.14856059      0.06811449     0.02598076
      m7.31  0.4238399      0.20515746      0.10111174     0.02598076
      m8.11  0.2097338      0.10725049      0.07248678     0.02598076
      m8.21  0.1665873      0.06976329      0.05007994     0.02598076
      m8.31  0.4754706      0.18144122      0.14097990     0.02598076
      m9.11  0.2061553      0.10183442      0.05533760     0.00000000
      m9.21  0.1596277      0.04482094      0.05293628     0.02598076
      m9.31  0.4999653      0.23668034      0.11239958     0.02598076
      m10.11 0.4396919      0.23908855      0.14287145     0.02598076
      m10.21 0.1298820      0.06036279      0.02947739     0.02598076
      m10.31 0.4831494      0.20848881      0.12271648     0.02598076
             AccuracyPValueSD McnemarPValueSD PositiveSD NegativeSD True PositiveSD
      m1.11         0.4051601       0.1973989        0.5        0.5       1.7078251
      m1.21         0.1600708       0.4196406        0.5        0.5       1.2909944
      m1.31         0.3617857       0.3986389        0.5        0.5       0.9574271
      m2.11         0.3934103       0.4392251        0.5        0.5       1.8257419
      m2.21         0.2489244       0.4439020        0.5        0.5       1.6329932
      m2.31         0.4098203       0.2446717        0.5        0.5       0.8164966
      m3.11         0.1801074       0.4174734        0.5        0.5       1.1547005
      m3.21         0.1498232       0.4174734        0.5        0.5       1.2583057
      m3.31         0.2646638       0.4693893        0.5        0.5       1.4142136
      m4.11         0.3365734       0.4205048        0.5        0.5       0.9574271
      m4.21         0.3882624       0.2199318        0.5        0.5       0.9574271
      m4.31         0.2089569       0.3986389        0.5        0.5       0.9574271
      m5.11         0.1753957       0.4196406        0.5        0.5       1.5000000
      m5.21         0.2657008       0.4895777        0.5        0.5       1.2583057
      m5.31         0.3152823       0.4084820        0.5        0.5       1.1547005
      m6.11         0.3020491       0.2726866        0.5        0.5       0.5000000
      m6.21         0.3910689       0.4416831        0.5        0.5       1.4142136
      m6.31         0.2862278       0.4693893        0.5        0.5       1.7320508
      m7.11         0.2324213       0.3868026        0.5        0.5       1.5000000
      m7.21         0.2619523       0.4132227        0.5        0.5       1.2583057
      m7.31         0.3388943       0.4392251        0.5        0.5       2.4494897
      m8.11         0.2688647       0.2136118        0.5        0.5       1.1547005
      m8.21         0.1842614       0.4330000        0.5        0.5       0.9574271
      m8.31         0.4461353       0.4128134        0.5        0.5       1.7078251
      m9.11         0.2251599       0.4090529        0.5        0.5       0.9574271
      m9.21         0.2134719       0.4284860        0.5        0.5       1.4142136
      m9.31         0.4078540       0.3999553        0.5        0.5       1.9148542
      m10.11        0.3828684       0.3760000        0.5        0.5       2.1602469
      m10.21        0.1207256       0.4364496        0.5        0.5       1.2583057
      m10.31        0.4078794       0.4999853        0.5        0.5       2.2173558
             False PositiveSD True NegativeSD False NegativeSD
      m1.11         1.4142136       0.9574271        1.2909944
      m1.21         0.9574271       0.5000000        0.5773503
      m1.31         0.5773503       1.5000000        1.2909944
      m2.11         2.0615528       1.7320508        1.8929694
      m2.21         1.7078251       1.2909944        1.2583057
      m2.31         0.9574271       1.7320508        1.5000000
      m3.11         0.9574271       1.7320508        1.5000000
      m3.21         1.4142136       1.0000000        0.5000000
      m3.31         1.7078251       1.2909944        1.2583057
      m4.11         0.5773503       1.7078251        1.7320508
      m4.21         0.5773503       1.2583057        1.7320508
      m4.31         0.8164966       0.8164966        0.5773503
      m5.11         1.4142136       1.2583057        1.4142136
      m5.21         1.0000000       1.2583057        1.6329932
      m5.31         1.2909944       1.2909944        1.5000000
      m6.11         1.0000000       0.9574271        1.0000000
      m6.21         1.5000000       1.5000000        1.4142136
      m6.31         1.5000000       0.8164966        0.5000000
      m7.11         1.9148542       1.2909944        1.2583057
      m7.21         1.6329932       1.1547005        0.9574271
      m7.31         2.0615528       0.8164966        0.5000000
      m8.11         0.9574271       0.5773503        0.9574271
      m8.21         1.0000000       1.2583057        1.0000000
      m8.31         2.1602469       1.7078251        1.2909944
      m9.11         1.2909944       1.5000000        1.0000000
      m9.21         1.5000000       1.5000000        1.0000000
      m9.31         2.2173558       0.5000000        1.0000000
      m10.11        2.3629078       0.8164966        0.5000000
      m10.21        1.2909944       1.2909944        0.9574271
      m10.31        1.8257419       1.5000000        1.4142136
      
      $`Araucaria angustifolia`
                    algo       ROC       TSS Sensitivity Specificity Pos Pred Value
      m1.1  mahal.custom 0.9633929 0.7916667     0.98800           1              1
      m2.1  mahal.custom 0.9555556 0.7732143     0.94000           1              1
      m3.1  mahal.custom 0.9734127 0.7613095     0.92800           1              1
      m4.1  mahal.custom 0.9615079 0.7428571     0.95100           1              1
      m5.1  mahal.custom 0.9556264 0.7898810     0.95050           1              1
      m6.1  mahal.custom 0.9700397 0.6815476     0.89000           1              1
      m7.1  mahal.custom 0.9660714 0.7678571     0.97625           1              1
      m8.1  mahal.custom 0.9461310 0.7851190     0.95175           1              1
      m9.1  mahal.custom 0.9570437 0.7666667     0.96300           1              1
      m10.1 mahal.custom 0.9636905 0.7964286     0.96300           1              1
            Neg Pred Value Precision  Recall      F1 Prevalence Detection Rate
      m1.1         0.96425         1 0.98800 0.96475    0.76650        0.75725
      m2.1         0.85325         1 0.94000 0.94375    0.77350        0.72700
      m3.1         0.83325         1 0.92800 0.93675    0.77350        0.71775
      m4.1         0.82250         1 0.95100 0.94575    0.77350        0.73600
      m5.1         0.85175         1 0.95050 0.95075    0.76650        0.72875
      m6.1         0.77525         1 0.89000 0.90900    0.77350        0.68850
      m7.1         0.92850         1 0.97625 0.95900    0.77350        0.75500
      m8.1         0.83675         1 0.95175 0.95175    0.78125        0.74400
      m9.1         0.86650         1 0.96300 0.95150    0.76650        0.73850
      m10.1        0.86650         1 0.96300 0.95775    0.78125        0.75250
            Detection Prevalence Balanced Accuracy Accuracy   Kappa AccuracyLower
      m1.1               0.80400           0.89575  0.94425 0.83200       0.78200
      m2.1               0.76475           0.88650  0.91575 0.77100       0.74550
      m3.1               0.75500           0.88075  0.90675 0.75525       0.73775
      m4.1               0.78325           0.87150  0.91500 0.74875       0.74125
      m5.1               0.76625           0.89500  0.92500 0.78925       0.75550
      m6.1               0.73550           0.84050  0.86800 0.65950       0.68275
      m7.1               0.80175           0.88400  0.93500 0.79775       0.77200
      m8.1               0.78125           0.89275  0.92525 0.78450       0.75700
      m9.1               0.78550           0.88325  0.92500 0.78450       0.75875
      m10.1              0.78975           0.89850  0.93375 0.80275       0.76575
            AccuracyUpper AccuracyNull AccuracyPValue McnemarPValue Positive Negative
      m1.1        0.99500      0.76650        0.98050     0.7400000     20.5     6.25
      m2.1        0.98150      0.77350        0.96250     0.7127500     20.5     6.00
      m3.1        0.97400      0.77350        0.96275     0.5670000     20.5     6.00
      m4.1        0.98550      0.77350        0.97400     1.0000000     20.5     6.00
      m5.1        0.98925      0.76650        0.93150     0.8700000     20.5     6.25
      m6.1        0.96325      0.77350        0.88725     0.3512500     20.5     6.00
      m7.1        0.98775      0.77350        0.93800     0.7493333     20.5     6.00
      m8.1        0.98575      0.78125        0.98975     1.0000000     20.5     5.75
      m9.1        0.98575      0.76650        0.97275     1.0000000     20.5     6.25
      m10.1       0.99125      0.78125        0.98700     1.0000000     20.5     5.75
            True Positive False Positive True Negative False Negative      ROCSD
      m1.1          20.25          11.00          6.25           1.25 0.03023239
      m2.1          19.25          11.25          6.00           1.00 0.04038661
      m3.1          19.00          11.50          6.00           1.00 0.03261702
      m4.1          19.50          11.25          6.00           1.25 0.03677011
      m5.1          19.50          11.00          6.25           1.00 0.04473929
      m6.1          18.25          11.50          6.00           1.25 0.03441417
      m7.1          20.00          11.00          6.00           1.25 0.03050053
      m8.1          19.50          11.75          5.75           1.00 0.05257337
      m9.1          19.75          11.25          6.25           1.25 0.03565306
      m10.1         19.75          10.75          5.75           1.00 0.02423236
                TSSSD SensitivitySD SpecificitySD Pos Pred ValueSD Neg Pred ValueSD
      m1.1  0.1280339    0.09085657     0.1484644       0.04236744       0.07150000
      m2.1  0.1451584    0.14195158     0.1359470       0.03753221       0.20931854
      m3.1  0.1770077    0.15516738     0.1359470       0.03626752       0.23570232
      m4.1  0.1599910    0.14670236     0.1593683       0.04427942       0.05641144
      m5.1  0.1704613    0.17058991     0.1364609       0.03880722       0.10806904
      m6.1  0.2354255    0.23528334     0.1593683       0.04201984       0.25955780
      m7.1  0.2088146    0.15220710     0.2096736       0.05162929       0.14300000
      m8.1  0.1591309    0.11893240     0.1359470       0.03724133       0.11983704
      m9.1  0.1710644    0.12114007     0.1484644       0.04543494       0.09034932
      m10.1 0.1373337    0.04383587     0.1359470       0.03722454       0.09034932
            PrecisionSD   RecallSD       F1SD PrevalenceSD Detection RateSD
      m1.1   0.04236744 0.09085657 0.08567380  0.017521415       0.07625123
      m2.1   0.03753221 0.14195158 0.13703862  0.005196152       0.11034793
      m3.1   0.03626752 0.15516738 0.15548097  0.005196152       0.12001493
      m4.1   0.04427942 0.14670236 0.15362617  0.005196152       0.11330012
      m5.1   0.03880722 0.17058991 0.16469871  0.011789826       0.13359266
      m6.1   0.04201984 0.23528334 0.23139721  0.005196152       0.18123557
      m7.1   0.05162929 0.15220710 0.13875968  0.005196152       0.11946652
      m8.1   0.03724133 0.11893240 0.11978696  0.013200379       0.09628560
      m9.1   0.04543494 0.12114007 0.12182604  0.017521415       0.09428680
      m10.1  0.03722454 0.04383587 0.04053805  0.013200379       0.03192047
            Detection PrevalenceSD Balanced AccuracySD AccuracySD    KappaSD
      m1.1              0.07625123          0.06411123 0.06094807 0.07058801
      m2.1              0.11034793          0.07283543 0.11071096 0.16399797
      m3.1              0.12001493          0.08845856 0.11920570 0.21282916
      m4.1              0.11330012          0.07990620 0.11530250 0.11658009
      m5.1              0.13359266          0.08509358 0.13052714 0.13895443
      m6.1              0.18123557          0.11773523 0.18170925 0.19442115
      m7.1              0.11946652          0.10444456 0.11599713 0.17728955
      m8.1              0.09628560          0.07940351 0.09026073 0.15286268
      m9.1              0.09428680          0.08566359 0.09567088 0.15369776
      m10.1             0.03192047          0.06848114 0.03777455 0.10781891
            AccuracyLowerSD AccuracyUpperSD AccuracyNullSD AccuracyPValueSD
      m1.1       0.05842944      0.05000333    0.017521415       0.02573584
      m2.1       0.10353542      0.09182002    0.005196152       0.20286038
      m3.1       0.12014262      0.10017110    0.005196152       0.29012914
      m4.1       0.10318915      0.10068888    0.005196152       0.05516641
      m5.1       0.12462343      0.10599174    0.011789826       0.11299705
      m6.1       0.17047458      0.15024535    0.005196152       0.22112591
      m7.1       0.11326775      0.09232010    0.005196152       0.11671332
      m8.1       0.07903744      0.07970989    0.013200379       0.05772564
      m9.1       0.08705314      0.08171087    0.017521415       0.04847250
      m10.1      0.04650717      0.03024759    0.013200379       0.04819665
            McnemarPValueSD PositiveSD NegativeSD True PositiveSD False PositiveSD
      m1.1      0.300222140  0.5773503        0.5       2.0816660        1.6329932
      m2.1      0.334659404  0.5773503        0.0       2.9860788        2.9860788
      m3.1      0.396720304  0.5773503        0.0       3.1622777        3.1091264
      m4.1      0.003265986  0.5773503        0.0       2.9860788        3.2015621
      m5.1      0.260000000  0.5773503        0.5       3.6968455        3.2659863
      m6.1      0.191842600  0.5773503        0.0       4.7609523        4.7958315
      m7.1      0.434167402  0.5773503        0.0       3.3166248        2.9439203
      m8.1      0.003593976  0.5773503        0.5       2.2173558        2.7537853
      m9.1      0.003304038  0.5773503        0.5       2.5000000        2.6299556
      m10.1     0.001414214  0.5773503        0.5       0.9574271        0.9574271
            True NegativeSD False NegativeSD
      m1.1        0.8164966        0.9574271
      m2.1        0.8164966        0.8164966
      m3.1        0.8164966        0.8164966
      m4.1        0.9574271        0.9574271
      m5.1        0.9574271        0.8164966
      m6.1        0.9574271        0.9574271
      m7.1        1.2583057        1.2583057
      m8.1        0.5000000        0.8164966
      m9.1        0.8164966        0.9574271
      m10.1       0.5000000        0.8164966
      

---

    Code
      i2$models
    Output
               caretSDM        
      .........................
      Class                   : Models
      Algorithms Names        : kknn 
      Variables Names         : bio1 bio4 bio12 
      Model Validation        :
               Method          : repeatedcv 
               Number          : 4 
               Metrics         :
      $`Salminus brasiliensis`
             algo       ROC       TSS Sensitivity Specificity Pos Pred Value
      m1.11  kknn 0.9500000 0.9000000     0.95000     0.95000        0.95825
      m1.21  kknn 0.8000000 0.5250000     0.71675     0.85825        0.81675
      m1.31  kknn 0.9750000 0.8500000     0.90000     0.95000        0.95825
      m2.11  kknn 0.8891667 0.6583333     0.80000     0.85825        0.86425
      m2.21  kknn 0.8259722 0.4416667     0.71675     0.77500        0.79275
      m2.31  kknn 0.9583333 0.7416667     0.86675     0.87500        0.89275
      m3.11  kknn 0.9791667 0.9583333     0.95825     1.00000        1.00000
      m3.21  kknn 0.8433333 0.6333333     0.67500     0.95825        0.95825
      m3.31  kknn 0.9291667 0.8583333     0.90825     0.95000        0.95825
      m4.11  kknn 0.9291667 0.8583333     0.90000     0.95825        0.95000
      m4.21  kknn 0.7958333 0.5916667     0.68325     0.90825        0.88750
      m4.31  kknn 0.9650000 0.8583333     0.90825     0.95000        0.95825
      m5.11  kknn 0.9541667 0.9083333     0.95825     0.95000        0.95825
      m5.21  kknn 0.8391667 0.5166667     0.66675     0.90000        0.88750
      m5.31  kknn 0.9375000 0.8750000     0.91675     0.95825        0.95825
      m6.11  kknn 0.9041667 0.8083333     0.85825     0.95000        0.93750
      m6.21  kknn 0.8941667 0.6666667     0.80000     0.86675        0.88100
      m6.31  kknn 0.9750000 0.9500000     0.95000     1.00000        1.00000
      m7.11  kknn 0.9000000 0.8000000     0.85000     0.95000        0.96425
      m7.21  kknn 0.7466667 0.4083333     0.55825     0.85000        0.81250
      m7.31  kknn 0.9900000 0.9000000     0.95000     0.95000        0.95825
      m8.11  kknn 0.9291667 0.8583333     0.90825     0.95000        0.95000
      m8.21  kknn 0.8958333 0.5083333     0.76675     0.74175        0.82500
      m8.31  kknn 0.9250000 0.8500000     0.90000     0.95000        0.95000
      m9.11  kknn 0.8833333 0.7666667     0.81675     0.95000        0.95825
      m9.21  kknn 0.9030556 0.7083333     0.80000     0.90825        0.91425
      m9.31  kknn 0.9250000 0.8500000     0.95000     0.90000        0.92250
      m10.11 kknn 0.9750000 0.9500000     0.95000     1.00000        1.00000
      m10.21 kknn 0.7875000 0.4750000     0.62500     0.85000        0.82500
      m10.31 kknn 0.9750000 0.9500000     0.95000     1.00000        1.00000
             Neg Pred Value Precision  Recall      F1 Prevalence Detection Rate
      m1.11         0.95825   0.95825 0.95000 0.94950        0.5        0.47500
      m1.21         0.73675   0.81675 0.71675 0.75425        0.5        0.35700
      m1.31         0.92850   0.95825 0.90000 0.91475        0.5        0.45000
      m2.11         0.81650   0.86425 0.80000 0.82525        0.5        0.40000
      m2.21         0.71675   0.79275 0.71675 0.72050        0.5        0.35825
      m2.31         0.86600   0.89275 0.86675 0.86675        0.5        0.43200
      m3.11         0.95825   1.00000 0.95825 0.97725        0.5        0.47750
      m3.21         0.76325   0.95825 0.67500 0.76900        0.5        0.33200
      m3.31         0.90825   0.95825 0.90825 0.93050        0.5        0.45250
      m4.11         0.91650   0.95000 0.90000 0.92225        0.5        0.45225
      m4.21         0.76400   0.88750 0.68325 0.74175        0.5        0.33650
      m4.31         0.92250   0.95825 0.90825 0.92675        0.5        0.45425
      m5.11         0.95825   0.95825 0.95825 0.95450        0.5        0.47750
      m5.21         0.71200   0.88750 0.66675 0.71675        0.5        0.33425
      m5.31         0.92850   0.95825 0.91675 0.92725        0.5        0.45475
      m6.11         0.87500   0.93750 0.85825 0.89400        0.5        0.42750
      m6.21         0.83675   0.88100 0.80000 0.82225        0.5        0.40225
      m6.31         0.95825   1.00000 0.95000 0.97225        0.5        0.47500
      m7.11         0.89575   0.96425 0.85000 0.89050        0.5        0.42950
      m7.21         0.67625   0.81250 0.55825 0.64275        0.5        0.28425
      m7.31         0.95825   0.95825 0.95000 0.94950        0.5        0.47500
      m8.11         0.90825   0.95000 0.90825 0.92725        0.5        0.45250
      m8.21         0.80350   0.82500 0.76675 0.75825        0.5        0.37975
      m8.31         0.91425   0.95000 0.90000 0.92225        0.5        0.45225
      m9.11         0.85700   0.95825 0.81675 0.86475        0.5        0.40475
      m9.21         0.83675   0.91425 0.80000 0.84050        0.5        0.40000
      m9.31         0.95825   0.92250 0.95000 0.93025        0.5        0.47500
      m10.11        0.95825   1.00000 0.95000 0.97225        0.5        0.47500
      m10.21        0.69700   0.82500 0.62500 0.70425        0.5        0.31150
      m10.31        0.95825   1.00000 0.95000 0.97225        0.5        0.47500
             Detection Prevalence Balanced Accuracy Accuracy   Kappa AccuracyLower
      m1.11               0.50000           0.95000  0.95000 0.90000       0.63425
      m1.21               0.45000           0.76250  0.76350 0.52500       0.41950
      m1.31               0.47500           0.92500  0.92500 0.85000       0.60650
      m2.11               0.47075           0.82925  0.82925 0.65825       0.49675
      m2.21               0.49575           0.72075  0.72075 0.44175       0.37825
      m2.31               0.50000           0.87075  0.86350 0.73375       0.54350
      m3.11               0.47750           0.97925  0.97725 0.95500       0.67150
      m3.21               0.35450           0.81675  0.80900 0.62400       0.46625
      m3.31               0.47500           0.92925  0.92950 0.85825       0.61100
      m4.11               0.47500           0.92925  0.92950 0.85825       0.61100
      m4.21               0.38425           0.79600  0.78850 0.58625       0.45750
      m4.31               0.47925           0.92925  0.92925 0.85825       0.60425
      m5.11               0.50250           0.95425  0.95225 0.90500       0.63725
      m5.21               0.42975           0.75825  0.76125 0.51650       0.41600
      m5.31               0.47725           0.93750  0.93175 0.86625       0.61325
      m6.11               0.45250           0.90425  0.90225 0.80500       0.58550
      m6.21               0.47025           0.83325  0.83400 0.66825       0.49400
      m6.31               0.47500           0.97500  0.97500 0.95000       0.66925
      m7.11               0.45225           0.90000  0.90675 0.80875       0.57900
      m7.21               0.35675           0.70425  0.71125 0.41350       0.37050
      m7.31               0.50000           0.95000  0.95000 0.90000       0.63425
      m8.11               0.47750           0.92925  0.92725 0.85500       0.60950
      m8.21               0.51600           0.75400  0.74300 0.50325       0.40575
      m8.31               0.47725           0.92500  0.92725 0.85350       0.60950
      m9.11               0.42975           0.88325  0.87950 0.76125       0.54900
      m9.21               0.44575           0.85425  0.85425 0.70825       0.51450
      m9.31               0.52275           0.92500  0.92725 0.85350       0.60300
      m10.11              0.47500           0.97500  0.97500 0.95000       0.66925
      m10.21              0.40925           0.73750  0.73850 0.47775       0.39550
      m10.31              0.47500           0.97500  0.97500 0.95000       0.66850
             AccuracyUpper AccuracyNull AccuracyPValue McnemarPValue Positive
      m1.11        0.99850       0.5000        0.00575     1.0000000     5.25
      m1.21        0.95450       0.5225        0.19800     0.8700000     5.25
      m1.31        0.99300       0.5000        0.01675     0.7400000     5.25
      m2.11        0.96750       0.5000        0.10050     1.0000000     5.25
      m2.21        0.93275       0.5000        0.16725     1.0000000     5.25
      m2.31        0.96700       0.5225        0.11200     0.5485000     5.25
      m3.11        0.99950       0.5225        0.00400     1.0000000     5.25
      m3.21        0.97200       0.5225        0.07650     0.5520000     5.25
      m3.31        0.99350       0.5225        0.01850     1.0000000     5.25
      m4.11        0.99350       0.5225        0.01850     1.0000000     5.25
      m4.21        0.95025       0.5225        0.15475     0.7113333     5.25
      m4.31        0.99800       0.5000        0.00650     1.0000000     5.25
      m5.11        0.99875       0.5225        0.00650     1.0000000     5.25
      m5.21        0.95625       0.5225        0.16825     0.8700000     5.25
      m5.31        0.99375       0.5225        0.01900     0.7400000     5.25
      m6.11        0.98275       0.5225        0.04675     1.0000000     5.25
      m6.21        0.97750       0.5225        0.06550     0.8700000     5.25
      m6.31        0.99925       0.5225        0.00350     1.0000000     5.25
      m7.11        0.99300       0.5225        0.02150     0.8266667     5.25
      m7.21        0.93200       0.5225        0.19825     0.7162500     5.25
      m7.31        0.99850       0.5000        0.00575     1.0000000     5.25
      m8.11        0.99325       0.5225        0.01750     1.0000000     5.25
      m8.21        0.93625       0.5225        0.24675     0.6385000     5.25
      m8.31        0.99325       0.5225        0.01750     1.0000000     5.25
      m9.11        0.98725       0.5225        0.03200     0.6533333     5.25
      m9.21        0.98625       0.5000        0.07125     0.8700000     5.25
      m9.31        0.99800       0.5225        0.00900     1.0000000     5.25
      m10.11       0.99925       0.5225        0.00350     1.0000000     5.25
      m10.21       0.94400       0.5225        0.21950     0.7742500     5.25
      m10.31       0.99925       0.5000        0.00325     1.0000000     5.25
             Negative True Positive False Positive True Negative False Negative
      m1.11      5.25          5.00           0.25          5.00           0.25
      m1.21      5.25          3.75           2.00          4.50           1.00
      m1.31      5.25          4.75           0.50          5.00           0.25
      m2.11      5.25          4.25           1.00          4.50           0.75
      m2.21      5.25          3.75           1.75          4.00           1.50
      m2.31      5.25          4.50           0.75          4.50           0.75
      m3.11      5.25          5.00           0.25          5.25           0.00
      m3.21      5.25          3.50           1.75          5.00           0.25
      m3.31      5.25          4.75           0.50          5.00           0.25
      m4.11      5.25          4.75           0.50          5.00           0.25
      m4.21      5.25          3.50           1.75          4.75           0.50
      m4.31      5.25          4.75           0.50          5.00           0.25
      m5.11      5.25          5.00           0.25          5.00           0.25
      m5.21      5.25          3.50           2.00          4.75           1.00
      m5.31      5.25          4.75           0.50          5.00           0.25
      m6.11      5.25          4.50           0.75          5.00           0.25
      m6.21      5.25          4.25           1.00          4.50           0.75
      m6.31      5.25          5.00           0.25          5.25           0.00
      m7.11      5.25          4.50           0.75          5.00           0.25
      m7.21      5.25          3.00           2.25          4.50           0.75
      m7.31      5.25          5.00           0.25          5.00           0.25
      m8.11      5.25          4.75           0.50          5.00           0.25
      m8.21      5.25          4.00           1.50          3.75           1.50
      m8.31      5.25          4.75           0.50          5.00           0.25
      m9.11      5.25          4.25           1.00          5.00           0.25
      m9.21      5.25          4.25           1.25          4.75           0.75
      m9.31      5.25          5.00           0.25          4.75           0.50
      m10.11     5.25          5.00           0.25          5.25           0.00
      m10.21     5.25          3.25           2.00          4.50           1.00
      m10.31     5.25          5.00           0.25          5.25           0.00
                  ROCSD      TSSSD SensitivitySD SpecificitySD Pos Pred ValueSD
      m1.11  0.05773503 0.11547005     0.1000000     0.1000000       0.08350000
      m1.21  0.11970256 0.23940513     0.2212591     0.1641308       0.13731563
      m1.31  0.05000000 0.19148542     0.2000000     0.1000000       0.08350000
      m2.11  0.03370625 0.30595933     0.1632993     0.1893117       0.18862374
      m2.21  0.11069680 0.20615528     0.1885619     0.2061553       0.17533848
      m2.31  0.08333333 0.33374974     0.1631633     0.2500000       0.21450000
      m3.11  0.04166667 0.08333333     0.0835000     0.0000000       0.00000000
      m3.21  0.08814970 0.14142136     0.2217356     0.0835000       0.08350000
      m3.31  0.08858455 0.17716910     0.1067969     0.1000000       0.08350000
      m4.11  0.08858455 0.17716910     0.1154701     0.0835000       0.10000000
      m4.21  0.15053915 0.30107831     0.2849367     0.1067969       0.13149778
      m4.31  0.04725816 0.09574271     0.1067969     0.1000000       0.08350000
      m5.11  0.05335937 0.10671874     0.0835000     0.1000000       0.08350000
      m5.21  0.12583057 0.18358568     0.1667001     0.1373156       0.16520190
      m5.31  0.07978559 0.15957118     0.1665000     0.0835000       0.08350000
      m6.11  0.14166667 0.28333333     0.1893117     0.1000000       0.12500000
      m6.21  0.08247895 0.16329932     0.1632993     0.1631633       0.15779100
      m6.31  0.05000000 0.10000000     0.1000000     0.0000000       0.00000000
      m7.11  0.08164966 0.16329932     0.1914854     0.1000000       0.07150000
      m7.21  0.15930404 0.17716910     0.2060071     0.1000000       0.14218884
      m7.31  0.02000000 0.11547005     0.1000000     0.1000000       0.08350000
      m8.11  0.09464847 0.18929694     0.1067969     0.1000000       0.10000000
      m8.21  0.14101156 0.26579719     0.2516391     0.3945955       0.23629078
      m8.31  0.09574271 0.19148542     0.1154701     0.1000000       0.10000000
      m9.11  0.08819171 0.17638342     0.2133594     0.1000000       0.08350000
      m9.21  0.11665212 0.17716910     0.1914854     0.1067969       0.10806904
      m9.31  0.05000000 0.10000000     0.1000000     0.1154701       0.09002407
      m10.11 0.05000000 0.10000000     0.1000000     0.0000000       0.00000000
      m10.21 0.15478480 0.20615528     0.1258306     0.1632993       0.16520190
      m10.31 0.05000000 0.10000000     0.1000000     0.0000000       0.00000000
             Neg Pred ValueSD PrecisionSD  RecallSD       F1SD PrevalenceSD
      m1.11        0.08350000  0.08350000 0.1000000 0.05888124   0.00000000
      m1.21        0.14981405  0.13731563 0.2212591 0.17129604   0.03674235
      m1.31        0.14300000  0.08350000 0.2000000 0.11791346   0.00000000
      m2.11        0.16440702  0.18862374 0.1632993 0.15101959   0.00000000
      m2.21        0.10873324  0.17533848 0.1885619 0.12085391   0.00000000
      m2.31        0.15542630  0.21450000 0.1631633 0.16316326   0.03674235
      m3.11        0.08350000  0.00000000 0.0835000 0.04550000   0.03674235
      m3.21        0.16331437  0.08350000 0.2217356 0.10120277   0.03674235
      m3.31        0.10679693  0.08350000 0.1067969 0.08344459   0.03674235
      m4.11        0.09641749  0.10000000 0.1154701 0.09685169   0.03674235
      m4.21        0.19419063  0.13149778 0.2849367 0.21143695   0.03674235
      m4.31        0.09002407  0.08350000 0.1067969 0.04973513   0.00000000
      m5.11        0.08350000  0.08350000 0.0835000 0.05253887   0.03674235
      m5.21        0.06271098  0.16520190 0.1667001 0.11160794   0.03674235
      m5.31        0.14300000  0.08350000 0.1665000 0.09506270   0.03674235
      m6.11        0.15945532  0.12500000 0.1893117 0.15729590   0.03674235
      m6.21        0.11983704  0.15779100 0.1632993 0.09814742   0.03674235
      m6.31        0.08350000  0.00000000 0.1000000 0.05550000   0.03674235
      m7.11        0.12505565  0.07150000 0.1914854 0.10454505   0.03674235
      m7.21        0.09409702  0.14218884 0.2060071 0.14411656   0.03674235
      m7.31        0.08350000  0.08350000 0.1000000 0.05888124   0.00000000
      m8.11        0.10679693  0.10000000 0.1067969 0.09506270   0.03674235
      m8.21        0.17126661  0.23629078 0.2516391 0.13348034   0.03674235
      m8.31        0.10171324  0.10000000 0.1154701 0.09685169   0.03674235
      m9.11        0.16512218  0.08350000 0.2133594 0.11196837   0.03674235
      m9.21        0.14719007  0.10806904 0.1914854 0.10711053   0.00000000
      m9.31        0.08350000  0.09002407 0.1000000 0.04854809   0.03674235
      m10.11       0.08350000  0.00000000 0.1000000 0.05550000   0.03674235
      m10.21       0.11192371  0.16520190 0.1258306 0.10307764   0.03674235
      m10.31       0.08350000  0.00000000 0.1000000 0.05550000   0.00000000
             Detection RateSD Detection PrevalenceSD Balanced AccuracySD AccuracySD
      m1.11        0.05000000             0.08164966          0.05773503 0.05773503
      m1.21        0.09572704             0.11233581          0.11960212 0.13077557
      m1.31        0.10000000             0.12583057          0.09574271 0.09574271
      m2.11        0.08164966             0.08844348          0.15304329 0.15304329
      m2.21        0.09428105             0.16844064          0.10322588 0.10322588
      m2.31        0.07851964             0.11104354          0.16689992 0.17425173
      m3.11        0.02598076             0.02598076          0.04150000 0.04550000
      m3.21        0.08298193             0.12763620          0.07086783 0.07502444
      m3.31        0.04092676             0.06204837          0.08844348 0.08802083
      m4.11        0.08446054             0.06204837          0.08844348 0.08802083
      m4.21        0.13252798             0.14089801          0.15045930 0.15988642
      m4.31        0.05328149             0.09159103          0.04784262 0.04784262
      m5.11        0.02598076             0.06837397          0.05328149 0.05525924
      m5.21        0.09572704             0.13277927          0.09181322 0.08581181
      m5.31        0.06411123             0.07842353          0.07990202 0.08712587
      m6.11        0.08760708             0.04092676          0.14167657 0.14149293
      m6.21        0.10376375             0.14942194          0.08178580 0.08676789
      m6.31        0.06204837             0.06204837          0.05000000 0.05000000
      m7.11        0.12065516             0.15373652          0.08164966 0.07443733
      m7.21        0.12510895             0.15391204          0.08872570 0.08971575
      m7.31        0.05000000             0.08164966          0.05773503 0.05773503
      m8.11        0.04092676             0.02598076          0.09463394 0.09506270
      m8.21        0.10974326             0.29943391          0.13305888 0.14984214
      m8.31        0.08446054             0.07842353          0.09574271 0.09506270
      m9.11        0.08987167             0.13010348          0.08825484 0.09136557
      m9.21        0.09574271             0.12263326          0.08872570 0.08872570
      m9.31        0.06204837             0.11321182          0.05000000 0.04868521
      m10.11       0.06204837             0.06204837          0.05000000 0.05000000
      m10.21       0.06035727             0.11117966          0.10307764 0.11149140
      m10.31       0.05000000             0.05000000          0.05000000 0.05000000
                KappaSD AccuracyLowerSD AccuracyUpperSD AccuracyNullSD
      m1.11  0.11547005      0.09317859     0.001732051     0.00000000
      m1.21  0.24249948      0.11276524     0.071339564     0.02598076
      m1.31  0.19148542      0.13276671     0.012083046     0.00000000
      m2.11  0.30589582      0.15903537     0.059668529     0.00000000
      m2.21  0.20600708      0.08126654     0.059868606     0.00000000
      m2.31  0.33988662      0.18560442     0.051813769     0.02598076
      m3.11  0.09000000      0.05736724     0.001000000     0.02598076
      m3.21  0.14314561      0.08442896     0.023930455     0.02598076
      m3.31  0.17731023      0.11128642     0.011090537     0.02598076
      m4.11  0.17731023      0.11128642     0.011090537     0.02598076
      m4.21  0.30728746      0.17313867     0.048300276     0.02598076
      m4.31  0.09577186      0.06497884     0.001414214     0.00000000
      m5.11  0.11000000      0.07817235     0.001500000     0.02598076
      m5.21  0.17642562      0.08113158     0.040743098     0.02598076
      m5.31  0.17016536      0.10052985     0.011206397     0.02598076
      m6.11  0.28301943      0.16785013     0.033180064     0.02598076
      m6.21  0.17033765      0.09253108     0.027160020     0.02598076
      m6.31  0.10000000      0.07693450     0.001500000     0.02598076
      m7.11  0.15484481      0.08721238     0.010739336     0.02598076
      m7.21  0.17701318      0.09145308     0.040849317     0.02598076
      m7.31  0.11547005      0.09317859     0.001732051     0.00000000
      m8.11  0.19000000      0.12360286     0.012203142     0.02598076
      m8.21  0.27163379      0.13352247     0.072724938     0.02598076
      m8.31  0.19039170      0.12360286     0.012203142     0.02598076
      m9.11  0.18075651      0.11986937     0.013073510     0.02598076
      m9.21  0.17702801      0.11113168     0.027097048     0.00000000
      m9.31  0.09788939      0.07617524     0.001414214     0.02598076
      m10.11 0.10000000      0.07693450     0.001500000     0.02598076
      m10.21 0.21436787      0.10561566     0.053099749     0.02598076
      m10.31 0.10000000      0.07833475     0.001500000     0.00000000
             AccuracyPValueSD McnemarPValueSD PositiveSD NegativeSD True PositiveSD
      m1.11       0.006075909      0.00000000        0.5        0.5       0.8164966
      m1.21       0.282014184      0.33465940        0.5        0.5       0.9574271
      m1.31       0.025979158      0.36769553        0.5        0.5       1.2583057
      m2.11       0.184371907      0.00000000        0.5        0.5       1.2583057
      m2.21       0.156538334      0.37600000        0.5        0.5       1.0000000
      m2.31       0.184184690      0.09687363        0.5        0.5       0.5773503
      m3.11       0.006000000              NA        0.5        0.5       0.0000000
      m3.21       0.073708887      0.31806079        0.5        0.5       1.0000000
      m3.31       0.028722813      0.00000000        0.5        0.5       0.5000000
      m4.11       0.028722813      0.00000000        0.5        0.5       0.9574271
      m4.21       0.169056943      0.49998533        0.5        0.5       1.2909944
      m4.31       0.005259911      0.00000000        0.5        0.5       0.5000000
      m5.11       0.006403124      0.00000000        0.5        0.5       0.0000000
      m5.21       0.154189007      0.37921322        0.5        0.5       0.9574271
      m5.31       0.028565714      0.36769553        0.5        0.5       0.5000000
      m6.11       0.083691397      0.00000000        0.5        0.5       1.0000000
      m6.21       0.080917654      0.26000000        0.5        0.5       1.2583057
      m6.31       0.005000000              NA        0.5        0.5       0.8164966
      m7.11       0.026851443      0.30022214        0.5        0.5       1.2909944
      m7.21       0.131289439      0.36061833        0.5        0.5       1.4142136
      m7.31       0.006075909      0.00000000        0.5        0.5       0.8164966
      m8.11       0.025632011      0.00000000        0.5        0.5       0.5000000
      m8.21       0.278717898      0.48957771        0.5        0.5       1.2583057
      m8.31       0.025632011      0.00000000        0.5        0.5       0.9574271
      m9.11       0.030397368      0.30022214        0.5        0.5       0.9574271
      m9.21       0.071500000      0.26000000        0.5        0.5       1.4142136
      m9.31       0.005416026      0.00000000        0.5        0.5       0.8164966
      m10.11      0.005000000              NA        0.5        0.5       0.8164966
      m10.21      0.186528818      0.26660630        0.5        0.5       0.5000000
      m10.31      0.005188127              NA        0.5        0.5       0.8164966
             False PositiveSD True NegativeSD False NegativeSD
      m1.11         0.5000000       0.8164966        0.5000000
      m1.21         1.4142136       0.9574271        0.8164966
      m1.31         1.0000000       0.8164966        0.5000000
      m2.11         0.8164966       1.0000000        0.9574271
      m2.21         0.9574271       0.8164966        1.2583057
      m2.31         0.9574271       1.0000000        1.5000000
      m3.11         0.5000000       0.5000000        0.0000000
      m3.21         1.2583057       0.0000000        0.5000000
      m3.31         0.5773503       0.8164966        0.5000000
      m4.11         0.5773503       0.0000000        0.5000000
      m4.21         1.7078251       0.5000000        0.5773503
      m4.31         0.5773503       0.8164966        0.5000000
      m5.11         0.5000000       0.8164966        0.5000000
      m5.21         0.8164966       0.9574271        0.8164966
      m5.31         1.0000000       0.0000000        0.5000000
      m6.11         0.9574271       0.8164966        0.5000000
      m6.21         0.8164966       0.5773503        0.9574271
      m6.31         0.5000000       0.5000000        0.0000000
      m7.11         0.9574271       0.8164966        0.5000000
      m7.21         0.9574271       1.0000000        0.5000000
      m7.31         0.5000000       0.8164966        0.5000000
      m8.11         0.5773503       0.8164966        0.5000000
      m8.21         1.2909944       1.8929694        2.3804761
      m8.31         0.5773503       0.8164966        0.5000000
      m9.11         1.1547005       0.8164966        0.5000000
      m9.21         0.9574271       0.5773503        0.5773503
      m9.31         0.5000000       0.9574271        0.5773503
      m10.11        0.5000000       0.5000000        0.0000000
      m10.21        0.8164966       1.2583057        0.8164966
      m10.31        0.5000000       0.5000000        0.0000000
      
      $`Araucaria angustifolia`
            algo       ROC       TSS Sensitivity Specificity Pos Pred Value
      m1.1  kknn 0.9729167 0.9458333     0.98750     0.95825        0.98750
      m2.1  kknn 0.9520833 0.8922619     0.97550     0.91650        0.97550
      m3.1  kknn 0.9464286 0.8928571     0.97625     0.91650        0.97675
      m4.1  kknn 0.9464286 0.8678571     0.95125     0.91650        0.97625
      m5.1  kknn 0.9464286 0.7797619     0.98800     0.79150        0.94800
      m6.1  kknn 0.9732143 0.9464286     0.98800     0.95825        0.98800
      m7.1  kknn 0.9464286 0.8928571     0.97625     0.91650        0.97675
      m8.1  kknn 0.9692460 0.8922619     0.97550     0.91650        0.97675
      m9.1  kknn 0.9464286 0.8511905     0.97625     0.87500        0.96625
      m10.1 kknn 0.9629960 0.8089286     0.97550     0.83325        0.95625
            Neg Pred Value Precision  Recall      F1 Prevalence Detection Rate
      m1.1         0.95825   0.98750 0.98750 0.98750    0.76650        0.75700
      m2.1         0.92250   0.97550 0.97550 0.97550    0.77350        0.75475
      m3.1         0.93750   0.97675 0.97625 0.97575    0.77350        0.75500
      m4.1         0.86600   0.97625 0.95125 0.96275    0.77350        0.73575
      m5.1         0.95825   0.94800 0.98800 0.96625    0.76650        0.75725
      m6.1         0.96425   0.98800 0.98800 0.98800    0.77350        0.76425
      m7.1         0.93750   0.97675 0.97625 0.97575    0.77350        0.75500
      m8.1         0.91650   0.97675 0.97550 0.97575    0.78125        0.76200
      m9.1         0.94450   0.96625 0.97625 0.97025    0.76650        0.74875
      m10.1        0.91650   0.95625 0.97550 0.96475    0.78100        0.76175
            Detection Prevalence Balanced Accuracy Accuracy   Kappa AccuracyLower
      m1.1               0.76650           0.97300  0.98075 0.94575       0.84150
      m2.1               0.77400           0.94625  0.96200 0.89175       0.80875
      m3.1               0.77400           0.94650  0.96275 0.89500       0.80975
      m4.1               0.75425           0.93400  0.94375 0.84725       0.78375
      m5.1               0.80350           0.89000  0.94450 0.80575       0.79000
      m6.1               0.77400           0.97325  0.98125 0.94600       0.83850
      m7.1               0.77400           0.94650  0.96275 0.89500       0.80975
      m8.1               0.78050           0.94625  0.96225 0.88900       0.80775
      m9.1               0.78650           0.92550  0.95425 0.86700       0.79850
      m10.1              0.79900           0.90450  0.94350 0.81925       0.78225
            AccuracyUpper AccuracyNull AccuracyPValue McnemarPValue Positive Negative
      m1.1        0.99775      0.76650        0.01075     1.0000000     20.5     6.25
      m2.1        0.99725      0.77350        0.01550     1.0000000     20.5     6.00
      m3.1        0.99725      0.77350        0.01575     0.8266667     20.5     6.00
      m4.1        0.99150      0.77350        0.04275     0.8266667     20.5     6.00
      m5.1        0.98725      0.76650        0.07350     0.5670000     20.5     6.25
      m6.1        0.99950      0.77350        0.00550     1.0000000     20.5     6.00
      m7.1        0.99725      0.77350        0.01575     0.8266667     20.5     6.00
      m8.1        0.99725      0.78125        0.02000     1.0000000     20.5     5.75
      m9.1        0.99525      0.76650        0.02525     0.6533333     20.5     6.25
      m10.1       0.99150      0.78100        0.04725     0.7493333     20.5     5.75
            True Positive False Positive True Negative False Negative      ROCSD
      m1.1          20.25           0.25          6.00           0.25 0.05416667
      m2.1          20.00           0.50          5.50           0.50 0.05626286
      m3.1          20.00           0.50          5.50           0.50 0.03948363
      m4.1          19.50           1.00          5.50           0.50 0.06484180
      m5.1          20.25           0.25          5.00           1.25 0.06219745
      m6.1          20.25           0.25          5.75           0.25 0.03933378
      m7.1          20.00           0.50          5.50           0.50 0.03948363
      m8.1          20.00           0.50          5.25           0.50 0.05147271
      m9.1          20.00           0.50          5.50           1.00 0.07866757
      m10.1         20.00           0.50          4.75           1.00 0.04857222
                 TSSSD SensitivitySD SpecificitySD Pos Pred ValueSD Neg Pred ValueSD
      m1.1  0.10833333    0.02500000    0.08350000       0.02500000       0.08350000
      m2.1  0.10092870    0.02830194    0.09641749       0.02830194       0.09002407
      m3.1  0.07896726    0.04750000    0.09641749       0.02687471       0.12500000
      m4.1  0.11034030    0.05632865    0.09641749       0.02750000       0.15542630
      m5.1  0.31429473    0.02400000    0.31564167       0.07547185       0.08350000
      m6.1  0.07866757    0.02400000    0.08350000       0.02400000       0.07150000
      m7.1  0.07896726    0.04750000    0.09641749       0.02687471       0.12500000
      m8.1  0.09960950    0.02830194    0.09641749       0.02687471       0.09641749
      m9.1  0.16947743    0.04750000    0.19225764       0.05141012       0.11100000
      m10.1 0.22596375    0.02830194    0.23570232       0.05907270       0.09641749
            PrecisionSD   RecallSD       F1SD PrevalenceSD Detection RateSD
      m1.1   0.02500000 0.02500000 0.02500000  0.011789826       0.02089657
      m2.1   0.02830194 0.02830194 0.02042058  0.005196152       0.02233644
      m3.1   0.02687471 0.04750000 0.02043486  0.005196152       0.03426368
      m4.1   0.02750000 0.05632865 0.03223223  0.005196152       0.04401799
      m5.1   0.07547185 0.02400000 0.04209810  0.017521415       0.01912023
      m6.1   0.02400000 0.02400000 0.01385641  0.005196152       0.01607016
      m7.1   0.02687471 0.04750000 0.02043486  0.005196152       0.03426368
      m8.1   0.02687471 0.02830194 0.01963628  0.013200379       0.01581139
      m9.1   0.05141012 0.04750000 0.02392175  0.011789826       0.04669315
      m10.1  0.05907270 0.02830194 0.02940947  0.018493242       0.02093442
            Detection PrevalenceSD Balanced AccuracySD AccuracySD    KappaSD
      m1.1              0.01178983          0.05400000 0.03850000 0.10850000
      m2.1              0.02760435          0.05024191 0.03144307 0.08877453
      m3.1              0.05086584          0.03929801 0.03021451 0.07874431
      m4.1              0.05150647          0.05515433 0.04817589 0.12794628
      m5.1              0.08317251          0.15699045 0.07084961 0.26572715
      m6.1              0.02760435          0.03916950 0.02165448 0.06261523
      m7.1              0.05086584          0.03929801 0.03021451 0.07874431
      m8.1              0.02414539          0.04968819 0.03024759 0.08749095
      m9.1              0.08102057          0.08485478 0.03708099 0.11516510
      m10.1             0.06000000          0.11292918 0.04804512 0.16584405
            AccuracyLowerSD AccuracyUpperSD AccuracyNullSD AccuracyPValueSD
      m1.1       0.06177648    0.0045000000    0.011789826      0.020172176
      m2.1       0.05031484    0.0041932485    0.005196152      0.017521415
      m3.1       0.04549267    0.0041932485    0.005196152      0.018006943
      m4.1       0.07007793    0.0110905365    0.005196152      0.053643111
      m5.1       0.10004332    0.0199562020    0.017521415      0.119940263
      m6.1       0.03649201    0.0005773503    0.005196152      0.005196152
      m7.1       0.04549267    0.0041932485    0.005196152      0.018006943
      m8.1       0.04600272    0.0041932485    0.013200379      0.018202564
      m9.1       0.05588306    0.0049244289    0.011789826      0.019872510
      m10.1      0.06938960    0.0110905365    0.018493242      0.050651588
            McnemarPValueSD PositiveSD NegativeSD True PositiveSD False PositiveSD
      m1.1               NA  0.5773503        0.5       0.9574271        0.5000000
      m2.1        0.0000000  0.5773503        0.0       0.8164966        0.5773503
      m3.1        0.3002221  0.5773503        0.0       0.8164966        1.0000000
      m4.1        0.3002221  0.5773503        0.0       1.2909944        1.1547005
      m5.1        0.6123545  0.5773503        0.5       0.5000000        0.5000000
      m6.1        0.0000000  0.5773503        0.0       0.5000000        0.5000000
      m7.1        0.3002221  0.5773503        0.0       0.8164966        1.0000000
      m8.1        0.0000000  0.5773503        0.5       0.8164966        0.5773503
      m9.1        0.3002221  0.5773503        0.5       0.8164966        1.0000000
      m10.1       0.4341674  0.5773503        0.5       0.8164966        0.5773503
            True NegativeSD False NegativeSD
      m1.1        0.8164966        0.5000000
      m2.1        0.5773503        0.5773503
      m3.1        0.5773503        0.5773503
      m4.1        0.5773503        0.5773503
      m5.1        2.1602469        1.8929694
      m6.1        0.5000000        0.5000000
      m7.1        0.5773503        0.5773503
      m8.1        0.5000000        0.5773503
      m9.1        1.5000000        1.1547005
      m10.1       1.2583057        1.4142136
      

# train_sdm - independent data

    Code
      i1
    Output
                  caretSDM           
      ...............................
      Class                         : input_sdm
      --------  Occurrences  --------
      Species Names                 : Salminus brasiliensis Araucaria angustifolia 
      Number of presences           : 76 21 
      Pseudoabsence methods         :
          Method to obtain PAs      : bioclim 
          Number of PA sets         : 10 
          Number of PAs in each set : 76 21 
      Independent Test              : TRUE (number of records =  26 )
      Data Cleaning                 : NAs, Capitals, Centroids, Geographically Duplicated, Identical Lat/Long, Institutions, Invalid, Non-terrestrial, Duplicated Cell (grid), Methods also applied in independent_test 
      --------  Predictors  ---------
      Number of Predictors          : 3 
      Predictors Names              : bio1, bio4, bio12 
      ---------  Scenarios  ---------
      Number of Scenarios           : 1 
      Scenarios Names               : current 
      -----------  Models  ----------
      Algorithms Names              : kknn 
      Variables Names               : bio1 bio4 bio12 
      Model Validation              :
          Method                    : repeatedcv 
          Number                    : 4 
          Metrics                   :
      $`Salminus brasiliensis`
        algo     ROC       TSS Sensitivity Specificity
      1 kknn 0.90775 0.7841667    0.848325    0.940825
      
      $`Araucaria angustifolia`
        algo       ROC       TSS Sensitivity Specificity
      1 kknn 0.9652412 0.8711842     0.97355    0.897375
      
      Independent Validation        :
          ROC (mean +- sd)            :  NA  +-  NA 

---

    Code
      i1$models
    Output
               caretSDM        
      .........................
      Class                   : Models
      Algorithms Names        : kknn 
      Variables Names         : bio1 bio4 bio12 
      Model Validation        :
               Method          : repeatedcv 
               Number          : 4 
               Metrics         :
      $`Salminus brasiliensis`
            algo       ROC       TSS Sensitivity Specificity Pos Pred Value
      m1.1  kknn 0.9000000 0.8000000     0.90000     0.90000        0.92250
      m2.1  kknn 0.9250000 0.8500000     0.85000     1.00000        1.00000
      m3.1  kknn 0.8791667 0.7583333     0.80825     0.95000        0.95825
      m4.1  kknn 0.9458333 0.8166667     0.86675     0.95000        0.95825
      m5.1  kknn 0.9250000 0.8500000     0.85000     1.00000        1.00000
      m6.1  kknn 0.9583333 0.8583333     0.90825     0.95000        0.95825
      m7.1  kknn 0.9233333 0.7666667     0.81675     0.95000        0.95000
      m8.1  kknn 0.8791667 0.7583333     0.80825     0.95000        0.95825
      m9.1  kknn 0.8125000 0.5250000     0.81675     0.75825        0.82500
      m10.1 kknn 0.9291667 0.8583333     0.85825     1.00000        1.00000
            Neg Pred Value Precision  Recall      F1 Prevalence Detection Rate
      m1.1         0.92850   0.92250 0.90000 0.89550        0.5        0.45000
      m2.1         0.89275   1.00000 0.85000 0.90975        0.5        0.42725
      m3.1         0.87050   0.95825 0.80825 0.84725        0.5        0.40425
      m4.1         0.88675   0.95825 0.86675 0.89950        0.5        0.42975
      m5.1         0.89575   1.00000 0.85000 0.90975        0.5        0.42950
      m6.1         0.90825   0.95825 0.90825 0.93050        0.5        0.45250
      m7.1         0.83675   0.95000 0.81675 0.87225        0.5        0.40475
      m8.1         0.86450   0.95825 0.80825 0.84725        0.5        0.40250
      m9.1         0.74975   0.82500 0.81675 0.79225        0.5        0.40700
      m10.1        0.87475   1.00000 0.85825 0.92175        0.5        0.42750
            Detection Prevalence Balanced Accuracy Accuracy   Kappa AccuracyLower
      m1.1               0.52025           0.90000  0.90225 0.80350       0.57525
      m2.1               0.42725           0.92500  0.92725 0.85350       0.60950
      m3.1               0.42925           0.87925  0.87925 0.75825       0.55250
      m4.1               0.45475           0.90825  0.90450 0.81125       0.57675
      m5.1               0.42950           0.92500  0.92950 0.85525       0.61100
      m6.1               0.47500           0.92925  0.92950 0.85825       0.61100
      m7.1               0.42975           0.88325  0.87950 0.76125       0.54900
      m8.1               0.42750           0.87925  0.87725 0.75500       0.55125
      m9.1               0.54550           0.76250  0.76825 0.52375       0.43975
      m10.1              0.42750           0.92925  0.92725 0.85500       0.60300
            AccuracyUpper AccuracyNull AccuracyPValue McnemarPValue Positive Negative
      m1.1        0.99250       0.5225        0.02300     0.8700000     5.25     5.25
      m2.1        0.99325       0.5225        0.01750     0.7400000     5.25     5.25
      m3.1        0.98200       0.5000        0.04675     0.7493333     5.25     5.25
      m4.1        0.99275       0.5225        0.02400     0.8700000     5.25     5.25
      m5.1        0.99350       0.5225        0.01850     0.7400000     5.25     5.25
      m6.1        0.99350       0.5225        0.01850     1.0000000     5.25     5.25
      m7.1        0.98725       0.5225        0.03200     0.8266667     5.25     5.25
      m8.1        0.98200       0.5225        0.04925     0.7493333     5.25     5.25
      m9.1        0.93425       0.5225        0.22525     0.9207500     5.25     5.25
      m10.1       0.99800       0.5225        0.00900     1.0000000     5.25     5.25
            True Positive False Positive True Negative False Negative      ROCSD
      m1.1           4.75           0.50          4.75           0.75 0.08164966
      m2.1           4.50           0.75          5.25           0.00 0.09574271
      m3.1           4.25           1.00          5.00           0.25 0.12720281
      m4.1           4.50           1.00          5.00           0.25 0.05335937
      m5.1           4.50           0.75          5.25           0.00 0.09574271
      m6.1           4.75           0.50          5.00           0.25 0.08858455
      m7.1           4.25           1.00          5.00           0.25 0.07272475
      m8.1           4.25           1.00          5.00           0.25 0.12720281
      m9.1           4.25           1.25          4.00           1.50 0.26714367
      m10.1          4.50           0.75          5.25           0.00 0.04787136
                 TSSSD SensitivitySD SpecificitySD Pos Pred ValueSD Neg Pred ValueSD
      m1.1  0.16329932    0.20000000     0.1154701       0.09002407        0.1430000
      m2.1  0.19148542    0.19148542     0.0000000       0.00000000        0.1369121
      m3.1  0.25440563    0.28332358     0.1000000       0.08350000        0.1770056
      m4.1  0.13743685    0.16316326     0.1000000       0.08350000        0.1395024
      m5.1  0.19148542    0.19148542     0.0000000       0.00000000        0.1250557
      m6.1  0.17716910    0.10679693     0.1000000       0.08350000        0.1067969
      m7.1  0.17638342    0.13731563     0.1000000       0.10000000        0.1198370
      m8.1  0.25440563    0.28332358     0.1000000       0.08350000        0.1780197
      m9.1  0.44586578    0.13731563     0.3804019       0.23629078        0.2887714
      m10.1 0.09574271    0.09577186     0.0000000       0.00000000        0.0835000
            PrecisionSD   RecallSD       F1SD PrevalenceSD Detection RateSD
      m1.1   0.09002407 0.20000000 0.10492696   0.03674235       0.10653638
      m2.1   0.00000000 0.19148542 0.11866023   0.03674235       0.11452911
      m3.1   0.08350000 0.28332358 0.18909676   0.00000000       0.14167657
      m4.1   0.08350000 0.16316326 0.08205892   0.03674235       0.06428063
      m5.1   0.00000000 0.19148542 0.11866023   0.03674235       0.12065516
      m6.1   0.08350000 0.10679693 0.08344459   0.03674235       0.04092676
      m7.1   0.10000000 0.13731563 0.09493989   0.03674235       0.03755330
      m8.1   0.08350000 0.28332358 0.18909676   0.03674235       0.13665650
      m9.1   0.23629078 0.13731563 0.15492229   0.03674235       0.06428063
      m10.1  0.00000000 0.09577186 0.05301179   0.03674235       0.03175426
            Detection PrevalenceSD Balanced AccuracySD AccuracySD    KappaSD
      m1.1              0.15329791          0.08164966 0.08177357 0.16344928
      m2.1              0.11452911          0.09574271 0.09506270 0.19039170
      m3.1              0.17016340          0.12723567 0.12723567 0.25437292
      m4.1              0.11327842          0.06883979 0.07448266 0.14550916
      m5.1              0.12065516          0.09574271 0.08802083 0.18241962
      m6.1              0.06204837          0.08844348 0.08802083 0.17731023
      m7.1              0.05994650          0.08825484 0.09136557 0.18075651
      m8.1              0.16635805          0.12723567 0.12650527 0.25317978
      m9.1              0.15649601          0.22312403 0.21238075 0.44813568
      m10.1             0.03175426          0.04784262 0.04868521 0.09712535
            AccuracyLowerSD AccuracyUpperSD AccuracyNullSD AccuracyPValueSD
      m1.1       0.11151196     0.011733144     0.02598076      0.023916521
      m2.1       0.12360286     0.012203142     0.02598076      0.025632011
      m3.1       0.14741438     0.032690468     0.00000000      0.083611702
      m4.1       0.09838149     0.010594810     0.02598076      0.027080128
      m5.1       0.11128642     0.011090537     0.02598076      0.028722813
      m6.1       0.11128642     0.011090537     0.02598076      0.028722813
      m7.1       0.11986937     0.013073510     0.02598076      0.030397368
      m8.1       0.15211481     0.032690468     0.02598076      0.082001524
      m9.1       0.18506103     0.112562205     0.02598076      0.395868981
      m10.1      0.07617524     0.001414214     0.02598076      0.005416026
            McnemarPValueSD PositiveSD NegativeSD True PositiveSD False PositiveSD
      m1.1        0.3002221        0.5        0.5       1.2583057        1.0000000
      m2.1        0.3676955        0.5        0.5       1.2909944        0.9574271
      m3.1        0.4341674        0.5        0.5       1.5000000        1.4142136
      m4.1        0.3002221        0.5        0.5       0.5773503        0.9574271
      m5.1        0.3676955        0.5        0.5       1.2909944        0.9574271
      m6.1        0.0000000        0.5        0.5       0.5000000        0.5773503
      m7.1        0.3002221        0.5        0.5       0.5000000        0.8164966
      m8.1        0.4341674        0.5        0.5       1.5000000        1.4142136
      m9.1        0.1585000        0.5        0.5       0.5000000        0.8164966
      m10.1       0.0000000        0.5        0.5       0.5773503        0.5000000
            True NegativeSD False NegativeSD
      m1.1        0.9574271        0.5773503
      m2.1        0.5000000        0.0000000
      m3.1        0.8164966        0.5000000
      m4.1        0.8164966        0.5000000
      m5.1        0.5000000        0.0000000
      m6.1        0.8164966        0.5000000
      m7.1        0.8164966        0.5000000
      m8.1        0.8164966        0.5000000
      m9.1        2.0000000        1.8929694
      m10.1       0.5000000        0.0000000
      
      $`Araucaria angustifolia`
            algo       ROC       TSS Sensitivity Specificity Pos Pred Value
      m1.1  kknn 0.9682018 0.8486842     0.97375     0.87500        0.96375
      m2.1  kknn 0.9747807 0.8903509     0.97350     0.91650        0.97425
      m3.1  kknn 0.9714912 0.7653509     0.97350     0.79150        0.94325
      m4.1  kknn 0.9791667 0.9451754     0.98675     0.95825        0.98750
      m5.1  kknn 0.9802632 0.8903509     0.97350     0.91650        0.97500
      m6.1  kknn 0.9451754 0.8903509     0.97350     0.91650        0.97425
      m7.1  kknn 0.9353070 0.8640351     0.94725     0.91650        0.97275
      m8.1  kknn 0.9475877 0.8951754     0.98675     0.90825        0.97425
      m9.1  kknn 0.9660088 0.8903509     0.97350     0.91650        0.97425
      m10.1 kknn 0.9844298 0.8320175     0.97350     0.85825        0.96175
            Neg Pred Value Precision  Recall      F1 Prevalence Detection Rate
      m1.1         0.93750   0.96375 0.97375 0.96700    0.76000        0.74000
      m2.1         0.92250   0.97425 0.97350 0.97350    0.76000        0.74000
      m3.1         0.92250   0.94325 0.97350 0.95625    0.75275        0.73275
      m4.1         0.95825   0.98750 0.98675 0.98675    0.76800        0.75750
      m5.1         0.92850   0.97500 0.97350 0.97350    0.76000        0.74000
      m6.1         0.92700   0.97425 0.97350 0.97350    0.75275        0.73300
      m7.1         0.85100   0.97275 0.94725 0.95975    0.76000        0.72000
      m8.1         0.95000   0.97425 0.98675 0.98025    0.76800        0.75750
      m9.1         0.91650   0.97425 0.97350 0.97350    0.76800        0.74750
      m10.1        0.91425   0.96175 0.97350 0.96700    0.77600        0.75550
            Detection Prevalence Balanced Accuracy Accuracy   Kappa AccuracyLower
      m1.1               0.77000           0.92425  0.95000 0.85975       0.78475
      m2.1               0.76000           0.94525  0.96000 0.89025       0.79875
      m3.1               0.78275           0.88275  0.93000 0.77725       0.76075
      m4.1               0.76750           0.97275  0.97950 0.94150       0.82775
      m5.1               0.76000           0.94550  0.96000 0.89000       0.79600
      m6.1               0.75300           0.94525  0.96050 0.89275       0.80075
      m7.1               0.74000           0.93200  0.94000 0.84150       0.77175
      m8.1               0.77800           0.94775  0.96925 0.90775       0.81300
      m9.1               0.76750           0.94525  0.95950 0.88675       0.79700
      m10.1              0.78625           0.91625  0.94875 0.84775       0.77775
            AccuracyUpper AccuracyNull AccuracyPValue McnemarPValue Positive Negative
      m1.1        0.99475      0.76000         0.0230     0.6533333       19     6.00
      m2.1        0.99700      0.76000         0.0150     1.0000000       19     6.00
      m3.1        0.98600      0.75275         0.0745     0.7113333       19     6.25
      m4.1        0.99950      0.76800         0.0270     1.0000000       19     5.75
      m5.1        0.99900      0.76000         0.0090     1.0000000       19     6.00
      m6.1        0.99700      0.75275         0.0135     1.0000000       19     6.25
      m7.1        0.99100      0.76000         0.0420     1.0000000       19     6.00
      m8.1        0.99725      0.76800         0.0270     1.0000000       19     5.75
      m9.1        0.99700      0.76800         0.0195     1.0000000       19     5.75
      m10.1       0.99675      0.77600         0.0355     1.0000000       19     5.50
            True Positive False Positive True Negative False Negative      ROCSD
      m1.1          18.50           0.50          5.25           0.75 0.03623402
      m2.1          18.50           0.50          5.50           0.50 0.05517432
      m3.1          18.50           0.50          5.00           1.25 0.05413307
      m4.1          18.75           0.50          5.50           0.25 0.04166667
      m5.1          18.50           0.50          5.50           0.50 0.03250254
      m6.1          18.50           0.50          5.75           0.50 0.05045449
      m7.1          18.00           1.00          5.50           0.50 0.06258010
      m8.1          18.75           0.25          5.25           0.50 0.06301305
      m9.1          18.50           0.50          5.25           0.50 0.05194175
      m10.1         18.50           0.50          4.75           0.75 0.01569783
                 TSSSD SensitivitySD SpecificitySD Pos Pred ValueSD Neg Pred ValueSD
      m1.1  0.13950310    0.05250000    0.15945532       0.04571196       0.12500000
      m2.1  0.10090897    0.03059956    0.09641749       0.02975875       0.09002407
      m3.1  0.30280104    0.03059956    0.31564167       0.08206248       0.09002407
      m4.1  0.08240480    0.05250000    0.08350000       0.02500000       0.14300000
      m5.1  0.06583819    0.03059956    0.09641749       0.02886751       0.08256109
      m6.1  0.10090897    0.03059956    0.09641749       0.02975875       0.08601938
      m7.1  0.13020728    0.04286704    0.09641749       0.03148942       0.11737405
      m8.1  0.12602611    0.02650000    0.10679693       0.02975875       0.10000000
      m9.1  0.10090897    0.03059956    0.09641749       0.02975875       0.09641749
      m10.1 0.08465253    0.03059956    0.09577186       0.02553919       0.10171324
            PrecisionSD   RecallSD         F1SD PrevalenceSD Detection RateSD
      m1.1   0.04571196 0.05250000 0.0255342907   0.00000000       0.04000000
      m2.1   0.02975875 0.03059956 0.0216410105   0.00000000       0.02309401
      m3.1   0.08206248 0.03059956 0.0404423458   0.01450000       0.01889224
      m4.1   0.02500000 0.05250000 0.0266520793   0.01600000       0.02600000
      m5.1   0.02886751 0.03059956 0.0005773503   0.00000000       0.02309401
      m6.1   0.02975875 0.03059956 0.0216410105   0.01450000       0.03320643
      m7.1   0.03148942 0.04286704 0.0347311100   0.00000000       0.03265986
      m8.1   0.02975875 0.02650000 0.0253294953   0.01600000       0.00500000
      m9.1   0.02975875 0.03059956 0.0216410105   0.01600000       0.01892969
      m10.1  0.02553919 0.03059956 0.0133416641   0.01847521       0.02968164
            Detection PrevalenceSD Balanced AccuracySD AccuracySD     KappaSD
      m1.1              0.06831301          0.06984447 0.03829708 0.108149202
      m2.1              0.03265986          0.05057915 0.03265986 0.089540959
      m3.1              0.09304255          0.15129965 0.06831301 0.246935045
      m4.1              0.03771825          0.04112582 0.03960955 0.105880436
      m5.1              0.04618802          0.03290897 0.00000000 0.006928203
      m6.1              0.04482559          0.05057915 0.03267517 0.089893919
      m7.1              0.02309401          0.06525846 0.05163978 0.135411718
      m8.1              0.02103965          0.06283510 0.03960955 0.120311748
      m9.1              0.02217356          0.05057915 0.03267517 0.089514896
      m10.1             0.04759814          0.04236646 0.02118765 0.068451321
            AccuracyLowerSD AccuracyUpperSD AccuracyNullSD AccuracyPValueSD
      m1.1       0.05846580     0.005500000     0.00000000       0.02103965
      m2.1       0.05031484     0.004690416     0.00000000       0.01773885
      m3.1       0.09660702     0.021150256     0.01450000       0.11699715
      m4.1       0.06371290     0.004856267     0.01600000       0.04681880
      m5.1       0.00000000     0.000000000     0.00000000       0.00000000
      m6.1       0.05032809     0.004690416     0.01450000       0.01864582
      m7.1       0.07513710     0.011575837     0.00000000       0.05290243
      m8.1       0.06371290     0.004856267     0.01600000       0.04681880
      m9.1       0.05056349     0.004690416     0.01600000       0.01799074
      m10.1      0.03200391     0.004500000     0.01847521       0.04186884
            McnemarPValueSD PositiveSD NegativeSD True PositiveSD False PositiveSD
      m1.1        0.3002221          0  0.0000000       1.0000000        1.0000000
      m2.1        0.0000000          0  0.0000000       0.5773503        0.5773503
      m3.1        0.4999853          0  0.5000000       0.5773503        0.5773503
      m4.1        0.3676955          0  0.5000000       1.0000000        1.0000000
      m5.1        0.0000000          0  0.0000000       0.5773503        0.5773503
      m6.1        0.0000000          0  0.5000000       0.5773503        0.5773503
      m7.1        0.0000000          0  0.0000000       0.8164966        0.8164966
      m8.1        0.0000000          0  0.5000000       0.5000000        0.5000000
      m9.1        0.0000000          0  0.5000000       0.5773503        0.5773503
      m10.1       0.0000000          0  0.5773503       0.5773503        0.5773503
            True NegativeSD False NegativeSD
      m1.1        0.9574271        0.9574271
      m2.1        0.5773503        0.5773503
      m3.1        2.1602469        1.8929694
      m4.1        0.5773503        0.5000000
      m5.1        0.5773503        0.5773503
      m6.1        0.9574271        0.5773503
      m7.1        0.5773503        0.5773503
      m8.1        0.9574271        0.5773503
      m9.1        0.5000000        0.5773503
      m10.1       0.9574271        0.5000000
      

