% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowcarre.R
\name{flowcarre}
\alias{flowcarre}
\title{Create a square matrice from geographical ID}
\usage{
flowcarre(liste, tab, origin, dest, valflow, empty.sq, format, diagonale)
}
\arguments{
\item{liste}{list or all the geographical ID as a single vector flow dataset}

\item{tab}{the non squared input flow dataset with three column : origin, destination, flow value}

\item{origin}{origin place}

\item{dest}{destination place}

\item{valflow}{flow value}

\item{empty.sq}{TRUE : to allows to have an matrice empty with only the ID of background map ; FALSE or missing}

\item{format}{the squared flow dataset output format. See Details.}

\item{diagonale}{See Details.}
}
\description{
Create a closed and square matrice from a list of geographic ID
}
\details{
- format is "M" for matrice format

- format is "L" for long format

- diagonal is "TRUE" to zero the main diagonal
}
\examples{
library(cartograflow)
data(flowdata)
var1<-geoid
var2<-flows

#1/2 Compute an empty square matrice with ID code, and sets the value to zero
#Example for matrice format (same procedure for the long format)

mat<-flowcarre(var1,var2,origin="i",dest="j",valflow="Fij",
               format="M",empty.sq=TRUE)

#2/2 Fill in the matrice with external flow values
mat<-flowcarre(var1,var2,origin="i",dest="j",valflow="Fij",
               format="M",empty.sq=FALSE)

#Square a matrice and zero the main diagonal
mat<-flowcarre(var1,var2,origin="i",dest="j",valflow="Fij",format="M",
               empty.sq=FALSE,diagonale = FALSE)
}
