% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowreduct.R
\name{flowreduct}
\alias{flowreduct}
\title{Flow matrix reduction according to another matrix}
\usage{
flowreduct(tab, tab.metric, metric, d.criteria, d)
}
\arguments{
\item{tab}{is the input flowdata set}

\item{tab.metric}{the distance dataset}

\item{metric}{select "continuous" or "ordinal" metric. See Details}

\item{d.criteria}{is for selecting "dmin" or "dmax" distance criteria for "continuous" metric. See Details.}

\item{d}{is the value of the selected "dmin" or "dmax". see Details}
}
\value{
A flow dataset with distances computations and flow reduction
}
\description{
Reduces a flow dataset according to an external matrix, eg. a matrix of travelled distance.\cr 
Builds geographical movements,  by weighting a flow dataset according to a distance criterion.
}
\details{
The involved metric can be continous or not.\cr

(1) Metric is 'continous" for distance as euclidian, maximum, manhattan, etc.\cr
See \link{flowdist} \cr
- Metric is 'ordinal" for computing neighbourhood ordinal distance matrix.
-- Select ="dmin" for reducing flow dataset to flow values that are up or equal to the dmin distance parameter  (Fij>=dmin);\cr
-- select ="dmax" for reducing flow dataset to values that are less or equal to the dmax distance parameter(Fij=<dmin).\cr \cr

- Metric is 'ordinal' for computing neighbourhood ordinal distance with k contiguity.\cr
See \link{flowcontig} for computing ordinal distance matrix \cr
}
\examples{
library(cartograflow)
library(sf)
library(dplyr)
data(flowdata)
map <- st_read(system.file("shape/MGP_TER.shp", package = "cartograflow"))

tab <- flowjointure(
  geom = "area", bkg = map, DF.flow = flows, origin = "i", destination = "j",
  id = "EPT_NUM", x = "X", y = "Y"
)

# Example for reducing a flow matrice with a distance matrice, in long format (i,j, distance)
## 1/2: Computes the matrice distances
tab.distance <- flowdist(tab, dist.method = "euclidian", result = "dist")
tab.distance <- tab.distance \%>\% select(i, j, distance)
## 2/2: Reduce the flow matrice
tab.flow <- flowreduct(flows, tab.distance,
  metric = "continous",
  d.criteria = "dmax", d = 8567
)
}
