% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dotDensityLayer.R
\name{dotDensityLayer}
\alias{dotDensityLayer}
\title{Dot Density layer}
\usage{
dotDensityLayer(spdf, df, spdfid = NULL, dfid = NULL, var, n = NULL,
  iter = 5, pch = 1, cex = 0.15, type = "random", col = "black",
  legend.pos = "topright", legend.txt = NULL, legend.cex = 0.6,
  legend.col = "black", legend.frame = TRUE, add = TRUE)
}
\arguments{
\item{spdf}{SpatialPointsDataFrame or SpatialPolygonsDataFrame; if spdf
is a SpatialPolygonsDataFrame symbols are plotted on centroids.}

\item{df}{data frame; df contains the values to plot.}

\item{spdfid}{id field in spdf, default to the first column
of the spdf data frame. (optional)}

\item{dfid}{id field in df, default to the first column of df. (optional)}

\item{var}{name of the numeric field in df to plot.}

\item{n}{one dot on the map represents n (in var units).}

\item{iter}{number of iteration to try to locate sample points (see Details).}

\item{pch}{symbol to use: \link{points}.}

\item{cex}{size of the symbols}

\item{type}{points allocation method: "random" or "regular" (see Details).}

\item{col}{color of the points.}

\item{legend.pos}{"topright", "left", "right", "bottomleft", "bottom", "bottomright". If
legend.pos is "n" then the legend is not plotted.}

\item{legend.txt}{text in the legend.}

\item{legend.cex}{size of the legend text.}

\item{legend.col}{color of the text in the legend.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE).}
}
\description{
Plot a dot density layer.
}
\details{
The iter parameter is defined within the \link{spsample} function. If an error occurred, increase this value.\cr
The type parameters is defined within the \link{spsample} function.
}
\examples{
data("nuts2006")
# Example 1
plot(nuts0.spdf)
dotDensityLayer(spdf = nuts0.spdf, df=nuts0.df,var="pop2008")


# Example 2
layoutLayer(title = "Population in Europe, 2008",
            sources = "Eurostat, 2008",
            scale = NULL,
            frame = TRUE,
            col = "black",
            coltitle = "white",
            bg = "#E6E6E6",
            extent = nuts0.spdf)
plot(nuts1.spdf, col = "#B8704D50",border = "white", add=TRUE)
dotDensityLayer(spdf = nuts1.spdf, df=nuts1.df,var="pop2008",
                type = "regular", pch=20, col = "brown",
                n = 100000)
}
\seealso{
\link{propSymbolsLayer}
}

