% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discLayer.R
\name{discLayer}
\alias{discLayer}
\title{Discontinuities Layer}
\usage{
discLayer(spdf, df, spdfid1 = NULL, spdfid2 = NULL, dfid = NULL, var,
  method = "quantile", nclass = NULL, threshold = 0.75, type = "rel",
  sizemin = 1, sizemax = 10, col = "red", legend.pos = "bottomleft",
  legend.title.txt = "legend title", legend.title.cex = 0.8,
  legend.values.cex = 0.6, legend.values.rnd = 2, legend.frame = FALSE,
  add = TRUE)
}
\arguments{
\item{spdf}{a SpatialLinesDataFrame, as outputed by the \link{getBorders} function.}

\item{df}{a data frame that contains the values used to compute and plot discontinuities.}

\item{spdfid1}{first identifier of the border, default to the second column 
of the spdf data frame. (optional)}

\item{spdfid2}{second identifier of the border, default to the third column 
of the spdf data frame. (optional)}

\item{dfid}{identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df used to compute and plot discontinuities.}

\item{method}{a discretization method; one of "sd", "equal", 
"quantile", "jenks","q6" or "geom"  (see \link{discretization} Details).}

\item{nclass}{a targeted number of classes. If null, the number of 
class is automatically defined (see \link{discretization} Details).}

\item{threshold}{share of represented borders, value between 0 
(nothing) and 1 (all the discontinuities).}

\item{type}{type of discontinuity measure, one of "rel" or "abs" (see Details).}

\item{sizemin}{thickness of the smallest line.}

\item{sizemax}{thickness of the biggest line.}

\item{col}{color of the discontinuities lines.}

\item{legend.pos}{position of the legend, one of "topleft", "top", 
"topright", "left", "right", "bottomleft", "bottom", "bottomright". If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values in 
the legend.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
This function computes and plots spatial discontinuities. The 
discontinuities are plotted over the layer outputed by the \link{getBorders} function.
The line widths reflect the ratio between values of an indicator in two neighbouring units.
}
\details{
The "rel" type of discontinuity is the result of pmax(value unit 1 / value unit 2, value unit 2 / value unit 1).\cr
The "abs" type of discontinuity is the result of pmax(value unit 1 - value unit 2, value unit 2 - value unit 1).
}
\examples{
data(nuts2006)
# Get borders
nuts0.contig.spdf <- getBorders(nuts0.spdf)
# GDP per capita
nuts0.df$gdpcap <- nuts0.df$gdppps2008/nuts0.df$pop2008
# Plot countries
plot(nuts0.spdf, col="#CCCCCC", lwd=1, border="white")
# Plot discontinuities
discLayer(spdf = nuts0.contig.spdf, df = nuts0.df,
          var = "gdpcap", col="red", nclass=5,
          method="quantile", threshold = 0.5, sizemin = 1,
          sizemax = 10, type = "rel", legend.frame = TRUE,
          legend.title.txt = "GDP per Capita discontinuities\\n(relative)",
          legend.pos = "topright", add=TRUE)
}
\seealso{
\link{getBorders}, \link{gradLinkLayer}, \link{legendGradLines}
}

