% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAT_ability_est_group.R
\name{CAT_ability_est_group}
\alias{CAT_ability_est_group}
\title{Ability level estimation for a group using a CAT decision tree}
\usage{
CAT_ability_est_group(cat.dt, res)
}
\arguments{
\item{cat.dt}{A \code{cat.dt} object returned by \code{\link{CAT_DT}}.}

\item{res}{Matrix containing the test takers' responses to every item. Rows
represent each individual and columns represent the responses given to each
item}
}
\value{
A list of lists containing the following elements for each
individual:

\code{$estimation} Estimated ability level after each level of the tree.

\code{$linf} Lower limit of the final estimation at 95%

\code{$lsup} Upper limit of the final estimation at 95%

\code{$items} Administered item in each level.

\code{$graphics} Plot object of the evolution of the ability level
estimation. It shows the ability level estimation after the individual
has answered to every administered item.
}
\description{
Computes the test takers' estimated ability level based on the CAT decision
tree previously built and the test takers' responses to every item at every
tree level
}
\examples{
\dontrun{
data("itemBank")
# Build the cat.dt
nodes = CAT_DT(bank = itemBank, model = "GRM", crit = "MEPV",
               C = 0.3, stop = 6, limit = 200, inters = 0.98,
               p = 0.9, dens = dnorm, 0, 1)

# Estimate the ability level of a subject with responses res
CAT_ability_est_group(nodes, res = itemRes)
}
}
\author{
Javier Rodríguez-Cuadrado
}
