% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_E_MFI.R
\name{create_E_MFI}
\alias{create_E_MFI}
\title{Fisher Information of every item for an specified node}
\usage{
create_E_MFI(bank, theta_est, nres, C)
}
\arguments{
\item{bank}{matrix of the item bank. Rows represent items, and columns
represent parameters. If the model is \code{"GRM"}, the first column
represents the \code{alpha} parameters and the next columns represent the
\code{beta} parameters. If the model is \code{"NRM"}, odd columns represent
the \code{alpha} parameters and even columns represent \code{beta}
parameters}

\item{theta_est}{estimated ability level}

\item{nres}{vector of number of possible responses for every item}

\item{C}{vector of item capacities}
}
\value{
A vector of all item Fisher Information for the specified node
}
\description{
Computes a vector of the Fisher Information of every item allocated to the
specified level node in the CAT decision tree. Every FI is computed using
the estimated ability level in the specified node
}
\author{
Javier Rodr?guez-Cuadrado
}
