#' MTurk Political Knowledge
#'
#' Data from Amazon Mechanical Turkers in 2012 responding to 64 political knowledge questions.  Political knowledge questions had a varying number of response options, noted below.  This dataset codes answers as either correct (a value of 0) or incorrect (a value of 1).
#' 
#' @format A data frame with 810 observations on the following 64 questions.
#' \describe{
#' 
#' \item{\code{Q1}}{How long is one term for the President of the United States?
#' 
#' Eight years; Six years; Four years; Two years}
#' 
#' \item{\code{Q2}}{The FDA is part of the national government primarily responsible for regulating
#'   
#'   Food quality; The national parks; Electricity production and energy; Pollution and the environment}
#' 
#' \item{\code{Q3}}{Who is the Vice President of the United States?
#'   
#'   Leon Panetta; William Daley; Hillary Clinton; Joe Biden}
#' 
#' \item{\code{Q4}}{The federal debt is 
#'   
#'   Much smaller than it was 20 years ago; The difference between imports and exports with foreign countries; The annual difference between spending and tax revenues; The accumulated borrowing of the federal government that has not been repaid}
#' 
#' \item{\code{Q5}}{How many times can an individual be elected President of the United States under current laws?
#'   
#'   Any number of terms; Three times; Twice; Once}
#' 
#' \item{\code{Q6}}{What do we call the first ten amendments to the Constitution?
#'   
#'   The Articles of Confederation; The inalienable right; The Bill of Rights; The Declaration of Independence}
#' 
#' \item{\code{Q7}}{Is the U.S. federal budget deficit, the amount by which the governments spending exceeds the amount of money it collects, now bigger, about the same, or smaller than it was during most of the 1990s?
#'   
#'   Smaller; About the same; Bigger}
#' 
#' \item{\code{Q8}}{Who signs bills to become laws?
#'   
#'   The President; The Vice President; The Chief Justice of the Supreme Court; The Secretary of State}
#' 
#' \item{\code{Q9}}{Which party is generally more supportive of creating a way for immigrants who are in the U.S. illegally to eventually become citizens?
#'   
#'   The Republican Party; The Democratic Party}
#' 
#' \item{\code{Q10}}{In what month do we vote for the President?
#'   
#'   November; October; February; January}
#' 
#' \item{\code{Q11}}{What are the two parts of the U.S. Congress?
#'   
#'   The Senate and the Supreme Court; The House of Lords and the House of Commons; The House of Representative and the Supreme Court; The Senate and House of Representatives}
#' 
#' \item{\code{Q12}}{Which party is generally more supportive of restricting access to abortion?
#'   
#'   The Republican Party; The Democratic Party}
#' 
#' \item{\code{Q13}}{Which of these political parties is considered most conservative?
#'   
#'   Green Party; Republican Party; Democratic Party}
#' 
#' \item{\code{Q14}}{The NRA is an organization that advocates for 
#'   
#'   Clean elections; A cleaner environment; The rights of gun owners; Women's rights}
#'   
#'   \item{\code{Q15}}{Compared to 30 years ago, is the difference in incomes between the top 20\% of households and the bottom 20\% of households now bigger, smaller, or the same?
#'   
#'   The difference is now the same as 30 years ago; The difference is now smaller than 30 years ago; The difference is now bigger than 30 years ago}
#'   
#'   \item{\code{Q16}}{The EPA is part of the national government primarily responsible for regulating
#'   
#'   Food quality; The national parks; Electricity production and energy; Pollution and the environment}
#'   
#'   \item{\code{Q17}}{Which party is generally more supportive of reducing the size of the defense budget?
#'   
#'   The Republican Party; The Democratic Party}
#'   
#'   \item{\code{Q18}}{Which party is generally more supportive of increasing taxes on higher income people to reduce the federal budget deficit?
#'   
#'   The Republican Party; The Democratic Party}
#'   
#'   \item{\code{Q19}}{Which party is generally more supportive of allowing drilling for oil in the Arctic National Wildlife Refuge?
#'   
#'   The Republican Party; The Democratic Party}
#'   
#'   \item{\code{Q20}}{Who is the Commander in Chief of the military?
#'   
#'   The Attorney General; The President; The Secretary of Defense; The Vice President}
#'   
#'   \item{\code{Q21}}{The First Amendment to the United States Constitution guarantees all of these rights EXCEPT
#'   
#'   Right to remain silent; Right to the free exercise of religion; Right to free speech; Right to peaceably assemble}
#'   
#'   \item{\code{Q22}}{Roe v Wade is a case decided by the Supreme Court that relates to
#'   
#'   Executive power; Campaign finance; Birth control; Abortion}
#'   
#'   \item{\code{Q23}}{Social Security is
#'   
#'   Funded by the personal income tax; Operated by state government; The responsibility of the Department of Defense; The benefit program for senior citizens}
#'   
#'   \item{\code{Q24}}{What is Medicare?
#'   
#'   A private, non-profit organization that runs free health clinic; A private health insurance plan sold to individuals in all 50 states; A program run by state governments to provide health care to poor people; A program run by the U.S. federal government to pay for old people's health care}
#' 
#' \item{\code{Q25}}{How many senators are elected from each state?
#'   
#'   It depends on the population of the state; Four; Two; One}
#' 
#' \item{\code{Q26}}{How many votes are required in Congress to override a presidential veto
#'   
#'   A simple majority of both houses of Congress; A simple majority of one house of Congress; A two-thirds majority of both houses of Congress; A two-thirds majority of one house of Congress}
#' 
#' \item{\code{Q27}}{The Secretary of State
#'   
#'   Serves a two-year term; Serves the state governments; Is nominated by the president; Heads the armed services}
#' 
#' \item{\code{Q28}}{Near the end of an election campaign, a polls shows that an issue that no candidate has mentioned is of great concern to voters. What is most likely to happen?
#'   
#'   Some candidates will drop out of the race; Candidates will start talking about the issue; Newspapers will not report the results of the poll; The election will be postponed}
#' 
#' \item{\code{Q29}}{Liberals are generally said to
#'   
#'   Support pro-life policies; Oppose all tax increases; Support military spending; Support government programs to give government assistance the needy}
#' 
#' \item{\code{Q30}}{Which party is generally more supportive of reducing the size and scope of the federal government?
#'   
#'   The Republican Party; The Democratic Party}
#' 
#' \item{\code{Q31}}{The ability of a minority of senators to prevent a vote on a bill is known as
#'   
#'   Suspension of the rules; Enrollment; A veto; A filibuster}
#' 
#' \item{\code{Q32}}{conservatives are generally said to
#'   
#'   Support pro-choice policies; Support tax cuts; Oppose military spending; Support government programs to give government assistance to the needy}
#' 
#' \item{\code{Q33}}{Which of these regions of the country is generally considered to be most supportive of Republican candidates 
#'   
#'   Midwest; South; West Coast; New England}
#' 
#' \item{\code{Q34}}{The presiding officer in the House of Representatives is 
#'   
#'   The Majority Leader; The Sergeant at Arms; The Vice President of the United States; The Speaker}
#' 
#' \item{\code{Q35}}{Which of these countries is NOT a permanent member of the U.N. Security Council
#'   
#'   United Kingdom; France; India; China}
#' 
#' \item{\code{Q36}}{Which part has a majority of seats in the U.S. House of Representatives?
#'   
#'   Neither; Democrats; Republicans}
#' 
#' \item{\code{Q37}}{What state holds the first primary election in Presidential primaries?
#'   
#'   Florida; Nevada; South Carolina; New Hampshire}
#' 
#' \item{\code{Q38}}{Who is the Speaker of the House of Representatives?
#'   
#'   Mitt Romney; Eric Holder; Harry Reid; John Boehner}
#' 
#' \item{\code{Q39}}{Most cases are considered by the Supreme Court
#'   
#'   In even-numbered years; At the request of the Congress; Upon order of the president; With the approval of at least four justices}
#' 
#' \item{\code{Q40}}{How many Justices typically serve on the U.S. Supreme Court
#'   
#'   Eleven; Nine; Eight; Seven}
#' 
#' \item{\code{Q41}}{What job or political office is no held by Ben Bernanke?
#'   
#'   None of these; Minority Whip of the U.S. House; Chief Justice of the United States Supreme Court; Majority leader of the U.S. Senate, Chairman of the Federal Reserve}
#' 
#' \item{\code{Q42}}{Whose responsibility is it to nominate judges to the Federal Courts
#'   
#'   The state governors; The Supreme Court; Congress; President}
#' 
#' \item{\code{Q43}}{Who is the Chief Justice of the U.S. Supreme Court?
#'   
#'   Larry Thompson; Anthony Kennedy; David Cole; John Roberts}
#' 
#' \item{\code{Q44}}{The U.S. Senate 
#'   
#'   Votes to confirm nominees to the U.S. Supreme court chosen by the House of Representatives; Plays no role in choosing the members of the U.S. Supreme Court; Chooses members of the U.S. Supreme Court; Votes to confirm nominees to the U.S. Supreme Court chosen by the President}
#' 
#' \item{\code{Q45}}{Which party has a majority of seats in the U.S. Senate
#'   
#'   Neither; Democrats; Republicans}
#' 
#' \item{\code{Q46}}{Which of the states listed below has the greatest number of electoral college votes in the U.S. Presidential Elections?
#'   
#'   Puerto Rico; Nevada; North Dakota; Washington, D.C.}
#' 
#' \item{\code{Q47}}{Citizens United v the FEC is a case decided by the Supreme Court that relates to
#'   
#'   Executive power; Campaign finance; Birth control; Abortion}
#' 
#' \item{\code{Q48}}{For how many years is a United States Senator elected that is, how many years are there in one full term of office for a U.S. Senator?
#'   
#'   None of these; Eight years; Six years; Four years; Two years}
#' 
#' \item{\code{Q49}}{Who is the Prime Minister of the United Kingdom?
#'   
#'   Richard Branson; Tony Hayward; Nick Clegg; David Cameron}
#' 
#' \item{\code{Q50}}{The president of Afghanistan is named
#'   
#'   Bashar al-Assad; Hosni Mubarak; Hamid Karzai; Nouri al-Maliki}
#' 
#' \item{\code{Q51}}{The House of Representatives has how many voting members?
#'   
#'   Four hundred and forty-one; Four hundred and thirty-five; Two hundred; One hundred}
#' 
#' \item{\code{Q52}}{The President of the Senate is
#'   
#'   The Majority Leader; The Sergeant at Arms; The Vice President of the United States; The senior senator of the majority party}
#' 
#' \item{\code{Q53}}{On which of the following federal programs is the most money spent each year?
#'   
#'   Medicare; Education; Subsidies to farmers; Aid to foreign countries}
#' 
#' \item{\code{Q54}}{What do all constitutional governments have?
#'   
#'   Separation of church and state; A bill of rights; A President as the head of government; Limits on political power}
#' 
#' \item{\code{Q55}}{One which of the following does the U.S. federal government spend the least money?
#'   
#'   Social Security; National defense; Medicare; Foreign aid}
#' 
#' \item{\code{Q56}}{The head of the Department of Justice is
#'   
#'   Kathleen Sebelius; Eric Holder; Timothy Geithner; Hillary Clinton}
#' 
#' \item{\code{Q57}}{The president may NOT
#'   
#'   Declare war; Pardon criminals without justification; Appoint federal officials when Congress is in recess; Refuse to sign legislation passed by Congress}
#' 
#' \item{\code{Q58}}{Which of these is NOT primarily the responsibility of the Federal government in Washington?
#'   
#'   Interstate commerce; Negotiating treaties with foreign countries; Education; National defense}
#' 
#' \item{\code{Q59}}{Who is the current president of Mexico?
#'   
#'   Vincente Fox; Hugo Chavez; Dilma Rousseff; Felipe Calderon}
#' 
#' \item{\code{Q60}}{Which of the following actions does the United States federal government commonly take to finance a budget deficit?
#'   
#'   Expanding public-works projects; Borrowing from the public; Imposing import quotas; Printing more money}
#' 
#' \item{\code{Q61}}{Common Cause is an organization that advocates for
#'   
#'   Women's rights; Clean elections; A cleaner environment; The right of gun owners}
#'   
#'   \item{\code{Q62}}{The Byrd Rule is relevant
#'   
#'   During the confirmation of cabinet members; For national party conventions; During Congressional debates over non-budgetary policies; For the Reconciliation process}
#'   
#'   \item{\code{Q63}}{The Majority Leader of the House of Representative is
#'   
#'   Nancy Pelosi; Kevin McCarthy; Eric Cantor; John Boehner}
#'   
#'   \item{\code{Q64}}{On which of the following does the U.S. federal government spend the most money each year?
#'   
#'   Education; Medicare; Interest on the national debt; National defense}
#' }
#'
#' @docType data
#' @keywords datasets
#' @name polknowMT
#' @usage data(polknowMT)
#'
#' @references Jacob M. Montgomery and Joshua Cutler. 2013. 
#' "Computerized Adaptive Testing for Public Opinion Surveys." 
#' Political Analysis (Spring 2013) 21 (2): 172-192.
#' 
#' @source \url{https://dataverse.harvard.edu/dataset.xhtml?persistentId=hdl:1902.1/19381}
"polknowMT"





#' TAPS Political Knowledge
#'
#' Data of responses to a political knowledge battery from the May 2013 wave of The American Panel Survey (TAPS) out of Washington University in St. Louis.  
#' 
#' TAPS is a monthly online panel survey  of about 2,000 adults in the United States. The panel was recruited in the fall of 2011 using an address-based sampling frame.  TAPS surveys are administered online.  Selected panelists who do not have a computer or online service are provided a computer and internet access by TAPS. 
#' 
#' @format A data frame with 1496 observations on the following 10 questions.
#' \describe{
#' 
#' \item{\code{Q1}}{Members of the U.S. Supreme Court serve 
#' 
#' 1 = two-year terms. 2 = ten-year terms. 3 = life terms. 4 = terms determined by the president. 5 = Don't know.
#' }
#' 
#' \item{\code{Q2}}{Who is the Chief Justice of the U.S. Supreme Court?
#' 
#' 1 = John Roberts. 2 = Antonin Scalia. 3 = Mitt Romney. 4 = Hillary Clinton. 5 = Don't know.
#' }
#' 
#' \item{\code{Q3}}{Social Security is
#' 
#' 1 = the benefit program for senior citizens. 2 = the responsibility of the Department of Defense. 3 = operated by state governments. 4 = funded by the personal income tax. 5 = Don't know.
#' }
#' 
#' \item{\code{Q4}}{On which of the following programs is the most money spent each year?
#' 
#' 1 = aid to foreign countries. 2 = Medicare. 3 = subsidies to farmers. 4 = education. 5 = Don't know.
#' }
#' 
#' \item{\code{Q5}}{Which party holds a majority of seats in the U.S. House of Representatives in Washington?
#' 
#' 1 = Democrats. 2 = Republicans. 3 = Independents. 4 = Don't know.
#' }
#' 
#' \item{\code{Q6}}{How many votes are required in Congress to override a presidential veto?
#' 
#' 1 = a simple majority of one house of Congress. 2 = a simple majority of both houses of Congress. 3 = a two-thirds majority of one house of Congress. 4 = a two-thirds majority of both houses of Congress. 5 = Don't know.
#' }
#' 
#' \item{\code{Q7}}{How long is one term for a member of the U.S. Senate?
#' 
#' 1 = two years. 2 = four years. 3 = six years. 4 = eight years. 5 = Don't know.
#' }
#' 
#' \item{\code{Q8}}{The ability of a minority of senators to prevent a vote on a bill is known as 
#' 
#' 1 = a veto. 2 = a filibuster. 3 = enrollment. 4 = suspension of the rules. 5 = Don't know.
#' }
#' 
#' \item{\code{Q9}}{Who is the Vice President of the United States?
#' 
#' 1 = Nancy Pelosi. 2 = John Boehner. 3 = Joseph Biden. 4 = Harry Reid. 5 = Don't know.
#' }
#' 
#' \item{\code{Q10}}{A president may serve
#' 
#' 1 = one term. 2 = two terms. 3 = three terms. 4 = any number of terms. 5 = Don't know.
#' }
#' }
#'
#' @docType data
#' @keywords datasets
#' @name polknowTAPS
#' @usage data(polknowTAPS)
#'
#' 
#' @source \url{http://taps.wustl.edu/data-archive}
"polknowTAPS"






#' Narcissistic Personality Inventory
#'
#' Data from the 40 item Narcissistic Personality Inventory (Raskin and Terry 1988).  Item responses are paired. Respondents had to choose the one that fit them the best. Missingness is optional.  Respondents were asked to affirm that their answers were accurate and suitable for research, those that did not (9\%) are not included in this dataset.  Observations come from one of three administrations of the survey: The American Panel Survey, Amazon's Mechanical Turk  in fall of 2014, or Amazon's Mechanical Turk in spring of 2015.
#' 
#' 
#' @format A data frame with 11,243 observations on the following 40 variables.
#' \describe{
#' \item{\code{Q1}}{0 = I have a natural talent for influencing people. 1 = I am not good at influencing people.}
#' \item{\code{Q2}}{0 = Modesty doesn't become me. 1 = I am essentially a modest person.}
#' \item{\code{Q3}}{0 = I would do almost anything on a dare. 1 = I tend to be a fairly cautious person.}
#' \item{\code{Q4}}{0 = When people compliment me I sometimes get embarrassed. 1 = I know that I am good because everybody keeps telling me so.}
#' \item{\code{Q5}}{0 = The thought of ruling the world frightens the hell out of me. 1 = If I ruled the world it would be a better place.}
#' \item{\code{Q6}}{0 = I can usually talk my way out of anything. 1 = I try to accept the consequences of my behavior.}
#' \item{\code{Q7}}{0 = I prefer to blend in with the crowd. 1 = I like to be the center of attention.}
#' \item{\code{Q8}}{0 = I will be a success. 1 = I am not too concerned about success.}
#' \item{\code{Q9}}{0 = I am no better or worse than most people. 1 = I think I am a special person.}
#' \item{\code{Q10}}{0 = I am not sure if I would make a good leader. 1 = I see myself as a good leader.}
#' \item{\code{Q11}}{0 = I am assertive. 1 = I wish I were more assertive.}
#' \item{\code{Q12}}{0 = I like to have authority over other people. 1 = I don't mind following orders.}
#' \item{\code{Q13}}{0 = I find it easy to manipulate people. 1 = I don't like it when I find myself manipulating people.}
#' \item{\code{Q14}}{0 = I insist upon getting the respect that is due me. 1 = I usually get the respect that I deserve.}
#' \item{\code{Q15}}{0 = I don't particularly like to show off my body. 1 = I like to show off my body.}
#' \item{\code{Q16}}{0 = I can read people like a book. 1 = People are sometimes hard to understand.}
#' \item{\code{Q17}}{0 = If I feel competent I am willing to take responsibility for making decisions. 1 = I like to take responsibility for making decisions.}
#' \item{\code{Q18}}{0 = I just want to be reasonably happy. 1 = I want to amount to something in the eyes of the world.}
#' \item{\code{Q19}}{0 = My body is nothing special. 1 = I like to look at my body.}
#' \item{\code{Q20}}{0 = I try not to be a show off. 1 = I will usually show off if I get the chance.}
#' \item{\code{Q21}}{0 = I always know what I am doing. 1 = Sometimes I am not sure of what I am doing.}
#' \item{\code{Q22}}{0 = I sometimes depend on people to get things done. 1 = I rarely depend on anyone else to get things done.}
#' \item{\code{Q23}}{0 = Sometimes I tell good stories. 1 = Everybody likes to hear my stories.}
#' \item{\code{Q24}}{0 = I expect a great deal from other people. 1 = I like to do things for other people.}
#' \item{\code{Q25}}{0 = I will never be satisfied until I get all that I deserve. 1 = I take my satisfactions as they come.}
#' \item{\code{Q26}}{0 = Compliments embarrass me. 1 = I like to be complimented.}
#' \item{\code{Q27}}{0 = I have a strong will to power. 1 = Power for its own sake doesn't interest me.}
#' \item{\code{Q28}}{0 = I don't care about new fads and fashions. 1 = I like to start new fads and fashions.}
#' \item{\code{Q29}}{0 = I like to look at myself in the mirror. 1 = I am not particularly interested in looking at myself in the mirror.}
#' \item{\code{Q30}}{0 = I really like to be the center of attention. 1 = It makes me uncomfortable to be the center of attention.}
#' \item{\code{Q31}}{0 = I can live my life in any way I want to. 1 = People can't always live their lives in terms of what they want.}
#' \item{\code{Q32}}{0 = Being an authority doesn't mean that much to me. 1 = People always seem to recognize my authority.}
#' \item{\code{Q33}}{0 = I would prefer to be a leader. 1 = It makes little difference to me whether I am a leader or not.}
#' \item{\code{Q34}}{0 = I am going to be a great person. 1 = I hope I am going to be successful.}
#' \item{\code{Q35}}{0 = People sometimes believe what I tell them. 1 = I can make anybody believe anything I want them to.}
#' \item{\code{Q36}}{0 = I am a born leader. 1 = Leadership is a quality that takes a long time to develop.}
#' \item{\code{Q37}}{0 = I wish somebody would someday write my biography. 1 = I don't like people to pry into my life for any reason.}
#' \item{\code{Q38}}{0 = I get upset when people don't notice how I look when I go out in public. 1 = I don't mind blending into the crowd when I go out in public.}
#' \item{\code{Q39}}{0 = I am more capable than other people. 1 = There is a lot that I can learn from other people.}
#' \item{\code{Q40}}{0 = I am much like everybody else. 1 = I am an extraordinary person.}
#' }
#' 
#' @references 
#' 
#' Raskin, Robert and Howard Terry. 1988. "A Principal-Components Analysis of the Narcissistic Personality Inventory and Further Evidence of Its Construct Validity." Journal of Personality and Social Psychology 54(5):890-902.
#'
#' @docType data
#' @keywords datasets
#' @name npi
#' @usage data(npi)
"npi"




#' Need For Cognition
#'
#' Data of survey respondents' responses to 18 NFC questions, which is a reduced version of NFC (Cacioppo and Petty 1984). For each question, respondents could choose one of five response options: 1 = agree strongly, 2 = agree somewhat, 3 = neither agree nor disagree, 4 = disagree somewhat, 5 = disagree strongly. Missingness is optional. Observations come from one of three administrations of the survey: The American Panel Survey, Amazon's Mechanical Turk  in fall of 2014, or Amazon's Mechanical Turk in spring of 2015.
#' 
#' 
#' @format A data frame with 4043 observations on the following 18 variables.
#' \describe{
#'     \item{\code{NFC1}}{I really enjoy a task that involves coming up with new solutions to problems}
#'     \item{\code{NFC4}}{I would prefer a task that is intellectual, difficult, and important to one that is somewhat important but does not require much thought}
#'     \item{\code{NFC10}}{Learning new ways to think doesn't excite me very much}
#'     \item{\code{NFC12}}{I usually end up deliberating about issues even when they do not affect me personally}
#'     \item{\code{NFC15}}{The idea of relying on thought to make my way to the top appeals to me}
#'     \item{\code{NFC16}}{The notion of thinking abstractly is appealing to me}
#'     \item{\code{NFC19}}{I only think as hard as I have to}
#'     \item{\code{NFC21}}{I think tasks that require little thought once I've learned them}
#'     \item{\code{NFC22}}{I prefer to think about small, daily projects to long-term ones}
#'     \item{\code{NFC23}}{I would rather do something that requires little thought than something that is sure to challenge my thinking abilities}
#'     \item{\code{NFC24}}{I find satisfaction in deliberating hard and for long hours}
#'     \item{\code{NFC29}}{I like to have the responsibility of handing a situation that requires a lot of thinkings}
#'     \item{\code{NFC31}}{I feel relief rather than satisfaction after completing a task that required a lot of mental effort}
#'     \item{\code{NFC32}}{Thinking is not my idea of fun}
#'     \item{\code{NFC33}}{I try to anticipate and avoid situations where there is likely a chance I will have to think in depth about something}
#'     \item{\code{NFC39}}{I prefer my life to be filed with puzzles that I must solve}
#'     \item{\code{NFC40}}{I would prefer complex to simple problems}
#'     \item{\code{NFC43}}{Its enough for me that something gets the job done; I don't care how or why it works}
#' }
#' 
#' @references 
#' 
#' Cacioppo, John T. and Richard E. Petty. 1984. "The Efficient Assessment of Need for Cognition." Journal of Personality Assessment 48(3):306-307.
#' 
#' 
#' @docType data
#' @keywords datasets
#' @name nfc
#' @usage data(nfc)
"nfc"



#' ltm Cat Object
#' 
#' An object of class \code{Cat} created using the \code{ltmCat} function with the \code{npi} dataset.
#' 
#' @examples 
#' \dontrun{
#' ## How this Cat object was created
#' data(npi)
#' ltm_cat <- ltmCat(npi, quadraturePoints = 100)
#' }
#' 
#' ## How to load this Cat object for usage
#' data(ltm_cat)
#' 
#' @format An object of class \code{Cat}.  See \code{\link{Cat-class}} for more details.
#' 
#' @seealso \code{\link{Cat-class}}, \code{\link{ltmCat}}, \code{\link{npi}}  
#'
#' @docType data
#' @name ltm_cat
#' @usage data(ltm_cat)
"ltm_cat"


#' grm Cat Object
#' 
#' An object of class \code{Cat} created using the \code{grmCat} function with the \code{nfc} dataset.
#' 
#' @examples 
#' \dontrun{
#' ## How this Cat object was created
#' data(nfc)
#' grm_cat <- grmCat(nfc, quadraturePoints = 100)
#' }
#' 
#' ## How to load this Cat object for usage
#' data(grm_cat)
#' 
#' @format An object of class \code{Cat}.  See \code{\link{Cat-class}} for more details.
#' 
#' @seealso \code{\link{Cat-class}}, \code{\link{grmCat}}, \code{\link{nfc}}  
#'
#' @docType data
#' @name grm_cat
#' @usage data(grm_cat)
"grm_cat"


#' tpm Cat Object
#' 
#' An object of class \code{Cat} created using the \code{tpmCat} function with the first twenty questions of the \code{polknowMT} dataset.
#' 
#' @examples 
#' \dontrun{
#' ## How this Cat object was created
#' data(polknowMT)
#' tpm_cat <- tpmCat(polknowMT[,1:20], quadraturePoints = 100, start.val = "random")
#' }
#' 
#' ## How to load this Cat object for usage
#' data(tpm_cat)
#' 
#' @format An object of class \code{Cat}.  See \code{\link{Cat-class}} for more details.
#' 
#' @seealso \code{\link{Cat-class}}, \code{\link{tpmCat}}, \code{\link{polknowMT}}  
#'
#' @docType data
#' @name tpm_cat
#' @usage data(tpm_cat)
"tpm_cat"


#' gpcm Cat Object
#' 
#' An object of class \code{Cat} created using the \code{gpcmCat} function with the \code{polknowTAPS} dataset.
#' To have a better fitting model, we first fit an object of class \code{gpcm} from the \code{ltm} package which
#' provides for additional control values to be used in fitting.  See \code{gpcmCat}.
#' 
#' @examples 
#' \dontrun{
#' ## How this Cat object was created
#' data(polknowTAPS)
#' gpcm_fit <- gpcm(polknowTAPS, constraint = "gpcm", control = list(iter.qN = 200, GHk = 100))
#' gpcm_cat <- gpcmCat(gpcm_fit)
#' }
#' 
#' ## How to load this Cat object for usage
#' data(gpcm_cat)
#' 
#' @format An object of class \code{Cat}.  See \code{\link{Cat-class}} for more details.
#' 
#' @seealso \code{\link{Cat-class}}, \code{\link{gpcmCat}}, \code{\link{polknowTAPS}}  
#'
#' @docType data
#' @name gpcm_cat
#' @usage data(gpcm_cat)
"gpcm_cat"





