% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{toWideMatrix}
\alias{toWideMatrix}
\title{Converts 3d array of CATA data to a wide 2d matrix format}
\usage{
toWideMatrix(X)
}
\arguments{
\item{X}{three-dimensional array (\eqn{I} assessors, \eqn{J}
products, \eqn{M} attributes) where values are \code{0} (not checked) 
or \code{1} (checked)}
}
\value{
A matrix with \code{J} products in rows and \eqn{I} 
assessors \eqn{\times M} attributes in columns
}
\description{
Converts a three-dimensional array (\eqn{I} assessors, \eqn{J}
products, \eqn{M} attributes) to a two-dimensional matrix
(\eqn{J} products, (\eqn{I} assessors, \eqn{M} attributes))
}
\examples{
data(bread)

# convert CATA results from the first 8 consumers and the first 4 attributes
# to a wide matrix
toWideMatrix(bread$cata[1:8,,1:4])
}
\author{
J.C. Castura
}
