% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{raise_conditions}
\alias{raise_conditions}
\alias{evaluate_results}
\alias{raise_col_warnings}
\alias{raise_col_messages}
\alias{raise_col_conditions}
\alias{print_errors}
\title{Raise and display collected conditions}
\usage{
raise_conditions(col_conds, display_errors = TRUE, raise_errors = TRUE,
  added_text = ":")

evaluate_results(col_conds, raise_errors = TRUE)

raise_col_warnings(conditions, added_text = ":")

raise_col_messages(conditions, added_text = ":")

raise_col_conditions(conditions, added_text = ":", toStdErr = TRUE)

print_errors(conditions, added_text = ":")
}
\arguments{
\item{col_conds}{A named list of the kind returned from \code{\link{collect_conditions}}.}

\item{display_errors}{A logical, which, if \code{TRUE}, will display the errors to \code{stderr} just like the messages and warnings.}

\item{raise_errors}{A logical, which, if \code{TRUE}, will raise the collected errors. Otherwise, errors will not be signalled.}

\item{added_text}{A string that will be appended immediately after the title of each type of condition being raised. E.g., a value of " in x[1]:" would print "Messages in x[1]:" followed by a newline for the messages.}

\item{conditions}{A list of conditions (i.e., a sublist from what is returned from \code{\link{collect_conditions}}).}

\item{toStdErr}{A logical, which, if \code{TRUE}, prints the results to \code{stderr()} rather than \code{stdout()}.}
}
\description{
There are times where you might want to raise the conditions that you have collected via \code{\link{collect_conditions}}, for example, after your code has processed them, etc. These functions help with that
}
\details{
\code{raise_conditions} will raise all the conditions from the named list returned from \code{\link{collect_conditions}}, and display them in a pretty, readable way at the same time, returning the input invisibly. You have the option to raise errors or not. \cr \cr
\code{evaluate_results} will strip away the condition sublists of a list returned from \code{\link{collect_conditions}}, and optionally raise errors if there are any. \cr \cr
\code{raise_col_warnings}, \code{raise_col_messages}, and \code{raise_col_conditions} will raise and display lists of conditions, while \code{print_errors} will display errors rather than raise them.
}
\examples{
res <- collect_conditions({
  warning("warning 1")
  message("message 1")
  warning("warning 2")
  signal_custom_condition("Custom condition #1!")
  signal_custom_condition("Custom condition #2!")
  stop("error 1")
  message("message 2 (not signalled)")
  "test value"
}, catchErrors = TRUE)
raise_conditions(res, raise_errors = FALSE)

# A demonstration of how it can be used with packages like `purrr`
\dontrun{
  # Let's pretend you got `l` from doing a purrr::map on some data
  l <- list(
    collect_conditions({warning("BAD!"); warning("Uh oh!"); 1}),
    collect_conditions({message("This is fine"); warning("This is bad!"); 2}),
    collect_conditions({message("Have a nice day!"); stop("DIE!"); 3},
    catchErrors=TRUE)
  )
  results <- purrr::imap(l, function(e, i)
    raise_conditions(e, raise_errors=FALSE,
                      added_text=paste0(" in x[",i,"]:"))) \%>\%
    evaluate_results()
}
}
\seealso{
\code{\link{collect_conditions}}, \code{\link{warn_now}}
}
