% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{posteriorDensityAncestral}
\alias{posteriorDensityAncestral}
\title{Posterior density of a node}
\usage{
posteriorDensityAncestral(
  node,
  vals,
  tree,
  tipTrait,
  root.value = NULL,
  disp,
  method = c("reml", "random.root", "fixed.root")
)
}
\arguments{
\item{node}{the node for which to compute the posterior density.}

\item{vals}{the table of values where the density should be computed.}

\item{tree}{a phylogenetic tree of class \code{\link[ape]{phylo}}.}

\item{tipTrait}{a names vector of tip trait values, with names matching the tree labels.}

\item{root.value}{the root starting value of the process.}

\item{disp}{the dispersion value.}

\item{method}{the method used to compute the likelihood.
One of \code{reml} (the default), \code{fixed.root} or \code{random.root}.
See Details.}
}
\value{
the posterior density value.
}
\description{
Compute the posterior density of a set of node values under a Cauchy process on a phylogenetic tree.
}
\details{
This function is internally called by \code{\link{ancestral}}, which
is the preferred way of doing ancestral reconstruction on a fitted
object.
}
\examples{
phy <- ape::rphylo(5, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy", parameters = list(root.value = 0, disp = 1))
posteriorDensityAncestral(7, 0.1, phy, dat, disp = 1)


}
\seealso{
\code{\link{ancestral}}, \code{\link{fitCauchy}}
}
