% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gausCorScore.R
\name{gausCorScore}
\alias{gausCorScore}
\title{Gaussian L0 score computed on correlation matrix}
\usage{
gausCorScore(cormat, n, p = NULL, lambda = NULL, ...)
}
\arguments{
\item{cormat}{A correlation matrix. Needs to be symmetric.}

\item{n}{The number of observations in the dataset that the correlation matrix was computed from.}

\item{p}{The number of variables. This is inferred from the cormat if not supplied.}

\item{lambda}{Penalty to use for the score. If \code{NULL} (default), the BIC score penalty is used. See
\code{\link[pcalg]{GaussL0penObsScore-class}} for further details.}

\item{...}{Other arguments passed along to \code{\link[pcalg]{GaussL0penObsScore-class}}.}
}
\value{
A \code{Score} object (S4), see \code{\link[pcalg]{Score-class}}.
}
\description{
The score is intended to be used with score-based causal discovery algorithms
from the pcalg package. It is identical to the \code{\link[pcalg]{GaussL0penObsScore-class}},
except that it takes in a correlation matrix instead of the full data set.
\code{\link[pcalg]{GaussL0penObsScore-class}}.
}
\examples{
# Simulate data and compute correlation matrix
x1 <- rnorm(100)
x2 <- rnorm(100)
x3 <- x1 + x2 + rnorm(100)
d <- data.frame(x1, x2, x3)
cmat <- cor(d)

# Use gausCorScore with pcalg::ges() 
pcalg::ges(gausCorScore(cmat, n = 100))


}
