% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_spl_est.R
\name{add_spl_est}
\alias{add_spl_est}
\title{The additive spline estimator}
\usage{
add_spl_est(Y,
            treat,
            treat_formula,
            data,
            grid_val,
            knot_num,
            treat_mod,
            link_function,
            ...)
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{treat_formula}{an object of class "formula" (or one that can be
coerced to that class) that regresses \code{treat} on a linear combination
of \code{X}: a symbolic description of the model to be fitted.}

\item{data}{is a dataframe containing \code{Y}, \code{treat}, and
\code{X}.}

\item{grid_val}{contains the treatment values to be evaluated.}

\item{knot_num}{is the number of knots used in outcome model}

\item{treat_mod}{a description of the error distribution to be used in the
model for treatment. Options include: \code{"Normal"} for normal model,
\code{"LogNormal"} for lognormal model, \code{"Poisson"} for Poisson model,
\code{"NegBinom"} for negative binomial model, \code{"Gamma"} for gamma
model.}

\item{link_function}{is either "log", "inverse", or "identity" for the
"Gamma" \code{treat_mod}.}

\item{...}{additional arguments to be passed to the outcome regression fitting function.}
}
\value{
\code{add_spl_est}  returns an object of class "causaldrf",
a list that contains the following components:

\item{param}{parameter estimates for a add_spl fit.}
\item{t_mod}{the result of the treatment model fit.}
\item{out_mod}{the result of the outcome model fit.}
\item{call}{the matched call.}
}
\description{
additive spline estimator described in Bia et al. (2014).
}
\examples{
## Example from Schafer (2015).
example_data <- sim_data
add_spl_list <- add_spl_est(Y = Y,
            treat = T,
            treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
            data = example_data,
            grid_val = seq(8, 16, by = 1),
            knot_num = 3,
            treat_mod = "Normal")


sample_index <- sample(1:1000, 100)
plot(example_data$T[sample_index],
      example_data$Y[sample_index],
      xlab = "T",
      ylab = "Y",
      main = "additive spline estimate")

lines(seq(8, 16, by = 1),
      add_spl_list$param,
      lty = 2,
      lwd = 2,
      col = "blue")
legend('bottomright',
        "additive spline estimate",
        lty=2,
        lwd = 2,
        col = "blue",
        bty='Y', cex=1)

rm(example_data, add_spl_list, sample_index)

## See Vignette for more examples.
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.

Bia, Michela, et al. (2014). A Stata package for the application of
semiparametric estimators of dose response functions.  \emph{Stata Journal}
\bold{14.3}, 580-604.
}
\seealso{
\code{\link{nw_est}}, \code{\link{iw_est}}, \code{\link{hi_est}}, \code{\link{gam_est}},
\code{\link{bart_est}}, etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

