#' An Interface to Specify Causal Graphs and Compute Bounds on Causal Effects
#' 
#' Specify causal graphs using a visual interactive interface and then analyze them and compute symbolic bounds for the causal effects in terms of the observable parameters.
#' 
#' @details Run the shiny app by results <- specify_graph(). See detailed instructions in the vignette browseVignettes("causaloptim").
#' @author Michael C Sachs, Arvid Sjölander, Gustav Jonzon, Alexander Balke, Colorado Reed, and Erin Gabriel
#'     Maintainer: Michael C Sachs <sachsmc at gmail.com>
#' @references A. Balke and J. Pearl, "Counterfactual Probabilities: Computational Methods,Bounds, and Applications"  UCLA Cognitive Systems Laboratory, Technical Report (R-213-B). In R. Lopez de Mantaras and D. Poole (Eds.), Proceedings of the Conference on Uncertainty in Artificial Intelligence (UAI-94), Morgan Kaufmann, San Mateo, CA, 46-54, July 29-31, 1994. \url{https://ftp.cs.ucla.edu/pub/stat_ser/R213-B.pdf} .
#' 
#' @docType package
#' @seealso \code{browseVignettes('causaloptim')}
#' @name causaloptim-package
#' @aliases causaloptim

NULL