% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_patients.R
\name{get_samples_by_patient}
\alias{get_samples_by_patient}
\title{Get sample IDs for a given set of patient IDs}
\usage{
get_samples_by_patient(patient_id = NULL, study_id = NULL, base_url = NULL)
}
\arguments{
\item{patient_id}{A character string of sample IDs to query}

\item{study_id}{A character string indicating which study ID should be searched.
Only 1 study allowed. If NULL, we will guess a default study ID based on your database URL.}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of patient IDs and corresponding sample IDs. If patient
has multiple samples, there will be multiple rows per patient.
}
\description{
Get sample IDs for a given set of patient IDs
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_samples_by_patient(patient_id = c("P-0000034", "P-0000036"))

\dontshow{\}) # examplesIf}
}
