% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_fields.R
\name{map_fields}
\alias{map_fields}
\title{Map field values from one column into new derived columns (takes a \code{data.frame}).}
\usage{
map_fields(d, cname, m)
}
\arguments{
\item{d}{name of table to re-map.}

\item{cname}{name of column to re-map.}

\item{m}{name of table of data describing the mapping (cname column is source, derived columns are destinations).}
}
\value{
re-mapped table
}
\description{
Map field values from one column into new derived columns (takes a \code{data.frame}).
}
\examples{

d <- data.frame(what = c("acc", "loss",
                         "val_acc", "val_loss"),
                score = c(0.8, 1.2,
                       0.7, 1.7),
                stringsAsFactors = FALSE)
m <- data.frame(what = c("acc", "loss",
                         "val_acc", "val_loss"),
                measure = c("accuracy", "log-loss",
                            "accuracy", "log-loss"),
                dataset = c("train", "train", "validation", "validation"),
                stringsAsFactors = FALSE)
map_fields(d, 'what', m)

}
