% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_names.r
\name{search_names}
\alias{search_names}
\title{Search database of site names}
\usage{
search_names(string = NULL, column = NULL)
}
\arguments{
\item{string}{The search string to be matched (case-sensitive). Will match 
whole or partial strings in the column values.}

\item{column}{The column to be searched. Possible options are
\code{WBID}, \code{name}, \code{OC} (Operational Catchment), \code{MC}
(Management Catchment) and \code{RBD} (River Basin District)}
}
\value{
A data frame containing the details of all the sites that match
the search string (full or partial matches) in the column specified.
Columns returned are defined in \code{\link{ea_wbids}}.
}
\description{
Searches the listing of EA monitoring sites to find rows
that contain the string provided. Can search by WBID (\code{WBID}), name 
(\code{name}), Management Catchment (\code{MC}), Operational Catchment 
(\code{OC}) or River Basin District (\code{RBD}). There is a hierarchical 
relationship between these levels as shown at \url{https://environment.data.gov.uk/catchment-planning/help#help-catchment-hierarchy}.

The search is done on a local copy of the waterbody listing contained in 
the \code{\link{ea_wbids}} object rather than connecting to the 
EA site.
}
\examples{
# search for sites containing "Tadnoll" in the name
search_names(string="Tadnoll", column="name")

# search for Operational Catchments containing "Cornwall"
search_names(string="Cornwall", column="OC")

}
