% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdgd1_pa.R
\name{cdgd1_pa}
\alias{cdgd1_pa}
\title{Perform conditional decomposition via parametric models}
\usage{
cdgd1_pa(Y, D, G, X, Q, data, alpha = 0.05, trim1 = 0, trim2 = 0)
}
\arguments{
\item{Y}{Outcome. The name of a continuous variable.}

\item{D}{Treatment status. The name of a binary numeric variable taking values of 0 and 1.}

\item{G}{Advantaged group membership. The name of a binary numeric variable taking values of 0 and 1.}

\item{X}{Confounders. The vector of the names of numeric variables.}

\item{Q}{Conditional set. The vector of the names of numeric variables.}

\item{data}{A data frame.}

\item{alpha}{1-alpha confidence interval.}

\item{trim1}{Threshold for trimming the propensity score. When trim1=a, individuals with propensity scores lower than a or higher than 1-a will be dropped.}

\item{trim2}{Threshold for trimming the G given Q predictions. When trim2=a, individuals with G given Q predictions lower than a or higher than 1-a will be dropped.}
}
\value{
A dataframe of estimates.
}
\description{
Perform conditional decomposition via parametric models
}
\examples{
data(exp_data)

results <- cdgd1_pa(
Y="outcome",
D="treatment",
G="group_a",
X="confounder",
Q="Q",
data=exp_data)

results
}
