% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cds.sim.R
\name{cds.sim}
\alias{cds.sim}
\title{Grouped Simulation with Response Styles}
\usage{
cds.sim(nr.indv = c(100, 100, 100), m = 25, scales = 1:7,
  err.coeff = 0.1, alphamat = rbind(c(4, 4, 1), c(1, 4, 4), c(1, 2, 1)),
  true.mu = NULL, random = TRUE, same.mu = TRUE, use.copula = FALSE,
  reverse.thresh = 1)
}
\arguments{
\item{nr.indv}{A vector giving the number of respondents in each group.}

\item{m}{The number of objects.}

\item{scales}{The rating scale used, 1:q.}

\item{err.coeff}{The standard error used in the underlying normal noise.}

\item{alphamat}{The matrix of spline parameters defining the response styles, with each
row containing a response style. No intercepts should be included.}

\item{true.mu}{Optional; a matrix or vector giving the true underlying preferences for the objects.}

\item{random}{Logical indicating whether to apply the response styles in random order}

\item{same.mu}{Logical indicating whether a universal value for mu should be assumed.}

\item{use.copula}{Logical indicating whether to use a correlated dependence structure 
through a copula.}

\item{reverse.thresh}{A numeric value giving the proportion of observations for which the 
dependece structure should be reversed. Only applicable when \code{copula} is \code{TRUE}.}
}
\value{
An object of class \code{cdsdata}, inheriting from class \code{icdsdata}, which is a 
list with the following slots:
\describe{
 \item{prers}{The pre-response style simulated data}
 \item{postrs}{The data after adding the response styles}
 \item{postbl}{The same as \code{postrs} in this case}
 \item{Fr.cent.rs}{The centred Fr matrix for \code{postrs}}
 \item{Fr.rs}{The Fr matrix for \code{postrs}}
 \item{Fr.cent.bl}{The same as \code{Fr.cent.rs}, for compatibility with \code{icds}}
 \item{Fr.bl}{The same as \code{Fr.rs}, for compatibility with \code{icds}}
 \item{mu}{Matrix of the true underlying preference structure for the obects}
 \item{block}{Numeric vector identifying the different blocks for incompleteness, in this case a vector
 of ones}
 \item{grp.rs}{The response style grouping vector}
 \item{alphamat}{Matrix of spline parameters for the response styles}
 \item{scales}{The rating scale 1:q used}
 \item{m}{Number of objects}
 \item{munique}{The number of objects seen within each block - equal to zero in this case}
 \item{m0}{The number of objects seen by all subjects - equal to \code{m} in this case}
 \item{true.tau}{Actual tau used in the simulation with copulae}
 \item{call}{The function call}
}
}
\description{
Simulate response data for a group of response styles.
}
\seealso{
\code{\link{createcdsdata}}
}
\keyword{multivariate}

