% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcormat.R
\name{rcormat}
\alias{rcormat}
\title{Randomly Generate Low-Rank Correlation Matrix}
\usage{
rcormat(m, r = 3L, sparse.prop = 0.5)
}
\arguments{
\item{m}{integer; the number of variables.}

\item{r}{integer; the required rank.}

\item{sparse.prop}{the proportion of zeros in the rows of the matrix.}
}
\value{
A list with the following components: \item{R}{The sampled
correlation matrix} \item{L}{The loading matrix}
}
\description{
Generate a correlation matrix as R = LL' where the rows of L are of length
1, L is of rank \code{r} and the matrix L is sparse (depending on
\code{sparse.prop}. The loadings in L are sampled from a standard normal
distribution, after which \code{sparse.prop} is used to set a randomly
chosen number of loadings in each row equal to zero. To ensure that a
correlation matrix results, the rows are normalized.
}
\examples{
R <- rcormat(m = 10)$R
eigen(R)
}

