% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtracks.R
\name{prefixes}
\alias{prefixes}
\title{Get Track Prefixes}
\usage{
prefixes(x, i)
}
\arguments{
\item{x}{a single track or a \code{tracks} object.}

\item{i}{subtrack length. A single integer, lists are not supported.}
}
\value{
A \emph{tracks} object is returned which contains all the subtracks
of any track in the input \emph{tracks} object that consist of exactly `i`
segments and start at the first registered coordinate of the given track.
}
\description{
Creates a \code{tracks} object consisting of all prefixes (i.e., subtracks
starting with the first position of a track) of `x`
with `i` segments (i.e., `i`+1 positions).
}
\details{
This function behaves exactly like \code{\link{subtracks}} except
that only subtracks starting from the first position are considered.
}
\seealso{
\code{\link{subtracks}} to extract all subtracks of a given length,
\code{\link{subtracksByTime}} to extract all subtracks of a given length
starting at some fixed timepoint, and \code{\link{selectSteps}} to extract
single steps starting at a fixed timepoint from a subset of trackids.
}
