% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree-mboost.R
\name{blackboost_train}
\alias{blackboost_train}
\title{Boosted trees via mboost}
\usage{
blackboost_train(
  formula,
  data,
  family,
  weights = NULL,
  teststat = "quad",
  testtype = "Teststatistic",
  mincriterion = 0,
  minsplit = 10,
  minbucket = 4,
  maxdepth = 2,
  saveinfo = FALSE,
  ...
)
}
\arguments{
\item{teststat}{a character specifying the type of the test statistic to be
applied for variable selection.}

\item{testtype}{a character specifying how to compute the distribution of
the test statistic. The first three options refer to p-values as criterion,
Teststatistic uses the raw statistic as criterion. Bonferroni and
Univariate relate to p-values from the asymptotic distribution (adjusted or
unadjusted). Bonferroni-adjusted Monte-Carlo p-values are computed when
both Bonferroni and MonteCarlo are given.}

\item{mincriterion}{the value of the test statistic or 1 - p-value that must
be exceeded in order to implement a split.}

\item{minsplit}{the minimum sum of weights in a node in order to be
considered for splitting.}

\item{minbucket}{the minimum sum of weights in a terminal node.}

\item{maxdepth}{maximum depth of the tree. The default maxdepth = Inf means
that no restrictions are applied to tree sizes.}

\item{saveinfo}{logical. Store information about variable selection procedure
in info slot of each partynode.}

\item{...}{Other arguments to pass.}

\item{x}{A data frame or matrix of predictors.}

\item{y}{A factor vector with 2 or more levels}
}
\value{
A fitted blackboost model.
}
\description{
\code{blackboost_train()} is a wrapper for the \code{blackboost()} function in the
\pkg{mboost} package that fits tree-based models
where all of the model arguments are in the main function.
}
\examples{
blackboost_train(Surv(time, status) ~ age + ph.ecog,
  data = lung[-14, ], family = mboost::CoxPH()
)
}
\keyword{internal}
