% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree-mboost.R
\name{survival_prob_mboost}
\alias{survival_prob_mboost}
\title{A wrapper for survival probabilities with mboost models}
\usage{
survival_prob_mboost(object, new_data, eval_time, time = deprecated())
}
\arguments{
\item{new_data}{Data for prediction.}

\item{eval_time}{A vector of integers for prediction times.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of integers for prediction times.}

\item{x}{A model from \code{blackboost()}.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
A wrapper for survival probabilities with mboost models
}
\examples{
library(mboost)
mod <- blackboost(Surv(time, status) ~ ., data = lung, family = CoxPH())
survival_prob_mboost(mod, new_data = lung[1:3, ], eval_time = 300)
}
\keyword{internal}
