% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_reg-survival.R
\name{survival_prob_survreg}
\alias{survival_prob_survreg}
\alias{hazard_survreg}
\title{Internal function helps for parametric survival models}
\usage{
survival_prob_survreg(object, new_data, eval_time, time = deprecated())

hazard_survreg(object, new_data, eval_time)
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from
\link[parsnip:details_survival_reg_survival]{survival_reg() with engine = "survival"}.}

\item{new_data}{A data frame.}

\item{eval_time}{A vector of time points.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of time points.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
Internal function helps for parametric survival models
}
\examples{
mod <- survival_reg() \%>\% 
  set_engine("survival") \%>\%
  fit(Surv(time, status) ~ ., data = lung)
survival_prob_survreg(mod, lung[1:3, ], eval_time = 100)
hazard_survreg(mod, lung[1:3, ], eval_time = 100)
}
\keyword{internal}
