% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tiles.R
\name{get-tiles-constrained}
\alias{get-tiles-constrained}
\alias{get_tiles_zoom}
\alias{get_tiles_dim}
\alias{get_tiles_buffer}
\title{Get tiles with specific constraints}
\usage{
get_tiles_zoom(x, zoom = 0, ..., format = "png")

get_tiles_dim(x, dim = c(512, 512), ..., format = "png")

get_tiles_buffer(x, buffer = NULL, ..., max_tiles = 9, format = "png")
}
\arguments{
\item{x}{a spatial object with an extent}

\item{zoom}{desired zoom for tiles, use with caution - cannot be unset in \code{get_tiles_zoom}}

\item{...}{passed to \code{get_tiles()}}

\item{format}{defaults to "png", also available is "jpg"}

\item{dim}{for \code{get_tiles_dim} the overall maximum dimensions of the image (padded out to tile size of 256x256)}

\item{buffer}{width in metres to extend around the location, ignored if 'x' is a spatial object with extent}

\item{max_tiles}{maximum number of tiles - if \code{NULL} is set by zoom constraints}
}
\value{
A list with files downloaded in character vector, a data frame of the tile indices,
the zoom level used and the extent in xmin,xmax,ymin,ymax form.
}
\description{
Get tiles by zoom, by overall dimension, or by buffer on a single point.
}
\details{
Each function expects an extent in longitude latitude or a spatial object with extent as the first argument.

\code{get_tiles_zoom()} requires a zoom value, defaulting to 0

\code{get_tiles_dim()} requires a dim value, default to \code{c(512, 512)}, a set of 4 tiles

\code{get_tiles_buffer()} requires a single location (longitude, latitude) and a buffer in metres
}
\examples{
if (!is.null(get_api_key())) {
 ex <- ext(146, 147, -43, -42)
 tile_infoz <- get_tiles_zoom(ex,  zoom = 1)

 tile_infod <- get_tiles_dim(ex,  dim = c(256, 256))

 tile_infob <- get_tiles_buffer(cbind(146.5, -42.5), buffer = 5000)
}
}
\seealso{
get_tiles
}
