% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{statetable}
\alias{statetable}
\title{Table of transitions}
\usage{
statetable(data, removeDiagonal = FALSE)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs
and \code{state}, associated state.}

\item{removeDiagonal}{if TRUE, does not count transition from a state i to i}
}
\value{
a vector of length \code{K} containing the total time spent in each state
}
\description{
Calculates a frequency table counting the number of times each pair of states were observed in successive observation times.
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

# table of transitions
statetable(d_JK)
}
\author{
Quentin Grimonprez
}
