% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{plot.Markov}
\alias{plot.Markov}
\title{Plot the transition graph}
\usage{
\method{plot}{Markov}(x, ...)
}
\arguments{
\item{x}{output of \code{\link{estimate_Markov}} function}

\item{...}{parameters of \code{plotmat} function from \code{diagram} package (see details).}
}
\value{
No return value, called for side effects
}
\description{
Plot the transition graph between the different states. A node corresponds to a state with the mean
time spent in this state. Each arrow represents the probability of transition between states.
}
\details{
Some useful extra parameters:
\itemize{
  \item \code{main} main title.
  \item \code{dtext} controls the position of arrow text relative to arrowhead (default = 0.3).
  \item \code{relsize}	scaling factor for size of the graph (default = 1).
  \item \code{box.size} size of label box, one value or a vector with dimension = number of rows of \code{x$P}.
  \item \code{box.cex}	relative size of text in boxes, one value or a vector with dimension=number of rows of \code{x$P}.
  \item \code{arr.pos} relative position of arrowhead on arrow segment/curve.
}
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 100, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

# estimation
mark <- estimate_Markov(d_JK)

# transition graph
plot(mark)
}
\author{
Cristian Preda
}
