% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_extract_to_bibtex.R
\name{cff_extract_to_bibtex}
\alias{cff_extract_to_bibtex}
\title{Create BibTeX entries from a package}
\usage{
cff_extract_to_bibtex(x, what = "preferred")
}
\arguments{
\item{x}{The source that would be used for generating
the \code{\link{cff}} object. It could be:
\itemize{
\item A missing value. That would retrieve the DESCRIPTION
file on your in-development package.
\item An existing \code{\link{cff}} object,
\item The name of an installed package (\code{"jsonlite"}), or
\item Path to a DESCRIPTION file (\code{"*/DESCRIPTION*"}).
}}

\item{what}{Fields to extract. The value could be:
\itemize{
\item \code{preferred}: This would create a single entry with the main citation
info of the package.
\item \code{references}: Extract all the entries on \code{references}.
\item \code{all}: A combination of the previous two options. This would extract
both the preferred citation info and the references.
}}
}
\value{
A \code{bibentry} object or a list of \code{bibentry} objects. This could
be parsed to BibTeX using \code{\link[=toBibtex]{toBibtex()}}
}
\description{
Extract the information of a package to BibTeX. This is done by creating a
\code{cff} object with \code{cff_create()} and extracting the corresponding entries
with \code{cff_to_bibtex()}.
}
\examples{
\donttest{

jsonvalidate <- cff_extract_to_bibtex("jsonvalidate")

jsonvalidate

toBibtex(jsonvalidate)

lite <- cff_extract_to_bibtex("jsonlite", "references")

lite

toBibtex(lite)
}
}
\seealso{
Other bibtex: 
\code{\link{cff_from_bibtex}()},
\code{\link{cff_to_bibtex}()},
\code{\link{encoded_utf_to_latex}()},
\code{\link{write_bib}()}
}
\concept{bibtex}
