% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{dag}
\alias{dag}
\title{Directed Acyclic Graph}
\usage{
dag(x)
}
\arguments{
\item{x}{A character string containing a sequence of definitions
of edges in the form \code{X -> Y}, \code{X <- Y} or \verb{X <-> Y}.
See details for more advanced constructs.}
}
\value{
An object of class \code{dag}, which is a square adjacency matrix
with the following attributes:
\itemize{
\item \code{labels} A character vector (or a list) of vertex labels.
\item \code{latent} A logical vector indicating latent variables.
\item \code{order} An integer vector giving a topological order for the vertices.
.
}
}
\description{
Define a directed acyclic graph (DAG).
}
\details{
The syntax for \code{x} follows closely that of \code{\link[dagitty:dagitty]{dagitty::dagitty()}} for compatibility.
The resulting adjacency matrix of the definition is checked for cycles.

Directed edges are defined as \code{X -> Y} meaning that there is an edge from
\code{X} to \code{Y} in the graph. Edges can be combined in sequence to create paths
for concise descriptions, for example \code{X -> Y <- Z -> W}.

Unobserved latent confounders are defined using bidirected edges as
\verb{X <-> Y} which means that there is an additional variable \code{U[X,Y]} in
the graph, and the edges \code{X <- U[X,Y] -> Y}, respectively.

Groups of vertices can be defined by enclosing the vertices within
curly braces. For example \verb{X -> \{Y Z\}} defines that the dag has an edge
from \code{X} to both \code{Y} and \code{Z}.
Different statements in \code{x} are automatically distinguished from one
another without any additional delimiters, but semicolons, commas
and line breaks can be used if desired.

Note that in the context of this package, vertex labels will always be
converted into upper case, meaning that typing \code{Z} or \code{z} within \code{x} will
always represent the same variable. This is done to enforce the notation
of counterfactual variables, where capital letter denote variables,
and small letters denote their value assignments.
}
\examples{
dag("x -> {y z} <- w <-> g")

# Groups can appear on both sides of an edge
dag("{x z} -> {y w}")

# Semicolons can be used to distinguish individual statements
dag("x -> z -> y; x <-> y")

# Commas can be used to distinguish variables for example
dag("{x, y, z} -> w")

# Line breaks are also allowed
dag("z -> w
     x -> y")

}
