% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgalPolygon.R
\name{cgalPolygon}
\alias{cgalPolygon}
\title{R6 class to represent a CGAL polygon}
\description{
R6 class to represent a CGAL polygon.
}
\examples{

## ------------------------------------------------
## Method `cgalPolygon$new`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg

## ------------------------------------------------
## Method `cgalPolygon$area`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$area() # should be 5 / sqrt(130 + 58*sqrt(5))
5 / sqrt(130 + 58*sqrt(5))

## ------------------------------------------------
## Method `cgalPolygon$boundingBox`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
plot(ptg$boundingBox(), asp = 1)
polygon(pentagram)

## ------------------------------------------------
## Method `cgalPolygon$convexParts`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
cxparts <- ptg$convexParts()
ptg$plot(col = "yellow", lwd = 3)
invisible(
  lapply(cxparts, function(cxpart) {
    polygon(cxpart, lwd = 2)
  })
)

## ------------------------------------------------
## Method `cgalPolygon$getVertices`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$getVertices()

## ------------------------------------------------
## Method `cgalPolygon$intersection`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# intersection
plgList <- plg1$intersection(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(lwd = 3, col = "red", new = FALSE)
par(opar)

## ------------------------------------------------
## Method `cgalPolygon$isCWO`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isCWO()

## ------------------------------------------------
## Method `cgalPolygon$isCCWO`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isCCWO()

## ------------------------------------------------
## Method `cgalPolygon$isConvex`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isConvex()

## ------------------------------------------------
## Method `cgalPolygon$isSimple`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isSimple()

## ------------------------------------------------
## Method `cgalPolygon$minkowskiSum`
## ------------------------------------------------

library(cgalPolygons)
plg1 <- cgalPolygon$new(decagram)
plg2 <- cgalPolygon$new(star)
minko <- plg1$minkowskiSum(plg2)
minko$plot(lwd = 2, col = "yellowgreen")

## ------------------------------------------------
## Method `cgalPolygon$plot`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$plot(lwd = 3, col = "red")

## ------------------------------------------------
## Method `cgalPolygon$reverseOrientation`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isCCWO()
ptg$reverseOrientation()
ptg$isCCWO()

## ------------------------------------------------
## Method `cgalPolygon$subtract`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# difference
plgList <- plg1$subtract(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(lwd = 3, col = "red", new = FALSE)
par(opar)

## ------------------------------------------------
## Method `cgalPolygon$symdiff`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# symmetric difference
plgList <- plg1$symdiff(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(list(lwd = 3, col = "red"), col = "white", new = FALSE)
par(opar)

## ------------------------------------------------
## Method `cgalPolygon$union`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# union
plgList <- plg1$union(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(lwd = 3, col = "red", new = FALSE)
par(opar)

## ------------------------------------------------
## Method `cgalPolygon$whereIs`
## ------------------------------------------------

library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
pt1 <- c(0, 0) # inside
pt2 <- c(4, 0) # outside
ptg$whereIs(rbind(pt1, pt2))
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-cgalPolygon-new}{\code{cgalPolygon$new()}}
\item \href{#method-cgalPolygon-print}{\code{cgalPolygon$print()}}
\item \href{#method-cgalPolygon-area}{\code{cgalPolygon$area()}}
\item \href{#method-cgalPolygon-boundingBox}{\code{cgalPolygon$boundingBox()}}
\item \href{#method-cgalPolygon-convexParts}{\code{cgalPolygon$convexParts()}}
\item \href{#method-cgalPolygon-getVertices}{\code{cgalPolygon$getVertices()}}
\item \href{#method-cgalPolygon-intersection}{\code{cgalPolygon$intersection()}}
\item \href{#method-cgalPolygon-isCWO}{\code{cgalPolygon$isCWO()}}
\item \href{#method-cgalPolygon-isCCWO}{\code{cgalPolygon$isCCWO()}}
\item \href{#method-cgalPolygon-isConvex}{\code{cgalPolygon$isConvex()}}
\item \href{#method-cgalPolygon-isSimple}{\code{cgalPolygon$isSimple()}}
\item \href{#method-cgalPolygon-minkowskiSum}{\code{cgalPolygon$minkowskiSum()}}
\item \href{#method-cgalPolygon-plot}{\code{cgalPolygon$plot()}}
\item \href{#method-cgalPolygon-reverseOrientation}{\code{cgalPolygon$reverseOrientation()}}
\item \href{#method-cgalPolygon-subtract}{\code{cgalPolygon$subtract()}}
\item \href{#method-cgalPolygon-symdiff}{\code{cgalPolygon$symdiff()}}
\item \href{#method-cgalPolygon-union}{\code{cgalPolygon$union()}}
\item \href{#method-cgalPolygon-whereIs}{\code{cgalPolygon$whereIs()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-new"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{cgalpolygon} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$new(vertices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vertices}}{a numeric matrix with two columns}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cgalPolygon} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-print"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-print}{}}}
\subsection{Method \code{print()}}{
Print the \code{cgalPolygon} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No value, just prints some information about the polygon.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-area"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-area}{}}}
\subsection{Method \code{area()}}{
Signed area of the polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$area()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number, the signed area of the polygon; it is positive if the 
  polygon is counter-clockwise oriented, negative otherwise.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$area() # should be 5 / sqrt(130 + 58*sqrt(5))
5 / sqrt(130 + 58*sqrt(5))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-boundingBox"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-boundingBox}{}}}
\subsection{Method \code{boundingBox()}}{
Bounding box of the polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$boundingBox()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 2x2 matrix giving the lower corner of the bounding box in its 
  first row and the upper corner in its second row.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
plot(ptg$boundingBox(), asp = 1)
polygon(pentagram)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-convexParts"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-convexParts}{}}}
\subsection{Method \code{convexParts()}}{
Decomposition into convex parts. The polygon must be simple 
  and counter-clockwise oriented.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$convexParts(method = "optimal")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{the method used: \code{"approx"}, \code{"greene"}, 
or \code{"optimal"}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of matrices; each matrix has two columns and represents 
  a convex polygon.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
cxparts <- ptg$convexParts()
ptg$plot(col = "yellow", lwd = 3)
invisible(
  lapply(cxparts, function(cxpart) {
    polygon(cxpart, lwd = 2)
  })
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-getVertices"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-getVertices}{}}}
\subsection{Method \code{getVertices()}}{
Vertices of the polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$getVertices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The vertices in a matrix with two columns.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$getVertices()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-intersection"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-intersection}{}}}
\subsection{Method \code{intersection()}}{
Intersection of the polygon with another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$intersection(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# intersection
plgList <- plg1$intersection(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(lwd = 3, col = "red", new = FALSE)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-isCWO"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-isCWO}{}}}
\subsection{Method \code{isCWO()}}{
Checks whether the polygon is clockwise oriented.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$isCWO()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A Boolean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isCWO()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-isCCWO"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-isCCWO}{}}}
\subsection{Method \code{isCCWO()}}{
Checks whether the polygon is counter-clockwise oriented.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$isCCWO()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A Boolean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isCCWO()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-isConvex"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-isConvex}{}}}
\subsection{Method \code{isConvex()}}{
Checks whether the polygon is convex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$isConvex()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A Boolean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isConvex()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-isSimple"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-isSimple}{}}}
\subsection{Method \code{isSimple()}}{
Checks whether the polygon is simple; that means its edges 
  do not intersect (except two consecutive edges which intersect at 
  their common vertex)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$isSimple()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A Boolean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isSimple()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-minkowskiSum"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-minkowskiSum}{}}}
\subsection{Method \code{minkowskiSum()}}{
Minkowski sum of the polygon and another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$minkowskiSum(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object, the polygon to add to the reference polygon}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Either a \code{cgalPolygonWithHoles} object, or, in the case if 
  there is no hole in the Minkowski sum, a \code{cgalPolygon} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
plg1 <- cgalPolygon$new(decagram)
plg2 <- cgalPolygon$new(star)
minko <- plg1$minkowskiSum(plg2)
minko$plot(lwd = 2, col = "yellowgreen")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-plot"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$plot(..., new = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments passed to \code{\link[graphics]{polygon}}}

\item{\code{new}}{Boolean, whether to create a new plot}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No returned value, called for side-effect.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$plot(lwd = 3, col = "red")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-reverseOrientation"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-reverseOrientation}{}}}
\subsection{Method \code{reverseOrientation()}}{
Reverse the orientation of the polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$reverseOrientation()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{cgalPolygon} object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
ptg$isCCWO()
ptg$reverseOrientation()
ptg$isCCWO()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-subtract"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-subtract}{}}}
\subsection{Method \code{subtract()}}{
Difference between the polygon and another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$subtract(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# difference
plgList <- plg1$subtract(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(lwd = 3, col = "red", new = FALSE)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-symdiff"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-symdiff}{}}}
\subsection{Method \code{symdiff()}}{
Symmetric difference of the polygon and another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$symdiff(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# symmetric difference
plgList <- plg1$symdiff(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(list(lwd = 3, col = "red"), col = "white", new = FALSE)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-union"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-union}{}}}
\subsection{Method \code{union()}}{
Union of the polygon with another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$union(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles
plg1 <- cgalPolygon$new(circle(-1, 0, 1.25))
plg2 <- cgalPolygon$new(circle(1, 0, 1.25))
# union
plgList <- plg1$union(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.3, 1.3), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(lwd = 2, new = FALSE)
plg2$plot(lwd = 2, new = FALSE)
plg$plot(lwd = 3, col = "red", new = FALSE)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygon-whereIs"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygon-whereIs}{}}}
\subsection{Method \code{whereIs()}}{
Locate point(s) with respect to the polygon. The polygon 
  must be simple.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygon$whereIs(points)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{points}}{a numeric matrix with two columns, or a numeric vector 
of length 2 (for a single point)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer vector with possible values \code{-1}, \code{1}, or 
  \code{0}: value \code{-1} for outside, \code{1} for inside, and 
  \code{0} if the point is on the boundary of the polygon.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
ptg <- cgalPolygon$new(pentagram)
pt1 <- c(0, 0) # inside
pt2 <- c(4, 0) # outside
ptg$whereIs(rbind(pt1, pt2))
}
\if{html}{\out{</div>}}

}

}
}
